/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.label;

import at.cdes.bo.data.label.BoldRichTextItem;
import at.cdes.bo.data.label.CDataRichTextItem;
import at.cdes.bo.data.label.ParagraphRichTextItem;
import at.cdes.bo.data.label.RichTextItem;
import at.cdes.bo.data.label.RichTextItemContainer;
import at.cdes.bo.data.label.RichTextState;
import at.cdes.bo.data.label.TemporaryCustomTextField;
import at.cdes.bo.data.label.TextField;
import at.cdes.bo.data.label.TextFieldVisitor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

public abstract class AbstractTextFieldRenderer
implements TextFieldVisitor {
    ByteArrayOutputStream os;
    final double dx;
    final double dy;
    final double userUnit;
    int iobj = 0;

    public AbstractTextFieldRenderer(double _dx, double _dy, double _userUnit) {
        this.dx = _dx;
        this.dy = _dy;
        this.userUnit = _userUnit;
        this.iobj = 2;
        this.os = new ByteArrayOutputStream();
    }

    public void renderFDFFile(OutputStream ostream, Collection textFields) throws UnsupportedEncodingException, IOException {
        this.iobj = 2;
        this.os.reset();
        if (textFields != null) {
            for (TextField textField : textFields) {
                textField.accept(this);
            }
        }
        ostream.write("%FDF-1.2\n1 0 obj<</FDF<</Annots[".getBytes("US-ASCII"));
        for (int i = 2; i < this.iobj; ++i) {
            ostream.write(String.format("%d 0 R ", i).getBytes("US-ASCII"));
        }
        ostream.write("]>>>>\nendobj\n".getBytes("US-ASCII"));
        ostream.write(this.os.toByteArray());
        ostream.write("trailer\n<</Root 1 0 R>>\n%%EOF\n".getBytes("US-ASCII"));
    }

    public String getXMLStyleString(RichTextState state) {
        String ret = "font-size:" + (double)state.getFontPtSize() / this.userUnit + "pt;font-family:" + state.getFont();
        if (state.getFont().equals("Helvetica")) {
            ret = ret + ",sans-serif";
        }
        if (state.getFont().equals("Courier")) {
            ret = ret + ",monospace";
        }
        if ((state.getFontStyle() & 2) != 0) {
            ret = ret + ";font-style:italic";
        }
        if ((state.getFontStyle() & 1) != 0) {
            ret = ret + ";font-weight:bold";
        }
        switch (state.getAlignment()) {
            case 2: {
                ret = ret + ";text-align:right";
                break;
            }
            case 1: {
                ret = ret + ";text-align:center";
            }
        }
        return ret;
    }

    public String getDSStyleString(RichTextState state) {
        String ret = "font: ";
        if ((state.getFontStyle() & 2) != 0) {
            ret = ret + "italic ";
        }
        if ((state.getFontStyle() & 1) != 0) {
            ret = ret + "bold ";
        }
        ret = ret + state.getFont() + " " + (double)state.getFontPtSize() / this.userUnit + "pt; color:#000000";
        switch (state.getAlignment()) {
            case 0: {
                ret = ret + "; text-align:left";
                break;
            }
            case 2: {
                ret = ret + "; text-align:right";
                break;
            }
            case 1: {
                ret = ret + "; text-align:center";
            }
        }
        return ret;
    }

    public static String getDAFontString(RichTextState state) {
        if (state.getFont().equals("Courier")) {
            switch (state.getFontStyle()) {
                case 2: {
                    return "/CoOb";
                }
                case 1: {
                    return "/CoBo";
                }
                case 3: {
                    return "/CoBO";
                }
            }
            return "/Cour";
        }
        switch (state.getFontStyle()) {
            case 2: {
                return "/HeOb";
            }
            case 1: {
                return "/HeBo";
            }
            case 3: {
                return "/HeBO";
            }
        }
        return "/Helv";
    }

    protected void renderFDFObject(TextField field, String subject, String author, Date creationDate, RichTextItem content, int i, int n) throws IOException {
        double ury;
        double lly;
        double urx;
        double llx;
        CDataRichTextItem subjectItem = new CDataRichTextItem(subject);
        CDataRichTextItem authorItem = new CDataRichTextItem(author);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssZ");
        String tmp = dateFormat.format(creationDate);
        String dateString = "D:" + tmp.substring(0, 17) + "'" + tmp.substring(17, 19) + "'";
        this.os.write(String.format("%d 0 obj\n<<", this.iobj).getBytes("US-ASCII"));
        double separation = 1.0;
        double width = field.getUrx() - field.getLlx();
        double height = field.getUry() - field.getLly();
        if (width > 1.1 * height || n == 1) {
            llx = this.dx + ((double)i * (field.getUrx() + separation) + (double)(n - i) * field.getLlx()) / (double)n;
            urx = this.dx + ((double)(i + 1) * field.getUrx() + (double)(n - i - 1) * (field.getLlx() - separation)) / (double)n;
            lly = this.dy + field.getLly();
            ury = this.dy + field.getUry();
        } else {
            urx = this.dx + field.getUrx();
            llx = this.dx + field.getLlx();
            ury = this.dy + height + 2.0 * field.getLly() - ((double)i * (field.getUry() + separation) + (double)(n - i) * field.getLly()) / (double)n;
            lly = this.dy + height + 2.0 * field.getLly() - ((double)(i + 1) * field.getUry() + (double)(n - i - 1) * (field.getLly() - separation)) / (double)n;
        }
        llx /= this.userUnit;
        lly /= this.userUnit;
        urx /= this.userUnit;
        ury /= this.userUnit;
        String bgColor = "0.9 0.9 0.9";
        if (field.isAlternativeReviewCycleTextField()) {
            bgColor = "0.87 0.92 1.0";
        }
        this.os.write(("/Rect[" + llx + " " + lly + " " + urx + " " + ury + "]/Subtype/FreeText/BS <</W 0>>/CA 1.38499/C[" + bgColor + "]/F 132/Subj(").getBytes("UTF-8"));
        this.os.write(254);
        this.os.write(255);
        subjectItem.renderPlain(this.os);
        this.os.write(")/T(".getBytes("UTF-8"));
        this.os.write(254);
        this.os.write(255);
        authorItem.renderPlain(this.os);
        this.os.write((")/CreationDate(" + dateString + ")/M(" + dateString + ")").getBytes("UTF-8"));
        this.os.write(("/DA(0 0 0 rg " + AbstractTextFieldRenderer.getDAFontString(field) + " " + (double)field.getFontPtSize() / this.userUnit + " Tf)/DS(" + this.getDSStyleString(field) + ")/Contents(").getBytes("UTF-8"));
        this.os.write(254);
        this.os.write(255);
        content.renderPlain(this.os);
        this.os.write((")/RC(<?xml version=\"1.0\"?><body xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\" xfa:APIVersion=\"Acrobat:7.0.0\" xfa:spec=\"2.0.2\" style=\"" + this.getXMLStyleString(field) + "\">").getBytes("UTF-8"));
        content.render(this.os, field);
        this.os.write("</body>)/Type/Annot/Page 0".getBytes("UTF-8"));
        this.os.write(" >>\nendobj\n".getBytes("US-ASCII"));
        ++this.iobj;
    }

    protected void renderSignatureTextFieldInternal(TextField field, Date date, String subject, String reviewer, String digest, String header, String trailer, int i, int n, boolean outputReduced, boolean outputTiny) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        RichTextItemContainer root = new RichTextItemContainer();
        if (outputTiny) {
            root.addItem(new ParagraphRichTextItem(new BoldRichTextItem(new CDataRichTextItem(subject + " ")), new CDataRichTextItem(reviewer + "\r")));
            root.addItem(new CDataRichTextItem(df.format(date) + " "));
            if (!outputReduced) {
                root.addItem(new ParagraphRichTextItem(new BoldRichTextItem(new CDataRichTextItem("sigId: ")), new CDataRichTextItem(digest)));
            }
        } else {
            root.addItem(new ParagraphRichTextItem(new BoldRichTextItem(new CDataRichTextItem(subject + "\r"))));
            root.addItem(new ParagraphRichTextItem(new CDataRichTextItem(reviewer + "\r")));
            root.addItem(new ParagraphRichTextItem(new CDataRichTextItem(df.format(date) + "\r")));
            if (!outputReduced) {
                root.addItem(new ParagraphRichTextItem(new BoldRichTextItem(new CDataRichTextItem("sigId: ")), new CDataRichTextItem(digest + "\r")));
            }
            if (trailer != null) {
                root.addItem(new ParagraphRichTextItem(new CDataRichTextItem(trailer + "\r")));
            }
        }
        this.renderFDFObject(field, subject, reviewer, date, root, i, n);
    }

    @Override
    public void visit(TemporaryCustomTextField field) throws IOException {
    }
}

