/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.document.NumberCalculator;
import at.cdes.api.document.NumberCalculatorException;
import at.cdes.api.document.NumberCalculatorFullResult;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.document.BaseDocumentVersion;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.TemporaryDocumentVersion;
import at.cdes.bo.data.project.Project;
import at.cdes.controller.number.OgnlNumberCalculator;
import at.cdes.db.dao.DocumentDAO;
import at.cdes.db.dao.DocumentVersionDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.ReviewCycleCellConnectionDAO;
import at.cdes.db.dao.ReviewCycleCellDAO;
import at.cdes.db.dao.ReviewCycleCellResultDAO;
import at.cdes.db.dao.ReviewCycleResultOptionDAO;

public class NumberCalculatorImpl
implements NumberCalculator {
    private DocumentDAO documentDAO;
    private ProjectDAO projectDAO;
    private ReviewCycleCellDAO reviewCycleCellDAO;
    private OgnlNumberCalculator ognlNumberCalculator;
    private DocumentVersionDAO documentVersionDAO;
    private ReviewCycleResultOptionDAO reviewCycleResultOptionDAO;
    private ReviewCycleCellConnectionDAO reviewCycleCellConnectionDAO;
    private ReviewCycleCellResultDAO reviewCycleCellResultDAO;

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setReviewCycleCellDAO(ReviewCycleCellDAO reviewCycleCellDAO) {
        this.reviewCycleCellDAO = reviewCycleCellDAO;
    }

    public void setOgnlNumberCalculator(OgnlNumberCalculator ognlNumberCalculator) {
        this.ognlNumberCalculator = ognlNumberCalculator;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setReviewCycleResultOptionDAO(ReviewCycleResultOptionDAO reviewCycleResultOptionDAO) {
        this.reviewCycleResultOptionDAO = reviewCycleResultOptionDAO;
    }

    public void setReviewCycleCellConnectionDAO(ReviewCycleCellConnectionDAO reviewCycleCellConnectionDAO) {
        this.reviewCycleCellConnectionDAO = reviewCycleCellConnectionDAO;
    }

    public void setReviewCycleCellResultDAO(ReviewCycleCellResultDAO reviewCycleCellResultDAO) {
        this.reviewCycleCellResultDAO = reviewCycleCellResultDAO;
    }

    public String getNumber(Long unreleasedDocumentId, Long reviewCycleCellId) throws NumberCalculatorException {
        return this.getFull(unreleasedDocumentId, reviewCycleCellId).getPlanNumber();
    }

    public NumberCalculatorFullResult getFull(Long unreleasedDocumentId, Long reviewCycleCellId) throws NumberCalculatorException {
        TemporaryDocumentVersion tdv = new TemporaryDocumentVersion();
        DocumentImpl document = this.documentDAO.get(unreleasedDocumentId.intValue());
        String planNumber = this.ognlNumberCalculator.getNumber((Document)document, document.getDocumentList().getSubProject().getProject(), this.reviewCycleCellDAO.get(reviewCycleCellId.intValue()), (BaseDocumentVersion)tdv);
        NumberCalculatorFullResult ret = new NumberCalculatorFullResult();
        ret.setPlanNumber(planNumber);
        ret.setVersionPartA(tdv.getVersionPartA());
        ret.setVersionPartB(tdv.getVersionPartB());
        ret.setVersionPartSeperator(tdv.getVersionPartSeperator());
        return ret;
    }

    public NumberCalculatorFullResult getFull(Long unreleasedDocumentId, Long reviewCycleCellId, String versionPartA, String versionPartB) throws NumberCalculatorException {
        TemporaryDocumentVersion tdv = new TemporaryDocumentVersion();
        if (versionPartA != null) {
            tdv.setVersionPartA(versionPartA);
        }
        if (versionPartB != null) {
            tdv.setVersionPartB(versionPartB);
        }
        DocumentImpl document = this.documentDAO.get(unreleasedDocumentId.intValue());
        String planNumber = this.ognlNumberCalculator.getNumber((Document)document, document.getDocumentList().getSubProject().getProject(), this.reviewCycleCellDAO.get(reviewCycleCellId.intValue()), (BaseDocumentVersion)tdv);
        NumberCalculatorFullResult ret = new NumberCalculatorFullResult();
        ret.setPlanNumber(planNumber);
        ret.setVersionPartA(tdv.getVersionPartA());
        ret.setVersionPartB(tdv.getVersionPartB());
        ret.setVersionPartSeperator(tdv.getVersionPartSeperator());
        return ret;
    }

    public NumberCalculatorFullResult getNumberForOption(Long documentVersionId, Long reviewCycleResultOptionId, String separator) throws NumberCalculatorException {
        DocumentVersion version = this.documentVersionDAO.get(documentVersionId.intValue());
        ReviewCycleResultOption option = this.reviewCycleResultOptionDAO.get(reviewCycleResultOptionId.intValue());
        this.ognlNumberCalculator.getNumber(version.getDocument(), version.getDocument().getDocumentList().getSubProject().getProject(), option, version, separator);
        NumberCalculatorFullResult ret = new NumberCalculatorFullResult();
        ret.setPlanNumber(version.getName());
        ret.setVersionPartA(version.getVersionPartA());
        ret.setVersionPartB(version.getVersionPartB());
        ret.setVersionPartSeperator(version.getVersionPartSeperator());
        return ret;
    }

    public NumberCalculatorFullResult getConnectionFull(Long reviewCycleCellConnectionId, Long reviewCycleCellResultId, Long projectId) throws NumberCalculatorException {
        TemporaryDocumentVersion tdv = new TemporaryDocumentVersion();
        String planNumber = this.ognlNumberCalculator.getNumber(this.reviewCycleCellConnectionDAO.get(reviewCycleCellConnectionId.intValue()), this.reviewCycleCellResultDAO.get(reviewCycleCellResultId.intValue()), this.projectDAO.get(projectId.intValue()), (BaseDocumentVersion)tdv);
        NumberCalculatorFullResult ret = new NumberCalculatorFullResult();
        ret.setPlanNumber(planNumber);
        ret.setVersionPartA(tdv.getVersionPartA());
        ret.setVersionPartB(tdv.getVersionPartB());
        ret.setVersionPartSeperator(tdv.getVersionPartSeperator());
        return ret;
    }

    public String getLastSeperator(Long projectId) {
        Project project = this.projectDAO.get(projectId.intValue());
        try {
            return this.ognlNumberCalculator.getLastSeperator(null, project);
        }
        catch (NumberCalculatorException e) {
            e.printStackTrace();
            return null;
        }
    }
}

