/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.document.DocumentRef;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.file.FileFinder;
import at.cdes.db.dao.DocumentRefDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import at.cdes.util.ImplContextHelper;
import java.io.File;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class DocumentRefMimeSource
implements VisitlessMimeSource {
    private DocumentRefDAO documentRefDAO;
    private ProjectDAO projectDAO;
    private FileFinder fileFinder;

    public String getActionName() {
        return "reviewProtocoll";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        return ImplContextHelper.getContextProjectId() != null ? this.projectDAO.get(ImplContextHelper.getContextProjectId()) : null;
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        String unique;
        File file;
        Integer id = (Integer)parameters[0];
        DocumentRef ref = this.documentRefDAO.get(id);
        String prettyFilename = null;
        try {
            file = ref.getId() > 0 ? this.fileFinder.findFile(ref.getAttachmentFilename(), CDESFileRepository.DOCUMENTREFSREPOSITORY) : this.fileFinder.findFile(ref.getAttachmentFilename(), CDESFileRepository.TEMPREPOSITORY);
            unique = this.fileFinder.makeUniqueName(ref.getAttachmentFilename(), CDESFileRepository.DOCUMENTREFSREPOSITORY);
            prettyFilename = ref.getAttachmentOriginalFilename();
            if (ref.getAttachmentFiletype() != null) {
                prettyFilename = prettyFilename + "." + ref.getAttachmentFiletype();
            }
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the DocumentRef", (Throwable)e);
        }
        return new FileMimeInputStream(file, unique, prettyFilename, DefaultHttpContext.getInstance().getMimeType(ref.getAttachmentFilename()));
    }

    public void setDocumentRefDAO(DocumentRefDAO documentRefDAO) {
        this.documentRefDAO = documentRefDAO;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }
}

