/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.hibernate;

import at.cdes.hibernate.HibernateSessionOptimizer;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.clazzes.util.aop.ThreadLocalManager;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateSessionInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HibernateSessionInterceptor.class);
    private String hibernateThreadLocalKey;
    private SessionFactory sessionFactory;
    private DataSource dataSource;
    private String dataSourceThreadLocalKey;
    private String hibernateTransactionThreadLocalKey;
    private FlushMode flushMode;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSourceThreadLocalKey(String dataSourceThreadLocalKey) {
        this.dataSourceThreadLocalKey = dataSourceThreadLocalKey;
    }

    public void setHibernateTransactionThreadLocalKey(String hibernateTransactionThreadLocalKey) {
        this.hibernateTransactionThreadLocalKey = hibernateTransactionThreadLocalKey;
    }

    public void setFlushMode(String flushMode) {
        this.flushMode = "COMMIT".equals(flushMode) ? FlushMode.COMMIT : ("AUTO".equals(flushMode) ? FlushMode.AUTO : ("ALWAYS".equals(flushMode) ? FlushMode.ALWAYS : FlushMode.ALWAYS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (ThreadLocalManager.getBoundResource((String)this.hibernateThreadLocalKey) != null) {
            return invocation.proceed();
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(HibernateSessionOptimizer.class.getClassLoader());
        try {
            Object object;
            if (log.isDebugEnabled()) {
                log.debug("Fetched connection, will openSession(connection) for method [" + invocation.getMethod() + "]");
            }
            ThreadLocalManager.bindResource((String)this.dataSourceThreadLocalKey, (Object)this.dataSource);
            Session session = this.sessionFactory.openSession();
            session.setFlushMode(this.flushMode);
            if (log.isDebugEnabled()) {
                log.debug("Opened session, will beginTransaction() for method [" + invocation.getMethod() + "]");
            }
            Transaction transaction = null;
            try {
                transaction = session.beginTransaction();
                if (log.isDebugEnabled()) {
                    log.debug("beginTransaction() succeeded, will proceed() for method [" + invocation.getMethod() + "]");
                }
                ThreadLocalManager.bindResource((String)this.hibernateThreadLocalKey, (Object)session);
                ThreadLocalManager.bindResource((String)this.hibernateTransactionThreadLocalKey, (Object)transaction);
                Object ret = invocation.proceed();
                if (log.isDebugEnabled()) {
                    log.debug("invocation.proceed() succeeded, will commit() for method [" + invocation.getMethod() + "]");
                }
                transaction.commit();
                ThreadLocalManager.unbindResource((String)this.hibernateThreadLocalKey);
                ThreadLocalManager.unbindResource((String)this.hibernateTransactionThreadLocalKey);
                transaction = null;
                if (log.isDebugEnabled()) {
                    log.debug("unbindResource() succeeded for method [" + invocation.getMethod() + "]");
                }
                object = ret;
            }
            catch (Throwable throwable) {
                try {
                    if (transaction != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Will unbindResource() and rollback() for method [" + invocation.getMethod() + "]");
                        }
                        ThreadLocalManager.unbindResource((String)this.hibernateThreadLocalKey);
                        ThreadLocalManager.unbindResource((String)this.hibernateTransactionThreadLocalKey);
                        transaction.rollback();
                        if (log.isDebugEnabled()) {
                            log.debug("transaction.rollback() succeeded for method [" + invocation.getMethod() + "]");
                        }
                    }
                }
                catch (Throwable e) {
                    log.warn("Error rolling back Hibernate transaction for method [" + invocation.getMethod() + "]", e);
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Will close() session for method [" + invocation.getMethod() + "]");
                    }
                    session.close();
                    if (!log.isDebugEnabled()) throw throwable;
                    log.debug("close() session succeeded for method [" + invocation.getMethod() + "]");
                    throw throwable;
                }
                catch (Throwable e) {
                    log.warn("Error closing Hibernate session for method [" + invocation.getMethod() + "]", e);
                }
                throw throwable;
            }
            try {
                if (transaction != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Will unbindResource() and rollback() for method [" + invocation.getMethod() + "]");
                    }
                    ThreadLocalManager.unbindResource((String)this.hibernateThreadLocalKey);
                    ThreadLocalManager.unbindResource((String)this.hibernateTransactionThreadLocalKey);
                    transaction.rollback();
                    if (log.isDebugEnabled()) {
                        log.debug("transaction.rollback() succeeded for method [" + invocation.getMethod() + "]");
                    }
                }
            }
            catch (Throwable e) {
                log.warn("Error rolling back Hibernate transaction for method [" + invocation.getMethod() + "]", e);
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Will close() session for method [" + invocation.getMethod() + "]");
                }
                session.close();
                if (!log.isDebugEnabled()) return object;
                log.debug("close() session succeeded for method [" + invocation.getMethod() + "]");
                return object;
            }
            catch (Throwable e) {
                log.warn("Error closing Hibernate session for method [" + invocation.getMethod() + "]", e);
            }
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            ThreadLocalManager.unbindResource((String)this.dataSourceThreadLocalKey);
        }
    }

    public void setHibernateThreadLocalKey(String hibernateThreadLocalKey) {
        this.hibernateThreadLocalKey = hibernateThreadLocalKey;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }
}

