/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.masterdata;

import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.role.ActionRule;
import at.cdes.bo.data.role.ActionRuleDefault;
import at.cdes.bo.data.role.CDESAction;
import at.cdes.bo.data.role.Context;
import at.cdes.db.dao.ActionDAO;
import at.cdes.db.dao.ContextDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.masterdata.IActionRuleUpdater;
import java.util.List;
import org.apache.log4j.Logger;

public class ActionRuleUpdater
implements IActionRuleUpdater {
    private static final Logger logger = Logger.getLogger(ActionRuleUpdater.class);
    private ActionDAO actionDAO;
    private NetworkDAO networkDAO;
    private ContextDAO contextDAO;
    private CDESAction[] cdesActions;

    public ActionRuleUpdater() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"ActionRuleUpdater created.");
        }
    }

    @Override
    public void startUpdate() {
        logger.info((Object)"ActionRuleUpdater started.");
        this.createRules();
    }

    protected void createRules() {
        this.checkCDESActions();
        logger.info((Object)"Creating rules ...");
        List networks = this.networkDAO.getAll();
        if (networks == null || networks.size() == 0) {
            logger.info((Object)"No networks found to create rules.");
        } else {
            logger.info((Object)("[" + networks.size() + "] networks found to create rules."));
        }
        int i = 0;
        int createCount = 0;
        int createDefaultCount = 0;
        for (ActionList aa : ActionList.values()) {
            ActionRuleDefault ruleDefault;
            List<ActionRule> rules;
            if (aa.global && ((rules = this.actionDAO.getActionRules(this.cdesActions[i].getId(), null)) == null || rules.size() == 0)) {
                Context context = this.contextDAO.get(1);
                this.addActionRule(this.cdesActions[i], null, context, false);
                ++createCount;
            }
            Context context = null;
            if (aa.context != -1) {
                context = this.contextDAO.get(aa.context);
                if (networks != null) {
                    for (Network network : networks) {
                        List<ActionRule> rules2;
                        if (network == null || (rules2 = this.actionDAO.getActionRules(this.cdesActions[i].getId(), network.getId())) != null && rules2.size() != 0) continue;
                        this.addActionRule(this.cdesActions[i], network, context, true);
                        ++createCount;
                    }
                }
            } else {
                context = this.contextDAO.get(20);
            }
            if ((ruleDefault = this.actionDAO.getActionRuleDefaultByAction(this.cdesActions[i].getId())) == null && aa.context != -1) {
                this.addActionRuleDefault(this.cdesActions[i], context, true);
                ++createDefaultCount;
                logger.info((Object)("ActionRuleDefault created for action with name=[" + this.cdesActions[i].getName() + "]"));
            }
            ++i;
        }
        logger.info((Object)("All ActionRules checked, [" + createCount + "] created"));
        logger.info((Object)("All default ActionRules checked, [" + createDefaultCount + "] created"));
        logger.info((Object)"ActionRuleUpdater ended.");
    }

    private ActionRule addActionRule(CDESAction action, Network network, Context context, boolean checkMember) {
        ActionRule actionRule = new ActionRule();
        actionRule.setAction(action);
        actionRule.setCheckMember(checkMember);
        actionRule.setDestinationContext(context);
        actionRule.setNetwork(network);
        actionRule.setRoles(null);
        actionRule.setSelected(false);
        actionRule = this.actionDAO.save(actionRule);
        logger.info((Object)("New ActionRule [" + action.getName() + "] for network.id=[" + (network == null ? "null" : network.getId()) + "] added, id=[" + actionRule.getId() + "]"));
        return actionRule;
    }

    private ActionRuleDefault addActionRuleDefault(CDESAction action, Context context, boolean checkMember) {
        ActionRuleDefault ruleDefault = new ActionRuleDefault();
        ruleDefault.setAction(action);
        ruleDefault.setCheckMember(checkMember);
        ruleDefault.setDestinationContext(context);
        ruleDefault.setDefaultRoles(null);
        ruleDefault = this.actionDAO.save(ruleDefault);
        logger.info((Object)("New ActionRuleDefault [" + action.getName() + "] added, id=[" + ruleDefault.getId() + "]"));
        return ruleDefault;
    }

    private void checkCDESActions() {
        logger.info((Object)"Creating actions ...");
        int i = 0;
        int createCount = 0;
        this.cdesActions = new CDESAction[ActionList.values().length];
        for (ActionList aa : ActionList.values()) {
            CDESAction action = this.actionDAO.get(aa.name);
            if (action == null) {
                action = new CDESAction();
                action.setDescription(aa.desc);
                action.setName(aa.name);
                action.setReadOnly(aa.readOnly);
                action = this.actionDAO.save(action);
                ++createCount;
                logger.info((Object)("new CDESAction [" + aa.name + "] saved, id=[" + action.getId() + "]."));
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("CDESAction [" + aa.name + "] already found in DB, id=[" + action.getId() + "]."));
            }
            this.cdesActions[i++] = action;
        }
        logger.info((Object)("All CDESActions available, [" + createCount + "] created."));
    }

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setContextDAO(ContextDAO contextDAO) {
        this.contextDAO = contextDAO;
    }

    private static enum ActionList {
        requestCreateProjectArchive("requestCreateProjectArchive", "Anfrage an den Administrator, ein Projekt zu archivieren", 1, false, 3),
        requestRestoreProjectArchive("requestRestoreProjectArchive", "Anfrage an den Administrator, ein archiviertes Projekt wieder zu restaurieren", 1, false, 3),
        createProjectArchive("createProjectArchive", "Projekt archivieren", 0, true, -1),
        deleteProjectArchiveDataFiles("deleteProjectArchiveDataFiles", "Datenfiles von vorher archivierten Projekten aus der Datenbank l\u00f6schen", 0, true, -1),
        restoreProjectArchive("restoreProjectArchive", "Ein archiviertes Projekt restaurieren", 0, true, -1),
        reactivateProjectFromArchive("reactivateProjectFromArchive", "Aus dem Archiv restaurierte Projekte reaktivieren", 1, true, -1),
        changeProjectAccessMode("changeProjectAccessMode", "Projektzugriff zwischen 'nicht sichtbar', 'nur lesen' und 'lesen/schreiben' umschalten", 2, false, 3),
        archiveDocumentSearch("archiveDocumentSearch", "Komprimiertes Planarchiv", 0, false, 3),
        requestManualPlotOwnRecipient("requestManualPlotOwnRecipient", "Manuellen Plotauftrag erstellen, nur der aktive Projektbeteiligte steht als Empf\u00e4nger zur Auswahl", 0, false, 3),
        requestManualPlotAllRecipients("requestManualPlotAllRecipients", "Manuellen Plotauftrag erstellen, alle Projektbeteiligten stehen als Empf\u00e4nger zur Auswahl", 0, false, 3),
        requestManualPlotAllRights("requestManualPlotAllRights", "Manuellen Plotauftrag erstellen, alle Projektbeteiligten stehen als Empf\u00e4nger zur Auswahl und properties ver\u00e4nderbar", 0, false, 3),
        showSupport("showSupport", "Supportinformationen anzeigen", 1, true, -1),
        editSupport("editSupport", "Supportinformationen bearbeiten und hinzuf\u00fcgen", 1, true, -1),
        deleteTask("deleteTask", "Aufgabe l\u00f6schen und Dokument dem Pr\u00fcflauf entsprechend verschieben", 0, true, -1),
        referenceOrganisation("referenceOrganisation", "Organisation aus einem anderen Netzwerk zum Eigenen hinzuf\u00fcgen", 0, true, 2),
        deleteDocumentVersion("deleteDocumentVersion", "uneingeschr\u00e4nktes 'Upload widerrufen'", 0, false, 3),
        reviseDocumentVersion("reviseDocumentVersion", "Revision zu einem freigegebenen Plan hochladen", 0, false, 4),
        uploadInvalidateDocument("uploadInvalidateDocument", "Plan ung\u00fcltig erkl\u00e4ren und neuen Plan hochladen in einem Schritt", 0, false, 4),
        requestManualPlotOwnRecipientOPContext("requestManualPlotOwnRecipientOPContext", "Manuellen Plotauftrag erstellen, nur der aktive Projektbeteiligte steht als Empf\u00e4nger zur Auswahl, mit Objektblatt-Kontext", 0, false, 4),
        requestManualPlotAllRecipientsOPContext("requestManualPlotAllRecipientsOPContext", "Manuellen Plotauftrag erstellen, alle Projektbeteiligten stehen als Empf\u00e4nger zur Auswahl, mit Objektblatt-Kontext", 0, false, 4),
        requestManualPlotAllRightsOPContext("requestManualPlotAllRightsOPContext", "Manuellen Plotauftrag erstellen, alle Projektbeteiligten stehen als Empf\u00e4nger zur Auswahl und properties ver\u00e4nderbar, mit Objektblatt-Kontext", 0, false, 4),
        requestOriginalDocumentOPContext("requestOriginalDocumentOPContext", "   Original-Dokument anfordern, mit Objektblatt-Kontext", 0, false, 4),
        reviewProtocollOPContext("reviewProtocollOPContext", "Pr\u00fcfprotokoll mit Objektblatt-Kontext anzeigen", 1, false, 4),
        downloadDocumentVersionOPContext("downloadDocumentVersionOPContext", "Documentversion herunterladen, mit Objektblatt-Kontext", 1, false, 4),
        showObjectPlannerOPContext("showObjectPlannerOPContext", "Objektblatt anzeigen, mit Objektblatt-Kontext", 1, false, 4),
        invalidateDocumentOPContext("invalidateDocumentOPContext", "Dokument ung\u00fcltig erkl\u00e4hren (Status U), mit Objektblatt-Kontext", 0, false, 4),
        overrideLateReviews("overrideLateReviews", "S\u00e4umige Pr\u00fcfaufgaben durchwinken", 0, false, 3),
        monitorLateReviews("monitorLateReviews", "S\u00e4umige Pr\u00fcfaufgaben anzeigen und per e-mail benachrichtigt werden", 0, false, 3),
        administrateNetwork("administrateNetworkProjects", "Konfiguration und Berechtigung zur Einsicht aller Projekte eines Netzwerks", 0, true, -1),
        exportReviewCycleStatus("exportReviewCycleStatus", "Excel-Export des Pr\u00fcfstatus", 1, false, 3),
        editPDCcsvImport("editPDCcsvImport", "Planlieferkatalog Import von CSV- Dateien", 0, false, 4),
        changeNetworkReviewCycles("changeNetworkReviewCycles", "Pr\u00fcfl\u00e4ufe zu Netzwerken hinzuf\u00fcgen bzw. entfernen", 0, true, -1),
        customLabelAssemblyDownload("customLabelAssemblyDownload", "Sammeldownload mit benutzerdefinierten Planschildinhalten", 0, true, -1),
        editVersionParts("editVersionParts", "Versionsnummern beim Upload ver\u00e4ndern", 0, false, 2),
        copySubProject("copySubProject", "Projektstatii mit allen Unterelementen kopieren", 1, false, 3),
        showDocumentsOfDeletedObjectPlanners("showDocumentsOfDeletedObjectPlanners", "Pl\u00e4ne gel\u00f6schter Objektbl\u00e4tter anzeigen", 1, false, 3),
        reactivatePreviousDocumentVersion("reactivatePreviousDocumentVersion", "Bei Upload Widerrufen die letzte Dokumentversion reaktivieren, wenn diese vorher Status-X erkl\u00e4rt wurde", 1, false, 3),
        administrateAsBuiltSubProject("administrateAsBuiltSubProject", "Erstellung und Administration von Bestandsplanphasen", 0, false, 3),
        administrateAsBuiltDocuments("administrateAsBuiltDocuments", "Import bzw. \u00dcberf\u00fchren von Bestandspl\u00e4nen", 0, false, 3),
        archiveReviewHistory("archiveReviewHistory", "Planarchiv mit Pr\u00fcfhistorie", 0, false, 3),
        superAdminRight("superAdminRight", "Systemadministratorenrecht zur Durchf\u00fchrung diverser Aufgaben", 0, true, -1),
        showProjectPlotOrders("showProjectPlotOrders", "Anzeigen aller Plotauftr\u00e4ge des betreffenden Projektes", 1, false, 3),
        chargePlotOrder("chargePlotOrder", "Abgeschlossene Plotauftr\u00e4ge als verrechnet signieren", 0, false, 3),
        showPngPreview("showPngPreview", "PNG Planvorschau", 0, false, 3),
        administrateCertificate("administrateCertificate", "Zertifkate verwalten (einladen, ausstellen, etc.)", 0, true, 1),
        planningNotificationSectionOverview("planningNotificationSectionOverview", "Register Auflagenmanagementkatalog", 0, true, 1),
        editPlanningNotificationTemplate("editPlanningNotificationTemplate", "Vorlagen f\u00fcr Bescheide bearbeiten", 0, true, 1),
        planningNotificationOverview("planningNotificationOverview", "\u00dcbersicht Bescheide", 1, false, 3),
        editPlanningNotification("editPlanningNotification", "Bescheide erstellen/bearbeiten", 0, false, 3),
        deletePlanningNotification("deletePlanningNotification", "Bescheide l\u00f6schen", 0, false, 3),
        downloadPlanningNotification("downloadPlanningNotification", "Bescheide herunterladen", 1, false, 3),
        editPlanningNotificationOrder("editPlanningNotificationOrder", "Vorgaben erstellen/bearbeiten", 0, false, 3),
        reassignPlanningNotificationToOrder("reassignPlanningNotificationToOrder", "Einer Vorgabe einen Bescheid neu zuordnen.", 0, false, 3),
        deletePlanningNotificationOrder("deletePlanningNotificationOrder", "Vorgabe l\u00f6schen", 0, false, 3),
        editPlanningNotificationProject("editPlanningNotificationProject", "Projekt Auflagenmanagementkatalog erstellen/bearbeiten", 0, false, 3),
        deletePlanningNotificationProject("deletePlanningNotificationProject", "Projekt Auflagenmanagementkatalog l\u00f6schen", 0, false, 3),
        insertPlanningNotificationProject("insertPlanningNotificationProject", "Projekt Auflagenmanagementkatalog erzeugen", 0, false, 2),
        generatePlanningNotificationReport("generatePlanningNotificationReport", "Auflagenmanagementkatalog Report erstellen", 0, false, 3),
        exportPlanningNotificationReportMSP("exportPlanningNotificationReportMSP", "Auflagenmanagementkatalog Report nach MSP exportieren", 0, false, 3),
        exportPlanningNotificationOrdersMSP("exportPlanningNotificationOrdersMSP", "Auflagenmanagementkatalog Vorgaben mit Rechtspflicht nach MSP exportieren", 0, false, 3),
        exportDocumentsMSP("exportDocumentsMSP", "Pl\u00e4ne/Dokumente (z.B. Bestand) nach MSP exportieren", 0, false, 3),
        monitorOpenReviewsPlanningNotification("monitorOpenReviewsPlanningNotification", "Auflagenmanagementkatalog Offene Aufgaben einsehen", 0, false, 3),
        assignOpenReviewsPlanningNotification("assignOpenReviewsPlanningNotification", "Auflagenmanagementkatalog Offene Aufgaben an anderen Pr\u00fcfer \u00fcbertragen", 0, false, 3),
        showOnlyOwnParticipationReviews("showOnlyOwnParticipationReviews", "Im Pr\u00fcfprotokoll nur meine bzw. Pr\u00fcfungen meines Projektteilnehmers anzeigen", 1, false, 3),
        showProjectMultiLanguageOption("showProjectMultiLanguageOption", "Die Projektoption 'Projektzweisprachigkeit' erm\u00f6glichen", 0, false, 2);

        private String name;
        private String desc;
        private int readOnly;
        private boolean global;
        private int context;

        private ActionList(String name, String desc, int readOnly, boolean global, int context) {
            this.name = name;
            this.desc = desc;
            this.readOnly = readOnly;
            this.global = global;
            this.context = context;
        }
    }
}

