/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.cycle.ReviewCycle;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentRef;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.ReleasedDocumentList;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.Label;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.bo.data.order.orig.OriginalDocumentOrder;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.file.FileFinder;
import at.cdes.db.dao.AttachmentDAO;
import at.cdes.db.dao.OrderDAO;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DocumentVersionSaver {
    private static final Logger log = Logger.getLogger(DocumentVersionSaver.class);
    private final Project project;
    private final FileFinder sourceFileFinder;
    private final FileFinder targetFileFinder;
    private final OrderDAO orderDAO;
    private final AttachmentDAO attachmentDAO;
    private State state;
    private static final long maxCount = 67076096L;

    protected DocumentVersionSaver(Project project, FileFinder fileFinder, FileFinder exportFileFinder, OrderDAO orderDAO, AttachmentDAO attachmentDAO) {
        this.project = project;
        this.sourceFileFinder = fileFinder;
        this.targetFileFinder = exportFileFinder;
        this.orderDAO = orderDAO;
        this.attachmentDAO = attachmentDAO;
        this.state = new State();
    }

    public void save() {
        this.state.setFinished(false);
        int count = 0;
        if (this.project == null) {
            log.error((Object)"project == null");
            return;
        }
        try {
            Collection reviewCycles;
            if (this.project.getSubProjects() == null) {
                log.error((Object)("subProjects == null when saving project id=[" + this.project.getId() + "]."));
                return;
            }
            Map subProjectsMap = this.project.getSubProjects();
            if (this.testNull("subProjectsMap", subProjectsMap)) {
                return;
            }
            Collection subProjects = subProjectsMap.values();
            if (subProjects != null) {
                for (SubProject subProject : subProjects) {
                    Collection<OriginalDocumentOrder> originals;
                    Object documents;
                    Map documentMap;
                    if (this.testNull("subProject", subProject)) continue;
                    log.info((Object)("Saving files of subproject [code=" + subProject.getCode() + ",name=" + subProject.getName() + "]..."));
                    ReleasedDocumentList releasedDocumentList = subProject.getActiveDocumentList();
                    if (!(this.testNull("releasedDocumentList", releasedDocumentList) || this.testNull("documentMap", documentMap = releasedDocumentList.getDocuments()) || this.testNull("documents", documents = documentMap.values()))) {
                        Iterator iterator = documents.iterator();
                        while (iterator.hasNext()) {
                            Map<Integer, DocumentRef> docRefMap;
                            Document document = (Document)iterator.next();
                            if (this.testNull("document", document)) continue;
                            Collection<DocumentVersion> docVersions = document.getAllDocumentVersions();
                            if (!this.testNull("docVersions", docVersions)) {
                                for (DocumentVersion dv : docVersions) {
                                    if (this.testNull("documentVersion", dv)) continue;
                                    this.copyFile(dv.getFileName(), CDESFileRepository.PLANREPOSITORY);
                                    ++count;
                                    List<Attachment> attachments = this.attachmentDAO.getAll(dv.getId());
                                    if (this.testNull("attachments", attachments)) continue;
                                    for (Attachment attachment : attachments) {
                                        if (this.testNull("attachment", attachment)) continue;
                                        this.copyFile(attachment.getFileName(), CDESFileRepository.ATTACHMENTREPOSITORY);
                                        ++count;
                                    }
                                }
                            }
                            if (this.testNull("docRefMap", docRefMap = document.getDocumentRefs())) continue;
                            Collection<DocumentRef> docRefs = docRefMap.values();
                            for (DocumentRef ref : docRefs) {
                                if (this.testNull("DocumentRef", ref)) continue;
                                this.copyFile(ref.getAttachmentFilename(), CDESFileRepository.DOCUMENTREFSREPOSITORY);
                                ++count;
                            }
                        }
                    }
                    if ((originals = this.orderDAO.getOriginalDocumentOrders(subProject.getId())) != null && !originals.isEmpty()) {
                        documents = originals.iterator();
                        while (documents.hasNext()) {
                            OriginalDocumentOrder original = (OriginalDocumentOrder)documents.next();
                            if (this.testNull("original", original) || this.testNull("original.fileName", original.getFileName())) continue;
                            this.copyFile(original.getFileName(), CDESFileRepository.ORIGINALDOCUMENTSREPOSITORY);
                            ++count;
                        }
                    }
                    log.info((Object)("Successfully saved files of subproject [code=" + subProject.getCode() + ",name=" + subProject.getName() + "]."));
                }
            }
            log.info((Object)("Saving labels of project [id=" + this.project.getId() + ",name=" + this.project.getName() + "]..."));
            Map reviewCycleMap = this.project.getNetwork().getReviewCycles();
            if (!this.testNull("reviewCycleMap", reviewCycleMap) && !this.testNull("reviewCycles", reviewCycles = reviewCycleMap.values())) {
                for (ReviewCycle reviewCycle : reviewCycles) {
                    Map labelsMap = reviewCycle.getLabels();
                    if (this.testNull("labelsMap", labelsMap)) continue;
                    Collection labels = reviewCycle.getLabels().values();
                    for (Label label : labels) {
                        if (this.testNull("label", label)) continue;
                        Collection labelContents = label.getLabelContents().values();
                        for (LabelContent labelContent : labelContents) {
                            if (this.testNull("labelContent", labelContent)) continue;
                            this.copyFile(labelContent.getFileName(), CDESFileRepository.LABELREPOSITORY);
                            ++count;
                        }
                    }
                }
            }
            log.info((Object)("Successfully saved labels of project [id=" + this.project.getId() + ",name=" + this.project.getName() + "]."));
        }
        catch (ActionException e) {
            log.error((Object)"Caught ActionException: ", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error((Object)"Caught IOException: ", (Throwable)e);
            throw new ActionException("Caught IOException: ", e);
        }
        finally {
            this.state.setFinished(true);
            log.info((Object)("DocumentVersionSaver finished, [" + count + "] files copied."));
        }
    }

    private boolean testNull(String comment, Object obj) {
        if (obj == null) {
            log.error((Object)(comment + " is null when saving files for project id=[" + (this.project == null ? "null" : this.project.getId()) + "]."));
            return true;
        }
        return false;
    }

    protected void copyFile(String fileName, CDESFileRepository kind) throws ActionException, IOException {
        if (fileName == null || "".equals(fileName)) {
            log.info((Object)("FileName is empty, kind=[" + (Object)((Object)kind) + "]."));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("copy file [" + fileName + "] ..."));
        }
        AbstractInterruptibleChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            File sourceFile = this.sourceFileFinder.findFile(fileName, kind);
            if (sourceFile != null && sourceFile.exists() && !sourceFile.canRead()) {
                throw new ActionException("Can't read file [" + sourceFile.getAbsolutePath() + "].");
            }
            if (sourceFile != null && sourceFile.exists() && !sourceFile.isFile()) {
                log.error((Object)("[" + sourceFile.getAbsolutePath() + "] is not a regular file."));
                return;
            }
            if (sourceFile != null && sourceFile.exists() && sourceFile.length() < 1L) {
                log.error((Object)("[" + sourceFile.getAbsolutePath() + "] has no length."));
                return;
            }
            File targetFile = this.targetFileFinder.buildFile(fileName, kind);
            if (targetFile.exists()) {
                if (kind == CDESFileRepository.LABELREPOSITORY) {
                    return;
                }
                throw new ActionException("The file [" + targetFile.getAbsolutePath() + "] already exists.");
            }
            File targetDir = targetFile.getParentFile();
            if (!targetDir.exists() && !targetDir.mkdirs()) {
                throw new ActionException("Unable to create subdirectory [" + targetDir + "].");
            }
            inChannel = new FileInputStream(sourceFile).getChannel();
            outChannel = new FileOutputStream(targetFile).getChannel();
            long size = ((FileChannel)inChannel).size();
            for (long position = 0L; position < size; position += ((FileChannel)inChannel).transferTo(position, 67076096L, (WritableByteChannel)((Object)outChannel))) {
            }
        }
        catch (IOException e) {
            throw new ActionException("Caught IOException writing to " + fileName, e);
        }
        catch (FileHandleException e) {
            throw new ActionException("Caught filehandle exception writing to " + fileName, e);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public boolean isFinished() {
        return this.state.isFinished();
    }

    class State {
        private boolean finished;

        State() {
        }

        public synchronized boolean isFinished() {
            return this.finished;
        }

        public synchronized void setFinished(boolean finished) {
            this.finished = finished;
            this.notifyAll();
        }
    }
}

