/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.helper;

import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.bo.date.HolidayCalculatorFactory;
import at.cdes.controller.apiHelper.ReviewCycleInterpretationHelper;
import at.cdes.service.exception.ReviewException;
import java.util.Calendar;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.log4j.Logger;
import org.clazzes.util.lang.Pair;

public class ReviewCycleInterpretationHelperImpl
implements ReviewCycleInterpretationHelper {
    static Logger logger = Logger.getLogger(ReviewCycleInterpretationHelperImpl.class);
    private HolidayCalculatorFactory holidayCalculatorFactory;

    public void setHolidayCalculatorFactory(HolidayCalculatorFactory holidayCalculatorFactory) {
        this.holidayCalculatorFactory = holidayCalculatorFactory;
    }

    @Override
    public Pair<Calendar, Calendar> getTargetDatesForNodeResult(ReviewCycleNodeResult nodeResult, ReviewCycleNodeInstanceRelease nodeInstance, Project project) {
        HolidayCalculator holidayCalculator = this.holidayCalculatorFactory.getInstance(project);
        Calendar targetStart = Calendar.getInstance();
        targetStart.setTime(nodeResult.getDocumentArrivalDate());
        int nodeDuration = nodeInstance.getDuration();
        Calendar targetEnd = holidayCalculator.addWorkingDays(targetStart, nodeDuration);
        return new Pair((Object)targetStart, (Object)targetEnd);
    }

    @Override
    public Pair<Calendar, Calendar> getTargetDatesDocumentUpload(Document document, Project project) {
        Calendar targetStart = null;
        if (document.getStartDate() != null) {
            targetStart = Calendar.getInstance();
            targetStart.setTime(document.getStartDate());
        }
        return new Pair((Object)targetStart, null);
    }

    @Override
    public boolean verifyReviewCycleNodeSkippingRule(ReviewCycleNodeInstance nodeInst, DocumentVersion dv, OrganisationPerson asBuiltContractorOrgPerson) throws ReviewException {
        Object expression;
        ReviewCycleNode node = nodeInst.getReviewCycleNode();
        String rule = node.getSkippingRule();
        if (rule == null || rule.isEmpty() || rule.trim().isEmpty()) {
            return false;
        }
        rule = "#key=\"moveNode\", " + rule;
        try {
            expression = Ognl.parseExpression(rule);
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL parse error in expression [" + rule + "]: " + e));
            throw new ReviewException(9, (Throwable)e);
        }
        OgnlContext context = new OgnlContext();
        context.put("document", dv.getDocument());
        context.put("documentVersion", dv);
        context.put("asBuiltReference", dv.getAsBuiltReference());
        context.put("asBuiltDocument", ((DocumentImpl)dv.getDocument()).getAsBuiltReference());
        context.put("plannerOrgPerson", dv.getDocument().getObjectPlanner().getPlanner().getMainParticipant().getOrganisationPerson());
        context.put("asBuiltContractorOrgPerson", asBuiltContractorOrgPerson);
        context.put("project", dv.getDocument().getObjectPlanner().getObject().getObjectList().getSubProject().getProject());
        try {
            Object res = Ognl.getValue(expression, (Map)context, (Object)context);
            if (res == null) {
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OGNL evaluation: expression [" + rule + "], res [" + res + "]."));
            }
            return Boolean.parseBoolean(String.valueOf(res));
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL evaluation error in expression [" + rule + "]: " + e));
            throw new ReviewException(9, (Throwable)e);
        }
    }

    @Override
    public boolean verifyReviewCycleNodeSkippingRuleForDocument(ReviewCycleNodeInstance nodeInst, DocumentImpl document, OrganisationPerson asBuiltContractorOrgPerson) throws ReviewException {
        Object expression;
        ReviewCycleNode node = nodeInst.getReviewCycleNode();
        String rule = node.getSkippingRule();
        if (rule == null || rule.isEmpty() || rule.trim().isEmpty()) {
            return false;
        }
        rule = "#key=\"moveNode\", " + rule;
        try {
            expression = Ognl.parseExpression(rule);
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL parse error in expression [" + rule + "]: " + e));
            throw new ReviewException(9, (Throwable)e);
        }
        OgnlContext context = new OgnlContext();
        context.put("document", document);
        context.put("documentVersion", (Object)null);
        context.put("asBuiltReference", (Object)null);
        context.put("asBuiltDocument", document.getAsBuiltReference());
        context.put("plannerOrgPerson", document.getObjectPlanner().getPlanner().getMainParticipant().getOrganisationPerson());
        context.put("asBuiltContractorOrgPerson", asBuiltContractorOrgPerson);
        context.put("project", document.getObjectPlanner().getObject().getObjectList().getSubProject().getProject());
        try {
            Object res = Ognl.getValue(expression, (Map)context, (Object)context);
            if (res == null) {
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OGNL evaluation: expression [" + rule + "], res [" + res + "]."));
            }
            return Boolean.parseBoolean(String.valueOf(res));
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL evaluation error in expression [" + rule + "]: " + e));
            throw new ReviewException(9, (Throwable)e);
        }
    }

    @Override
    public boolean verifyReviewCycleNodeSkippingRuleForProject(ReviewCycleNode node, Project project) throws ReviewException {
        Object expression;
        String rule = node.getSkippingRule();
        if (rule == null || rule.isEmpty() || rule.trim().isEmpty()) {
            return false;
        }
        rule = "#key=\"showNode\", " + rule;
        try {
            expression = Ognl.parseExpression(rule);
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL parse error in expression [" + rule + "]: " + e));
            throw new ReviewException(9, (Throwable)e);
        }
        OgnlContext context = new OgnlContext();
        context.put("document", (Object)null);
        context.put("documentVersion", (Object)null);
        context.put("asBuiltReference", (Object)null);
        context.put("asBuiltDocument", (Object)null);
        context.put("plannerOrgPerson", (Object)null);
        context.put("asBuiltContractorOrgPerson", (Object)null);
        context.put("project", project);
        try {
            Object res = Ognl.getValue(expression, (Map)context, (Object)context);
            if (res == null) {
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OGNL evaluation: expression [" + rule + "], res [" + res + "]."));
            }
            return Boolean.parseBoolean(String.valueOf(res));
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL evaluation error in expression [" + rule + "]: " + e));
            throw new ReviewException(9, (Throwable)e);
        }
    }
}

