/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.data.cycle.ReviewCycleInstanceRelease;
import at.cdes.bo.data.cycle.ReviewCyclePositionReleaseImpl;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.object.ObjectPlannerPosition;
import at.cdes.bo.data.object.ReleasedCDESObject;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.ObjectDigestCalculator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.util.encoders.Base64;

public class ObjectDigesterV1
extends ObjectDigestCalculator {
    @Override
    public String getObjectListHash(ReleasedObjectList objectList) throws DigestCalculatorException {
        if (objectList.getDigest() != null) {
            return objectList.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        DigestOutputStream dos = new DigestOutputStream(osd, this.getMessageDigest());
        try {
            dos.write(("id=" + objectList.getId()).getBytes());
            dos.write(("objectListId=" + objectList.getObjectList().getId()).getBytes());
            dos.write(("subprojectId=" + objectList.getSubProject().getId()).getBytes());
            dos.write(("version=" + objectList.getVersion()).getBytes());
            dos.write("objects".getBytes());
            if (objectList.getObjects() != null) {
                Object[] a = objectList.getObjects().keySet().toArray();
                Arrays.sort(a);
                for (int i = 0; i < a.length; ++i) {
                    dos.write(((Integer)a[i]).toString().getBytes());
                }
            }
        }
        catch (IOException e) {
            throw new DigestCalculatorException("Hashing ObjectList = ", e);
        }
        String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return res;
    }

    @Override
    public String getCDESObjectHash(ReleasedCDESObject object) throws DigestCalculatorException {
        if (object.getDigest() != null) {
            return object.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        DigestOutputStream dos = new DigestOutputStream(osd, this.getMessageDigest());
        try {
            dos.write(("id=" + object.getId()).getBytes());
            dos.write(("objectListId=" + object.getObjectList().getId()).getBytes());
            dos.write(("code=" + object.getCode()).getBytes());
            dos.write(("name=" + object.getName()).getBytes());
            dos.write(("comment=" + object.getComment()).getBytes());
            dos.write(("stretchKmFrom=" + object.getStretchKmFrom()).getBytes());
            dos.write(("stretchKmTo=" + object.getStretchKmTo()).getBytes());
            dos.write(("version=" + object.getObject().getId()).getBytes());
            dos.write(("version=" + object.getCode()).getBytes());
            dos.write("objects".getBytes());
        }
        catch (IOException e) {
            throw new DigestCalculatorException("Hashing Object = ", e);
        }
        String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return res;
    }

    @Override
    public String getObjectPlannerHash(ReleasedObjectPlanner objectPlanner) throws DigestCalculatorException {
        if (objectPlanner.getDigest() != null) {
            return objectPlanner.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        DigestOutputStream dos = new DigestOutputStream(osd, this.getMessageDigest());
        try {
            dos.write(("id=" + objectPlanner.getId()).getBytes());
            dos.write(("objectId=" + objectPlanner.getObject().getId()).getBytes());
            dos.write(("objectPlannerId=" + objectPlanner.getObjectPlanner().getId()).getBytes());
            dos.write(("code=" + objectPlanner.getCode()).getBytes());
            dos.write(("area=" + objectPlanner.getArea()).getBytes());
            if (objectPlanner.getReviewCycleInstance() != null) {
                dos.write(("reviewCycleInstanceId=" + objectPlanner.getReviewCycleInstance().getId()).getBytes());
            }
            if (objectPlanner.getPlanner() != null) {
                dos.write(("plannerId=" + objectPlanner.getPlanner().getId()).getBytes());
            }
            if (objectPlanner.getPositions() != null) {
                Collection positions = objectPlanner.getPositions().values();
                for (ObjectPlannerPosition position : positions) {
                    dos.write(("position" + position.getId() + "=" + position.getProjectParticipation().getId() + " " + position.getRole().getId()).getBytes());
                }
            }
        }
        catch (IOException e) {
            throw new DigestCalculatorException("Hashing Object = ", e);
        }
        String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return res;
    }

    @Override
    public String getReviewCycleInstanceHash(ReviewCycleInstanceRelease instance) throws DigestCalculatorException {
        if (instance.getDigest() != null) {
            return instance.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        DigestOutputStream dos = new DigestOutputStream(osd, this.getMessageDigest());
        try {
            dos.write(("id=" + instance.getId()).getBytes());
            dos.write(("name=" + instance.getName()).getBytes());
            dos.write(("subprojectId=" + instance.getSubProject().getId()).getBytes());
            dos.write(("subProjectId=" + instance.getReviewCycle().getId()).getBytes());
            dos.write(("reviewCycleInstanceId=" + instance.getReviewCycleInstance().getId()).getBytes());
            dos.write(("objectListId=" + instance.getObjectList().getId()).getBytes());
            if (instance.getReviewCycleCellInstances() != null) {
                Object[] a = instance.getReviewCycleCellInstances().keySet().toArray();
                Arrays.sort(a);
                for (int i = 0; i < a.length; ++i) {
                    Iterator it;
                    ReviewCycleCellInstanceRelease cell = (ReviewCycleCellInstanceRelease)instance.getReviewCycleCellInstances().get((Integer)a[i]);
                    dos.write(("cell-id=" + cell.getId()).getBytes());
                    dos.write(("cell-duration=" + cell.getDuration()).getBytes());
                    dos.write(("cell-cellId=" + cell.getReviewCycleCell().getId()).getBytes());
                    dos.write(("cell-cellInstanceId=" + cell.getReviewCycleCellInstance().getId()).getBytes());
                    dos.write(("cell-instanceId=" + cell.getReviewCycleInstance().getId()).getBytes());
                    dos.write(("cell-startCell" + cell.isStartCell()).getBytes());
                    Iterator iterator = it = cell.getReviewCycleNodeInstances() != null ? cell.getReviewCycleNodeInstances().values().iterator() : null;
                    while (it != null && it.hasNext()) {
                        ReviewCycleNodeInstanceRelease node = (ReviewCycleNodeInstanceRelease)it.next();
                        dos.write(("node-id=" + node.getId()).getBytes());
                        dos.write(("node-duration=" + node.getDuration()).getBytes());
                        dos.write(("node-cellInstanceId=" + node.getReviewCycleCellInstance().getId()).getBytes());
                        dos.write(("node-nodeId=" + node.getReviewCycleNode().getId()).getBytes());
                        dos.write(("node-nodeInstanceId=" + node.getReviewCycleNodeInstance().getId()).getBytes());
                        Object[] poss = node.getReviewCyclePositions().keySet().toArray();
                        Arrays.sort(poss);
                        for (int k = 0; k < poss.length; ++k) {
                            ReviewCyclePositionReleaseImpl pos = (ReviewCyclePositionReleaseImpl)node.getReviewCyclePositions().get((Integer)poss[k]);
                            dos.write(("postion-id=" + pos.getId()).getBytes());
                            dos.write(("postion-projectParticipationId=" + pos.getProjectParticipation().getId()).getBytes());
                            dos.write(("postion-realmId=" + pos.getRealm().getId()).getBytes());
                            dos.write(("postion-reviewCycleNodeInstanceId=" + pos.getReviewCycleNodeInstance().getId()).getBytes());
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new DigestCalculatorException("Hashing ReviewCycleInstanceRelease = ", e);
        }
        String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return res;
    }
}

