/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.project;

import at.cdes.bo.data.CdesDataObject;
import at.cdes.bo.data.cycle.ReviewCycleResultOption;
import at.cdes.bo.data.localisation.Localisation;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.number.DocumentNumberPartGroup;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.ProjectConfig;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.project.SubProjectComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Project
implements CdesDataObject {
    static final long serialVersionUID = 1L;
    public static final int STATUS_ACTIVE = 0;
    public static final int STATUS_ARCHIVING_REQUESTED = 1;
    public static final int STATUS_ARCHIVED = 2;
    public static final int STATUS_DATAFILES_DELETED = 3;
    public static final int STATUS_RESTORATION_REQUESTED = 4;
    public static final int STATUS_RESTORED = 5;
    public static final int STATUS_INACTIVE = 6;
    public static final int STATUS_UNFINISHED = 7;
    public static final int STATUS_PLANNINGNOTIFICATIONPROJECT = 10;
    public static final int ACCESS_INVISIBLE = 0;
    public static final int ACCESS_READ_ONLY = 1;
    public static final int ACCESS_READ_WRITE = 2;
    public static final int ACCESS_INVISIBLE_FORNONADMIN = 3;
    public static final int ACCESS_READ_ONLY_FORNONADMIN = 4;
    private Integer id;
    private String code;
    private String name;
    private String principalProject;
    private String stretchName;
    private String comment;
    private String routeName;
    private float kmFrom;
    private float kmTo;
    private Integer interval;
    private Date created;
    private OrganisationPerson createdBy;
    private Date modified;
    private OrganisationPerson modifiedBy;
    private Network network;
    private Map realms;
    private Map projectParticipations;
    private Map subProjects;
    private Map deletedSubProjects;
    private Map holidays;
    private Localisation localisation;
    private ProjectConfig projectConfig;
    private DocumentNumberPartGroup documentNumberPartGroup;
    private int status;
    private int access;
    private boolean withSubProjectRestrictions;
    private Integer wizardStep;
    private boolean ignorePlotOrderReceivedSteps;
    private ReviewCycleResultOption allowedFinalReviewCycleResultOption;
    private boolean usePDCStartDateForTasks;

    public boolean isWithSubProjectRestrictions() {
        return this.withSubProjectRestrictions;
    }

    public void setWithSubProjectRestrictions(boolean withSubProjectRestrictions) {
        this.withSubProjectRestrictions = withSubProjectRestrictions;
    }

    public String getKms() {
        return String.format(Locale.US, "%.3f", Float.valueOf(this.kmFrom)) + " - " + String.format(Locale.US, "%.3f", Float.valueOf(this.kmTo));
    }

    public void setKms(String kms) {
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getRouteName() {
        return this.routeName;
    }

    public void setRouteName(String routeName) {
        this.routeName = routeName;
    }

    public String getStretchName() {
        return this.stretchName;
    }

    public void setStretchName(String stretchName) {
        this.stretchName = stretchName;
    }

    public float getStretchKmFrom() {
        return this.kmFrom;
    }

    public void setStretchKmFrom(float kmFrom) {
        this.kmFrom = kmFrom;
    }

    public float getStretchKmTo() {
        return this.kmTo;
    }

    public void setStretchKmTo(float kmTo) {
        this.kmTo = kmTo;
    }

    public Integer getReviewInterval() {
        return this.interval;
    }

    public void setReviewInterval(Integer interval) {
        this.interval = interval;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public OrganisationPerson getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(OrganisationPerson createdBy) {
        this.createdBy = createdBy;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public OrganisationPerson getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(OrganisationPerson modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Network getNetwork() {
        return this.network;
    }

    public void setNetwork(Network network) {
        this.network = network;
    }

    public Map getProjectParticipations() {
        return this.projectParticipations;
    }

    public void setProjectParticipations(Map projectParticipations) {
        this.projectParticipations = projectParticipations;
    }

    public Map getSubProjects() {
        return this.subProjects;
    }

    public List<SubProject> getSubProjectsSortedByCodeName() {
        ArrayList<SubProject> sps = new ArrayList<SubProject>();
        if (this.getSubProjects() != null) {
            sps.addAll(this.getSubProjects().values());
            Collections.sort(sps, new SubProjectComparator());
        }
        return sps;
    }

    public void setSubProjects(Map subProjects) {
        this.subProjects = subProjects;
    }

    public Map getRealms() {
        return this.realms;
    }

    public void setRealms(Map realms) {
        this.realms = realms;
    }

    public Map getHolidays() {
        return this.holidays;
    }

    public void setHolidays(Map holidays) {
        this.holidays = holidays;
    }

    public Localisation getLocalisation() {
        return this.localisation;
    }

    public void setLocalisation(Localisation localisation) {
        this.localisation = localisation;
    }

    public DocumentNumberPartGroup getDocumentNumberPartGroup() {
        return this.documentNumberPartGroup;
    }

    public void setDocumentNumberPartGroup(DocumentNumberPartGroup documentNumberPartGroup) {
        this.documentNumberPartGroup = documentNumberPartGroup;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        if (this.access > Project.getMaxAllowedAccess(this.status)) {
            this.access = Project.getMaxAllowedAccess(this.status);
        }
    }

    public int getAccess() {
        return this.access;
    }

    public void setAccess(int access) {
        this.access = access > Project.getMaxAllowedAccess(this.status) ? Project.getMaxAllowedAccess(this.status) : access;
    }

    public static final int getMaxAllowedAccess(int status) {
        switch (status) {
            case 0: 
            case 7: 
            case 10: {
                return 2;
            }
            case 1: 
            case 2: 
            case 5: {
                return 1;
            }
        }
        return 0;
    }

    public void setWizardStep(Integer wizardStep) {
        this.wizardStep = wizardStep;
    }

    public Integer getWizardStep() {
        return this.wizardStep;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!Project.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        Project other = (Project)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public List<ProjectParticipation> getActiveProjectParticipations() {
        ArrayList<ProjectParticipation> ret = new ArrayList<ProjectParticipation>();
        Collection pps = this.projectParticipations.values();
        for (ProjectParticipation pp : pps) {
            if (pp.getStatus() != 0) continue;
            ret.add(pp);
        }
        return ret;
    }

    public Map getDeletedSubProjects() {
        return this.deletedSubProjects;
    }

    public void setDeletedSubProjects(Map deletedSubProjects) {
        this.deletedSubProjects = deletedSubProjects;
    }

    public boolean isIgnorePlotOrderReceivedSteps() {
        return this.ignorePlotOrderReceivedSteps;
    }

    public void setIgnorePlotOrderReceivedSteps(boolean ignorePlotOrderReceivedSteps) {
        this.ignorePlotOrderReceivedSteps = ignorePlotOrderReceivedSteps;
    }

    public String getPrincipalProject() {
        return this.principalProject;
    }

    public void setPrincipalProject(String principalProject) {
        this.principalProject = principalProject;
    }

    public ReviewCycleResultOption getAllowedFinalReviewCycleResultOption() {
        return this.allowedFinalReviewCycleResultOption;
    }

    public void setAllowedFinalReviewCycleResultOption(ReviewCycleResultOption allowedFinalReviewCycleResultOption) {
        this.allowedFinalReviewCycleResultOption = allowedFinalReviewCycleResultOption;
    }

    public boolean isUsePDCStartDateForTasks() {
        return this.usePDCStartDateForTasks;
    }

    public void setUsePDCStartDateForTasks(boolean usePDCStartDateForTasks) {
        this.usePDCStartDateForTasks = usePDCStartDateForTasks;
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public void setProjectConfig(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }
}

