/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.file;

import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.cycle.ReviewCycle;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentRef;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.label.Label;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.bo.data.planningNotification.PlanningNotification;
import at.cdes.bo.file.FileFinder;
import at.cdes.service.exception.ActionException;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.clazzes.util.io.IOUtil;

public class UploadFileHandler
implements Serializable {
    static final long serialVersionUID = 1L;
    private File tempDocumentPath;
    private File documentPath;
    private File attachmentPath;
    private File labelPath;
    private File originalDocumentPath;
    private File documentRefPath;
    private File planningNotificationPath;
    private File planningNotificationAttachmentPath;
    private FileFinder fileFinder;
    static Logger logger = Logger.getLogger((String)"UploadFileHandler");

    public String generateName(Integer id, String type) {
        return id.toString() + "-" + System.currentTimeMillis() + (type != null ? "." + type : "");
    }

    public File saveUploaded(Document document, InputStream fis, String type) throws FileHandleException {
        FileOutputStream fos = null;
        try {
            int length;
            File file = new File(this.tempDocumentPath, this.generateName(document.getId(), type));
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
            }
            fis.close();
            fos.close();
            file.deleteOnExit();
            File file2 = file;
            return file2;
        }
        catch (IOException ioe) {
            throw new FileHandleException("Saving the temporary file", ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Saving the temporary file", ioe);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Saving the temporary file", ioe);
                }
            }
        }
    }

    public String replaceUploaded(Document document, InputStream fis, String type, String oldFileName) throws FileHandleException {
        File file = this.saveUploaded(document, fis, type);
        logger.info((Object)("replacing uploaded, deleting file=[" + oldFileName + "]"));
        this.deleteUploaded(oldFileName);
        return file.getAbsolutePath();
    }

    public String copyUploadedDocumentVersion(Document document, String fileName) throws FileHandleException {
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            int length;
            String relativePath = this.generateRelativePath(document) + this.generateName(document.getId(), IOUtil.getFileExtension((String)fileName));
            File destinationFile = new File(this.documentPath, relativePath);
            fis = new FileInputStream(fileName);
            destinationFile.createNewFile();
            fos = new FileOutputStream(destinationFile);
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
            }
            fis.close();
            fos.close();
            String string = relativePath;
            return string;
        }
        catch (IOException ioe) {
            logger.error((Object)ioe);
            throw new FileHandleException("Copy the temporary file", ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Copy the temporary file", ioe);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Copy the temporary file", ioe);
                }
            }
        }
    }

    public String savePlanningNotificationFile(PlanningNotification pn, String fileName, InputStream fis) throws FileHandleException {
        FileOutputStream fos = null;
        try {
            int length;
            String filePath = this.generatePlanningNotificationPath(pn) + this.generateName(pn.getId(), IOUtil.getFileExtension((String)fileName));
            fos = new FileOutputStream(new File(this.planningNotificationPath, filePath));
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
            }
            fis.close();
            fos.close();
            String string = filePath;
            return string;
        }
        catch (IOException e) {
            throw new FileHandleException("Saving the planningNotification", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new FileHandleException("Saving the planningNotification", e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new FileHandleException("Saving the planningNotification", e);
                }
            }
        }
    }

    public String saveAttachment(DocumentVersion version, String name, InputStream fis) throws FileHandleException {
        FileOutputStream fos = null;
        try {
            int length;
            String fileName = this.generateAttachmentPath(version) + this.generateName(version.getId(), IOUtil.getFileExtension((String)name));
            fos = new FileOutputStream(new File(this.attachmentPath, fileName));
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
            }
            fis.close();
            fos.close();
            String string = fileName;
            return string;
        }
        catch (IOException ioe) {
            throw new FileHandleException("Saving the attachment", ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Saving the attachment", ioe);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Saving the attachment", ioe);
                }
            }
        }
    }

    public String savePlanningNotificationAttachment(Integer networkId, Integer workflowActivityPosResId, String fileName, InputStream fis) throws FileHandleException {
        FileOutputStream fos = null;
        try {
            int length;
            String filePath = this.generatePlanningNotificationAttachmentPath(networkId) + this.generateName(workflowActivityPosResId, IOUtil.getFileExtension((String)fileName));
            fos = new FileOutputStream(new File(this.planningNotificationAttachmentPath, filePath));
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
            }
            fis.close();
            fos.close();
            String string = filePath;
            return string;
        }
        catch (IOException e) {
            throw new FileHandleException("Saving the planningNotification", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    throw new FileHandleException("Saving the planningNotification", e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new FileHandleException("Saving the planningNotification", e);
                }
            }
        }
    }

    public String generateRelativePath(Document document) throws IOException {
        String prPath = document.getDocumentList().getSubProject().getProject().getId().toString();
        String obPath = document.getObjectPlanner().getObject().getId().toString();
        String relPath = prPath + File.separator + obPath + File.separator;
        File dir = new File(this.documentPath, relPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return relPath;
    }

    private String generateAttachmentPath(DocumentVersion version) throws IOException {
        String prPath = version.getDocument().getDocumentList().getSubProject().getProject().getId().toString();
        String obPath = version.getDocument().getObjectPlanner().getObject().getId().toString();
        String relPath = prPath + File.separator + obPath + File.separator;
        File dir = new File(this.attachmentPath, relPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return relPath;
    }

    private String generateDocumentRefPath(DocumentRef docRef) throws IOException {
        String prPath = docRef.getDocument().getDocumentList().getSubProject().getProject().getId().toString();
        String obPath = docRef.getDocument().getObjectPlanner().getObject().getId().toString();
        String relPath = prPath + File.separator + obPath + File.separator;
        File dir = new File(this.documentRefPath, relPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return relPath;
    }

    public String generateOriginalDocumentPath(DocumentVersion version) throws IOException {
        String prPath = version.getDocument().getDocumentList().getSubProject().getProject().getId().toString();
        String obPath = version.getDocument().getObjectPlanner().getObject().getId().toString();
        String relPath = prPath + File.separator + obPath + File.separator;
        File dir = new File(this.originalDocumentPath, relPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return relPath;
    }

    private String generateLabelPath(Organisation org) throws IOException {
        String prPath = org.getId().toString();
        String relPath = prPath + File.separator;
        File dir = new File(this.labelPath, relPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return relPath;
    }

    private String generatePlanningNotificationPath(PlanningNotification pn) throws IOException {
        String relPath = pn.getNetwork().getId() + File.separator;
        File dir = new File(this.planningNotificationPath, relPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return relPath;
    }

    private String generatePlanningNotificationAttachmentPath(Integer networkId) throws IOException {
        String relPath = networkId + File.separator;
        File dir = new File(this.planningNotificationAttachmentPath, relPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return relPath;
    }

    public void deletePlanningNotificationFile(String fileName) throws FileHandleException {
        File file;
        if (fileName != null && (file = this.fileFinder.findFile(fileName, CDESFileRepository.PLANNINGNOTIFICATIONREPOSITORY)).exists()) {
            try {
                file.delete();
            }
            catch (SecurityException se) {
                throw new FileHandleException("No permission to delete the file", se);
            }
        }
    }

    private void deleteUploaded(String fileName) throws FileHandleException {
        File file;
        if (fileName != null && (file = new File(fileName)).exists()) {
            try {
                if (!file.delete()) {
                    throw new FileHandleException("Die Datei konnte nicht gel\u00f6scht werden");
                }
            }
            catch (SecurityException e) {
                throw new FileHandleException("No permission to delete the file", e);
            }
        }
    }

    public void setTempDocumentPath(String tempDocumentPath) {
        this.tempDocumentPath = new File(tempDocumentPath);
    }

    public void setDocumentPath(String uploadPath) {
        this.documentPath = new File(uploadPath);
    }

    public void setAttachmentPath(String attachmentPath) {
        this.attachmentPath = new File(attachmentPath);
    }

    public void deleteAttachment(Attachment att) throws FileHandleException {
        if (att.getFileName() == null || att.getFileName().length() == 0) {
            return;
        }
        File file = new File(this.attachmentPath, att.getFileName());
        if (!file.exists()) {
            return;
        }
        try {
            if (!file.delete()) {
                throw new FileHandleException("Die Datei konnte nicht gel\u00f6scht werden");
            }
        }
        catch (SecurityException e) {
            throw new FileHandleException("No permission to delete the file", e);
        }
    }

    public void setLabelPath(String labelPath) {
        this.labelPath = new File(labelPath);
    }

    public String saveLabel(String name, Integer id, Organisation org, InputStream fis) throws FileHandleException {
        FileOutputStream fos = null;
        try {
            int length;
            String fileName = this.generateLabelPath(org) + this.generateName(id, IOUtil.getFileExtension((String)name));
            fos = new FileOutputStream(new File(this.labelPath, fileName));
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
            }
            fis.close();
            fos.close();
            String string = fileName;
            return string;
        }
        catch (IOException ioe) {
            logger.error((Object)"Encountered an error saving the label: ", (Throwable)ioe);
            throw new FileHandleException("Saving the label", ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Saving the label", ioe);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Saving the label", ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveOriginalDocument(DocumentVersion version, String name, InputStream fis) throws FileHandleException, IOException {
        FileOutputStream fos = null;
        try {
            int length;
            String fileName = this.generateOriginalDocumentPath(version) + this.generateName(version.getId(), IOUtil.getFileExtension((String)name));
            fos = new FileOutputStream(new File(this.originalDocumentPath, fileName));
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
            }
            fis.close();
            fos.close();
            String string = fileName;
            return string;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Saving the original document", ioe);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Saving the original document", ioe);
                }
            }
        }
    }

    public String getDocumentPath() {
        return this.documentPath.getAbsolutePath();
    }

    public void setOriginalDocumentPath(String originalDocumentPath) {
        this.originalDocumentPath = new File(originalDocumentPath);
    }

    public String getOriginalDocumentPath() {
        return this.originalDocumentPath.getAbsolutePath();
    }

    public String saveDocumentReferenceAttachmentTemporary(InputStream fis, String fileName, String fileExtension) throws FileHandleException {
        String filenameBase = null;
        filenameBase = fileExtension == null || fileExtension.length() <= 0 ? System.currentTimeMillis() + fileName : System.currentTimeMillis() + fileName + "." + fileExtension;
        File tmpRef = this.fileFinder.buildFile(filenameBase, CDESFileRepository.TEMPREPOSITORY);
        try {
            int n;
            FileOutputStream os = new FileOutputStream(tmpRef);
            byte[] buf = new byte[16384];
            while ((n = fis.read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, n);
            }
            ((OutputStream)os).close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            throw new ActionException("Caught FileNotFoundException writing to " + fileName, e);
        }
        catch (IOException e) {
            throw new ActionException("Caught IOException writing to " + fileName, e);
        }
        return tmpRef.getName();
    }

    public File getDocumentRefPath() {
        return this.documentRefPath;
    }

    public void setDocumentRefPath(File documentRefPath) {
        this.documentRefPath = documentRefPath;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public DocumentRef copyUploadedDocumentReference(DocumentRef ref) {
        try {
            int n;
            File oldAttachment = this.fileFinder.findFile(ref.getAttachmentFilename(), CDESFileRepository.TEMPREPOSITORY);
            String newFilename = this.generateDocumentRefPath(ref) + this.generateName(ref.getId(), ref.getAttachmentFiletype());
            FileInputStream fis = new FileInputStream(oldAttachment);
            FileOutputStream os = new FileOutputStream(new File(this.documentRefPath, newFilename));
            byte[] buf = new byte[16384];
            while ((n = ((InputStream)fis).read(buf)) > 0) {
                ((OutputStream)os).write(buf, 0, n);
            }
            ((OutputStream)os).close();
            ((InputStream)fis).close();
            ref.setAttachmentFilename(newFilename);
            return ref;
        }
        catch (FileNotFoundException e) {
            throw new ActionException("Caught FileNotFoundException copying DocumentRef", e);
        }
        catch (FileHandleException e) {
            throw new ActionException("Caught FileHandleException copying DocumentRef", e);
        }
        catch (IOException e) {
            throw new ActionException("Caught IOException copying DocumentRef", e);
        }
    }

    public String copyLabel(Label label2Copy, String name) throws FileHandleException {
        Organisation org = label2Copy.getOrganisation();
        ReviewCycle cycle = label2Copy.getReviewCycle();
        FileOutputStream fos = null;
        FileInputStream fis = null;
        name = name.replace('\\', File.separatorChar);
        try {
            int length;
            String fileName = this.generateLabelPath(org) + this.generateName(label2Copy.getId(), IOUtil.getFileExtension((String)name));
            fis = new FileInputStream(this.fileFinder.findFile(name, CDESFileRepository.LABELREPOSITORY));
            fos = new FileOutputStream(new File(this.labelPath, fileName));
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) >= 0) {
                fos.write(buffer, 0, length);
            }
            fis.close();
            fos.close();
            String string = fileName;
            return string;
        }
        catch (IOException ioe) {
            logger.error((Object)"Encountered an error saving the label: ", (Throwable)ioe);
            throw new FileHandleException("Saving the label", ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Saving the label", ioe);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    throw new FileHandleException("Saving the label", ioe);
                }
            }
        }
    }

    public void deleteLabelFile(String fileName) throws FileHandleException {
        File file;
        if (fileName != null && (file = this.fileFinder.findFile(fileName, CDESFileRepository.LABELREPOSITORY)).exists()) {
            try {
                file.delete();
            }
            catch (SecurityException se) {
                throw new FileHandleException("No permission to delete the file", se);
            }
        }
    }

    public void deleteUploadFile(String fileName) {
        try {
            this.deleteUploaded(fileName);
        }
        catch (FileHandleException e) {
            e.printStackTrace();
        }
    }

    public void deleteOriginalDocumentOrderFile(String filename) throws FileHandleException, IOException {
        File file = new File(this.originalDocumentPath.getCanonicalPath() + File.separator + filename);
        logger.info((Object)("Trying to delete original document with path=[" + file.getCanonicalPath() + "]"));
        if (!file.exists()) {
            return;
        }
        try {
            if (!file.delete()) {
                throw new FileHandleException("The file could not be deleted.");
            }
        }
        catch (SecurityException e) {
            throw new FileHandleException("No permission to delete the file", e);
        }
    }

    public File getPlanningNotificationPath() {
        return this.planningNotificationPath;
    }

    public void setPlanningNotificationPath(File planningNotificationPath) {
        this.planningNotificationPath = planningNotificationPath;
    }

    public File getPlanningNotificationAttachmentPath() {
        return this.planningNotificationAttachmentPath;
    }

    public void setPlanningNotificationAttachmentPath(File planningNotificationAttachmentPath) {
        this.planningNotificationAttachmentPath = planningNotificationAttachmentPath;
    }
}

