/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.document.ReleasedDocumentList;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestList;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public abstract class DocumentDigestCalculator
implements DigestCalculator {
    static Logger logger = Logger.getLogger((String)"document digester");

    public abstract String getDocumentHash(ReleasedDocument var1) throws DigestCalculatorException;

    public abstract String getDocumentListHash(ReleasedDocumentList var1) throws DigestCalculatorException;

    @Override
    public String getSignableContent(Object o) throws DigestCalculatorException {
        DigestList<String> list = new DigestList<String>();
        this.getSignableContentIteration(o, list);
        return list.toString();
    }

    public void getSignableContentIteration(Object o, DigestList<String> digests) throws DigestCalculatorException {
        if (o instanceof ReleasedDocumentList) {
            ReleasedDocumentList list = (ReleasedDocumentList)o;
            if (list.getDigest() == null) {
                this.getDocumentListHash(list);
            } else {
                digests.add(list.getDigest());
            }
            Iterator it = list.getDocuments().values().iterator();
            while (it.hasNext()) {
                this.getSignableContentIteration(it.next(), digests);
            }
        } else if (o instanceof ReleasedDocument) {
            ReleasedDocument object = (ReleasedDocument)o;
            if (object.getDigest() == null) {
                this.getDocumentHash(object);
            } else {
                digests.add(object.getDigest());
            }
        } else {
            throw new DigestCalculatorException("Class " + o.getClass().getName() + " is not supported in this DigestCalculation");
        }
    }

    protected MessageDigest getMessageDigest() throws DigestCalculatorException {
        try {
            return MessageDigest.getInstance("SHA1", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestCalculatorException("Init Message Digest", e);
        }
        catch (NoSuchProviderException e) {
            throw new DigestCalculatorException("Init Message Digest", e);
        }
    }

    @Override
    public String getDigest(Object o) throws DigestCalculatorException {
        if (o instanceof ReleasedDocumentList) {
            return this.getDocumentListHash((ReleasedDocumentList)o);
        }
        if (o instanceof ReleasedDocument) {
            return this.getDocumentHash((ReleasedDocument)o);
        }
        throw new DigestCalculatorException("Class " + o.getClass().getName() + " is not supported in this DigestCalculation");
    }

    @Override
    public boolean validate(byte[] digest, Object o) throws DigestCalculatorException {
        byte[] newDigest = this.getDigest(o).getBytes();
        return MessageDigest.isEqual(newDigest, digest);
    }
}

