/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.localisation.Localisation;
import at.cdes.bo.data.message.FeedbackMessage;
import at.cdes.bo.data.message.InfoMessage;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.search.Search;
import at.cdes.controller.helper.CdesDTOHelper;
import at.cdes.db.dao.CountryDAO;
import at.cdes.db.dao.LocalisationDAO;
import at.cdes.db.dao.MessageDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.RoleDAO;
import at.cdes.db.dao.SearchDAO;
import at.cdes.db.dao.SubProjectDAO;
import at.cdes.oldGwtDto.CDESContext;
import at.cdes.oldGwtDto.MessageDTO;
import at.cdes.service.CommonOperations;
import at.cdes.util.OgnlComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CommonOperationsImpl
implements CommonOperations {
    private static final long serialVersionUID = 4864697962805602346L;
    static Logger logger = Logger.getLogger(CommonOperationsImpl.class);
    private LocalisationDAO localisationDAO;
    private RoleDAO roleDAO;
    private CountryDAO countryDAO;
    private SearchDAO searchDAO;
    private MessageDAO messageDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private NetworkDAO networkDAO;
    private ProjectDAO projectDAO;
    private SubProjectDAO subProjectDAO;
    private String manualLink;

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    @Override
    public List getLocalisations() {
        return this.localisationDAO.getAll();
    }

    @Override
    public List getRoles(Integer networkId, Locale locale) {
        ArrayList ret = new ArrayList(this.roleDAO.getAll(networkId));
        Collections.sort(ret, new OgnlComparator("name", true, locale));
        return ret;
    }

    @Override
    public List getProjectRoles(Integer networkId, Locale locale) {
        ArrayList ret = new ArrayList(this.roleDAO.getAll(networkId, -1));
        Collections.sort(ret, new OgnlComparator("name", true, locale));
        return ret;
    }

    @Override
    public List getPlanningNotificationRoles(Integer networkId, Locale locale) {
        ArrayList ret = new ArrayList(this.roleDAO.getAll(networkId, -7));
        Collections.sort(ret, new OgnlComparator("name", true, locale));
        return ret;
    }

    public void setLocalisationDAO(LocalisationDAO localisationDAO) {
        this.localisationDAO = localisationDAO;
    }

    @Override
    public Localisation getLocalisation(Integer id) {
        return this.localisationDAO.get(id);
    }

    @Override
    public List getCountries() {
        return this.countryDAO.getAll();
    }

    public void setCountryDAO(CountryDAO countryDAO) {
        this.countryDAO = countryDAO;
    }

    @Override
    public void deleteSearch(Integer searchId) {
        Search search = this.searchDAO.get(searchId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("deleting stored search: [" + search.getName() + "] page: [" + search.getPageName() + "] PersonId: [" + search.getPersonId() + "]."));
        }
        this.searchDAO.delete(search);
    }

    @Override
    public List getPersonalSearches(Integer personId) {
        return this.searchDAO.getAll(personId);
    }

    @Override
    public List getPageSearches(String pageName) {
        return this.searchDAO.getAll(pageName);
    }

    @Override
    public List<Search> getPersonalPageSearches(Integer projectId, Integer personId, String pageName) {
        return this.searchDAO.getAll(projectId, personId, pageName);
    }

    public void setSearchDAO(SearchDAO searchDAO) {
        this.searchDAO = searchDAO;
    }

    @Override
    public Search insertSearch(Search search) {
        return this.searchDAO.save(search);
    }

    @Override
    public Search updateSearch(Search search) {
        return this.searchDAO.update(search);
    }

    @Override
    public Search getSearch(Integer id) {
        return this.searchDAO.get(id);
    }

    public MessageDAO getMessageDAO() {
        return this.messageDAO;
    }

    public void setMessageDAO(MessageDAO messageDAO) {
        this.messageDAO = messageDAO;
    }

    @Override
    public void deleteInfoMessage(Integer messageId) {
        InfoMessage message = this.messageDAO.getInfoMessage(messageId);
        this.messageDAO.delete(message);
    }

    @Override
    public InfoMessage getInfoMessage(Integer id) {
        return this.messageDAO.getInfoMessage(id);
    }

    @Override
    public List<InfoMessage> getInfoMessages() {
        return this.messageDAO.getAllInfoMessages();
    }

    @Override
    public InfoMessage saveOrUpdateInfoMessage(InfoMessage message) {
        if (message.getId() == null) {
            return this.messageDAO.save(message);
        }
        return this.messageDAO.update(message);
    }

    @Override
    public List<InfoMessage> getAllInfoMessagesByDate(Date from, Date to) {
        return this.messageDAO.getAllInfoMessagesByDate(from, to);
    }

    @Override
    public FeedbackMessage getFeedbackByOrganisationPerson(Integer id) {
        return this.messageDAO.getFeedbackByOrganisationPerson(id);
    }

    @Override
    public ArrayList<MessageDTO> getMessages(Date from, Date to) {
        return CdesDTOHelper.getMessagesDTO(this.getAllInfoMessagesByDate(from, to));
    }

    @Override
    public FeedbackMessage saveOrUpdateFeedbackMessage(FeedbackMessage message) {
        if (message.getId() == null) {
            return this.messageDAO.saveFeedback(message);
        }
        return this.messageDAO.updateFeedback(message);
    }

    @Override
    public String getManualLink() {
        return this.manualLink;
    }

    public void setManualLink(String manualLink) {
        this.manualLink = manualLink;
    }

    @Override
    public CDESContext getCDESContext(Integer orgPersonId, Integer contextObjectId, int mode) {
        OrganisationPerson op = this.organisationPersonDAO.get(orgPersonId);
        switch (mode) {
            case 0: {
                return CdesDTOHelper.getContext(op);
            }
            case 1: {
                return CdesDTOHelper.getContext(this.networkDAO.get(contextObjectId), op);
            }
            case 2: {
                return CdesDTOHelper.getContext(this.projectDAO.get(contextObjectId), op);
            }
            case 3: {
                return CdesDTOHelper.getContext(this.subProjectDAO.get(contextObjectId), op);
            }
        }
        return null;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }
}

