/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.service;

import at.cdes.bo.data.CdesDataObject;
import org.aopalliance.intercept.Joinpoint;
import org.apache.log4j.Logger;
import org.clazzes.util.aop.ReflectiveMethodInvocation;
import org.clazzes.util.datetime.UtcTimestamp;

public class JobInfo
implements CdesDataObject {
    private static final long serialVersionUID = 7637134156478229233L;
    protected static final Logger log = Logger.getLogger(JobInfo.class);
    protected Integer id;
    protected Integer certificateId;
    protected String methodName;
    protected UtcTimestamp stored;
    protected UtcTimestamp started;
    protected UtcTimestamp ended;
    protected Object result;
    protected transient Joinpoint joinpoint;
    private String cookie;
    private ClassLoader classLoader;

    public void setFrom(Joinpoint joinpoint) {
        this.joinpoint = joinpoint;
        if (joinpoint == null) {
            log.error((Object)"Can't setup JobInfo: Joinpoint is 'null'.");
            return;
        }
        if (!(joinpoint instanceof ReflectiveMethodInvocation)) {
            log.error((Object)("Can't setup JobInfo: Joinpoint: [" + joinpoint.toString() + "] is not a ReflectiveMethodInvocation."));
            return;
        }
        ReflectiveMethodInvocation mi = (ReflectiveMethodInvocation)joinpoint;
        this.methodName = mi.getMethod().getName();
        Object[] args = mi.getArguments();
        if (args == null || args.length == 0) {
            log.error((Object)("Can't setup JobInfo: Joinpoint: [" + joinpoint.toString() + "] has no arguments."));
            return;
        }
    }

    protected Object[] getArguments() {
        if (this.joinpoint != null && this.joinpoint instanceof ReflectiveMethodInvocation) {
            ReflectiveMethodInvocation mi = (ReflectiveMethodInvocation)this.joinpoint;
            Object[] args = mi.getArguments();
            return args;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int res = 1;
        res = 31 * res + (this.certificateId == null ? 0 : this.certificateId.hashCode());
        res = 31 * res + (this.methodName == null ? 0 : this.methodName.hashCode());
        return res;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!JobInfo.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        JobInfo other = (JobInfo)obj;
        if (this.certificateId == null ? other.certificateId != null : !this.certificateId.equals(other.certificateId)) {
            return false;
        }
        return !(this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName));
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public UtcTimestamp getStarted() {
        return this.started;
    }

    public void setStarted(UtcTimestamp started) {
        this.started = started;
    }

    public UtcTimestamp getEnded() {
        return this.ended;
    }

    public void setEnded(UtcTimestamp ended) {
        this.ended = ended;
    }

    public Integer getCertificateId() {
        return this.certificateId;
    }

    public void setCertificateId(Integer certificateId) {
        this.certificateId = certificateId;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Joinpoint getJoinpoint() {
        return this.joinpoint;
    }

    public void setJoinpoint(Joinpoint joinpoint) {
        this.joinpoint = joinpoint;
    }

    public UtcTimestamp getStored() {
        return this.stored;
    }

    public void setStored(UtcTimestamp stored) {
        this.stored = stored;
    }

    public String getCookie() {
        return this.cookie;
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

