/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.service;

import at.cdes.bo.data.cycle.ReviewCycleInstanceRelease;
import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.ReviewCyclePositionParticipationComparator;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstance;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.task.DocumentVersionTask;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.service.ObjectOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.TaskOperations;
import at.cdes.util.DateHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.clazzes.util.lang.Triple;

public class ReviewCycleNodeInstanceHelper {
    public static List<ReviewCyclePosition> getReviewCyclePositionsSortedByParticipation(ReviewCycleNodeInstance nodeInstance) {
        Collection opositions = nodeInstance.getReviewCyclePositions().values();
        ArrayList<ReviewCyclePosition> ret = new ArrayList<ReviewCyclePosition>(opositions.size());
        ret.addAll(opositions);
        Collections.sort(ret, ReviewCyclePositionParticipationComparator.getInstance());
        return ret;
    }

    public static ArrayList<ReviewCyclePositionResult> sortPositionListByDate(ArrayList<ReviewCyclePositionResult> position) {
        ArrayList<ReviewCyclePositionResult> sortedResults = new ArrayList<ReviewCyclePositionResult>();
        for (ReviewCyclePositionResult unsorted : position) {
            boolean add = true;
            for (ReviewCyclePositionResult sorted : sortedResults) {
                if (!unsorted.getResultDate().before(sorted.getResultDate())) continue;
                add = false;
                sortedResults.add(sortedResults.indexOf(sorted), unsorted);
                break;
            }
            if (!add) continue;
            sortedResults.add(unsorted);
        }
        return sortedResults;
    }

    public static Calendar verifyDocumentDepartureDate(ReviewCycleNodeResult nodeResult) {
        Calendar cal = null;
        ArrayList<ReviewCyclePositionResult> positions = new ArrayList<ReviewCyclePositionResult>();
        Map m = nodeResult.getReviewCycleNodePositionResults();
        if (m != null && !m.isEmpty()) {
            positions.addAll(m.values());
            positions = ReviewCycleNodeInstanceHelper.sortPositionListByDate(positions);
        }
        Date objectListReleaseDate = null;
        ReleasedObjectList oListReleasedAtDeparture = (ReleasedObjectList)nodeResult.getActiveObjectListOfDocumentDeparture();
        if (oListReleasedAtDeparture != null) {
            objectListReleaseDate = oListReleasedAtDeparture.getSignature().getTime();
        }
        if (nodeResult.getDocumentDepartureDate() != null) {
            cal = positions.size() > 0 && positions.get(positions.size() - 1).getResultDate().before(nodeResult.getDocumentDepartureDate()) && objectListReleaseDate != null && positions.get(positions.size() - 1).getResultDate().after(objectListReleaseDate) ? DateHelper.getCalendar(positions.get(positions.size() - 1).getResultDate()) : DateHelper.getCalendar(nodeResult.getDocumentDepartureDate());
        }
        return cal;
    }

    public static Triple<Calendar, Integer, Integer> calcDelayOfActualNode(ObjectOperations objectOperations, TaskOperations taskoper, ReviewOperations reviewoper, HolidayCalculator holiCalc, ReviewCycleNodeResult nodeResult, Calendar startDate, boolean byTask, ReleasedObjectList objectList) {
        int nodesDelay = 0;
        Calendar toDay = Calendar.getInstance();
        Calendar contractualDeadline = null;
        int nodesDuration = 0;
        if (byTask) {
            List<DocumentVersionTask> tasks = taskoper.getTasksOfDocumentVersion(nodeResult.getDocumentVersion().getId());
            if (tasks.size() > 0) {
                contractualDeadline = tasks.get(0).getContractualDeadline();
                nodesDelay = holiCalc.getWorkingDaysBetween(toDay, contractualDeadline);
            }
        } else {
            Integer objectPlannerId = nodeResult.getDocumentVersion().getDocument().getObjectPlanner().getId();
            Integer objectListId = objectList.getId();
            ReleasedObjectPlanner releasedObjectPlanner = objectOperations.getReleasedObjectPlannerFromList(objectPlannerId, objectListId);
            ReviewCycleInstanceRelease cycleInstanceRel = (ReviewCycleInstanceRelease)releasedObjectPlanner.getReviewCycleInstance();
            ReviewCycleNodeInstanceRelease nodeInstanceRel = reviewoper.getReleasedReviewCycleNodeInstance3(nodeResult.getReviewCycleNode().getId(), cycleInstanceRel.getId());
            nodesDuration = nodeInstanceRel.getDuration();
            if (startDate == null) {
                startDate = DateHelper.getCalendar(nodeResult.getDocumentArrivalDate());
            }
            Calendar endDate = DateHelper.getCalendar(nodeResult.getDocumentDepartureDate());
            contractualDeadline = holiCalc.addWorkingDays(startDate, nodesDuration);
            nodesDelay = endDate == null ? holiCalc.getWorkingDaysBetween(toDay, contractualDeadline) : holiCalc.getWorkingDaysBetween(endDate, contractualDeadline);
        }
        return new Triple((Object)contractualDeadline, (Object)nodesDelay, (Object)nodesDuration);
    }
}

