/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.schema;

import at.cdes.db.SchemaUpdateSnippet;
import java.sql.SQLException;
import org.clazzes.jdbc2xml.schema.ForeignKeyInfo;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.TableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUpdate_0_268_Remove
implements SchemaUpdateSnippet {
    private static final Logger log = LoggerFactory.getLogger(SchemaUpdate_0_268_Remove.class);

    @Override
    public String getTargetVersion() {
        return "0.268";
    }

    @Override
    public String getUpdateComment() {
        return "Add a delete cascade to tasks.";
    }

    private void addCascade(ISchemaEngine schemaEngine, String table, String foreignKey) throws SQLException {
        log.info("Getting key and table info for {} and {}", (Object)table, (Object)foreignKey);
        TableInfo tableInfo = schemaEngine.fetchTableInfo(table, null);
        if (tableInfo == null) {
            log.error("Did not find table {}.", (Object)table);
            return;
        }
        ForeignKeyInfo keyInfo = tableInfo.getForeignKeyInfo(foreignKey);
        if (keyInfo == null) {
            log.error("Did not find foreign key {} in table {}.", (Object)foreignKey, (Object)table);
            return;
        }
        if (keyInfo.getDeleteRule() == 0) {
            return;
        }
        keyInfo.setDeleteRule((short)0);
        schemaEngine.dropForeignKey(tableInfo, foreignKey);
        schemaEngine.addForeignKey(tableInfo, keyInfo);
    }

    @Override
    public void performUpdate(ISchemaEngine schemaEngine) throws SQLException {
        this.addCascade(schemaEngine, "review_task", "review_task_task_fk");
        this.addCascade(schemaEngine, "review_task_done", "review_task_done_task_fk");
        this.addCascade(schemaEngine, "document_version_task", "document_version_task_task_fk");
        this.addCascade(schemaEngine, "document_task", "document_task_task_fk");
        this.addCascade(schemaEngine, "attached_review_task", "attached_review_task_task_fk");
        this.addCascade(schemaEngine, "attached_review_task_done", "attached_review_task_done_task_fk");
        this.addCascade(schemaEngine, "original_document_task", "rc_original_document_task_task_fk");
        this.addCascade(schemaEngine, "original_document_task_done", "rcd1_original_document_task_done_task_fk");
        this.addCascade(schemaEngine, "review_cycle_entry_task", "review_cycle_entry_task_task_fk");
        this.addCascade(schemaEngine, "review_cycle_entry_task_done", "review_cycle_entry_task_done_task_fk");
        this.addCascade(schemaEngine, "review_cycle_plott_task", "rc_plott_task_task_fk");
        this.addCascade(schemaEngine, "review_cycle_plott_task_done", "rcd_plott_task_task_fk");
        this.addCascade(schemaEngine, "select_cell_connection_task", "select_cell_connection_task_task_fk");
        this.addCascade(schemaEngine, "select_cell_connection_task_done", "select_cell_connection_task_done_task_fk");
        this.addCascade(schemaEngine, "future_email", "future_email_fk2");
        this.addCascade(schemaEngine, "task_email_snippet", "tems_task_fk");
        this.addCascade(schemaEngine, "review_task_position_map", "rtpm_rt_fk");
        TableInfo plotOrderTableInfo = schemaEngine.fetchTableInfo("plot_order_acceptance_task", null);
        TableInfo plotOrderDoneTableInfo = schemaEngine.fetchTableInfo("plot_order_acceptance_task_done", null);
        ForeignKeyInfo plotOrderTaskKey = new ForeignKeyInfo("plot_order_acceptance_task_fk3", "task_id", "document_version_task", "task_id");
        ForeignKeyInfo plotOrderDoneTaskKey = new ForeignKeyInfo("plot_order_acceptance_task_done_fk3", "task_id", "document_version_task", "task_id");
        plotOrderTaskKey.setDeleteRule((short)0);
        plotOrderDoneTaskKey.setDeleteRule((short)0);
        schemaEngine.addForeignKey(plotOrderTableInfo, plotOrderTaskKey);
        schemaEngine.addForeignKey(plotOrderDoneTableInfo, plotOrderDoneTaskKey);
    }
}

