/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.util;

import at.cdes.api.document.compositeDto.LabelStatus;
import at.cdes.api.document.compositeDto.SeekLabelResult;
import at.cdes.bo.data.document.TemporaryDocumentVersion;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;

public class TemporaryDocumentVersionMapper {
    private static Integer nullSafeIntValue(Long value) {
        if (value == null) {
            return null;
        }
        return (int)value.longValue();
    }

    public static TemporaryDocumentVersion mapVersion(at.cdes.api.document.compositeDto.TemporaryDocumentVersion documentVersion, Long reviewCycleCellId) {
        TemporaryDocumentVersion tdv = new TemporaryDocumentVersion();
        SeekLabelResult seekResult = documentVersion.getSeekResult();
        tdv.setDocumentId(documentVersion.getUnreleasedDocumentId().intValue());
        tdv.setLabelContentId(seekResult.getLabelContentId() == null ? null : Integer.valueOf(seekResult.getLabelContentId().intValue()));
        tdv.setFileName(documentVersion.getStoredFileName());
        tdv.setRenderLabelOutsideOfPlan(seekResult.getLabelStatus() == LabelStatus.OUTSIDE);
        tdv.setLabelIgnored(seekResult.getLabelStatus() == LabelStatus.IGNORED);
        tdv.setName(documentVersion.getPlanNumber());
        tdv.setFileType(FilenameUtils.getExtension((String)documentVersion.getStoredFileName()));
        tdv.setLabelCorrelation(seekResult.getLabelCorrelation());
        tdv.setLabelOverlap(seekResult.getLabelOverlap());
        tdv.setLabelSeparation(seekResult.getLabelSeperation());
        tdv.setLabelXOffset(seekResult.getLabelXOffset());
        tdv.setLabelYOffset(seekResult.getLabelYOffset());
        tdv.setUserUnit(seekResult.getUserUnit());
        tdv.setUrx(seekResult.getUrx());
        tdv.setUry(seekResult.getUry());
        tdv.setLlx(seekResult.getLlx());
        tdv.setLly(seekResult.getLly());
        tdv.setUploaded(Date.from(documentVersion.getCreated()));
        tdv.setComment(null);
        tdv.setInvalidationCellConnectionId(null);
        tdv.setRevisionCellConnectionId(null);
        tdv.setDestinationCellId(TemporaryDocumentVersionMapper.nullSafeIntValue(reviewCycleCellId));
        return tdv;
    }
}

