/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.cycle;

import at.cdes.bo.cycle.EvaluationException;
import at.cdes.bo.cycle.ReviewCycleActionListenerEvaluator;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.log4j.Logger;

public class OgnlActionListenerEvaluator
implements ReviewCycleActionListenerEvaluator {
    static Logger logger = Logger.getLogger(OgnlActionListenerEvaluator.class);

    @Override
    public boolean evaluateCondition(ReviewCycleNodeResult result, String rule) throws EvaluationException {
        Object expression;
        try {
            expression = Ognl.parseExpression(rule);
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL parse error in expression [" + rule + "]: " + e));
            throw new EvaluationException("Parse Exception", e);
        }
        OgnlContext context = new OgnlContext();
        context.put("result", result);
        context.put("documentVersion", result.getDocumentVersion());
        context.put("nextCell", result.getReviewCycleCellResult().getNextReviewCycleCell());
        try {
            Object res = Ognl.getValue(expression, (Map)context, (Object)context);
            if (res == null) {
                return false;
            }
            logger.info((Object)("OGNL evaluation: expression [" + rule + "], result [" + res + "]."));
            return Boolean.parseBoolean(String.valueOf(res));
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL evaluation error in expression [" + rule + "]: " + e));
            throw new EvaluationException("Evaluate Exception", e);
        }
    }
}

