/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.order.plott;

import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.order.OrderAddress;
import at.cdes.bo.data.order.OrderAddressExtractorVisitorImpl;
import at.cdes.bo.data.order.plott.PlottOrder;
import at.cdes.bo.data.order.plott.PlottOrderItem;
import at.cdes.bo.data.order.plott.PlottOrderItemTemplate;
import at.cdes.bo.data.order.plott.PlottOrderTemplate;
import at.cdes.bo.data.order.plott.PlottProperties;
import at.cdes.bo.data.order.plott.TemplatePropertyResolver;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.db.dao.OrderDAO;
import at.cdes.db.dao.ProjectParticipationDAO;
import at.cdes.db.dao.ReviewCycleNodeInstanceDAO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;

public class ProjectParticipationPlotOrderTemplatePropertyResolver
implements TemplatePropertyResolver,
Serializable {
    private static final long serialVersionUID = 2L;
    private ProjectParticipationDAO projectParticipationDAO;
    private OrderDAO orderDAO;
    private ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO;
    private ObjectPlannerDAO objectPlannerDAO;

    public void setReviewCycleNodeInstanceDAO(ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO) {
        this.reviewCycleNodeInstanceDAO = reviewCycleNodeInstanceDAO;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    @Override
    public PlottOrder resolveProperties(DocumentVersion version, PlottOrder order, PlottOrderTemplate template, boolean onlyItems) {
        if (!onlyItems) {
            order.setOrderItems(new HashMap());
            order.setBillingAddress(this.orderDAO.getOrderAddress(template.getBillingAddressId()));
            order.setPlotter(this.projectParticipationDAO.get(template.getPlotterId()).getOrganisation());
            order.setTemplate(template);
            order.setProject(template.getProject());
            order.setComment(template.getComment());
            order.setKindOfDelivery(template.getKindOfDelivery());
        }
        this.resolvePropertiesInner(version, order, template);
        return order;
    }

    private PlottOrder resolvePropertiesInner(DocumentVersion version, PlottOrder order, PlottOrderTemplate template) {
        Collection items = template.getOrderItems().values();
        ObjectPlannerImpl objectPlanner = (ObjectPlannerImpl)version.getDocument().getObjectPlanner();
        ReviewCycleNode node = version.getActualReviewCycleNode();
        SubProject subProject = objectPlanner.getObject().getObjectList().getSubProject();
        ReleasedObjectList releasedObjectList = subProject.getActiveObjectList();
        ReleasedObjectPlanner releasedObjectPlanner = this.objectPlannerDAO.getReleasedObjectPlanner(releasedObjectList.getId(), objectPlanner.getId());
        ReviewCycleNodeInstanceRelease releasedNodeInstance = this.reviewCycleNodeInstanceDAO.getReleased(releasedObjectPlanner.getReviewCycleInstance().getId(), node.getId());
        OrderAddressExtractorVisitorImpl visitor = new OrderAddressExtractorVisitorImpl();
        HashMap<Integer, PlottOrderItem> newItems = new HashMap<Integer, PlottOrderItem>();
        int id = -1;
        for (PlottOrderItemTemplate item : items) {
            Integer ppId = item.getDeliveryAddressId();
            if (ppId == null || item.isInvalidated()) continue;
            PlottOrderItem newItem = new PlottOrderItem();
            newItem.setDocumentVersion(version);
            newItem.setOrderContract(order);
            newItem.setNodeInstanceRelease(releasedNodeInstance);
            newItem.setReceiverId(ppId);
            newItem.setReceiverType(0);
            newItem.setTemplate(item);
            ProjectParticipation pp = this.projectParticipationDAO.get(ppId);
            OrderAddress address = pp.accept(visitor);
            newItem.setDeliveryAddress(address);
            newItem.setPlottProperties(new PlottProperties(item.getPlottProperties()));
            newItem.getPlottProperties().setLlx(version.getLlx());
            newItem.getPlottProperties().setLly(version.getLly());
            newItem.getPlottProperties().setUrx(version.getUrx());
            newItem.getPlottProperties().setUry(version.getUry());
            newItem.getPlottProperties().setUserUnit(version.getUserUnit());
            newItems.put(id, newItem);
            --id;
        }
        order.setOrderItems(newItems);
        return order;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setOrderDAO(OrderDAO orderDAO) {
        this.orderDAO = orderDAO;
    }

    public ProjectParticipation resolveProjectParticipation(Integer receiverId) {
        return this.projectParticipationDAO.get(receiverId);
    }

    @Override
    public PlottOrderItem resolvePlottOrderItem(Integer orderItemId) {
        if (orderItemId == null) {
            return null;
        }
        return this.orderDAO.getPlottOrderItem(orderItemId);
    }

    @Override
    public String getName() {
        return "ProjectParticipationPlotTemplate";
    }
}

