/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.certificate;

import at.cdes.service.exception.WrongPasswordException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.Key;
import java.security.KeyPair;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openssl.PEMDecryptor;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyHelper {
    private static Logger log = LoggerFactory.getLogger(KeyHelper.class);

    public static KeyPair decryptKeyLegacy(Object o, String password) throws IOException {
        LegacyPEMDecryptorProvider decProv = new LegacyPEMDecryptorProvider(password.toCharArray());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        return converter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair((PEMDecryptorProvider)decProv));
    }

    public static KeyPair decryptKey(Object o, String password) throws IOException {
        PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        return converter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(decProv));
    }

    public static KeyPair openKeyPair(String pemString, String password) throws WrongPasswordException {
        PEMParser pr = null;
        try {
            StringReader sr = new StringReader(pemString);
            pr = new PEMParser((Reader)sr);
            Object o = pr.readObject();
            KeyPair rootCaKeyPair = KeyHelper.decryptKey(o, password);
            if (rootCaKeyPair == null) {
                throw new IOException();
            }
            KeyPair keyPair = rootCaKeyPair;
            return keyPair;
        }
        catch (IOException e) {
            log.warn("Caught exception decrpyting key prima vista", (Throwable)e);
            boolean hasHighChars = false;
            for (char c : password.toCharArray()) {
                if (c <= '\u007f' && c >= '\u0000') continue;
                hasHighChars = true;
                break;
            }
            if (!hasHighChars) {
                throw new WrongPasswordException();
            }
            PEMParser pr2 = null;
            try {
                StringReader sr2 = new StringReader(pemString);
                pr2 = new PEMParser((Reader)sr2);
                Object o2 = pr2.readObject();
                KeyPair rootCaKeyPair = KeyHelper.decryptKeyLegacy(o2, password);
                if (rootCaKeyPair == null) {
                    throw new IOException();
                }
                KeyPair keyPair = rootCaKeyPair;
                return keyPair;
            }
            catch (IOException e1) {
                log.error("Error trying to decrpyt legacy key", (Throwable)e1);
                throw new WrongPasswordException();
            }
            finally {
                try {
                    if (pr2 != null) {
                        pr2.close();
                    }
                }
                catch (IOException e2) {
                    throw new WrongPasswordException("Verifying PKCS7 Signature", e2);
                }
            }
        }
        finally {
            try {
                if (pr != null) {
                    pr.close();
                }
            }
            catch (IOException e) {
                throw new WrongPasswordException("Verifying PKCS7 Signature", e);
            }
        }
    }

    private static class LegacyPEMDecryptorProvider
    implements PEMDecryptorProvider {
        private final char[] password;

        public LegacyPEMDecryptorProvider(char[] password) {
            this.password = password;
        }

        public PEMDecryptor get(String dekAlgName) throws OperatorCreationException {
            int maxSaltLength;
            int keyLen;
            String alg;
            if (dekAlgName.startsWith("DES-EDE3")) {
                alg = "DESede/CBC/PKCS5Padding";
                keyLen = 24;
                maxSaltLength = Integer.MAX_VALUE;
            } else if (dekAlgName.startsWith("AES-256")) {
                alg = "AES/CBC/PKCS5Padding";
                keyLen = 32;
                maxSaltLength = 8;
            } else {
                throw new OperatorCreationException("unknown encryption [" + dekAlgName + "] with legacy private key");
            }
            return new PEMDecryptor(){

                public byte[] decrypt(byte[] data, byte[] iv) throws PEMException {
                    byte[] salt = iv;
                    if (salt.length > maxSaltLength) {
                        salt = new byte[8];
                        System.arraycopy(iv, 0, salt, 0, maxSaltLength);
                    }
                    OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
                    pGen.init(Strings.toByteArray((char[])password), salt);
                    SecretKeySpec kSpec = new SecretKeySpec(((KeyParameter)pGen.generateDerivedParameters(keyLen * 8)).getKey(), "OpenSSLPBKDF");
                    IvParameterSpec paramSpec = new IvParameterSpec(iv);
                    try {
                        Cipher cipher = Cipher.getInstance(alg, "BC");
                        cipher.init(2, (Key)kSpec, paramSpec);
                        return cipher.doFinal(data);
                    }
                    catch (Exception e) {
                        throw new PEMException("Unable to decrypt symmetrically encrypted PEM content", e);
                    }
                }
            };
        }
    }
}

