/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.document.LabelSeeker;
import at.cdes.api.document.ManualNotFoundResolution;
import at.cdes.api.document.compositeDto.LabelStatus;
import at.cdes.api.document.compositeDto.SeekLabelResult;
import at.cdes.bo.data.cycle.ReviewCycleInstanceImpl;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.TemporaryDocumentVersion;
import at.cdes.bo.data.label.LabelContent;
import at.cdes.db.dao.DocumentDAO;
import at.cdes.service.LabelOperations;
import at.cdes.service.exception.MimeDRMError;
import at.cdes.service.exception.MimeHPGSError;
import at.cdes.service.exception.MimeSeekIOError;
import at.cdes.service.exception.MimeSeekTimeout;
import at.cdes.util.ConfigurationHelper;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelSeekerImpl
implements LabelSeeker {
    private static final Logger log = LoggerFactory.getLogger(LabelSeekerImpl.class);
    private LabelOperations labelOperations;
    private DocumentDAO documentDAO;

    public void setLabelOperations(LabelOperations labelOperations) {
        this.labelOperations = labelOperations;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public SeekLabelResult seekLabel(Long unreleasedDocumentId, String fileName, String planNumber, ManualNotFoundResolution manualNotFoundResolution, boolean mayChoseRenderLabelOutside) {
        DocumentImpl document = this.documentDAO.get(unreleasedDocumentId.intValue());
        TemporaryDocumentVersion tdv = new TemporaryDocumentVersion();
        tdv.setDocumentId(unreleasedDocumentId.intValue());
        boolean setByReviewCycle = ((ReviewCycleInstanceImpl)document.getObjectPlanner().getReviewCycleInstance()).isRenderLabelOutside();
        LabelContent outsideLabelContent = this.labelOperations.getLabelOutsideContent(unreleasedDocumentId.intValue(), true);
        boolean labelOutsidePossible = outsideLabelContent != null && mayChoseRenderLabelOutside;
        tdv.setRenderLabelOutsideOfPlan(manualNotFoundResolution == ManualNotFoundResolution.RENDER_LABEL_OUTSIDE_OF_PLAN);
        tdv.setLabelOutsideContentId(outsideLabelContent != null ? outsideLabelContent.getId() : null);
        tdv.setLabelIgnored(manualNotFoundResolution == ManualNotFoundResolution.LABEL_IGNORED);
        tdv.setFileName(fileName);
        tdv.setName(planNumber);
        boolean pending = false;
        try {
            this.labelOperations.seekLabel(tdv, true);
        }
        catch (MimeSeekTimeout timeout) {
            log.warn("Received MimeSeekTimeout, returning LabelStatus.PENDING");
            pending = true;
        }
        catch (MimeDRMError | MimeHPGSError | MimeSeekIOError e) {
            throw new RuntimeException(e);
        }
        SeekLabelResult ret = new SeekLabelResult();
        if (pending) {
            ret.setLabelStatus(LabelStatus.PENDING);
        } else {
            ret.setLabelContentId(tdv.getLabelContentId() != null ? Long.valueOf(tdv.getLabelContentId().longValue()) : null);
            ret.setLabelStatus(LabelStatus.fromValue((int)tdv.getLabelStatus()));
            ret.setNumberOfPages(Integer.valueOf(tdv.getNumberOfPages()));
            ret.setNativeRotation(Integer.valueOf(tdv.getNativeRotation()));
            ret.setPreviewRotation(Integer.valueOf(tdv.getPreviewRotation()));
            ret.setLabelXOffset(tdv.getLabelXOffset());
            ret.setLabelYOffset(tdv.getLabelYOffset());
            ret.setLabelCorrelation(tdv.getLabelCorrelation());
            ret.setLabelSeperation(tdv.getLabelSeparation());
            ret.setLabelOverlap(tdv.getLabelOverlap());
            ret.setLlx(tdv.getLlx());
            ret.setLly(tdv.getLly());
            ret.setUrx(tdv.getUrx());
            ret.setUry(tdv.getUry());
            ret.setSupportsType(Boolean.valueOf(ConfigurationHelper.isFileTypeSupportedForLabelSeeking(FilenameUtils.getExtension((String)fileName))));
            ret.setFound(Boolean.valueOf(!this.labelOperations.needToSeekLabel(tdv)));
            ret.setUserUnit(Double.valueOf(tdv.getUserUnit()));
        }
        return ret;
    }
}

