/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.cycle.ReviewCycleNodeResultPositionComparator;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResultImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.db.dao.ReviewCycleNodeResultDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ReviewCycleNodeResultDAOHibernate
extends HibernateDaoSupport
implements ReviewCycleNodeResultDAO {
    @Override
    public ReviewCycleNodeResult get(Integer id) {
        return (ReviewCycleNodeResult)this.getSession().load(ReviewCycleNodeResultImpl.class, (Serializable)id);
    }

    @Override
    public List getAll() {
        return this.loadAllHibernate(ReviewCycleNodeResult.class);
    }

    @Override
    public ReviewCycleNodeResult save(ReviewCycleNodeResult cons) {
        return this.get((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public ReviewCycleNodeResult update(ReviewCycleNodeResult cons) {
        this.getSession().update((Object)cons);
        return cons;
    }

    @Override
    public void delete(ReviewCycleNodeResult cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public ReviewCycleNodeResult get(ReviewCycleNode node, DocumentVersion version) {
        Criteria crit = this.getSession().createCriteria(ReviewCycleNodeResult.class);
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)node.getId()));
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)version.getId()));
        List nodeResults = crit.list();
        ReviewCycleNodeResult actual = null;
        for (ReviewCycleNodeResult res : nodeResults) {
            if (actual != null && (res.getDocumentArrivalDate() == null || actual.getDocumentArrivalDate() == null || !res.getDocumentArrivalDate().after(actual.getDocumentArrivalDate()))) continue;
            actual = res;
        }
        return actual;
    }

    @Override
    public List getAll(ReviewCycleNode node, DocumentVersion version) {
        Criteria crit = this.getSession().createCriteria(ReviewCycleNodeResult.class);
        crit.createCriteria("reviewCycleNode").add(Restrictions.idEq((Object)node.getId()));
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)version.getId()));
        return crit.list();
    }

    @Override
    public List getAllFinishedWithinTime(Date startDate, Date endDate) {
        Criteria crit = this.getSession().createCriteria(ReviewCycleNodeResult.class);
        crit.add((Criterion)Restrictions.like((String)"finished", (Object)Boolean.TRUE));
        crit.add((Criterion)Restrictions.ge((String)"documentDepartureDate", (Object)startDate));
        crit.add((Criterion)Restrictions.le((String)"documentDepartureDate", (Object)endDate));
        return crit.list();
    }

    @Override
    public void evict(ReviewCycleNodeResult cons) {
        this.getSession().evict((Object)cons);
    }

    @Override
    public List<ReviewCycleNodeResultImpl> getAllSortedByPosition(DocumentVersion dv) {
        Criteria crit = this.getSession().createCriteria(ReviewCycleNodeResultImpl.class);
        crit.createCriteria("documentVersion").add(Restrictions.idEq((Object)dv.getId()));
        List results = crit.list();
        Collections.sort(results, new ReviewCycleNodeResultPositionComparator());
        return results;
    }
}

