/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.file.CDESDataFile;
import at.cdes.bo.file.FileFinder;
import at.cdes.bo.service.ArchiveServiceJobInfo;
import at.cdes.bo.service.JobInfo;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.ServiceInvocationQueue;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class JobInfoMimeSource
implements VisitlessMimeSource {
    private FileFinder fileFinder;
    private ProjectDAO projectDAO;
    private ServiceInvocationQueue serviceInvocationQueue;

    public String getActionName() {
        return "downloadDocumentVersion";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        Integer id = (Integer)parameters[0];
        JobInfo jobInfo = this.serviceInvocationQueue.getRecentJobInfo(id);
        if (jobInfo instanceof ArchiveServiceJobInfo) {
            ArchiveServiceJobInfo aji = (ArchiveServiceJobInfo)jobInfo;
            return this.projectDAO.get(aji.getProjectId());
        }
        return null;
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        String unique;
        File file;
        Integer id = (Integer)parameters[0];
        JobInfo jobInfo = this.serviceInvocationQueue.getRecentJobInfo(id);
        if (jobInfo.getResult() == null) {
            throw new IOError("Job with id [" + id + "] has not been finished yet.");
        }
        if (!(jobInfo.getResult() instanceof CDESDataFile)) {
            throw new IOError("Job with id [" + id + "] does not have downloadable result.");
        }
        CDESDataFile df = (CDESDataFile)jobInfo.getResult();
        try {
            file = this.fileFinder.findFile(df);
            unique = df.toString();
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the job info result", (Throwable)e);
        }
        return new FileMimeInputStream(file, unique, df.getPath(), DefaultHttpContext.getInstance().getMimeType(df.getPath()));
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setServiceInvocationQueue(ServiceInvocationQueue serviceInvocationQueue) {
        this.serviceInvocationQueue = serviceInvocationQueue;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }
}

