/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.hibernate;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.clazzes.util.aop.ThreadLocalManager;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushModeInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(FlushModeInterceptor.class);
    private String hibernateThreadLocalKey;
    private String hibernateTransactionThreadLocalKey;

    public void setHibernateThreadLocalKey(String hibernateThreadLocalKey) {
        this.hibernateThreadLocalKey = hibernateThreadLocalKey;
    }

    public void setHibernateTransactionThreadLocalKey(String hibernateTransactionThreadLocalKey) {
        this.hibernateTransactionThreadLocalKey = hibernateTransactionThreadLocalKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        boolean transactionOpenedHere;
        Transaction transaction;
        Session session;
        block23: {
            session = (Session)ThreadLocalManager.getBoundResource((String)this.hibernateThreadLocalKey);
            transaction = (Transaction)ThreadLocalManager.getBoundResource((String)this.hibernateTransactionThreadLocalKey);
            transactionOpenedHere = transaction == null;
            FlushMode oldFlushMode = null;
            String methodName = invocation.getMethod().getName();
            try {
                if (transactionOpenedHere) {
                    transaction = session.beginTransaction();
                    if (log.isDebugEnabled()) {
                        log.debug("Opening transaction in FlushModeInterceptor.");
                    }
                }
                if (transaction == null) {
                    throw new NullPointerException();
                }
                if (methodName.startsWith("get") || methodName.startsWith("check") || methodName.startsWith("validate") || methodName.startsWith("count") || methodName.startsWith("fill") || methodName.startsWith("render") || methodName.startsWith("extract") || methodName.startsWith("is")) {
                    oldFlushMode = session.getFlushMode();
                    session.setFlushMode(FlushMode.NEVER);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Running method " + invocation.getMethod() + " with oldFlushMode = " + oldFlushMode);
                }
                Object ret = invocation.proceed();
                if (log.isDebugEnabled()) {
                    log.debug("Method " + invocation.getMethod() + " finished.");
                }
                if (transactionOpenedHere) {
                    transaction.commit();
                    if (log.isDebugEnabled()) {
                        log.debug("Committed transaction in FlushModeInterceptor.");
                    }
                }
                transaction = null;
                object = ret;
                if (oldFlushMode == null) break block23;
            }
            catch (Throwable throwable) {
                if (oldFlushMode != null) {
                    session.setFlushMode(oldFlushMode);
                }
                if (transactionOpenedHere && transaction != null) {
                    try {
                        if (transaction != null) {
                            if (log.isDebugEnabled()) {
                                log.debug("Will unbindResource() and rollback() for method [" + invocation.getMethod() + "]");
                            }
                            transaction.rollback();
                            session.clear();
                            if (log.isDebugEnabled()) {
                                log.debug("transaction.rollback() succeeded for method [" + invocation.getMethod() + "]");
                            }
                        }
                    }
                    catch (Throwable e) {
                        log.warn("Error rolling back Hibernate transaction for method [" + invocation.getMethod() + "]", e);
                    }
                }
                throw throwable;
            }
            session.setFlushMode(oldFlushMode);
        }
        if (transactionOpenedHere && transaction != null) {
            try {
                if (transaction != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Will unbindResource() and rollback() for method [" + invocation.getMethod() + "]");
                    }
                    transaction.rollback();
                    session.clear();
                    if (log.isDebugEnabled()) {
                        log.debug("transaction.rollback() succeeded for method [" + invocation.getMethod() + "]");
                    }
                }
            }
            catch (Throwable e) {
                log.warn("Error rolling back Hibernate transaction for method [" + invocation.getMethod() + "]", e);
            }
        }
        return object;
    }
}

