/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.data.document.ReleasedDocument;
import at.cdes.bo.data.document.ReleasedDocumentList;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DocumentDigestCalculator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Base64;

public class DocumentDigesterV1
extends DocumentDigestCalculator {
    @Override
    public String getDocumentListHash(ReleasedDocumentList documentList) throws DigestCalculatorException {
        if (documentList.getDigest() != null) {
            return documentList.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        DigestOutputStream dos = new DigestOutputStream(osd, this.getMessageDigest());
        try {
            dos.write(("id=" + documentList.getId()).getBytes());
            dos.write(("documentListId=" + documentList.getDocumentList().getId()).getBytes());
            dos.write(("subprojectId=" + documentList.getSubProject().getId()).getBytes());
            dos.write(("version=" + documentList.getVersion()).getBytes());
            dos.write("documents".getBytes());
            if (documentList.getDocuments() != null) {
                Object[] a = documentList.getDocuments().keySet().toArray();
                Arrays.sort(a);
                for (int i = 0; i < a.length; ++i) {
                    dos.write(((Integer)a[i]).toString().getBytes());
                }
            }
        }
        catch (IOException e) {
            throw new DigestCalculatorException("Hashing DocumentList = ", e);
        }
        String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return res;
    }

    @Override
    public String getDocumentHash(ReleasedDocument document) throws DigestCalculatorException {
        if (document.getDigest() != null) {
            return document.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        DigestOutputStream dos = new DigestOutputStream(osd, this.getMessageDigest());
        try {
            dos.write(("id=" + document.getId()).getBytes());
            dos.write(("documentListId=" + document.getDocumentList().getId()).getBytes());
            dos.write(("name=" + document.getName()).getBytes());
            dos.write(("number=" + document.getNumber()).getBytes());
            dos.write(("scale=" + document.getScale()).getBytes());
            dos.write(("document=" + document.getDocument().getId()).getBytes());
        }
        catch (IOException e) {
            throw new DigestCalculatorException("Hashing Document = ", e);
        }
        String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return res;
    }
}

