/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.cycle.Realm;
import at.cdes.db.dao.RealmDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Restrictions;

public class RealmDAOHibernate
extends HibernateDaoSupport
implements RealmDAO {
    @Override
    public Realm get(Integer id) {
        return (Realm)this.getSession().load(Realm.class, (Serializable)id);
    }

    @Override
    public List getAll() {
        return this.loadAllHibernate(Realm.class);
    }

    @Override
    public List getAllofProject(Integer projectId, Integer typeId) {
        if (projectId == null && typeId == null) {
            return this.getAll();
        }
        if (projectId != null && typeId == null) {
            return this.findHibernate("from Realm where project.id = ?", projectId);
        }
        if (projectId == null && typeId != null) {
            return this.findHibernate("from Realm where reviewCyclePositionType.id = ?", typeId);
        }
        return this.findHibernate("from Realm where reviewCyclePositionType.id = ? and project.id = ?", new Object[]{typeId, projectId});
    }

    @Override
    public List getAllOfProjectBetween(Integer projectId, Integer typeId, Date from, Date until) {
        Criteria crit = this.getSession().createCriteria(Realm.class);
        if (projectId != null) {
            crit.createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        if (typeId != null) {
            crit.createCriteria("reviewCyclePositionType").add(Restrictions.idEq((Object)typeId));
        }
        List allRealmsOfProject = crit.list();
        ArrayList<Realm> allValidRealmsOfProject = new ArrayList<Realm>();
        for (Realm realm : allRealmsOfProject) {
            if (realm.getValidToDate() == null && realm.getValidFromDate() == null || from == null && until == null) {
                allValidRealmsOfProject.add(realm);
                continue;
            }
            if (realm.getValidToDate() == null || until == null) {
                if (realm.getValidFromDate().compareTo(from) < 0) continue;
                allValidRealmsOfProject.add(realm);
                continue;
            }
            if (realm.getValidFromDate() == null || from == null) {
                if (realm.getValidToDate().compareTo(until) > 0) continue;
                allValidRealmsOfProject.add(realm);
                continue;
            }
            if (realm.getValidFromDate().compareTo(from) < 0 || realm.getValidToDate().compareTo(until) > 0) continue;
            allValidRealmsOfProject.add(realm);
        }
        return allValidRealmsOfProject;
    }

    @Override
    public List getAllOfProjectForObjectList(Integer projectId, Integer typeId, Date objectListReleased) {
        Criteria crit = this.getSession().createCriteria(Realm.class);
        if (projectId != null) {
            crit.createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        if (typeId != null) {
            crit.createCriteria("reviewCyclePositionType").add(Restrictions.idEq((Object)typeId));
        }
        List allRealmsOfProject = crit.list();
        ArrayList<Realm> ValidRealmsOfProject = new ArrayList<Realm>();
        for (Realm realm : allRealmsOfProject) {
            if (realm.getValidToDate() == null && realm.getValidFromDate() == null || objectListReleased == null) {
                ValidRealmsOfProject.add(realm);
                continue;
            }
            if (realm.getValidToDate() != null && realm.getValidFromDate() != null) {
                if (objectListReleased.compareTo(realm.getValidFromDate()) <= 0 || objectListReleased.compareTo(realm.getValidToDate()) > 0) continue;
                ValidRealmsOfProject.add(realm);
                continue;
            }
            if (realm.getValidFromDate() != null) {
                if (objectListReleased.compareTo(realm.getValidFromDate()) <= 0) continue;
                ValidRealmsOfProject.add(realm);
                continue;
            }
            if (realm.getValidToDate() == null || objectListReleased.compareTo(realm.getValidToDate()) > 0) continue;
            ValidRealmsOfProject.add(realm);
        }
        return ValidRealmsOfProject;
    }

    @Override
    public List getAllValidOfProject(Integer projectId, Integer typeId) {
        Criteria crit = this.getSession().createCriteria(Realm.class);
        if (projectId != null) {
            crit.createCriteria("project").add(Restrictions.idEq((Object)projectId));
        }
        if (typeId != null) {
            crit.createCriteria("reviewCyclePositionType").add(Restrictions.idEq((Object)typeId));
        }
        List allRealmsOfProject = crit.list();
        ArrayList<Realm> allValidRealmsOfProject = new ArrayList<Realm>();
        for (Realm realm : allRealmsOfProject) {
            if (realm.getValidToDate() != null) continue;
            allValidRealmsOfProject.add(realm);
        }
        return allValidRealmsOfProject;
    }

    @Override
    public Realm save(Realm cons) {
        return this.get((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public Realm update(Realm cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void delete(Realm cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public List<Realm> getTemplatesOfType(Integer typeId) {
        return this.getSession().createCriteria(Realm.class).add(Restrictions.isNull((String)"project")).createCriteria("reviewCyclePositionType").add(Restrictions.idEq((Object)typeId)).list();
    }

    @Override
    public List<Realm> getAllOfType(Integer typeId) {
        return this.getSession().createCriteria(Realm.class).createCriteria("reviewCyclePositionType").add(Restrictions.idEq((Object)typeId)).list();
    }
}

