/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.ReviewResultDigestCalculator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.DigestOutputStream;
import java.util.Arrays;
import org.bouncycastle.util.encoders.Base64;

public class ReviewResultDigesterV1
extends ReviewResultDigestCalculator {
    @Override
    public String getPositionResultHash(ReviewCyclePositionResult positionResult) throws DigestCalculatorException {
        if (positionResult.getDigest() != null) {
            return positionResult.getDigest();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream osd = new DataOutputStream(os);
        DigestOutputStream dos = new DigestOutputStream(osd, this.getMessageDigest());
        try {
            dos.write(("id=" + positionResult.getId()).getBytes());
            dos.write(("comment=" + positionResult.getComment()).getBytes());
            dos.write(("documentVersionId=" + positionResult.getDocumentVersion().getId()).getBytes());
            if (positionResult.getActiveDocumentList() != null) {
                dos.write(("activeDocumentListId=" + positionResult.getActiveDocumentList().getId()).getBytes());
            }
            dos.write(("activeObjectListId=" + positionResult.getActiveObjectList().getId()).getBytes());
            dos.write(("projectParticipantId=" + positionResult.getProjectParticipant().getId()).getBytes());
            if (positionResult.getRealm() != null) {
                dos.write(("realmId=" + positionResult.getRealm().getId()).getBytes());
            }
            if (positionResult.getCommentReference() == null || positionResult.getReviewCycleNodeResult() != null) {
                dos.write(("reviewCycleNodeResultId=" + positionResult.getReviewCycleNodeResult().getId()).getBytes());
            }
            if (positionResult.getReviewCycleResultOption() != null) {
                dos.write(("reviewCycleResultOptionId=" + positionResult.getReviewCycleResultOption().getId()).getBytes());
            }
            if (positionResult.getReviewCycleCommentOption() != null) {
                dos.write(("reviewCycleCommentOptionId=" + positionResult.getReviewCycleCommentOption().getId()).getBytes());
            }
            dos.write(("resultDate=" + positionResult.getResultDate()).getBytes());
            dos.write("attachments=".getBytes());
            if (positionResult.getAttachments() != null) {
                Object[] a = positionResult.getAttachments().keySet().toArray();
                Arrays.sort(a);
                for (int i = 0; i < a.length; ++i) {
                    if (((Attachment)positionResult.getAttachments().get((Integer)a[i])).getDigest() == null) continue;
                    dos.write(((Integer)a[i]).toString().getBytes());
                    dos.write("=".getBytes());
                    dos.write(((Attachment)positionResult.getAttachments().get((Integer)a[i])).getDigest().getBytes());
                    dos.write("\n".getBytes());
                }
            }
            dos.write(("reviewCycleNodeId=" + positionResult.getReviewCycleNode()).getBytes());
        }
        catch (IOException e) {
            throw new DigestCalculatorException("Hashing DocumentList = ", e);
        }
        String res = new String(Base64.encode((byte[])dos.getMessageDigest().digest()));
        return res;
    }
}

