/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.certificate.CDESCertificate;
import at.cdes.bo.data.certificate.CDESCertificateAuthority;
import at.cdes.bo.data.certificate.CDESCertificateTO;
import at.cdes.bo.data.certificate.CertificateRequest;
import at.cdes.bo.data.mail.EMail;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.person.PersonCertificatesTO;
import at.cdes.bo.sec.certificate.CDESCertificateGenerator;
import at.cdes.controller.actionhandler.login.URLMapper;
import at.cdes.db.dao.CertificateAuthorityDAO;
import at.cdes.db.dao.CertificateDAO;
import at.cdes.db.dao.PersonDAO;
import at.cdes.db.dao.SignatureDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.service.CertificateOperations;
import at.cdes.service.CommonOperations;
import at.cdes.service.exception.CDESCertificateException;
import at.cdes.service.exception.Challenge1NotFoundException;
import at.cdes.service.exception.Challenge2EnrolementException;
import at.cdes.service.exception.WrongPasswordException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.xnap.commons.i18n.I18n;

public class CertificateOperationsImpl
implements CertificateOperations {
    private CertificateDAO certificateDAO;
    private CertificateAuthorityDAO certificateAuthorityDAO;
    private CDESCertificateGenerator cdesCertificateGenerator;
    private URLMapper urlMapper;
    private CommonOperations commonOperations;
    private SignatureDAO signatureDAO;
    private PersonDAO personDAO;

    @Override
    public List getRootCAs() {
        return this.certificateAuthorityDAO.getRootCAs();
    }

    @Override
    public List getAllUserCAs() {
        return this.certificateAuthorityDAO.getUserCAs();
    }

    @Override
    public List getInvitationsByOrganisationPerson(Integer for_orgperson_id) {
        return this.certificateDAO.getInvitations(for_orgperson_id);
    }

    @Override
    public List getAcceptedCertificateRequestsByOrganisationPerson(Integer for_orgperson_id) {
        return this.certificateDAO.getAcceptedCertificateRequests(for_orgperson_id);
    }

    @Override
    public List getCertificateRequestsByOrganisationPerson(Integer for_orgperson_id) {
        return this.certificateDAO.getCertificateRequests(for_orgperson_id);
    }

    @Override
    public List getCertificatesByOrganisationPerson(Integer for_orgperson_id) {
        return this.certificateDAO.getCertificates(for_orgperson_id);
    }

    @Override
    public CDESCertificateAuthority insertCA(CDESCertificateAuthority ca) {
        ca = this.certificateAuthorityDAO.save(ca);
        return ca;
    }

    @Override
    public CDESCertificateAuthority updateCA(CDESCertificateAuthority ca) {
        ca = this.certificateAuthorityDAO.save(ca);
        return ca;
    }

    @Override
    public void deleteCA(Integer certificateAuthorityId) {
        CDESCertificateAuthority cert = this.certificateAuthorityDAO.get(certificateAuthorityId);
        this.certificateAuthorityDAO.delete(cert);
    }

    @Override
    public CDESCertificate insertCert(CDESCertificate cert) {
        cert = this.certificateDAO.save(cert);
        return cert;
    }

    @Override
    public CDESCertificate updateCert(CDESCertificate cert) {
        cert = this.certificateDAO.update(cert);
        return cert;
    }

    @Override
    public CDESCertificate deleteCert(Integer certificateId) {
        CDESCertificate cert = this.certificateDAO.get(certificateId);
        if (cert.getCertificateRequest() != null) {
            this.deleteCertRequest(cert.getCertificateRequest());
        }
        this.certificateDAO.delete(cert);
        return null;
    }

    @Override
    public CertificateRequest insertCertRequest(CertificateRequest certreq) {
        certreq.setCreated(new Date(System.currentTimeMillis()));
        certreq = this.certificateDAO.saveRequest(certreq);
        return certreq;
    }

    @Override
    public CertificateRequest updateCertRequest(CertificateRequest certreq) {
        certreq = this.certificateDAO.updateRequest(certreq);
        return certreq;
    }

    @Override
    public CertificateRequest deleteCertRequest(CertificateRequest certreq) {
        List<CDESCertificate> certs = this.certificateDAO.getCertificatesByRequestId(certreq.getId());
        for (CDESCertificate certificate : certs) {
            this.certificateDAO.delete(certificate);
        }
        this.certificateDAO.deleteRequest(certreq);
        return null;
    }

    public CertificateAuthorityDAO getCertificateAuthorityDAO() {
        return this.certificateAuthorityDAO;
    }

    public void setCertificateAuthorityDAO(CertificateAuthorityDAO certificateAuthorityDAO) {
        this.certificateAuthorityDAO = certificateAuthorityDAO;
    }

    public CertificateDAO getCertificateDAO() {
        return this.certificateDAO;
    }

    public void setCertificateDAO(CertificateDAO certificateDAO) {
        this.certificateDAO = certificateDAO;
    }

    public void setCommonOperations(CommonOperations commonOperations) {
        this.commonOperations = commonOperations;
    }

    public CommonOperations getCommonOperations() {
        return this.commonOperations;
    }

    @Override
    public CDESCertificate generateCertificateRequest(CertificateRequest invitation, OrganisationPerson requester, String password) throws CDESCertificateException {
        return this.cdesCertificateGenerator.generateCertificateRequest(invitation, requester, password);
    }

    @Override
    public CDESCertificate signCertificateRequest(CDESCertificate cert2sign, CDESCertificateAuthority userCA, String userCA_password, OrganisationPerson signer, int years) throws CDESCertificateException, WrongPasswordException {
        cert2sign.setCertificateAuthority(userCA);
        cert2sign = this.cdesCertificateGenerator.signCertificateRequest(cert2sign, userCA, userCA_password, signer, years);
        this.certificateDAO.updateRequest(cert2sign.getCertificateRequest());
        cert2sign = this.certificateDAO.update(cert2sign);
        return cert2sign;
    }

    @Override
    public CDESCertificateAuthority generateRootCA(String subject_dn, String password, int years, OrganisationPerson created_by) throws CDESCertificateException {
        return this.cdesCertificateGenerator.generateRootCA(subject_dn, password, years, created_by);
    }

    @Override
    public CDESCertificateAuthority generateUserCA(String subject_dn, String password, Network for_network, OrganisationPerson created_by, CDESCertificateAuthority rootca, String rootcapassword) throws CDESCertificateException, WrongPasswordException {
        this.invalidateUserCAs(for_network);
        return this.cdesCertificateGenerator.generateUserCA(subject_dn, password, for_network, created_by, rootca, rootcapassword);
    }

    private void invalidateUserCAs(Network network) {
        List userCAs = this.getUserCAs(network);
        for (CDESCertificateAuthority userCA : userCAs) {
            userCA.setMayIssue(false);
            this.certificateAuthorityDAO.update(userCA);
        }
    }

    @Override
    public CDESCertificateAuthority getCAById(Integer id) {
        return this.certificateAuthorityDAO.get(id);
    }

    @Override
    public CDESCertificate getCertById(Integer id) {
        return this.certificateDAO.get(id);
    }

    @Override
    public CertificateRequest getCertRequestById(Integer id) {
        return this.certificateDAO.getRequest(id);
    }

    @Override
    public CertificateRequest generateInvitation(OrganisationPerson for_orgperson, OrganisationPerson created_by) {
        return this.cdesCertificateGenerator.generateInvitation(for_orgperson, created_by);
    }

    @Override
    public String generateInvitationEMailText(CertificateRequest invitation) {
        Locale locale = new Locale(invitation.getCreatedFor().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        StringBuffer sb = new StringBuffer();
        if (invitation.getCreatedFor().getPerson().isFemale()) {
            sb.append(String.format(locale, i18n.tr("Sehr geehrte Frau %s%s"), invitation.getCreatedFor().getPerson().getTitle() != null ? invitation.getCreatedFor().getPerson().getTitle() + " " : "", invitation.getCreatedFor().getPerson().getCommonName() + ",\n"));
        } else {
            sb.append(String.format(locale, i18n.tr("Sehr geehrter Herr %s%s"), invitation.getCreatedFor().getPerson().getTitle() != null ? invitation.getCreatedFor().getPerson().getTitle() + " " : "", invitation.getCreatedFor().getPerson().getCommonName() + ",\n"));
        }
        sb.append("\n");
        sb.append("\n");
        sb.append(i18n.tr("Sie werden zur Teilnahme an der Internet-Plattform c.des eingeladen.") + "\n");
        sb.append(i18n.tr("F\u00fcr die Durchf\u00fchrung der Zertifikatsanforderung ben\u00f6tigen Sie einen Sicherheitscode, der Ihnen in einem gesonderten E-mail mitgeteilt werden.") + "\n");
        sb.append(i18n.tr("Im Ermessen der zust\u00e4ndigen Projektleitung, kann dieser Sicherheitscode in den n\u00e4chsten Tagen per Post an folgende Adresse zugestellt werden:") + "\n");
        sb.append((invitation.getCreatedFor().getPerson().getTitle() != null ? invitation.getCreatedFor().getPerson().getTitle() + " " : "") + "\n" + invitation.getCreatedFor().getPerson().getCommonName() + "\n" + invitation.getCreatedFor().getOrganisation().getName() + "\n" + invitation.getCreatedFor().getPostalAddress() + "\n" + invitation.getCreatedFor().getPostalCode() + " " + invitation.getCreatedFor().getLocalityName() + "\n" + invitation.getCreatedFor().getCountry().getDescDe() + "\n\n");
        sb.append(String.format(locale, i18n.tr("Sollten Sie das E-mail oder den Brief nicht erhalten haben, bitte um kurze Mitteilung an die e-mail Adresse %s"), invitation.getCreatedBy().getEmailAddress()) + "\n\n");
        sb.append(i18n.tr("Die Zertifikatsanforderung erfolgt unter folgendem Link:"));
        sb.append("\n\n");
        String url = this.urlMapper.getURL(invitation.getCreatedFor()) + "?service=external/ChallengeLogin&sp=S" + invitation.getChallenge1();
        sb.append(url + "\n\n");
        sb.append(i18n.tr("Dort werden Sie zur Eingabe des Sicherheitscodes aufgefordert und erhalten weitere Informationen."));
        sb.append("\n");
        if (this.getCommonOperations().getManualLink() != null && this.getCommonOperations().getManualLink().length() > 0) {
            String manuallink = this.getCommonOperations().getManualLink();
            if (!manuallink.endsWith("/")) {
                manuallink = manuallink.substring(0, manuallink.lastIndexOf(47) + 1);
            }
            if (!manuallink.startsWith("http")) {
                String app = this.urlMapper.getURL(invitation.getCreatedFor());
                app = app.substring(0, app.indexOf(47, 8));
                manuallink = manuallink.startsWith("/") ? app + manuallink : app + "/" + manuallink;
            }
            sb.append("Schritt-f\u00fcr-Schritt Anleitung zur Anforderung eines Zertifikats: " + manuallink + "Anleitung_Zertifikatsanforderung.pdf");
        }
        sb.append("\n");
        sb.append(i18n.tr("Mit freundlichen Gr\u00fcssen") + "\n\n" + (invitation.getCreatedBy().getPerson().getTitle() != null ? invitation.getCreatedBy().getPerson().getTitle() + " " : "") + invitation.getCreatedBy().getPerson().getCommonName() + "\n" + invitation.getCreatedBy().getOrganisation().getName());
        return sb.toString();
    }

    @Override
    public String generateSecurityCodeEMailText(CertificateRequest invitation) {
        StringBuffer sb = new StringBuffer();
        Locale locale = new Locale(invitation.getCreatedFor().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        if (invitation.getCreatedFor().getPerson().isFemale()) {
            sb.append(String.format(locale, i18n.tr("Sehr geehrte Frau %s%s"), invitation.getCreatedFor().getPerson().getTitle() != null ? invitation.getCreatedFor().getPerson().getTitle() + " " : "", invitation.getCreatedFor().getPerson().getCommonName() + ",\n"));
        } else {
            sb.append(String.format(locale, i18n.tr("Sehr geehrter Herr %s%s"), invitation.getCreatedFor().getPerson().getTitle() != null ? invitation.getCreatedFor().getPerson().getTitle() + " " : "", invitation.getCreatedFor().getPerson().getCommonName() + ",\n"));
        }
        sb.append("\n");
        sb.append("\n");
        sb.append(String.format(locale, i18n.tr("im Rahmen Ihrer Mitarbeit an Projektrealisierungen der %s werden\nSie eingeladen, ein Benutzerzertifikat anzufordern, damit f\u00fcr Sie ein Zugang zur Internet-\nPlattform c.des eingerichtet werden kann."), invitation.getCreatedBy().getOrganisation().getName() != null ? invitation.getCreatedBy().getOrganisation().getName() : "??"));
        sb.append(i18n.tr("N\u00e4here Anweisungen sollten Sie per e-mail oder Brief erhalten haben.") + "\n");
        sb.append(i18n.tr("Der Sicherheitcode f\u00fcr die im e-mail oder Brief referenzierte Zertifikatsanforderung lautet:") + "\n");
        sb.append("\n");
        sb.append(invitation.getChallenge2());
        sb.append("\n\n");
        sb.append(i18n.tr("Wir bitten Sie, mit diesen Informationen Ihr Zertifikat zu beantragen.") + "\n");
        sb.append("\n");
        sb.append(i18n.tr("Mit freundlichen Gr\u00fcssen") + "\n\n" + (invitation.getCreatedBy().getPerson().getTitle() != null ? invitation.getCreatedBy().getPerson().getTitle() + " " : "") + invitation.getCreatedBy().getPerson().getCommonName() + "\n" + invitation.getCreatedBy().getOrganisation().getName());
        return sb.toString();
    }

    @Override
    public void fillInvitationEMail(EMail mail, CertificateRequest invitation) {
        mail.setBody(this.generateInvitationEMailText(invitation));
    }

    @Override
    public String generateCertificateSignedEMailText(CDESCertificate signedCert) {
        StringBuffer sb = new StringBuffer();
        Locale locale = new Locale(signedCert.getOrganisationPerson().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        if (signedCert.getOrganisationPerson().getPerson().isFemale()) {
            sb.append(String.format(locale, i18n.tr("Sehr geehrte Frau %s%s"), signedCert.getOrganisationPerson().getPerson().getTitle() != null ? signedCert.getOrganisationPerson().getPerson().getTitle() + " " : "", signedCert.getOrganisationPerson().getPerson().getCommonName() + ",\n"));
        } else {
            sb.append(String.format(locale, i18n.tr("Sehr geehrter Herr %s%s"), signedCert.getOrganisationPerson().getPerson().getTitle() != null ? signedCert.getOrganisationPerson().getPerson().getTitle() + " " : "", signedCert.getOrganisationPerson().getPerson().getCommonName() + ",\n"));
        }
        sb.append("\n\n");
        sb.append(i18n.tr("Ihr Zertifikat f\u00fcr den Zugang zur Planpr\u00fcfplattform c.des wurde ausgestellt.") + "\n");
        sb.append(i18n.tr("Sie k\u00f6nnen sich ab sofort einloggen und signieren."));
        sb.append("\n\n\n");
        sb.append(i18n.tr("Mit freundlichen Gr\u00fcssen") + "\n\n" + (signedCert.getCreatedBy().getPerson().getTitle() != null ? signedCert.getCreatedBy().getPerson().getTitle() + " " : "") + signedCert.getCreatedBy().getPerson().getCommonName() + "\n" + signedCert.getCreatedBy().getOrganisation().getName());
        return sb.toString();
    }

    @Override
    public String generateCertificateRequestEMailText(CDESCertificate cert) {
        StringBuffer sb = new StringBuffer();
        Locale locale = new Locale(cert.getCreatedBy().getPerson().getPersonVariables(false).getUserLocale());
        I18n i18n = I18nFactory.getI18n(locale);
        if (cert.getCreatedBy().getPerson().isFemale()) {
            sb.append(String.format(locale, i18n.tr("Sehr geehrte Frau %s%s"), cert.getCreatedBy().getPerson().getTitle() != null ? cert.getCreatedBy().getPerson().getTitle() + " " : "", cert.getCreatedBy().getPerson().getCommonName() + ",\n"));
        } else {
            sb.append(String.format(locale, i18n.tr("Sehr geehrter Herr %s%s"), cert.getCreatedBy().getPerson().getTitle() != null ? cert.getCreatedBy().getPerson().getTitle() + " " : "", cert.getCreatedBy().getPerson().getCommonName() + ",\n"));
        }
        sb.append("\n\n");
        sb.append(String.format(locale, i18n.tr("%s hat die Zertifikatsanforderung zur Einladung mit der ID (Challenge 1) %s durchgef\u00fchrt."), cert.getOrganisationPerson().getPerson().getCommonName(), cert.getCertificateRequest().getChallenge1()));
        sb.append("\n\n");
        sb.append(i18n.tr("Das Zertifikat kann nach Einlangen des Faxes ausgestellt werden.") + "\n");
        return sb.toString();
    }

    @Override
    public CertificateRequest getCertRequestByChallenges(String c1, String c2) throws Challenge1NotFoundException, Challenge2EnrolementException {
        CertificateRequest certreq = this.certificateDAO.getCertificateRequestByChallenge1(c1);
        if (certreq == null) {
            throw new Challenge1NotFoundException();
        }
        if (!certreq.getChallenge2().equals(c2)) {
            throw new Challenge2EnrolementException();
        }
        return certreq;
    }

    @Override
    public List getUserCAs(Network forNetwork) {
        return this.certificateAuthorityDAO.getUserCAs(forNetwork);
    }

    @Override
    public CDESCertificate getCertByRequest(CertificateRequest cr) {
        return this.certificateDAO.getCertificateByRequest(cr);
    }

    @Override
    public List getCertificatesByNetwork(Integer network_id) {
        return this.certificateDAO.getCertificatesByNetwork(network_id);
    }

    @Override
    public List<PersonCertificatesTO> getCertifiedPersonsByNetwork(Integer networkId) {
        List certs = this.certificateDAO.getCertificatesByNetwork(networkId);
        HashMap<Integer, PersonCertificatesTO> persons = new HashMap<Integer, PersonCertificatesTO>();
        for (CDESCertificate cert : certs) {
            Person person = cert.getOrganisationPerson().getPerson();
            if (person.getStatus() == 1) continue;
            if (person.getStatus() == 2) continue;
            PersonCertificatesTO p = (PersonCertificatesTO)persons.get(cert.getOrganisationPerson().getPerson().getId());
            if (p == null) {
                p = new PersonCertificatesTO(cert.getOrganisationPerson().getPerson());
            }
            p.getCertificates().add(new CDESCertificateTO(cert));
            persons.put(p.getId(), p);
        }
        return new ArrayList<PersonCertificatesTO>(persons.values());
    }

    @Override
    public PersonCertificatesTO getPersonCertificateTO(Integer personId) {
        Person p = this.personDAO.get(personId);
        PersonCertificatesTO pto = new PersonCertificatesTO(p);
        return pto;
    }

    @Override
    public List getInvitationsByNetwork(Integer network_id) {
        return this.certificateDAO.getInvitationsByNetwork(network_id);
    }

    @Override
    public List getCertificateRequestsByNetwork(Integer network_id) {
        return this.certificateDAO.getCertificateRequestsByNetwork(network_id);
    }

    public void setCdesCertificateGenerator(CDESCertificateGenerator cdesCertificateGenerator) {
        this.cdesCertificateGenerator = cdesCertificateGenerator;
    }

    @Override
    public CDESCertificate changePassword(String password, String oldPassword, CDESCertificate cert) throws WrongPasswordException {
        return this.cdesCertificateGenerator.changePassword(password, oldPassword, cert);
    }

    @Override
    public CDESCertificateAuthority changePassword2(String password, String oldPassword, CDESCertificateAuthority cert) throws WrongPasswordException {
        return this.cdesCertificateGenerator.changePassword(password, oldPassword, cert);
    }

    @Override
    public CertificateRequest getCertRequestByChallenge1(String challenge1) {
        return this.certificateDAO.getCertificateRequestByChallenge1(challenge1);
    }

    @Override
    public CDESCertificate invalidateCert(CDESCertificate cert2del) {
        cert2del.setMaySign(false);
        cert2del.setMayLogin(false);
        return this.certificateDAO.update(cert2del);
    }

    @Override
    public CDESCertificate renewCertificate(CDESCertificate oldCert, CertificateRequest certificateRequest, CDESCertificateAuthority userCA, String password, OrganisationPerson signer, int years) throws WrongPasswordException, CDESCertificateException {
        CDESCertificate cert = new CDESCertificate();
        cert.setCertificateAuthority(userCA);
        cert.setCertificateRequest(certificateRequest);
        cert.setCertificate(null);
        cert.setDn(oldCert.getDn());
        cert.setCreatedBy(oldCert.getCreatedBy());
        cert.setMayLogin(false);
        cert.setMaySign(false);
        cert.setOrganisationPerson(oldCert.getOrganisationPerson());
        cert.setPrivateKey(oldCert.getPrivateKey());
        cert.setSerial(null);
        cert.setValidFrom(new Date());
        cert.setValidTo(null);
        oldCert.setMayLogin(false);
        oldCert.setMaySign(false);
        this.certificateDAO.update(oldCert);
        cert = this.cdesCertificateGenerator.renewCertificate(oldCert, cert, userCA, password, signer, years);
        cert = this.certificateDAO.save(cert);
        return cert;
    }

    @Override
    public CDESCertificate generateDirectCertificate(OrganisationPerson requester, String privkey) {
        return this.cdesCertificateGenerator.generateDirectCertificate(requester, privkey);
    }

    @Override
    public CDESCertificate signCertificateDirectly(CDESCertificate cert2sign, CDESCertificateAuthority ca, String userPassword, OrganisationPerson signer, int duration_years, CDESCertificate oldCert) throws CDESCertificateException, WrongPasswordException {
        cert2sign.setCertificateAuthority(ca);
        cert2sign = this.certificateDAO.save(cert2sign);
        cert2sign = this.cdesCertificateGenerator.signCertificateDirectly(cert2sign, ca, userPassword, signer, duration_years, oldCert);
        return this.certificateDAO.update(cert2sign);
    }

    @Override
    public List getCertificatesByPerson(Integer personId) {
        return this.certificateDAO.getCertificatesByPerson(personId);
    }

    @Override
    public List getValidUserCAs(Integer networkId) {
        return this.certificateAuthorityDAO.getValidUserCAs(networkId);
    }

    @Override
    public CDESCertificate getSignerCertificate(Integer organisationPersonId, boolean includeExpired) {
        return this.certificateDAO.getSignerCertificate(organisationPersonId, includeExpired);
    }

    @Override
    public CDESCertificateAuthority insertRootCAIfDatabaseCreatedFromScratch(Person person) {
        List rootCAs = this.certificateAuthorityDAO.getRootCAs();
        if (rootCAs != null && rootCAs.size() > 0 || person.getOrganisationPersons() == null || person.getOrganisationPersons().size() == 0) {
            return null;
        }
        OrganisationPerson op = person.getOrganisationPersons().values().iterator().next();
        try {
            CDESCertificateAuthority rootCA = this.generateRootCA("CN=RootCA 01, OU=CDES Security, O=BEG, C=AT", "cdes", 5, op);
            rootCA = this.insertCA(rootCA);
            return rootCA;
        }
        catch (CDESCertificateException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setUrlMapper(URLMapper urlMapper) {
        this.urlMapper = urlMapper;
    }

    @Override
    public boolean hasMultipleCertifiedOrganisationPersons(Integer personId) {
        List signableCertificatesByPerson = this.certificateDAO.getSignableCertificatesByPerson(personId);
        int count = 0;
        for (CDESCertificate cert : signableCertificatesByPerson) {
            if (!cert.getOrganisationPerson().isInActive()) {
                ++count;
            }
            if (count <= 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getSignableCertificatesByPerson(Integer personId) {
        return this.certificateDAO.getSignableCertificatesByPerson(personId);
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    @Override
    public boolean hasOrganisationPersonCertificatesWithSignatures(Integer orgPersonId) {
        List certificates = this.certificateDAO.getCertificates(orgPersonId);
        if (certificates != null && certificates.size() > 0) {
            for (CDESCertificate cert : certificates) {
                if (!this.signatureDAO.hasCertificateSignatures(cert.getId())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasPendingInvitationsOrRequests(Integer personId) {
        return !this.certificateDAO.getInvitationsOrRequestsForPerson(personId).isEmpty();
    }

    public void setPersonDAO(PersonDAO personDAO) {
        this.personDAO = personDAO;
    }
}

