/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.svg;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.svg.IMarkupWriter;
import at.cdes.svg.SvgRenderKit;
import at.cdes.svg.SvgReviewHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.xnap.commons.i18n.I18n;

public class UploadStatisticSvgRenderer {
    static final Logger logger = Logger.getLogger(UploadStatisticSvgRenderer.class);
    private boolean showAll;
    private Integer width;
    private Integer height;

    public void render(IMarkupWriter writer, int inheight, int inwidth, boolean sAll, List<DocumentVersion> uploads, I18n i18n) {
        List<DocumentVersion> documentVersions = uploads;
        this.height = inheight;
        this.width = inwidth;
        this.showAll = sAll;
        if (documentVersions.size() <= 0) {
            SvgRenderKit.addText(writer, 0.0, 20.0, "font-family:verdana; font-size:10px", i18n.tr("Es wurden keine Dokumente gefunden."), null);
        } else if (this.showAll) {
            String style = "stroke:black; stroke-width:1px;";
            int maxUploads = 0;
            Border border = this.getBorderMonth(documentVersions);
            Calendar latestMonth = border.latestDate;
            Calendar firstMonth = border.earliestDate;
            int firstMonthInt = firstMonth.get(2);
            int firstYearInt = firstMonth.get(1);
            int latestMonthInt = latestMonth.get(2);
            int firstDayInt = firstMonth.get(5);
            int monthToDraw = SvgReviewHelper.calculateMonthToDraw(firstMonth, latestMonth);
            int y = latestMonth.get(1) - firstMonth.get(1) + 1;
            if (y == 1) {
                this.drawOnlyOneYear(writer, latestMonth, firstMonth, firstMonthInt, documentVersions);
            } else {
                ArrayList<int[]> years = new ArrayList<int[]>();
                if (firstDayInt == 0) {
                    firstMonth.set(2, firstMonthInt - 1);
                } else {
                    firstMonth.set(5, firstDayInt - 1);
                }
                latestMonth.set(2, latestMonthInt + 1);
                int tmp = firstYearInt;
                for (int i = 0; i < y; ++i) {
                    int[] counter;
                    int z;
                    Calendar lastDay = Calendar.getInstance();
                    lastDay.set(2, 0);
                    lastDay.set(1, ++tmp);
                    lastDay.set(6, 1);
                    if (latestMonth.before(lastDay)) {
                        lastDay = (Calendar)latestMonth.clone();
                    }
                    if ((z = this.findMax(counter = this.getStatistic(documentVersions, firstMonth, lastDay))) > maxUploads) {
                        maxUploads = z;
                    }
                    years.add(counter);
                    firstMonth = (Calendar)lastDay.clone();
                }
                this.drawAxes(writer, style, maxUploads, 40);
                int maxHeight = this.height - 52;
                double increment = (this.width - 45) / (monthToDraw - 1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("getwidth " + this.width + "Increment " + increment));
                }
                int counter = 0;
                for (int j = 0; j < years.size(); ++j) {
                    monthToDraw = j == years.size() - 1 ? latestMonthInt + 1 : 12 - firstMonthInt;
                    for (int i = 0; i < monthToDraw; ++i) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("month to Draw:" + monthToDraw));
                            logger.debug((Object)("firstMonth" + firstMonthInt));
                        }
                        int actualUploads = ((int[])years.get(j))[firstMonthInt];
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("uploads" + actualUploads));
                        }
                        if (actualUploads > 0) {
                            double actualHeight = (double)actualUploads / (double)maxUploads * (double)maxHeight;
                            SvgRenderKit.addRec(writer, 30.0 + (double)counter * increment, (double)this.height.intValue() - (42.0 + actualHeight), 10.0, actualHeight, "fill:green;", null);
                            SvgRenderKit.addText(writer, 40.0 + (double)counter * increment, (double)this.height.intValue() - (44.0 + actualHeight), "font-family:verdana; font-size:10px", String.valueOf(actualUploads), "rotate(-90," + (40.0 + (double)counter * increment) + "," + ((double)this.height.intValue() - (44.0 + actualHeight)) + ")");
                        }
                        SvgRenderKit.addLine(writer, 35.0 + (double)counter * increment, this.height - 40, 35.0 + (double)counter * increment, this.height - 35, style);
                        SvgRenderKit.addText(writer, 40.0 + (double)counter * increment, this.height.intValue(), "font-family:verdana; font-size:10px", SvgRenderKit.getMonth(firstMonthInt + 1) + "." + SvgRenderKit.getYear(firstYearInt), "rotate(-90," + (40.0 + (double)counter * increment) + "," + this.height + ")");
                        ++firstMonthInt;
                        ++counter;
                    }
                    firstMonthInt = 0;
                    ++firstYearInt;
                }
            }
        } else {
            Calendar actualMonth = Calendar.getInstance();
            int firstMonth = actualMonth.get(2) - 5;
            actualMonth.set(2, firstMonth);
            this.drawOnlyOneYear(writer, null, actualMonth, firstMonth, documentVersions);
        }
    }

    private void drawOnlyOneYear(IMarkupWriter writer, Calendar latestMonth, Calendar firstMonth, int firstMonthInt, List<DocumentVersion> documentVersions) {
        Calendar afterThisMonth = (Calendar)firstMonth.clone();
        afterThisMonth.set(2, firstMonth.get(2) - 1);
        Calendar beforethisMonth = null;
        if (latestMonth != null) {
            beforethisMonth = (Calendar)latestMonth.clone();
            beforethisMonth.set(2, latestMonth.get(2) + 1);
        }
        int[] counter = this.getStatistic(documentVersions, afterThisMonth, beforethisMonth);
        int maxHeight = this.height - 27;
        int maxUploads = this.findMax(counter);
        this.drawAxes(writer, "stroke:black; stroke-width:1px;", maxUploads, 15);
        int numMonth = latestMonth == null ? 5 : latestMonth.get(2) - firstMonth.get(2);
        int increment = 0;
        if (numMonth > 0) {
            increment = (this.width - 60) / numMonth;
        }
        for (int i = 0; i < numMonth + 1; ++i) {
            int actualUploads = counter[firstMonthInt];
            if (actualUploads > 0) {
                double actualHeight = (double)actualUploads / (double)maxUploads * (double)maxHeight;
                SvgRenderKit.addRec(writer, 30 + i * increment, (double)this.height.intValue() - (17.0 + actualHeight), 10.0, actualHeight, "fill:green;", null);
                SvgRenderKit.addText(writer, 40 + i * increment, (double)this.height.intValue() - (17.0 + actualHeight), "font-family:verdana; font-size:10px", String.valueOf(actualUploads), null);
            }
            SvgRenderKit.addLine(writer, 35 + i * increment, this.height - 15, 35 + i * increment, this.height - 10, "stroke:black; stroke-width:1px;");
            String date = SvgRenderKit.getMonth(firstMonthInt + 1);
            if (latestMonth != null) {
                date = date + "." + SvgRenderKit.getYear(firstMonth.get(1));
            }
            SvgRenderKit.addText(writer, 35 - date.length() * 7 / 2 + i * increment, this.height.intValue(), "font-family:verdana; font-size:10px", date, null);
            ++firstMonthInt;
        }
    }

    private void drawAxes(IMarkupWriter writer, String style, int maxUploads, int basic) {
        SvgRenderKit.addLine(writer, 25.0, this.height - basic, this.width.intValue(), this.height - basic, style);
        SvgRenderKit.addLine(writer, 25.0, this.height - basic, 25.0, 5.0, style);
        SvgRenderKit.addLine(writer, 25.0, 10.0, 20.0, 10.0, style);
        SvgRenderKit.addText(writer, maxUploads < 10 ? 5.0 : 0.0, 15.0, "font-family:verdana; font-size:10px", String.valueOf(maxUploads), null);
    }

    private int[] getStatistic(List<DocumentVersion> documentVersions, Calendar afterthisMonth, Calendar beforethisMonth) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getStatistic");
            logger.debug((Object)("after this date : " + afterthisMonth.get(5) + "." + afterthisMonth.get(2) + "." + afterthisMonth.get(1)));
            logger.debug((Object)("before this date : " + beforethisMonth.get(5) + "." + beforethisMonth.get(2) + "." + beforethisMonth.get(1)));
        }
        int[] counter = new int[12];
        for (DocumentVersion d : documentVersions) {
            Date date = d.getUploaded();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            if (beforethisMonth == null) {
                if (!cal.after(afterthisMonth)) continue;
                int n = cal.get(2);
                counter[n] = counter[n] + 1;
                continue;
            }
            if (!cal.after(afterthisMonth) || !cal.before(beforethisMonth)) continue;
            int n = cal.get(2);
            counter[n] = counter[n] + 1;
        }
        return counter;
    }

    private int findMax(int[] counter) {
        int max = counter[0];
        for (int i = 1; i < counter.length; ++i) {
            if (counter[i] <= max) continue;
            max = counter[i];
        }
        return max;
    }

    private Border getBorderMonth(List<DocumentVersion> documentVersions) {
        Date latestDate;
        Date earliestDate = latestDate = documentVersions.get(0).getUploaded();
        for (DocumentVersion d : documentVersions) {
            if (d.getUploaded().after(latestDate)) {
                latestDate = d.getUploaded();
                continue;
            }
            if (!d.getUploaded().before(earliestDate)) continue;
            earliestDate = d.getUploaded();
        }
        GregorianCalendar latestCal = new GregorianCalendar();
        latestCal.setTime(latestDate);
        GregorianCalendar earliestCalendar = new GregorianCalendar();
        earliestCalendar.setTime(earliestDate);
        Border border = new Border();
        border.latestDate = latestCal;
        border.earliestDate = earliestCalendar;
        return border;
    }

    public class Border {
        Calendar latestDate;
        Calendar earliestDate;
    }
}

