/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.file.FileFinder;
import at.cdes.db.dao.AttachmentDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import at.cdes.util.ImplContextHelper;
import java.io.File;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class AttachmentMimeSource
implements VisitlessMimeSource {
    private AttachmentDAO attachmentDAO;
    private ProjectDAO projectDAO;
    private FileFinder fileFinder;

    public String getActionName() {
        return "downloadAttachment";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        return ImplContextHelper.getContextProjectId() != null ? this.projectDAO.get(ImplContextHelper.getContextProjectId()) : null;
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        String unique;
        File file;
        Integer id = (Integer)parameters[0];
        Attachment att = this.attachmentDAO.get(id);
        try {
            file = this.fileFinder.findFile(att.getFileName(), CDESFileRepository.ATTACHMENTREPOSITORY);
            unique = this.fileFinder.makeUniqueName(att.getFileName(), CDESFileRepository.ATTACHMENTREPOSITORY);
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the documentversion", (Throwable)e);
        }
        return new FileMimeInputStream(file, unique, att.getOriginalName(), DefaultHttpContext.getInstance().getMimeType(att.getFileName()));
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }
}

