/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.db.dao.ConsortiumDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.OrganisationDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.service.OrganisationOperations;
import at.cdes.util.DLStringMatcher;
import at.cdes.util.OgnlComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OrganisationOperationsImpl
implements OrganisationOperations {
    private OrganisationDAO organisationDAO;
    private NetworkDAO networkDAO;
    private ConsortiumDAO consortiumDAO;
    private OrganisationPersonDAO organisationPersonDAO;

    @Override
    public Organisation getOrganisation(Integer id) {
        return this.organisationDAO.get(id);
    }

    @Override
    public List getOrganisations(Integer networkId, Integer organisationPersonId, String filter, Locale locale) {
        Integer organisationId = null;
        if (organisationPersonId != null) {
            organisationId = this.organisationPersonDAO.get(organisationPersonId).getOrganisation().getId();
        }
        ArrayList ret = new ArrayList(this.organisationDAO.getAll(networkId, organisationId, filter));
        Collections.sort(ret, new OgnlComparator("name", true, locale));
        return ret;
    }

    @Override
    public Organisation insertOrganisation(Organisation org, Integer networkId) {
        if (networkId != null) {
            Network network = this.networkDAO.get(networkId);
            org.setNetworks(new HashMap());
            org.getNetworks().put(network.getId(), network);
            network.getOrganisations().put(null, org);
        }
        return this.organisationDAO.save(org);
    }

    @Override
    public void deleteOrganisation(Organisation org) {
        org.setConsortiums(null);
        if (org.getNetworks() != null) {
            for (Network network : org.getNetworks().values()) {
                network.getOrganisations().remove(org.getId());
                this.networkDAO.merge(network);
            }
        }
        org.setNetworks(null);
        org.setConsortiumMembers(null);
        this.organisationDAO.delete(org);
    }

    @Override
    public Organisation updateOrganisation(Organisation org) {
        return this.organisationDAO.update(org);
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    @Override
    public List getOrganisationAndConsortiums(Integer networkId, Integer organisationPersonId, String filter, Locale locale) {
        Integer organisationId = null;
        if (organisationPersonId != null) {
            organisationId = this.organisationPersonDAO.get(organisationPersonId).getOrganisation().getId();
        }
        ArrayList ret = new ArrayList();
        ret.addAll(this.organisationDAO.getAll(networkId, organisationId, filter));
        ret.addAll(this.consortiumDAO.getAll(networkId, organisationId, filter));
        Collections.sort(ret, new OgnlComparator("name", true, locale));
        return ret;
    }

    public void setConsortiumDAO(ConsortiumDAO consortiumDAO) {
        this.consortiumDAO = consortiumDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    @Override
    public List getOtherNetworksOrganisations(Integer networkId, String filter) {
        List<Organisation> organisations = this.organisationDAO.getOtherNetworksAll(networkId, filter);
        ArrayList<Organisation> excludedOwn = new ArrayList<Organisation>();
        for (Organisation organisation : organisations) {
            if (organisation.getNetworks() == null || organisation.getNetworks().keySet().contains(networkId)) continue;
            excludedOwn.add(organisation);
        }
        return excludedOwn;
    }

    @Override
    public void addOrganisationToNetwork(Organisation organisation, Network network) {
        if (organisation.getNetworks() == null) {
            organisation.setNetworks(new HashMap());
        }
        organisation.getNetworks().put(network.getId(), network);
        if (network.getOrganisations() == null) {
            network.setOrganisations(new HashMap());
        }
        network.getOrganisations().put(organisation.getId(), organisation);
        this.networkDAO.merge(network);
        this.organisationDAO.update(organisation);
    }

    @Override
    public Map getOrganisationPersonsByOrganisation(Integer organisationId) {
        Organisation org = this.organisationDAO.get(organisationId);
        return org.getAllOrganisationPersons();
    }

    @Override
    public boolean isOrganisationInNetwork(Integer organisationPersonId, Integer networkId) {
        OrganisationPerson orgPerson = this.organisationPersonDAO.get(organisationPersonId);
        return orgPerson.getOrganisation().getNetworks().containsKey(networkId);
    }

    @Override
    public List getOrganisationsFromOtherNetworks(Integer ownNetworkId, String filter, boolean isConsortium) {
        if (isConsortium) {
            return this.consortiumDAO.getOtherNetworksAllConsortiums(ownNetworkId, filter);
        }
        return this.organisationDAO.getOtherNetworksAll(ownNetworkId, filter);
    }

    @Override
    public String getOtherOrganisationNames(Integer networkId, boolean isConsortium) {
        String resultString = "";
        String organisationSeparator = "$";
        String subElementSeparator = "|";
        ArrayList<Integer> doneOrgIDs = new ArrayList<Integer>();
        List ownOrganisations = null;
        ownOrganisations = isConsortium ? this.consortiumDAO.getAll(networkId, null, null) : this.organisationDAO.getAll(networkId, null, null);
        for (Organisation org : ownOrganisations) {
            resultString = resultString + org.getId() + subElementSeparator + org.getName() + subElementSeparator + "true" + organisationSeparator;
            doneOrgIDs.add(org.getId());
        }
        List<Organisation> otherOrgs = null;
        otherOrgs = isConsortium ? this.consortiumDAO.getOtherNetworksAllConsortiums(networkId, null) : this.organisationDAO.getOtherNetworksAll(networkId, null);
        for (Organisation org : otherOrgs) {
            if (doneOrgIDs.contains(org.getId())) continue;
            resultString = resultString + org.getId() + subElementSeparator + org.getName() + subElementSeparator + "false" + organisationSeparator;
            doneOrgIDs.add(org.getId());
        }
        return resultString;
    }

    @Override
    public List<Organisation> getPotentialOrganisationsWithMatchingNames(String orgName, int maxDistance, Integer networkId, Integer activeOrganisationId) {
        ArrayList<Organisation> ret = new ArrayList<Organisation>();
        List allOrgs = this.organisationDAO.getAll(activeOrganisationId == null ? null : networkId, null, null);
        for (Organisation org : allOrgs) {
            if (org.getId().equals(activeOrganisationId) || !DLStringMatcher.valdiateDistance(org.getName().toLowerCase(), orgName.toLowerCase(), maxDistance)) continue;
            ret.add(org);
        }
        return ret;
    }

    @Override
    public int getActiveOrganisationCount() {
        return this.organisationDAO.getActiveOrganisationCount();
    }
}

