/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.helper;

import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.task.AttachedReviewTaskDone;
import at.cdes.bo.data.task.OriginalDocumentTask;
import at.cdes.bo.data.task.OriginalDocumentTaskDone;
import at.cdes.bo.data.task.PlotOrderAcceptanceTask;
import at.cdes.bo.data.task.PlotOrderAcceptanceTaskDone;
import at.cdes.bo.data.task.ReviewCycleEntryTask;
import at.cdes.bo.data.task.ReviewCycleEntryTaskDone;
import at.cdes.bo.data.task.ReviewCyclePlottTask;
import at.cdes.bo.data.task.ReviewCyclePlottTaskDone;
import at.cdes.bo.data.task.ReviewTaskDone;
import at.cdes.bo.data.task.ReviewableTask;
import at.cdes.bo.data.task.ReviewableTaskDone;
import at.cdes.bo.data.task.SelectCellConnectionTask;
import at.cdes.bo.data.task.SelectCellConnectionTaskDone;
import at.cdes.bo.data.task.Task;
import at.cdes.bo.data.task.TaskTO;
import at.cdes.bo.date.HolidayCalculator;
import at.cdes.service.ObjectOperations;
import at.cdes.service.ProjectOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.util.TapestryI18nHelper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.xnap.commons.i18n.I18n;

public class TaskOverviewTaskTOGenerator {
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private ObjectOperations objectOperations;
    private ProjectOperations projectOperations;
    private ReviewOperations reviewOperations;

    public TaskTO generateTaskTO(Task task, Calendar from, HolidayCalculator holidayCalculator, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        if (task instanceof ReviewableTask) {
            return this.processReviewableTask((ReviewableTask)task, from, holidayCalculator, isMainParticipantTask, i18n, isOOOMode);
        }
        if (task instanceof SelectCellConnectionTask) {
            return this.processSelectCellConnectionTask((SelectCellConnectionTask)task, from, holidayCalculator, isMainParticipantTask, i18n, isOOOMode);
        }
        if (task instanceof ReviewCycleEntryTask) {
            return this.processReviewCycleEntryTask((ReviewCycleEntryTask)task, from, holidayCalculator, isMainParticipantTask, i18n, isOOOMode);
        }
        if (task instanceof ReviewCyclePlottTask) {
            return this.processReviewCyclePlottTask((ReviewCyclePlottTask)task, isMainParticipantTask, i18n, isOOOMode);
        }
        if (task instanceof OriginalDocumentTask) {
            return this.processOriginalDocumentTask((OriginalDocumentTask)task, isMainParticipantTask, i18n, isOOOMode);
        }
        if (task instanceof PlotOrderAcceptanceTask) {
            return this.processPlotOrderAcceptanceTask((PlotOrderAcceptanceTask)task, isMainParticipantTask, i18n, isOOOMode);
        }
        return this.generateDoneTaskTO(task, isMainParticipantTask, i18n, isOOOMode);
    }

    public TaskTO generateDoneTaskTO(Task task, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        if (task instanceof ReviewTaskDone || task instanceof AttachedReviewTaskDone) {
            return this.processReviewTaskDone((ReviewableTaskDone)task, isMainParticipantTask, i18n, isOOOMode);
        }
        if (task instanceof ReviewCycleEntryTaskDone) {
            return this.processReviewCycleEntryTaskDone((ReviewCycleEntryTaskDone)task, isMainParticipantTask, i18n, isOOOMode);
        }
        if (task instanceof SelectCellConnectionTaskDone) {
            return this.processSelectCellConnectionTaskDone((SelectCellConnectionTaskDone)task, isMainParticipantTask, i18n, isOOOMode);
        }
        if (task instanceof ReviewCyclePlottTaskDone) {
            return this.processReviewCyclePlottTaskDone((ReviewCyclePlottTaskDone)task, isMainParticipantTask, i18n, isOOOMode);
        }
        if (task instanceof PlotOrderAcceptanceTaskDone) {
            return this.processPlotOrderAcceptanceTaskDone((PlotOrderAcceptanceTaskDone)task, isMainParticipantTask, i18n, isOOOMode);
        }
        if (task instanceof OriginalDocumentTaskDone) {
            return this.processOriginalDocumentTaskDone((OriginalDocumentTaskDone)task, isMainParticipantTask, i18n, isOOOMode);
        }
        return null;
    }

    public TaskTO generateSurveillanceTaskTO(Task task, Calendar from, HolidayCalculator holidayCalculator, boolean ownLateTask, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO taskTO = this.generateTaskTO(task, from, holidayCalculator, isMainParticipantTask, i18n, isOOOMode);
        taskTO.setLateTask(true);
        taskTO.setOwnLateTask(ownLateTask);
        return taskTO;
    }

    private TaskTO processReviewableTask(ReviewableTask task, Calendar from, HolidayCalculator holidayCalculator, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setType(4);
        te.setId(task.getId());
        String rawReviewCycleNodeName = TapestryI18nHelper.getLocalizedString(task.getDocumentVersion().getActualReviewCycleNode().getName());
        String reviewCycleNodeName = TapestryI18nHelper.getLocalizedString(rawReviewCycleNodeName);
        te.setName(reviewCycleNodeName);
        Document releasedOrImplDocument = task.getDocumentVersion().getDocument();
        if (releasedOrImplDocument instanceof DocumentImpl) {
            releasedOrImplDocument = ((DocumentImpl)releasedOrImplDocument).getLastReleasedOrImplDocument();
        }
        te.setDocumentNumber(releasedOrImplDocument.getNumber());
        te.setTitle(task.getDocumentVersion().getName());
        String content = releasedOrImplDocument.getContent();
        te.setSubTitle(TapestryI18nHelper.getLocalizedString(content));
        te.setSubGroup(task.getObjectPlanner().getObject().getCode());
        te.setSubGroupDetails(task.getObjectPlanner().getObject().getName());
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setSampleControlReview(task.isSampleControlReview());
        if (task.getDocumentVersion().getActualReviewCycleNode().getReviewCyclePositionType() != null && task.getDocumentVersion().getActualReviewCycleNode().getReviewCyclePositionType().getSampleControlReviewCyclePositionType() != null) {
            te.setSampleControlReviewResultOptionText(TapestryI18nHelper.getLocalizedString(task.getDocumentVersion().getActualReviewCycleNode().getReviewCyclePositionType().getSampleControlReviewCyclePositionType().getName()));
        }
        te.setUploaded(task.getDocumentVersion().getUploaded());
        te.setUploadedFilterString(dateFormat.format(te.getUploaded()));
        te.setLateTask(false);
        te.setOwnLateTask(false);
        int diff = holidayCalculator.getWorkingDaysBetween(task.getEndDate(), from);
        te.setDiff(diff);
        this.setTaskStatusText(te, i18n, diff, task.getEndDate().getTime(), isOOOMode, task.isTaskInSignatureFolder());
        te.setTaskDelay(diff);
        Calendar reviewCycleEndDate = Calendar.getInstance();
        boolean isContractual = false;
        if (releasedOrImplDocument.getEndDate() != null) {
            reviewCycleEndDate.setTime(releasedOrImplDocument.getEndDate());
            isContractual = true;
        } else {
            reviewCycleEndDate = task.getOverallEndDate();
        }
        if (reviewCycleEndDate != null) {
            int reviewCycleDiff = holidayCalculator.getWorkingDaysBetween(reviewCycleEndDate, from);
            te.setReviewCycleDelay(reviewCycleDiff);
            this.setReviewCycleStatusText(te, i18n, reviewCycleDiff, reviewCycleEndDate.getTime(), isContractual, isOOOMode);
        }
        te.setMainParticipant(isMainParticipantTask);
        te.setActiveObjectPlannerReleaseId(this.getActiveObjectPlannerReleaseId(task.getDocumentVersion().getDocument()));
        te.setDocumentId(task.getDocumentVersion().getDocument().getId());
        te.setDocumentVersionId(task.getDocumentVersion().getId());
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (task.isTaskInSignatureFolder()) {
            this.evalSignatureFolderPositions(task, te, i18n);
        }
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    private TaskTO processSelectCellConnectionTask(SelectCellConnectionTask task, Calendar from, HolidayCalculator holidayCalculator, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setType(0);
        te.setId(task.getId());
        te.setName(task.getDisplayName());
        Document releasedOrImplDocument = task.getDocumentVersion().getDocument();
        if (releasedOrImplDocument instanceof DocumentImpl) {
            releasedOrImplDocument = ((DocumentImpl)releasedOrImplDocument).getLastReleasedOrImplDocument();
        }
        te.setDocumentNumber(releasedOrImplDocument.getNumber());
        te.setTitle(task.getDocumentVersion().getName());
        String content = releasedOrImplDocument.getContent();
        te.setSubTitle(TapestryI18nHelper.getLocalizedString(content));
        te.setSubGroup(task.getObjectPlanner().getObject().getCode());
        te.setSubGroupDetails(task.getObjectPlanner().getObject().getName());
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setSampleControlReview(false);
        te.setUploaded(task.getDocumentVersion().getUploaded());
        te.setUploadedFilterString(dateFormat.format(te.getUploaded()));
        te.setLateTask(false);
        te.setOwnLateTask(false);
        int diff = holidayCalculator.getWorkingDaysBetween(task.getEndDate(), from);
        te.setDiff(diff);
        this.setTaskStatusText(te, i18n, diff, task.getEndDate().getTime(), isOOOMode, false);
        te.setTaskDelay(diff);
        Calendar reviewCycleEndDate = Calendar.getInstance();
        boolean isContractual = false;
        if (releasedOrImplDocument.getEndDate() != null) {
            reviewCycleEndDate.setTime(releasedOrImplDocument.getEndDate());
            isContractual = true;
        } else {
            reviewCycleEndDate = task.getOverallEndDate();
        }
        if (reviewCycleEndDate != null) {
            int reviewCycleDiff = holidayCalculator.getWorkingDaysBetween(reviewCycleEndDate, from);
            this.setReviewCycleStatusText(te, i18n, reviewCycleDiff, reviewCycleEndDate.getTime(), isContractual, isOOOMode);
            te.setReviewCycleDelay(reviewCycleDiff);
        }
        te.setMainParticipant(isMainParticipantTask);
        te.setActiveObjectPlannerReleaseId(this.getActiveObjectPlannerReleaseId(task.getDocumentVersion().getDocument()));
        te.setDocumentId(task.getDocumentVersion().getDocument().getId());
        te.setDocumentVersionId(task.getDocumentVersion().getId());
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    private TaskTO processReviewCycleEntryTask(ReviewCycleEntryTask task, Calendar from, HolidayCalculator holidayCalculator, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setType(1);
        te.setId(task.getId());
        te.setName(task.getDisplayName());
        Document releasedOrImplDocument = task.getDocument();
        if (releasedOrImplDocument instanceof DocumentImpl) {
            releasedOrImplDocument = ((DocumentImpl)releasedOrImplDocument).getLastReleasedOrImplDocument();
        }
        te.setDocumentNumber(releasedOrImplDocument.getNumber());
        te.setTitle(releasedOrImplDocument.getName());
        String content = releasedOrImplDocument.getContent();
        te.setSubTitle(TapestryI18nHelper.getLocalizedString(content));
        te.setSubGroup(task.getObjectPlanner().getObject().getCode());
        te.setSubGroupDetails(task.getObjectPlanner().getObject().getName());
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setSampleControlReview(false);
        te.setUploaded(null);
        te.setLateTask(false);
        te.setOwnLateTask(false);
        Calendar docsStartDate = Calendar.getInstance();
        if (releasedOrImplDocument.getStartDate() != null) {
            docsStartDate.setTime(releasedOrImplDocument.getStartDate());
        } else {
            docsStartDate = task.getEndDate();
        }
        int diff = holidayCalculator.getWorkingDaysBetween(docsStartDate, from);
        te.setDiff(diff);
        this.setTaskStatusText(te, i18n, diff, docsStartDate.getTime(), isOOOMode, false);
        te.setTaskDelay(diff);
        Calendar reviewCycleEndDate = Calendar.getInstance();
        boolean isContractual = false;
        if (releasedOrImplDocument.getEndDate() != null) {
            reviewCycleEndDate.setTime(releasedOrImplDocument.getEndDate());
            isContractual = true;
        } else {
            reviewCycleEndDate = task.getOverallEndDate();
        }
        if (reviewCycleEndDate != null) {
            int reviewCycleDiff = holidayCalculator.getWorkingDaysBetween(reviewCycleEndDate, from);
            this.setReviewCycleStatusText(te, i18n, reviewCycleDiff, reviewCycleEndDate.getTime(), isContractual, isOOOMode);
            te.setReviewCycleDelay(reviewCycleDiff);
        }
        te.setMainParticipant(isMainParticipantTask);
        te.setActiveObjectPlannerReleaseId(this.getActiveObjectPlannerReleaseId(task.getDocument()));
        te.setDocumentId(task.getDocument().getId());
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    private TaskTO processReviewCyclePlottTask(ReviewCyclePlottTask task, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setType(2);
        te.setId(task.getId());
        te.setName(task.getDisplayName());
        te.setDocumentNumber(task.getDocumentVersion().getDocument().getNumber());
        te.setTitle("");
        te.setSubTitle("");
        te.setSubGroup("");
        te.setSubGroupDetails("");
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setSampleControlReview(false);
        te.setUploaded(null);
        te.setLateTask(false);
        te.setOwnLateTask(false);
        te.setDiff(19999);
        te.setTaskDelay(19999);
        te.setReviewCycleDelay(19999);
        te.setPlotOrderJobNumber("" + task.getOrder().getJobNumber());
        te.setMainParticipant(isMainParticipantTask);
        te.setDocumentId(task.getDocumentVersion().getDocument().getId());
        te.setDocumentVersionId(task.getDocumentVersion().getId());
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    private TaskTO processOriginalDocumentTask(OriginalDocumentTask task, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setType(3);
        te.setId(task.getId());
        te.setName(task.getDisplayName());
        Document releasedOrImplDocument = task.getDocumentVersion().getDocument();
        if (releasedOrImplDocument instanceof DocumentImpl) {
            releasedOrImplDocument = ((DocumentImpl)releasedOrImplDocument).getLastReleasedOrImplDocument();
        }
        te.setDocumentNumber(releasedOrImplDocument.getNumber());
        te.setTitle(task.getDocumentVersion().getName());
        String content = releasedOrImplDocument.getContent();
        te.setSubTitle(TapestryI18nHelper.getLocalizedString(content));
        te.setSubGroup(task.getObjectPlanner().getObject().getCode());
        te.setSubGroupDetails(task.getObjectPlanner().getObject().getName());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setSampleControlReview(false);
        te.setUploaded(null);
        te.setDiff(20000);
        te.setTaskDelay(20000);
        te.setReviewCycleDelay(20000);
        te.setLateTask(false);
        te.setOwnLateTask(false);
        te.setMainParticipant(isMainParticipantTask);
        te.setActiveObjectPlannerReleaseId(this.getActiveObjectPlannerReleaseId(task.getDocumentVersion().getDocument()));
        te.setDocumentId(task.getDocumentVersion().getDocument().getId());
        te.setDocumentVersionId(task.getDocumentVersion().getId());
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    private TaskTO processPlotOrderAcceptanceTask(PlotOrderAcceptanceTask task, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setType(5);
        te.setId(task.getId());
        te.setName(task.getDisplayName());
        Document releasedOrImplDocument = task.getDocumentVersion().getDocument();
        if (releasedOrImplDocument instanceof DocumentImpl) {
            releasedOrImplDocument = ((DocumentImpl)releasedOrImplDocument).getLastReleasedOrImplDocument();
        }
        te.setDocumentNumber(releasedOrImplDocument.getNumber());
        te.setTitle("");
        te.setSubTitle("");
        te.setSubGroup("");
        te.setSubGroupDetails("");
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setSampleControlReview(false);
        te.setUploaded(null);
        te.setLateTask(false);
        te.setOwnLateTask(false);
        te.setPlotOrderJobNumber("" + task.getOrder().getJobNumber());
        te.setDiff(1999);
        te.setMainParticipant(isMainParticipantTask);
        te.setDocumentId(task.getDocumentVersion().getDocument().getId());
        te.setDocumentVersionId(task.getDocumentVersion().getId());
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    private TaskTO processReviewTaskDone(ReviewableTaskDone task, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setId(task.getId());
        te.setName(task.getDisplayName());
        te.setType(10);
        Document releasedOrImplDocument = task.getDocumentVersion().getDocument();
        if (releasedOrImplDocument instanceof DocumentImpl) {
            releasedOrImplDocument = ((DocumentImpl)releasedOrImplDocument).getLastReleasedOrImplDocument();
        }
        te.setDocumentNumber(releasedOrImplDocument.getNumber());
        te.setTitle(task.getDocumentVersion().getName());
        String content = releasedOrImplDocument.getContent();
        te.setSubTitle(TapestryI18nHelper.getLocalizedString(content));
        te.setSubGroup(task.getObjectPlanner().getObject().getCode());
        te.setSubGroupDetails(task.getObjectPlanner().getObject().getName());
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setUploaded(task.getDocumentVersion().getUploaded());
        te.setUploadedFilterString(dateFormat.format(te.getUploaded()));
        te.setLateTask(false);
        te.setOwnLateTask(false);
        te.setDiff(0);
        te.setTaskDelay(0);
        te.setMainParticipant(isMainParticipantTask);
        te.setActiveObjectPlannerReleaseId(this.getActiveObjectPlannerReleaseId(task.getDocumentVersion().getDocument()));
        te.setDocumentId(task.getDocumentVersion().getDocument().getId());
        te.setDocumentVersionId(task.getDocumentVersion().getId());
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (task instanceof ReviewTaskDone) {
            te.setSampleControlReview(((ReviewTaskDone)task).isSampleControlReview());
            te.setDoneDate(((ReviewTaskDone)task).getDoneDate().getTime());
            te.setDoneDateFilterString(dateFormat.format(task.getDoneDate().getTime()));
        } else {
            te.setSampleControlReview(((AttachedReviewTaskDone)task).isSampleControlReview());
            te.setDoneDate(((AttachedReviewTaskDone)task).getDoneDate().getTime());
            te.setDoneDateFilterString(dateFormat.format(task.getDoneDate().getTime()));
        }
        this.evalPositionResults(task, te, i18n);
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    private TaskTO processReviewCycleEntryTaskDone(ReviewCycleEntryTaskDone task, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setType(7);
        te.setId(task.getId());
        te.setName(task.getDisplayName());
        Document releasedOrImplDocument = task.getDocument();
        if (releasedOrImplDocument instanceof DocumentImpl) {
            releasedOrImplDocument = ((DocumentImpl)releasedOrImplDocument).getLastReleasedOrImplDocument();
        }
        te.setDocumentNumber(task.getDocument().getNumber());
        te.setTitle(task.getReviewCycleEntryResult().getDocumentVersion().getName());
        te.setDocumentId(task.getDocument().getId());
        te.setDocumentVersionId(task.getReviewCycleEntryResult().getDocumentVersion().getId());
        String content = task.getDocument().getContent();
        te.setSubTitle(TapestryI18nHelper.getLocalizedString(content));
        te.setSubGroup(task.getObjectPlanner().getObject().getCode());
        te.setSubGroupDetails(task.getObjectPlanner().getObject().getName());
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setSampleControlReview(false);
        te.setUploaded(task.getReviewCycleEntryResult().getDocumentVersion().getUploaded());
        te.setUploadedFilterString(dateFormat.format(te.getUploaded()));
        te.setDoneDate(task.getDoneDate().getTime());
        te.setDoneDateFilterString(dateFormat.format(task.getDoneDate().getTime()));
        te.setMainParticipant(isMainParticipantTask);
        te.setActiveObjectPlannerReleaseId(this.getActiveObjectPlannerReleaseId(task.getDocument()));
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    private TaskTO processSelectCellConnectionTaskDone(SelectCellConnectionTaskDone task, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setType(6);
        te.setId(task.getId());
        te.setName(task.getDisplayName());
        Document releasedOrImplDocument = task.getDocumentVersion().getDocument();
        if (releasedOrImplDocument instanceof DocumentImpl) {
            releasedOrImplDocument = ((DocumentImpl)releasedOrImplDocument).getLastReleasedOrImplDocument();
        }
        te.setDocumentNumber(releasedOrImplDocument.getNumber());
        te.setTitle(task.getDocumentVersion().getName());
        String content = releasedOrImplDocument.getContent();
        te.setSubTitle(TapestryI18nHelper.getLocalizedString(content));
        te.setSubGroup(task.getObjectPlanner().getObject().getCode());
        te.setSubGroupDetails(task.getObjectPlanner().getObject().getName());
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setSampleControlReview(false);
        te.setUploaded(task.getDocumentVersion().getUploaded());
        te.setUploadedFilterString(dateFormat.format(te.getUploaded()));
        te.setDoneDate(task.getDoneDate().getTime());
        te.setDoneDateFilterString(dateFormat.format(task.getDoneDate().getTime()));
        te.setLateTask(false);
        te.setOwnLateTask(false);
        te.setMainParticipant(isMainParticipantTask);
        te.setActiveObjectPlannerReleaseId(this.getActiveObjectPlannerReleaseId(task.getDocumentVersion().getDocument()));
        te.setDocumentId(task.getDocumentVersion().getDocument().getId());
        te.setDocumentVersionId(task.getDocumentVersion().getId());
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    private TaskTO processReviewCyclePlottTaskDone(ReviewCyclePlottTaskDone task, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setType(8);
        te.setId(task.getId());
        te.setName(task.getDisplayName());
        te.setDocumentNumber(task.getDocumentVersion().getDocument().getNumber());
        te.setTitle("");
        te.setSubTitle("");
        te.setSubGroup("");
        te.setSubGroupDetails("");
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setSampleControlReview(false);
        te.setUploaded(null);
        te.setLateTask(false);
        te.setOwnLateTask(false);
        te.setDoneDate(task.getDoneDate().getTime());
        te.setDoneDateFilterString(dateFormat.format(task.getDoneDate().getTime()));
        te.setDiff(19999);
        te.setTaskDelay(19999);
        te.setReviewCycleDelay(19999);
        te.setPlotOrderJobNumber("" + task.getOrder().getJobNumber());
        te.setMainParticipant(isMainParticipantTask);
        te.setDocumentId(task.getDocumentVersion().getDocument().getId());
        te.setDocumentVersionId(task.getDocumentVersion().getId());
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    private TaskTO processPlotOrderAcceptanceTaskDone(PlotOrderAcceptanceTaskDone task, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setType(11);
        te.setId(task.getId());
        te.setName(task.getDisplayName());
        te.setDocumentNumber(task.getDocumentVersion().getDocument().getNumber());
        te.setTitle("");
        te.setSubTitle("");
        te.setSubGroup("");
        te.setSubGroupDetails("");
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setDoneDate(task.getDoneDate().getTime());
        te.setDoneDateFilterString(dateFormat.format(task.getDoneDate().getTime()));
        te.setSampleControlReview(false);
        te.setUploaded(null);
        te.setLateTask(false);
        te.setOwnLateTask(false);
        te.setPlotOrderJobNumber("" + task.getOrder().getJobNumber());
        te.setDiff(1999);
        te.setMainParticipant(isMainParticipantTask);
        te.setActiveObjectPlannerReleaseId(this.getActiveObjectPlannerReleaseId(task.getDocumentVersion().getDocument()));
        te.setDocumentId(task.getDocumentVersion().getDocument().getId());
        te.setDocumentVersionId(task.getDocumentVersion().getId());
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    private TaskTO processOriginalDocumentTaskDone(OriginalDocumentTaskDone task, boolean isMainParticipantTask, I18n i18n, boolean isOOOMode) {
        TaskTO te = new TaskTO();
        te.setType(9);
        te.setId(task.getId());
        te.setName(task.getDisplayName());
        Document releasedOrImplDocument = task.getDocumentVersion().getDocument();
        if (releasedOrImplDocument instanceof DocumentImpl) {
            releasedOrImplDocument = ((DocumentImpl)releasedOrImplDocument).getLastReleasedOrImplDocument();
        }
        te.setDocumentNumber(releasedOrImplDocument.getNumber());
        te.setTitle(task.getDocumentVersion().getName());
        String content = releasedOrImplDocument.getContent();
        te.setSubTitle(TapestryI18nHelper.getLocalizedString(content));
        te.setSubGroup(task.getObjectPlanner().getObject().getCode());
        te.setSubGroupDetails(task.getObjectPlanner().getObject().getName());
        te.setProjectId(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getId());
        te.setGroup(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getCode());
        te.setGroupDetails(task.getObjectPlanner().getObject().getObjectList().getSubProject().getProject().getName());
        te.setProjectParticipationId(task.getProjectParticipationId());
        te.setDoneDate(task.getDoneDate().getTime());
        te.setDoneDateFilterString(dateFormat.format(task.getDoneDate().getTime()));
        te.setSampleControlReview(false);
        te.setUploaded(null);
        te.setDiff(20000);
        te.setTaskDelay(20000);
        te.setReviewCycleDelay(20000);
        te.setLateTask(false);
        te.setOwnLateTask(false);
        te.setMainParticipant(isMainParticipantTask);
        te.setActiveObjectPlannerReleaseId(this.getActiveObjectPlannerReleaseId(task.getDocumentVersion().getDocument()));
        te.setDocumentId(task.getDocumentVersion().getDocument().getId());
        te.setDocumentVersionId(task.getDocumentVersion().getId());
        ProjectParticipation pp = this.projectOperations.getProjectParticipation(task.getProjectParticipationId());
        te.setMainParticipantCommonName(pp.getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName());
        if (isOOOMode) {
            te.setObjectPlannerNameOOo(task.getObjectPlanner().getCode() + " " + task.getObjectPlanner().getArea());
            te.setReviewCycleInstanceNameOOo(TapestryI18nHelper.getLocalizedString(task.getObjectPlanner().getReviewCycleInstance().getName()));
        }
        return te;
    }

    public boolean isOwnSignatureFolderTask(ReviewableTask task, Integer orgPersonId) {
        if (!task.isTaskInSignatureFolder()) {
            return false;
        }
        Iterator posIt = task.getReviewCyclePositionReleases().values().iterator();
        ReviewCycleNodeResult reviewCycleNodeResult = this.reviewOperations.getReviewCycleNodeResult(task.getDocumentVersion().getActualReviewCycleNode(), task.getDocumentVersion());
        while (posIt.hasNext()) {
            ReviewCyclePosition pos = (ReviewCyclePosition)posIt.next();
            ReviewCyclePositionResult positionResult = this.reviewOperations.getReviewCyclePositionResult2(pos, task.getDocumentVersion(), reviewCycleNodeResult.getId());
            if (positionResult == null || !positionResult.getProjectParticipant().getOrganisationPerson().getId().equals(orgPersonId)) continue;
            return true;
        }
        return false;
    }

    private void evalSignatureFolderPositions(ReviewableTask task, TaskTO te, I18n i18n) {
        Iterator posIt = task.getReviewCyclePositionReleases().values().iterator();
        ReviewCycleNodeResult reviewCycleNodeResult = this.reviewOperations.getReviewCycleNodeResult(task.getDocumentVersion().getActualReviewCycleNode(), task.getDocumentVersion());
        String resultString = "";
        String reviewComment = "";
        Date reviewed = null;
        while (posIt.hasNext()) {
            ReviewCyclePosition pos = (ReviewCyclePosition)posIt.next();
            ReviewCyclePositionResult positionResult = this.reviewOperations.getReviewCyclePositionResult2(pos, task.getDocumentVersion(), reviewCycleNodeResult.getId());
            if (positionResult == null) continue;
            reviewed = positionResult.getResultDate();
            if (!reviewComment.isEmpty()) {
                reviewComment = reviewComment + "\n\n";
            }
            reviewComment = reviewComment + (positionResult.getComment() != null ? positionResult.getComment() : "");
            if (positionResult.getReviewCycleResultOption() == null) continue;
            if (positionResult.getReviewCycleResultOption().isFinishCell()) {
                resultString = resultString + "<span style='color:red;'>";
            }
            String realm = (positionResult.getRealm().getCode() != null && !positionResult.getRealm().getCode().isEmpty() ? positionResult.getRealm().getCode() + " " : "") + (positionResult.getRealm().getName() != null ? TapestryI18nHelper.getLocalizedString(positionResult.getRealm().getName()) : "");
            resultString = resultString + "<strong>" + realm + ":</strong> ";
            resultString = resultString + TapestryI18nHelper.getLocalizedString(positionResult.getReviewCycleResultOption().getName());
            te.getReviewResultsOOo().add(new Object[]{realm, TapestryI18nHelper.getLocalizedString(positionResult.getReviewCycleResultOption().getName()), new Boolean(positionResult.getReviewCycleResultOption().isFinishCell())});
            if (positionResult.getReviewCycleResultOption() != null && positionResult.getReviewCycleResultOption().isFinishCell()) {
                resultString = resultString + "</span>";
            }
            if (!posIt.hasNext()) continue;
            resultString = resultString + "<br/>";
        }
        te.setReviewed(reviewed);
        te.setReviewedFilterString(reviewed != null ? dateFormat.format(reviewed) : "");
        te.setReviewComment(reviewComment);
        te.setReviewResult(resultString);
    }

    private void evalPositionResults(ReviewableTaskDone task, TaskTO te, I18n i18n) {
        Iterator posResIt = null;
        if (task instanceof ReviewTaskDone) {
            posResIt = ((ReviewTaskDone)task).getReviewCyclePositionResults().values().iterator();
        } else if (task instanceof AttachedReviewTaskDone) {
            posResIt = ((AttachedReviewTaskDone)task).getReviewCyclePositionResults().values().iterator();
        } else {
            return;
        }
        String resultString = "";
        while (posResIt.hasNext()) {
            ReviewCyclePositionResult positionResult = (ReviewCyclePositionResult)posResIt.next();
            if (positionResult.getReviewCycleResultOption() == null) continue;
            if (positionResult.getReviewCycleResultOption().isFinishCell()) {
                resultString = resultString + "<span style='color:red;'>";
            }
            String realm = (positionResult.getRealm().getCode() != null && !positionResult.getRealm().getCode().isEmpty() ? positionResult.getRealm().getCode() + " " : "") + (positionResult.getRealm().getName() != null ? TapestryI18nHelper.getLocalizedString(positionResult.getRealm().getName()) : "");
            resultString = resultString + "<strong>" + realm + ":</strong> ";
            resultString = resultString + TapestryI18nHelper.getLocalizedString(positionResult.getReviewCycleResultOption().getName());
            te.getReviewResultsOOo().add(new Object[]{realm, TapestryI18nHelper.getLocalizedString(positionResult.getReviewCycleResultOption().getName()), new Boolean(positionResult.getReviewCycleResultOption().isFinishCell())});
            if (positionResult.getReviewCycleResultOption().isFinishCell()) {
                resultString = resultString + "</span>";
            }
            if (!posResIt.hasNext()) continue;
            resultString = resultString + "<br/>";
        }
        te.setDoneResult(resultString);
        if (task.getDoneDate() != null) {
            te.setDoneDate(task.getDoneDate().getTime());
            te.setDoneDateFilterString(dateFormat.format(task.getDoneDate().getTime()));
        }
    }

    private Integer getActiveObjectPlannerReleaseId(Document doc) {
        Integer objectPlannerImplId = doc.getObjectPlanner().getId();
        ReleasedObjectPlanner activeReleasedObjectPlanner = this.objectOperations.getActiveReleasedObjectPlanner(objectPlannerImplId);
        return activeReleasedObjectPlanner != null ? activeReleasedObjectPlanner.getId() : null;
    }

    public void setObjectOperations(ObjectOperations objectOperations) {
        this.objectOperations = objectOperations;
    }

    public void setProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }

    public void setReviewCycleStatusText(TaskTO te, I18n i18n, int diff, Date endDate, boolean isContractual, boolean isOOOMode) {
        String statusText = "";
        if (!isOOOMode) {
            statusText = statusText + "<b>";
        }
        statusText = diff < -1 ? statusText + String.format(i18n.tr("in %s Tagen"), diff * -1) : (diff == 0 ? statusText + i18n.tr("heute") : (diff == -1 ? statusText + i18n.tr("in 1 Tag") : (diff == 1 ? statusText + i18n.tr("1 Tag versp\u00e4tet") : statusText + String.format(i18n.tr("%s Tage versp\u00e4tet"), diff))));
        if (!isOOOMode) {
            statusText = statusText + "</b>";
        }
        if (isOOOMode) {
            te.setReviewCycleStatusTextOOo(statusText);
        }
        if (endDate != null) {
            if (!isOOOMode) {
                statusText = statusText + "<br><small>(" + (isContractual ? i18n.tr("vereinbarter Termin") : i18n.tr("berechneter Termin")) + ": " + dateFormat.format(endDate) + ")</small>";
            } else {
                statusText = statusText + "<text:line-break/>" + (isContractual ? i18n.tr("vereinbarter Termin") : i18n.tr("berechneter Termin")) + ": " + dateFormat.format(endDate);
                te.setReviewCycleStatusDeadlineOOo(endDate);
            }
        }
        te.setReviewCycleStatusText(statusText);
    }

    public void setTaskStatusText(TaskTO te, I18n i18n, int diff, Date endDate, boolean isOOOMode, boolean isInSignatureFolder) {
        String statusText = "";
        if (!isOOOMode) {
            statusText = statusText + "<b>";
        }
        statusText = diff < -1 ? statusText + String.format(i18n.tr("in %s Tagen"), diff * -1) : (diff == 0 ? statusText + i18n.tr("heute") : (diff == -1 ? statusText + i18n.tr("in 1 Tag") : (diff == 1 ? statusText + i18n.tr("1 Tag versp\u00e4tet") : statusText + String.format(i18n.tr("%s Tage versp\u00e4tet"), diff))));
        if (isOOOMode) {
            if (isInSignatureFolder && endDate == null) {
                statusText = statusText + i18n.tr(" (in Signaturmappe)");
            }
            te.setTaskStatusTextOOo("" + statusText);
        }
        if (!isOOOMode) {
            statusText = statusText + "</b>";
        }
        if (endDate != null) {
            if (!isOOOMode) {
                statusText = statusText + "<br><small>(" + i18n.tr("Termin") + ": " + dateFormat.format(endDate) + ")</small>";
                if (isInSignatureFolder) {
                    statusText = statusText + "<br/><b><small>" + i18n.tr("in Signaturmappe") + "</small></b>";
                }
            } else {
                statusText = statusText + "<text:line-break/>" + i18n.tr("Termin") + ": " + dateFormat.format(endDate);
                if (isInSignatureFolder) {
                    statusText = statusText + "<text:line-break/>" + i18n.tr("(in Signaturmappe)");
                }
                te.setTaskStatusDeadlineOOo(endDate);
            }
        }
        te.setTaskStatusText(statusText);
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }
}

