/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.schema;

import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.file.FileFinder;
import at.cdes.db.FileFinderAware;
import at.cdes.db.SchemaUpdateSnippet;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;

public class SchemaUpdate_0_178
implements SchemaUpdateSnippet,
FileFinderAware {
    private FileFinder fileFinder;
    protected static final Logger logger = Logger.getLogger(SchemaUpdate_0_178.class);

    @Override
    public String getTargetVersion() {
        return "0.178";
    }

    @Override
    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    @Override
    public String getUpdateComment() {
        return "move DocumentRefs into folders and change filenames in order to avoid eventual file path problems";
    }

    @Override
    public void performUpdate(ISchemaEngine schemaEngine) throws SQLException {
        Statement select = schemaEngine.getConnection().createStatement();
        PreparedStatement update = schemaEngine.getConnection().prepareStatement("update document_reference set attachment_filename = ? where id = ?");
        ResultSet rs = select.executeQuery("select dr.id as docrefId, p.id as projectId, o.id as objectId, dr.attachment_filename as filename, dr.attachment_filetype as filetype from document_reference dr join document d on (d.id=dr.document_id) left join document_list dl on (dl.id=d.document_list_id) left join sub_project sp on (dl.sub_project_id=sp.id) left join project p on (sp.project_id=p.id) left join object_planner op on (op.id=d.object_planner_id) left join object o on (o.id=op.object_id) where dr.attachment_filename is not null");
        while (rs.next()) {
            int docrefId = rs.getInt("docrefId");
            int projectId = rs.getInt("projectId");
            int objectId = rs.getInt("objectId");
            String filename = rs.getString("filename");
            String filetype = rs.getString("filetype");
            logger.info((Object)("executed query: docrefId=[" + docrefId + "]; projectId=[" + projectId + "]; objectId=[" + objectId + "]; filename=[" + filename + "]; filetype=[" + filetype + "]"));
            String prPath = Integer.valueOf(projectId).toString() + File.separator + Integer.valueOf(objectId).toString() + File.separator;
            File dir = new File(this.fileFinder.getAbsoluteRepositoryFilepath(CDESFileRepository.DOCUMENTREFSREPOSITORY), prPath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String nf = prPath + Integer.valueOf(docrefId) + "-" + System.currentTimeMillis() + (filetype != null ? "." + filetype : "");
            try {
                File file = this.fileFinder.findFile(filename, CDESFileRepository.DOCUMENTREFSREPOSITORY);
                File nfile = this.fileFinder.buildFile(nf, CDESFileRepository.DOCUMENTREFSREPOSITORY);
                if (!file.renameTo(nfile)) {
                    logger.error((Object)("Cannot rename file [" + file + "] to [" + nfile + "]."));
                } else {
                    logger.info((Object)("Sucessfully moved DocumentRef attachment file from [" + filename + "] to [" + nf + "]."));
                }
            }
            catch (FileHandleException e) {
                logger.error((Object)("Document ref file [" + filename + "] does not exist."), (Throwable)e);
            }
            update.setString(1, nf);
            update.setInt(2, docrefId);
            update.executeUpdate();
        }
    }
}

