/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.order.plott;

import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.order.plott.PlottOrder;
import at.cdes.bo.data.order.plott.PlottOrderItem;
import at.cdes.bo.data.order.plott.PlottOrderTemplate;
import at.cdes.bo.data.order.plott.TemplatePropertyResolver;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.db.dao.OrderDAO;
import at.cdes.db.dao.ProjectParticipationDAO;
import java.io.Serializable;
import java.util.HashMap;

public class ManualPlotOrderTemplatePropertyResolver
implements TemplatePropertyResolver,
Serializable {
    private static final long serialVersionUID = 2L;
    private ProjectParticipationDAO projectParticipationDAO;
    private OrderDAO orderDAO;

    @Override
    public PlottOrder resolveProperties(DocumentVersion version, PlottOrder order, PlottOrderTemplate template, boolean onlyItems) {
        order.setOrderItems(new HashMap());
        order.setBillingAddress(this.orderDAO.getOrderAddress(template.getBillingAddressId()));
        order.setPlotter(this.projectParticipationDAO.get(template.getPlotterId()).getOrganisation());
        order.setTemplate(template);
        order.setProject(template.getProject());
        order.setKindOfDelivery(template.getKindOfDelivery());
        return order;
    }

    private PlottOrder resolvePropertiesInner(DocumentVersion version, PlottOrder order, PlottOrderTemplate template) {
        return order;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setOrderDAO(OrderDAO orderDAO) {
        this.orderDAO = orderDAO;
    }

    public ProjectParticipation resolveProjectParticipation(Integer receiverId) {
        return this.projectParticipationDAO.get(receiverId);
    }

    @Override
    public PlottOrderItem resolvePlottOrderItem(Integer orderItemId) {
        if (orderItemId == null) {
            return null;
        }
        return this.orderDAO.getPlottOrderItem(orderItemId);
    }

    @Override
    public String getName() {
        return "ManualPlotTemplate";
    }
}

