/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.cycle;

import at.cdes.bo.cycle.EvaluationException;
import at.cdes.bo.cycle.ReviewCycleCellConnectionEvaluator;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnection;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellResult;
import at.cdes.bo.data.cycle.cell.ReviewCycleEntryCondition;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.log4j.Logger;

public class OgnlConnectionEvaluator
implements ReviewCycleCellConnectionEvaluator {
    static Logger logger = Logger.getLogger(OgnlConnectionEvaluator.class);

    @Override
    public boolean evaluateConnection(ReviewCycleCellResult result, ReviewCycleCellConnection connection) throws EvaluationException {
        Object expression;
        String rule = connection.getRule();
        try {
            expression = Ognl.parseExpression(rule);
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL parse error in expression [" + rule + "]: " + e));
            throw new EvaluationException("Parse Exception", e);
        }
        OgnlContext context = new OgnlContext();
        context.put("sourceResult", result);
        context.put("documentVersion", result.getDocumentVersion());
        context.put("connection", connection);
        context.put("sourceCell", connection.getSourceCell());
        context.put("destinationCell", connection.getDestinationCell());
        try {
            Object res = Ognl.getValue(expression, (Map)context, (Object)context);
            if (res == null) {
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OGNL evaluation: expression [" + rule + "], res [" + res + "]."));
            }
            return Boolean.parseBoolean(String.valueOf(res));
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL evaluation error in expression [" + rule + "]: " + e));
            throw new EvaluationException("Evaluate Exception", e);
        }
    }

    @Override
    public boolean evaluateEntryCondition(ReviewCycleEntryCondition entryCondition) throws EvaluationException {
        Object expression;
        String rule = entryCondition.getRule();
        try {
            expression = Ognl.parseExpression(rule);
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL parse error in expression [" + rule + "]: " + e));
            throw new EvaluationException("Parse Exception", e);
        }
        OgnlContext context = new OgnlContext();
        try {
            Object res = Ognl.getValue(expression, (Map)context, (Object)context);
            if (res == null) {
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OGNL evaluation: expression [" + rule + "], res [" + res + "]."));
            }
            return Boolean.parseBoolean(String.valueOf(res));
        }
        catch (OgnlException e) {
            logger.error((Object)("OGNL evaluation error in expression [" + rule + "]: " + e));
            throw new EvaluationException("Evaluate Exception", e);
        }
    }
}

