/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.data.certificate;

import at.cdes.bo.data.certificate.CDESCertificate;
import java.io.Serializable;
import java.util.Date;

public class CDESCertificateTO
implements Serializable {
    private static final long serialVersionUID = -4956940719575066062L;
    private Integer id;
    private boolean maySign;
    private Date validFrom;
    private Date validTo;
    private String organisationName;
    private String createdBy;

    public CDESCertificateTO() {
    }

    public CDESCertificateTO(CDESCertificate cert) {
        this.id = cert.getId();
        this.maySign = cert.isMaySign();
        this.validFrom = cert.getValidFrom();
        this.validTo = cert.getValidTo();
        this.organisationName = cert.getOrganisationPerson().getOrganisation().getName();
        this.createdBy = cert.getCreatedBy().getPerson().getCommonName();
        if (cert.getCertificateAuthority() != null && cert.getCertificateAuthority().getNetwork() != null) {
            this.createdBy = this.createdBy + " [" + cert.getCertificateAuthority().getNetwork().getName() + "]";
        }
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public boolean isMaySign() {
        return this.maySign;
    }

    public void setMaySign(boolean maySign) {
        this.maySign = maySign;
    }

    public Date getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.validFrom = validFrom;
    }

    public Date getValidTo() {
        return this.validTo;
    }

    public void setValidTo(Date validTo) {
        this.validTo = validTo;
    }

    public String getOrganisationName() {
        return this.organisationName;
    }

    public void setOrganisationName(String organisationName) {
        this.organisationName = organisationName;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }
}

