/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.controller.actionhandler;

import at.cdes.api.document.NumberCalculatorException;
import at.cdes.bo.data.attachment.Attachment;
import at.cdes.bo.data.cycle.AttachedReviewCyclePositionImpl;
import at.cdes.bo.data.cycle.Realm;
import at.cdes.bo.data.cycle.ReviewCycle;
import at.cdes.bo.data.cycle.ReviewCycleInstance;
import at.cdes.bo.data.cycle.ReviewCycleInstanceImpl;
import at.cdes.bo.data.cycle.ReviewCycleInstanceRelease;
import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.ReviewCyclePositionComparator;
import at.cdes.bo.data.cycle.ReviewCyclePositionImpl;
import at.cdes.bo.data.cycle.ReviewCyclePositionRelease;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.ReviewCyclePositionType;
import at.cdes.bo.data.cycle.cell.ReviewCycleCell;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnection;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceImpl;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeInstanceListener;
import at.cdes.bo.data.cycle.node.listener.ReviewCycleNodeListener;
import at.cdes.bo.data.document.Document;
import at.cdes.bo.data.document.DocumentListImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.localisation.Localisation;
import at.cdes.bo.data.mail.NodeListenerEMailSnippet;
import at.cdes.bo.data.mail.StatusEMailSnippet;
import at.cdes.bo.data.mail.TaskFutureEMail;
import at.cdes.bo.data.network.Network;
import at.cdes.bo.data.notification.ReviewCycleNodeInstanceNotification;
import at.cdes.bo.data.number.DocumentNumberPartGroup;
import at.cdes.bo.data.object.CDESObjectImpl;
import at.cdes.bo.data.object.ObjectListImpl;
import at.cdes.bo.data.object.ObjectPlanner;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ObjectPlannerPosition;
import at.cdes.bo.data.object.ObjectPlannerPositionImpl;
import at.cdes.bo.data.object.PersonObjectPlannerPositionAssignmentComparator;
import at.cdes.bo.data.object.ReleasedCDESObject;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.object.ReleasedObjectPlannerPosition;
import at.cdes.bo.data.order.OrderStep;
import at.cdes.bo.data.order.orig.OriginalDocumentOrder;
import at.cdes.bo.data.order.plott.PlottOrder;
import at.cdes.bo.data.order.plott.PlottOrderItem;
import at.cdes.bo.data.order.plott.PlottOrderItemTemplate;
import at.cdes.bo.data.order.plott.PlottOrderTemplate;
import at.cdes.bo.data.order.plott.ReviewCycleNodeInstancePlottOrderListener;
import at.cdes.bo.data.organisation.Organisation;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.person.Person;
import at.cdes.bo.data.person.PersonObjectPlannerPositionAssignmentDTO;
import at.cdes.bo.data.person.PersonProjectParticipationAssignmentDTO;
import at.cdes.bo.data.person.PersonReviewCycleInstanceAssignmentContainer;
import at.cdes.bo.data.person.PersonReviewCycleInstanceAssignmentDTO;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.ProjectConfig;
import at.cdes.bo.data.project.ProjectExport;
import at.cdes.bo.data.project.ProjectHoliday;
import at.cdes.bo.data.project.ProjectParticipant;
import at.cdes.bo.data.project.ProjectParticipantDateHistoryPart;
import at.cdes.bo.data.project.ProjectParticipation;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.data.project.SubProjectComparator;
import at.cdes.bo.data.project.SubProjectDTO;
import at.cdes.bo.data.project.SubProjectType;
import at.cdes.bo.data.review.ReviewCycleObjectPlannerAssignmentDTO;
import at.cdes.bo.data.role.ActionRule;
import at.cdes.bo.data.role.Role;
import at.cdes.bo.data.role.RoleType;
import at.cdes.bo.data.task.AttachedReviewTask;
import at.cdes.bo.data.task.OriginalDocumentTask;
import at.cdes.bo.data.task.PlotOrderAcceptanceTask;
import at.cdes.bo.data.task.ReviewCycleEntryTask;
import at.cdes.bo.data.task.ReviewCyclePlottTask;
import at.cdes.bo.data.task.ReviewTask;
import at.cdes.bo.data.task.SelectCellConnectionTask;
import at.cdes.bo.data.task.Task;
import at.cdes.bo.data.task.TaskBase;
import at.cdes.bo.data.workflow.WorkflowActivityPositionResult;
import at.cdes.bo.data.workflow.WorkflowNodePosition;
import at.cdes.bo.role.RoleMap;
import at.cdes.bo.role.RoleMapEntry;
import at.cdes.controller.apiHelper.SubProjectCopyContainer;
import at.cdes.controller.helper.CdesDTOHelper;
import at.cdes.db.dao.ActionDAO;
import at.cdes.db.dao.AttachmentDAO;
import at.cdes.db.dao.DigestCalculatorDAO;
import at.cdes.db.dao.DocumentListDAO;
import at.cdes.db.dao.DocumentNumberPartDAO;
import at.cdes.db.dao.EMailDAO;
import at.cdes.db.dao.LabelDAO;
import at.cdes.db.dao.LocalisationDAO;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.ObjectListDAO;
import at.cdes.db.dao.OrderDAO;
import at.cdes.db.dao.OrganisationPersonDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.ProjectParticipantDAO;
import at.cdes.db.dao.ProjectParticipationDAO;
import at.cdes.db.dao.RealmDAO;
import at.cdes.db.dao.ReviewCyclePositionDAO;
import at.cdes.db.dao.RoleDAO;
import at.cdes.db.dao.SubProjectDAO;
import at.cdes.db.dao.SubProjectTypeDAO;
import at.cdes.db.dao.TaskDAO;
import at.cdes.db.dao.WorkflowActivityDAO;
import at.cdes.db.dao.WorkflowNodePositionDAO;
import at.cdes.db.dao.WorkflowTokenDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.oldGwtDto.NetworkDTO;
import at.cdes.oldGwtDto.PlanningNotificationDTO;
import at.cdes.oldGwtDto.ProjectDTO;
import at.cdes.service.MailOperations;
import at.cdes.service.ObjectOperations;
import at.cdes.service.OrderOperations;
import at.cdes.service.PlanDeliverCatalogueOperations;
import at.cdes.service.ProjectOperations;
import at.cdes.service.ReviewCycleOperations;
import at.cdes.service.ReviewOperations;
import at.cdes.service.RoleOperations;
import at.cdes.service.TaskOperations;
import at.cdes.service.exception.ActionException;
import at.cdes.util.ImplContextHelper;
import at.cdes.util.TapestryI18nHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.xnap.commons.i18n.I18n;

public class ProjectOperationsImpl
implements ProjectOperations {
    private ProjectDAO projectDAO;
    private SubProjectDAO subProjectDAO;
    private ObjectListDAO objectListDAO;
    private DocumentListDAO documentListDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private NetworkDAO networkDAO;
    private OrderOperations orderOperations;
    private RoleOperations roleOperations;
    private RoleDAO roleDAO;
    private TaskDAO taskDAO;
    private ActionDAO actionDAO;
    private AttachmentDAO attachmentDAO;
    private ObjectOperations objectOperations;
    private ReviewCycleOperations reviewCycleOperations;
    private ReviewOperations reviewOperations;
    private RealmDAO realmDAO;
    private OrderDAO orderDAO;
    private LabelDAO labelDAO;
    private EMailDAO mailDAO;
    private MailOperations mailOperations;
    private TaskOperations taskOperations;
    private ReviewCyclePositionDAO reviewCyclePositionDAO;
    private SubProjectTypeDAO subProjectTypeDAO;
    private PlanDeliverCatalogueOperations planDeliverCatalogueOperations;
    private LocalisationDAO locDAO;
    private DocumentNumberPartDAO documentNumberPartDAO;
    private WorkflowNodePositionDAO workflowNodePositionDAO;
    private WorkflowTokenDAO workflowTokenDAO;
    private WorkflowActivityDAO workflowActivityDAO;
    protected static final Logger logger = Logger.getLogger(ProjectOperationsImpl.class);
    private DigestCalculatorDAO digestCalculatorDAO;

    @Override
    public int countProjects() {
        return this.projectDAO.countProjects();
    }

    @Override
    public List getAllProjects(Integer networkId, Integer organisationPersonId, String filter, Integer projectStatus) {
        Integer organisationId = null;
        if (organisationPersonId != null) {
            organisationId = this.organisationPersonDAO.get(organisationPersonId).getOrganisation().getId();
        }
        return this.projectDAO.getAll(networkId, organisationId, filter, projectStatus);
    }

    @Override
    public List getAllProjectsByStatus(Integer networkId, Integer organisationPersonId, Integer status) {
        Integer organisationId = null;
        if (organisationPersonId != null) {
            organisationId = this.organisationPersonDAO.get(organisationPersonId).getOrganisation().getId();
        }
        return this.projectDAO.getAllProjectsByStatus(networkId, organisationId, status);
    }

    @Override
    public List getAllPersonalProjects(Integer networkId, Integer organisationPersonId, String filter) {
        return this.projectDAO.getAllPersonal(networkId, organisationPersonId, filter);
    }

    @Override
    public List getAllVisiblePersonalProjects(Integer networkId, Integer organisationPersonId, String filter) {
        return this.projectDAO.getAllVisiblePersonal(networkId, organisationPersonId, filter);
    }

    @Override
    public Project getProject(Integer projectId) {
        Project project = this.projectDAO.get(projectId);
        try {
            ProjectConfig projectConfig = project.getProjectConfig();
            if (projectConfig == null) {
                projectConfig = new ProjectConfig();
                project.setProjectConfig(projectConfig);
                this.projectDAO.save(projectConfig);
                project = this.projectDAO.save(project);
            }
            return project;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Project insertProject(Project project, OrganisationPerson projectAdmin, OrganisationPerson projectManager, Locale locale, boolean withoutRealms, int projectAdminRoleType, int projectManagerRoleType) {
        ProjectConfig projectConfig = project.getProjectConfig();
        if (projectConfig == null) {
            projectConfig = new ProjectConfig();
            project.setProjectConfig(projectConfig);
        }
        this.projectDAO.save(projectConfig);
        project = this.projectDAO.save(project);
        I18n i18n = I18nFactory.getI18n(locale);
        project.setProjectParticipations(new HashMap());
        ProjectParticipation part = new ProjectParticipation();
        part.setProject(project);
        List roles = this.roleDAO.getAll(project.getNetwork().getId(), projectAdminRoleType);
        if (roles == null || roles.size() == 0) {
            throw new ActionException(i18n.tr("Die Rolle Projektadministrator konnte nicht gefunden werden."));
        }
        part.setRole((Role)roles.get(0));
        part.setOrganisation(projectAdmin.getOrganisation());
        part = this.projectParticipationDAO.save(part);
        ProjectParticipant participant = new ProjectParticipant();
        participant.setCreated(new Date(System.currentTimeMillis()));
        participant.setMainParticipant(true);
        participant.setParticipation(part);
        participant.setOrganisationPerson(projectAdmin);
        this.projectParticipantDAO.save(participant);
        part.setProjectParticipants(new HashMap());
        part.getProjectParticipants().put(participant.getId(), participant);
        this.projectParticipationDAO.merge(part);
        project.getProjectParticipations().put(part.getId(), part);
        if (projectManager != null) {
            part = new ProjectParticipation();
            part.setProject(project);
            roles = this.roleDAO.getAll(project.getNetwork().getId(), projectManagerRoleType);
            if (roles == null || roles.size() == 0) {
                throw new ActionException(i18n.tr("Die Rolle Projektleiter konnte nicht gefunden werden."));
            }
            part.setRole((Role)roles.get(0));
            part.setOrganisation(projectManager.getOrganisation());
            part = this.projectParticipationDAO.save(part);
            participant = new ProjectParticipant();
            participant.setCreated(new Date(System.currentTimeMillis()));
            participant.setMainParticipant(true);
            participant.setParticipation(part);
            participant.setOrganisationPerson(projectManager);
            this.projectParticipantDAO.save(participant);
            part.setProjectParticipants(new HashMap());
            part.getProjectParticipants().put(participant.getId(), participant);
            this.projectParticipationDAO.merge(part);
            project.getProjectParticipations().put(part.getId(), part);
        }
        if (!withoutRealms) {
            this.copyRealmTemplatesToProject(project);
        }
        return this.projectDAO.update(project);
    }

    @Override
    public Project updateProject(Project project) {
        ProjectConfig projectConfig = project.getProjectConfig();
        if (projectConfig == null) {
            projectConfig = new ProjectConfig();
            project.setProjectConfig(projectConfig);
            this.projectDAO.save(projectConfig);
        } else if (projectConfig.getId() == null) {
            this.projectDAO.save(projectConfig);
        } else {
            this.projectDAO.update(projectConfig);
        }
        return this.projectDAO.update(project);
    }

    @Override
    public void copyRealmTemplatesToProject(Project project) {
        Network network = project.getNetwork();
        if (network.getReviewCycles() == null) {
            return;
        }
        Iterator it = network.getReviewCycles().values().iterator();
        while (it.hasNext()) {
            for (ReviewCycleCell cell : ((ReviewCycle)it.next()).getReviewCycleCellsSortedByPosition()) {
                List realms;
                ReviewCyclePositionType t;
                Iterator it3 = cell.getReviewCycleNodes().values().iterator();
                while (it3.hasNext()) {
                    t = ((ReviewCycleNode)it3.next()).getReviewCyclePositionType();
                    realms = this.realmDAO.getAllofProject(project.getId(), t.getId());
                    if (realms != null && !realms.isEmpty()) continue;
                    this.copyRealmTemplatesToProject(project, t);
                }
                it3 = cell.getFreeReviewCycleNodes().values().iterator();
                while (it3.hasNext()) {
                    t = ((ReviewCycleNode)it3.next()).getReviewCyclePositionType();
                    realms = this.realmDAO.getAllofProject(project.getId(), t.getId());
                    if (realms != null && !realms.isEmpty()) continue;
                    this.copyRealmTemplatesToProject(project, t);
                }
                Collection conns = cell.getLeavingConnections().values();
                for (ReviewCycleCellConnection connection : conns) {
                    List realms2;
                    if (connection.getReviewCyclePositionType() == null || (realms2 = this.realmDAO.getAllofProject(project.getId(), connection.getReviewCyclePositionType().getId())) != null && !realms2.isEmpty()) continue;
                    this.copyRealmTemplatesToProject(project, connection.getReviewCyclePositionType());
                }
            }
        }
    }

    private void copyRealmTemplatesToProject(Project project, ReviewCyclePositionType type) {
        List<Realm> realms = this.realmDAO.getTemplatesOfType(type.getId());
        if (realms == null) {
            return;
        }
        for (Realm templ : realms) {
            Realm realm = new Realm(templ);
            realm.setProject(project);
            realm.setValidFromDate(new Date(System.currentTimeMillis()));
            this.realmDAO.save(realm);
        }
    }

    @Override
    public void deleteProjectById(Integer projectId) {
        Project project = this.getProject(projectId);
        this.deleteProject(project);
    }

    @Override
    public void deleteProject(Project project) {
        boolean notDeletable = false;
        if (project.getSubProjects() != null) {
            for (SubProject sp : project.getSubProjects().values()) {
                if (sp.getActiveObjectList() != null) {
                    notDeletable = true;
                    continue;
                }
                this.deleteSubProjectById(sp.getId());
            }
        }
        if (!notDeletable) {
            Iterator<Object> it;
            List realms;
            if (project.getProjectParticipations() != null) {
                Iterator it2 = project.getProjectParticipations().values().iterator();
                while (it2.hasNext()) {
                    this.deleteProjectParticipation((ProjectParticipation)it2.next());
                }
            }
            if ((realms = this.reviewCycleOperations.getRealms(project.getId())) != null) {
                it = realms.iterator();
                while (it.hasNext()) {
                    this.reviewCycleOperations.deleteProjectRealm((Realm)it.next());
                }
            }
            if (project.getHolidays() != null) {
                it = project.getHolidays().values().iterator();
                while (it.hasNext()) {
                    this.deleteProjectHoliday((ProjectHoliday)it.next());
                }
            }
            ProjectConfig projectConfig = project.getProjectConfig();
            this.objectOperations.deleteObjectPlannerDefinitionByProject(project.getId());
            this.projectDAO.delete(project);
            if (projectConfig != null) {
                this.projectDAO.delete(projectConfig);
            }
        } else {
            project.setAccess(0);
            project.setStatus(6);
            this.projectDAO.update(project);
        }
    }

    @Override
    public void changeProjectsAccessMode(Project project, int newMode) {
        project.setAccess(newMode);
        this.projectDAO.update(project);
    }

    @Override
    public void deleteProjectHoliday(ProjectHoliday holiday) {
        this.projectDAO.delete(holiday);
    }

    @Override
    public ProjectHoliday getProjectHoliday(Integer id) {
        return this.projectDAO.getProjectHoliday(id);
    }

    @Override
    public List getAllSubProjects(Integer networkId, Integer organisationPersonId, boolean activeOnly) {
        List projects = this.projectDAO.getAll(networkId, organisationPersonId, null, null);
        Iterator it = projects.iterator();
        ArrayList subProjects = new ArrayList();
        while (it.hasNext()) {
            Project project = (Project)it.next();
            Integer projectId = project.getId();
            Iterator sIt = this.subProjectDAO.getAll(projectId, activeOnly).iterator();
            while (sIt.hasNext()) {
                subProjects.add(sIt.next());
            }
        }
        return subProjects;
    }

    @Override
    public SubProject getSubProject(Integer id) {
        return this.subProjectDAO.get(id);
    }

    @Override
    public SubProject insertSubProject(SubProject esubProject) {
        SubProject subProject = this.subProjectDAO.save(esubProject);
        ObjectListImpl objectList = new ObjectListImpl();
        objectList.setSubProject(subProject);
        objectList.setVersion(0);
        subProject.setEditObjectList(objectList);
        this.objectListDAO.save(objectList);
        DocumentListImpl documentList = new DocumentListImpl();
        documentList.setSubProject(subProject);
        documentList.setVersion(0);
        subProject.setEditDocumentList(documentList);
        this.documentListDAO.save(documentList);
        Project project = subProject.getProject();
        if (project.getSubProjects() == null) {
            project.setSubProjects(new HashMap());
        }
        project.getSubProjects().put(subProject.getId(), subProject);
        this.projectDAO.update(project);
        return subProject;
    }

    @Override
    public SubProject updateSubProject(SubProject subProject) {
        SubProject oldEntry = this.subProjectDAO.get(subProject.getId());
        subProject.setProject(oldEntry.getProject());
        subProject = this.subProjectDAO.update(subProject);
        Project project = subProject.getProject();
        if (project.getSubProjects() == null) {
            project.setSubProjects(new HashMap());
        }
        project.getSubProjects().put(subProject.getId(), subProject);
        this.projectDAO.update(project);
        return subProject;
    }

    @Override
    public void deleteSubProjectById(Integer subProjectId) {
        SubProject sp = this.subProjectDAO.get(subProjectId);
        this.planDeliverCatalogueOperations.deleteDocumentListByID(sp.getEditDocumentList().getId());
        this.objectOperations.deleteObjectListById(sp.getEditObjectList().getId());
        if (sp.getReviewCycleInstances() != null) {
            Iterator it = sp.getReviewCycleInstances().values().iterator();
            while (it.hasNext()) {
                this.reviewCycleOperations.deleteReviewCycleInstance((ReviewCycleInstanceImpl)it.next());
            }
        }
        ArrayList projectParticipations = new ArrayList(sp.getProject().getProjectParticipations().values());
        for (ProjectParticipation participation : projectParticipations) {
            if (participation.getExcludedSubProjects().containsKey(subProjectId)) {
                participation.getExcludedSubProjects().remove(subProjectId);
            }
            participation = this.projectParticipationDAO.update(participation);
        }
        this.subProjectDAO.delete(sp);
    }

    @Override
    public void changeSubProjectAccessMode(Integer subProjectId, boolean readOnly) {
        SubProject subProject = this.subProjectDAO.get(subProjectId);
        subProject.setReadOnly(readOnly);
        this.updateSubProject(subProject);
    }

    @Override
    public ProjectParticipation getProjectParticipation(Integer id) {
        return this.projectParticipationDAO.get(id);
    }

    @Override
    public ProjectParticipation insertProjectParticipation(ProjectParticipation participation, List participants, List subProjectRestrictionSelections, Integer organisationPersonId) {
        int i;
        HashMap<Integer, ProjectParticipant> participantsMap = new HashMap<Integer, ProjectParticipant>();
        HashMap<Integer, SubProject> subProjectExclusionsMap = new HashMap<Integer, SubProject>();
        participation = this.projectParticipationDAO.save(participation);
        for (i = 0; i < participants.size(); ++i) {
            ProjectParticipant participant = (ProjectParticipant)participants.get(i);
            participant.setOrganisationPerson(this.organisationPersonDAO.get(participant.getOrganisationPerson().getId()));
            participant.setParticipation(participation);
            participant.setCreated(new Date(System.currentTimeMillis()));
            this.projectParticipantDAO.save(participant);
            participantsMap.put(participant.getId(), participant);
            ProjectParticipantDateHistoryPart hist = new ProjectParticipantDateHistoryPart();
            hist.setProjectParticipant(participant);
            hist.setStartDate(new Date(System.currentTimeMillis()));
            OrganisationPerson orgPerson = this.organisationPersonDAO.get(organisationPersonId);
            hist.setOrganisationPerson(orgPerson);
            hist.setEditDate(new Date(System.currentTimeMillis()));
            this.projectParticipantDAO.save(hist);
        }
        if (subProjectRestrictionSelections != null) {
            for (i = 0; i < subProjectRestrictionSelections.size(); ++i) {
                SubProject subProject = (SubProject)subProjectRestrictionSelections.get(i);
                subProjectExclusionsMap.put(subProject.getId(), subProject);
            }
        }
        if (participation.getRole().getType() != null && participation.getRole().getType().getType() == 2 && participation.getRole().hasAction("monitorLateReviews")) {
            this.createFutureEmails(participation);
        }
        participation.setProjectParticipants(participantsMap);
        participation.setExcludedSubProjects(subProjectExclusionsMap);
        participation = this.projectParticipationDAO.merge(participation);
        return participation;
    }

    private void createFutureEmails(ProjectParticipation participation) {
        Project project = participation.getProject();
        Calendar deadline = Calendar.getInstance();
        ArrayList allTasksOfProject = new ArrayList();
        allTasksOfProject.addAll(this.taskDAO.getAllLateReviewTasks(deadline, project.getId()));
        allTasksOfProject.addAll(this.taskDAO.getAllLateUploadTasks(deadline, project.getId()));
        for (Task task : allTasksOfProject) {
            Collection<TaskFutureEMail> futureMailsOfTask = this.mailDAO.getFutureMailsOfTask(task.getId());
            for (TaskFutureEMail femail : futureMailsOfTask) {
                if (femail.getType() != -2 || !femail.getParticipationId().equals(participation.getId())) continue;
                this.mailDAO.deleteFutureEMail(femail);
            }
            this.mailOperations.createLateTaskFutureEmail(participation, task);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ProjectParticipation updateProjectParticipation(ProjectParticipation participation, ProjectParticipant mainParticipant, List<ProjectParticipant> insert, List<ProjectParticipant> delete, List<SubProject> subProjectRestrictionSelections, List<SubProject> subProjectRestrictionDeletes, Integer originalRoleTypeId, Locale locale, Integer organisationPersonId) {
        I18n i18n = I18nFactory.getI18n(locale);
        ProjectParticipation oldParticipation = this.projectParticipationDAO.get(participation.getId());
        boolean isSurveillant = participation.getRole().getType().getType() == 2 && participation.getRole().hasAction("monitorLateReviews");
        Object oldMainParticipantId = null;
        boolean newMainParticipantWasProxyParticipant = false;
        HashMap<Integer, OrganisationPerson> organisationPersonsForLateTaskEmails = new HashMap<Integer, OrganisationPerson>();
        oldParticipation.setComment(participation.getComment());
        oldParticipation.setProject(participation.getProject());
        oldParticipation.setRole(participation.getRole());
        oldParticipation.setMailReciever(participation.isMailReciever());
        oldParticipation.setCustomerId(participation.getCustomerId());
        oldParticipation.setOrganisation(participation.getOrganisation());
        oldParticipation.setAttachmentEmailAddress(participation.getAttachmentEmailAddress());
        Map oldEntries = oldParticipation.getProjectParticipants();
        ProjectParticipant oldMainParticipant = oldParticipation.getMainParticipant();
        ArrayList<Object> removed = new ArrayList<Object>();
        if (insert != null) {
            removed.addAll(oldEntries.keySet());
            removed.addAll(oldParticipation.getInvalidProjectParticipants().keySet());
        } else {
            for (ProjectParticipant toDelete : delete) {
                removed.add(toDelete.getId());
            }
        }
        ArrayList oldParticipants = new ArrayList(oldParticipation.getProjectParticipants().values());
        boolean mainParticipantChanged = false;
        if (!(mainParticipant == null || oldMainParticipant != null && oldMainParticipant.getOrganisationPerson().getId().equals(mainParticipant.getOrganisationPerson().getId()))) {
            if (isSurveillant) {
                for (ProjectParticipant projectParticipant : oldParticipants) {
                    if (!projectParticipant.getOrganisationPerson().getId().equals(mainParticipant.getOrganisationPerson().getId())) continue;
                    newMainParticipantWasProxyParticipant = true;
                    break;
                }
                if (!newMainParticipantWasProxyParticipant) {
                    organisationPersonsForLateTaskEmails.put(mainParticipant.getOrganisationPerson().getId(), mainParticipant.getOrganisationPerson());
                }
            }
            if (oldMainParticipant != null) {
                oldMainParticipant.setInactive(true);
                this.projectParticipantDAO.update(oldMainParticipant);
                mainParticipantChanged = true;
                oldEntries.remove(oldMainParticipant.getId());
            }
            mainParticipant.setMainParticipant(true);
            if (insert == null) {
                insert = new ArrayList<ProjectParticipant>();
            }
            insert.add(mainParticipant);
        } else {
            removed.remove(oldMainParticipant.getId());
        }
        participation = oldParticipation;
        if (insert != null) {
            for (ProjectParticipant projectParticipant : insert) {
                if (!(oldEntries.containsKey(projectParticipant.getId()) || mainParticipant.getOrganisationPerson().getId().equals(projectParticipant.getOrganisationPerson().getId()) && !mainParticipantChanged)) {
                    void var22_28;
                    if (isSurveillant) {
                        boolean orgPersonWasParticipantBefore = false;
                        for (ProjectParticipant oldPart : oldParticipants) {
                            if (oldPart.isInactive() || !oldPart.getOrganisationPerson().getId().equals(projectParticipant.getOrganisationPerson().getId())) continue;
                            orgPersonWasParticipantBefore = true;
                            break;
                        }
                        if (!orgPersonWasParticipantBefore) {
                            organisationPersonsForLateTaskEmails.put(projectParticipant.getOrganisationPerson().getId(), projectParticipant.getOrganisationPerson());
                        }
                    }
                    projectParticipant.setOrganisationPerson(this.organisationPersonDAO.get(projectParticipant.getOrganisationPerson().getId()));
                    projectParticipant.setParticipation(participation);
                    if (projectParticipant.getId() != null && projectParticipant.isInactive()) {
                        ProjectParticipant projectParticipant2 = this.projectParticipantDAO.update(projectParticipant);
                    } else {
                        projectParticipant.setCreated(new Date(System.currentTimeMillis()));
                        ProjectParticipant projectParticipant3 = this.projectParticipantDAO.save(projectParticipant);
                    }
                    ProjectParticipantDateHistoryPart hist = new ProjectParticipantDateHistoryPart();
                    hist.setProjectParticipant((ProjectParticipant)var22_28);
                    hist.setStartDate(new Date(System.currentTimeMillis()));
                    OrganisationPerson orgPerson = this.organisationPersonDAO.get(organisationPersonId);
                    hist.setOrganisationPerson(orgPerson);
                    hist.setEditDate(new Date(System.currentTimeMillis()));
                    this.projectParticipantDAO.save(hist);
                    var22_28.setInactive(false);
                    this.projectParticipantDAO.update((ProjectParticipant)var22_28);
                    participation.getProjectParticipants().put(var22_28.getId(), var22_28);
                    removed.remove(var22_28.getId());
                    continue;
                }
                removed.remove(projectParticipant.getId());
            }
        }
        for (Integer n : removed) {
            ProjectParticipant participant = this.projectParticipantDAO.get(n);
            if (participation.getInvalidProjectParticipants() == null || participation.getInvalidProjectParticipants().containsKey(n)) continue;
            participant.setInactive(true);
            if (participant.isMainParticipant()) {
                participant.setInactiveComment("durch neuen Verantwortlichen ersetzt.");
            } else {
                participant.setInactiveComment("ausgetragen");
            }
            ProjectParticipantDateHistoryPart hist = participant.getLastDateHistoryPart();
            if (hist == null) {
                hist = new ProjectParticipantDateHistoryPart();
                hist.setProjectParticipant(participant);
                this.projectParticipantDAO.save(hist);
            }
            hist.setEndDate(new Date(System.currentTimeMillis()));
            OrganisationPerson orgPerson = this.organisationPersonDAO.get(organisationPersonId);
            hist.setOrganisationPerson(orgPerson);
            hist.setEditDate(new Date(System.currentTimeMillis()));
            this.projectParticipantDAO.update(hist);
            participation.getProjectParticipants().remove(participant.getId());
            if (participation.getInvalidProjectParticipants() == null) {
                participation.setInvalidProjectParticipants(new HashMap());
            }
            participation.getInvalidProjectParticipants().put(participant.getId(), participant);
            this.projectParticipantDAO.update(participant);
        }
        participation = this.projectParticipationDAO.merge(participation);
        if (subProjectRestrictionSelections != null) {
            for (SubProject subProject : subProjectRestrictionSelections) {
                participation.getExcludedSubProjects().put(subProject.getId(), subProject);
            }
        }
        if (subProjectRestrictionDeletes != null) {
            for (SubProject subProject : subProjectRestrictionDeletes) {
                participation.getExcludedSubProjects().remove(subProject.getId());
            }
        }
        participation = this.projectParticipationDAO.update(participation);
        RoleType originalRoleType = null;
        if (originalRoleTypeId != null) {
            originalRoleType = this.roleDAO.getType(originalRoleTypeId);
        }
        if (!isSurveillant && originalRoleType != null && originalRoleType.getType() == 2) {
            this.mailOperations.deleteAllLateTaskFutureEmailsForParticipationId(participation.getId());
        } else if (originalRoleType != null && originalRoleType.getType() != 2 && isSurveillant) {
            this.createFutureEmails(participation);
        }
        if (!organisationPersonsForLateTaskEmails.isEmpty()) {
            this.createEmailNotificationsForLateTasks(new ArrayList<OrganisationPerson>(organisationPersonsForLateTaskEmails.values()), participation.getProject(), i18n, locale);
        }
        return participation;
    }

    private void createEmailNotificationsForLateTasks(List<OrganisationPerson> organisationPersons, Project project, I18n i18n, Locale locale) {
        List<Task> allTasksOfProject = this.taskDAO.getAllTasksOfProject(project.getId());
        ArrayList<Task> allLateTasksOfProject = new ArrayList<Task>();
        Calendar now = Calendar.getInstance();
        for (Task task : allTasksOfProject) {
            if (!(task instanceof ReviewCycleEntryTask) && !(task instanceof SelectCellConnectionTask) && !(task instanceof ReviewTask) && !(task instanceof AttachedReviewTask) || !task.getEndDate().before(now)) continue;
            allLateTasksOfProject.add(task);
        }
        if (!allLateTasksOfProject.isEmpty()) {
            this.mailOperations.createLateTaskEmails(organisationPersons, allLateTasksOfProject, project);
        }
    }

    @Override
    public void deleteProjectParticipation(ProjectParticipation pp) {
        logger.info((Object)("deleting ProjectParticipation with id=[" + pp.getId() + "]"));
        if (pp.getProjectParticipants() != null) {
            Iterator<ProjectParticipant> it = pp.getAllParticipants().iterator();
            while (it.hasNext()) {
                this.deleteProjectParticipant(it.next());
            }
        }
        if (pp.getRole().getType() != null && pp.getRole().getType().getType() == 2) {
            this.mailOperations.deleteAllLateTaskFutureEmailsForParticipationId(pp.getId());
        }
        this.projectParticipationDAO.delete(pp);
    }

    @Override
    public ProjectParticipation invalidateProjectParticipation(Integer ppId) throws ActionException {
        ProjectParticipation pp = this.getProjectParticipation(ppId);
        if (!this.isProjectParticipationInvalidatable(pp)) {
            throw new ActionException("could not invalidate ProjectParticipation");
        }
        pp.setStatus(2);
        return this.projectParticipationDAO.update(pp);
    }

    @Override
    public boolean isProjectParticipationInvalidatable(ProjectParticipation pp) {
        Project project = pp.getProject();
        if (project.getStatus() != 10) {
            Collection subProjects = project.getSubProjects().values();
            for (Object subProject : subProjects) {
                Object positions;
                Collection objectImpls = ((SubProject)subProject).getEditObjectList().getObjects().values();
                for (CDESObjectImpl objectImpl : objectImpls) {
                    Collection objectPlannerImpls = objectImpl.getObjectPlanners().values();
                    Iterator iterator = objectPlannerImpls.iterator();
                    while (iterator.hasNext()) {
                        ObjectPlannerImpl objectPlannerImpl = (ObjectPlannerImpl)iterator.next();
                        positions = objectPlannerImpl.getPositions().values();
                        Iterator iterator2 = positions.iterator();
                        while (iterator2.hasNext()) {
                            ObjectPlannerPositionImpl pos = (ObjectPlannerPositionImpl)iterator2.next();
                            if (pos.getProjectParticipation() == null || !pos.getProjectParticipation().getId().equals(pp.getId())) continue;
                            return false;
                        }
                        if (objectPlannerImpl.getPlanner() == null || !objectPlannerImpl.getPlanner().getId().equals(pp.getId())) continue;
                        return false;
                    }
                }
                if (((SubProject)subProject).getActiveObjectList() != null) {
                    ReleasedObjectList relObjectList = ((SubProject)subProject).getActiveObjectList();
                    Collection relObjects = relObjectList.getObjects().values();
                    for (ReleasedCDESObject relObject : relObjects) {
                        if (relObject.getObjectPlanners() == null) continue;
                        Collection relObjectPlanners = relObject.getObjectPlanners().values();
                        positions = relObjectPlanners.iterator();
                        while (positions.hasNext()) {
                            ReleasedObjectPlanner relObjectPlanner = (ReleasedObjectPlanner)positions.next();
                            Collection relPositions = relObjectPlanner.getPositions().values();
                            Iterator iterator = relPositions.iterator();
                            while (iterator.hasNext()) {
                                ReleasedObjectPlannerPosition relPosition = (ReleasedObjectPlannerPosition)iterator.next();
                                if (relPosition.getProjectParticipation() == null || !relPosition.getProjectParticipation().getId().equals(pp.getId())) continue;
                                return false;
                            }
                            if (relObjectPlanner.getPlanner() == null || !relObjectPlanner.getPlanner().getId().equals(pp.getId())) continue;
                            return false;
                        }
                    }
                }
                Collection rcis = ((SubProject)subProject).getReviewCycleInstances().values();
                for (ReviewCycleInstanceImpl rci : rcis) {
                    ReviewCycleInstanceRelease rciRel;
                    Object nodeListener2;
                    Collection rccis = rci.getReviewCycleCellInstances().values();
                    for (ReviewCycleCellInstanceImpl rcci : rccis) {
                        Collection rcnis = rcci.getReviewCycleNodeInstances().values();
                        for (ReviewCycleNodeInstanceImpl rcni : rcnis) {
                            Collection positions2 = rcni.getReviewCyclePositions().values();
                            Iterator iterator = positions2.iterator();
                            while (iterator.hasNext()) {
                                ReviewCyclePositionImpl position = (ReviewCyclePositionImpl)iterator.next();
                                if (!position.getProjectParticipation().getId().equals(pp.getId())) continue;
                                return false;
                            }
                            Collection nodeListeners = rcni.getReviewCycleNode().getListeners().values();
                            for (Object nodeListener2 : nodeListeners) {
                                PlottOrderTemplate plottOrderTemplate;
                                ReviewCycleNodeInstanceListener instanceListener = this.reviewCycleOperations.getReviewCycleNodeInstanceListenerByInstance(((ReviewCycleNodeListener)nodeListener2).getId(), rcni.getId());
                                if (instanceListener instanceof ReviewCycleNodeInstanceNotification && ((ReviewCycleNodeInstanceNotification)instanceListener).getReference().containsKey(pp.getId())) {
                                    return false;
                                }
                                if (!(instanceListener instanceof ReviewCycleNodeInstancePlottOrderListener) || (plottOrderTemplate = (PlottOrderTemplate)instanceListener.getReference()) == null || !plottOrderTemplate.getTemplateResolver().equals("ProjectParticipationPlotTemplate") || plottOrderTemplate.isInvalidated()) continue;
                                Collection itemTempls = plottOrderTemplate.getOrderItems().values();
                                for (PlottOrderItemTemplate itemTempl : itemTempls) {
                                    if (itemTempl.isInvalidated() || itemTempl.getDeliveryAddressId() == null || !itemTempl.getDeliveryAddressId().equals(pp.getId())) continue;
                                    return false;
                                }
                                if (plottOrderTemplate.getPlotterId() == null || !plottOrderTemplate.getPlotterId().equals(pp.getId())) continue;
                                return false;
                            }
                            List<AttachedReviewTask> attachedTasks = this.taskOperations.getAllAttachedReviewTasksByParticipation(pp.getId());
                            nodeListener2 = attachedTasks.iterator();
                            while (nodeListener2.hasNext()) {
                                AttachedReviewTask task = (AttachedReviewTask)nodeListener2.next();
                                Collection attachedPositions = task.getReviewCyclePositionReleases().values();
                                for (AttachedReviewCyclePositionImpl position : attachedPositions) {
                                    ReviewCycleNodeResult reviewCycleNodeResult = this.reviewOperations.getReviewCycleNodeResult(position.getReviewCycleNodeInstance().getReviewCycleNode(), task.getDocumentVersion());
                                    ReviewCyclePositionResult positionResult = this.reviewOperations.getReviewCyclePositionResult2(position, task.getDocumentVersion(), reviewCycleNodeResult.getId());
                                    if (positionResult != null && (positionResult == null || positionResult.getSignature() != null)) continue;
                                    return false;
                                }
                            }
                        }
                    }
                    if (((SubProject)subProject).getActiveObjectList() == null || (rciRel = this.reviewCycleOperations.getReleased(((SubProject)subProject).getActiveObjectList().getId(), rci.getId())) == null) continue;
                    Collection rccisRel = rciRel.getReviewCycleCellInstances().values();
                    for (ReviewCycleCellInstanceRelease rcciRel : rccisRel) {
                        Collection rcnisRel = rcciRel.getReviewCycleNodeInstances().values();
                        for (ReviewCycleNodeInstanceRelease rcniRel : rcnisRel) {
                            Collection positionsRel = rcniRel.getReviewCyclePositions().values();
                            nodeListener2 = positionsRel.iterator();
                            while (nodeListener2.hasNext()) {
                                ReviewCyclePositionRelease positionRel = (ReviewCyclePositionRelease)nodeListener2.next();
                                if (!positionRel.getProjectParticipation().getId().equals(pp.getId())) continue;
                                return false;
                            }
                        }
                        Collection freeRcnisRel = rcciRel.getFreeReviewCycleNodeInstances().values();
                        for (ReviewCycleNodeInstanceRelease rcniRel : freeRcnisRel) {
                            Collection positionsRel = rcniRel.getReviewCyclePositions().values();
                            for (ReviewCyclePositionRelease positionRel : positionsRel) {
                                if (!positionRel.getProjectParticipation().getId().equals(pp.getId())) continue;
                                return false;
                            }
                        }
                    }
                }
            }
            if (this.orderOperations.existingOpenPlotOrdersForParticipant(pp, pp.getMainParticipant(), pp.getProject())) {
                return false;
            }
            Collection templatesOfProject = this.orderOperations.getTemplatesOfProject(pp.getProject().getId());
            for (PlottOrderTemplate templ : templatesOfProject) {
                if (templ.isInvalidated()) continue;
                if (templ.getPlotterId() != null && templ.getPlotterId().equals(pp.getId())) {
                    return false;
                }
                if (!templ.getTemplateResolver().equals("ProjectParticipationPlotTemplate")) continue;
                Collection items = templ.getOrderItems().values();
                for (PlottOrderItemTemplate item : items) {
                    if (item.isInvalidated() || item.getDeliveryAddressId() == null || !item.getDeliveryAddressId().equals(pp.getId())) continue;
                    return false;
                }
            }
        } else {
            List<WorkflowNodePosition> workflowNodePositions = this.workflowNodePositionDAO.getPositionsForProject(project.getId());
            for (WorkflowNodePosition workflowNodePosition : workflowNodePositions) {
                if (!workflowNodePosition.getProjectParticipation().getId().equals(pp.getId())) continue;
                return false;
            }
        }
        return true;
    }

    public void deleteProjectParticipant(ProjectParticipant pp) {
        Iterator iter = pp.getDateHistory().values().iterator();
        while (iter.hasNext()) {
            this.projectParticipantDAO.delete((ProjectParticipantDateHistoryPart)iter.next());
        }
        this.projectParticipantDAO.delete(pp);
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setDocumentListDAO(DocumentListDAO documentListDAO) {
        this.documentListDAO = documentListDAO;
    }

    public void setObjectListDAO(ObjectListDAO objectListDAO) {
        this.objectListDAO = objectListDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    @Override
    public List getProjectParticipants(Person person) {
        Iterator<OrganisationPerson> iter = person.getOrganisationPersons().values().iterator();
        ArrayList participants = new ArrayList();
        while (iter.hasNext()) {
            participants.addAll(this.projectParticipantDAO.getAll(iter.next(), true));
        }
        return participants;
    }

    @Override
    public List getProjectParticipations(Integer organisationPersonId, Integer projectId, boolean invisibleProjects_also) {
        OrganisationPerson organisationPerson = this.organisationPersonDAO.get(organisationPersonId);
        List participants = this.projectParticipantDAO.getAll(organisationPerson, true);
        Iterator iter = participants.iterator();
        ArrayList<ProjectParticipation> ret = new ArrayList<ProjectParticipation>();
        while (iter.hasNext()) {
            ProjectParticipant pp = (ProjectParticipant)iter.next();
            if (projectId != null && !pp.getParticipation().getProject().getId().equals(projectId) || !invisibleProjects_also && pp.getParticipation().getProject().getAccess() == 0) continue;
            ret.add(pp.getParticipation());
        }
        return ret;
    }

    @Override
    public List getWriteableProjectParticipations(Integer organisationPersonId) {
        OrganisationPerson organisationPerson = this.organisationPersonDAO.get(organisationPersonId);
        List participants = this.projectParticipantDAO.getAll(organisationPerson, true);
        Iterator iter = participants.iterator();
        ArrayList<ProjectParticipation> ret = new ArrayList<ProjectParticipation>();
        while (iter.hasNext()) {
            ProjectParticipant pp = (ProjectParticipant)iter.next();
            if (pp.getParticipation().getProject().getAccess() != 2) continue;
            ret.add(pp.getParticipation());
        }
        return ret;
    }

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    @Override
    public List<ReviewTask> getParticipationReviewTodos(Integer projectParticipationId) {
        return this.taskDAO.getAllProjectParticipationReviewTodos(projectParticipationId);
    }

    public List<PlotOrderAcceptanceTask> getPlotOrderAcceptanceTodos(Integer projectParticipationId) {
        return this.taskDAO.getAllPlotOrderAcceptanceTodos(projectParticipationId);
    }

    @Override
    public List<SelectCellConnectionTask> getParticipationSelectCellConnectionTodos(Integer projectParticipationId) {
        return this.taskDAO.getAllProjectParticipationSelectCellConnectionTodos(projectParticipationId);
    }

    public void setTaskDAO(TaskDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    @Override
    public Project insertAndUpdateProjectHolidays(Integer projectId, List updates, List deleted) {
        int i;
        Project project = this.projectDAO.get(projectId);
        ProjectConfig projectConfig = project.getProjectConfig();
        if (projectConfig == null) {
            projectConfig = new ProjectConfig();
            project.setProjectConfig(projectConfig);
            this.projectDAO.save(projectConfig);
            project = this.projectDAO.save(project);
        }
        if (project.getHolidays() == null) {
            project.setHolidays(new HashMap());
        }
        for (i = 0; i < updates.size(); ++i) {
            ProjectHoliday hol = (ProjectHoliday)updates.get(i);
            hol.setProject(project);
            if (hol.getId() == null || hol.getId() < 0) {
                if (hol.getStartDate() == null || hol.getEndDate() == null) continue;
                hol.setId(null);
                hol = this.projectDAO.save(hol);
                project.getHolidays().put(hol.getId(), hol);
                continue;
            }
            hol = this.projectDAO.update(hol);
            project.getHolidays().put(hol.getId(), hol);
        }
        for (i = 0; i < deleted.size(); ++i) {
            Integer id = (Integer)deleted.get(i);
            this.projectDAO.delete(this.projectDAO.getProjectHoliday(id));
            project.getHolidays().remove(id);
        }
        this.projectDAO.update(projectConfig);
        project = this.projectDAO.update(project);
        this.taskOperations.updateRecalculateProjectTaskDeadlines(project.getId());
        return project;
    }

    @Override
    public ProjectParticipant getProjectParticipant(Integer projectParticipantId) {
        return this.projectParticipantDAO.get(projectParticipantId);
    }

    public void setObjectOperations(ObjectOperations objectOperations) {
        this.objectOperations = objectOperations;
    }

    public void setReviewCycleOperations(ReviewCycleOperations reviewCycleOperations) {
        this.reviewCycleOperations = reviewCycleOperations;
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }

    public void setRealmDAO(RealmDAO realmDAO) {
        this.realmDAO = realmDAO;
    }

    @Override
    public Collection<AttachedReviewTask> getParticipationAttachedReviewTodos(Integer ppId) {
        return this.taskDAO.getAllProjectParticipationAttachedReviewTodos(ppId);
    }

    @Override
    public boolean containsProjectCode(Integer networkId, Project project) {
        List projects = this.projectDAO.getAll(networkId, null, null, null);
        projects.addAll(this.projectDAO.getAllPlanningNotificationProjectsFromNetwork(networkId));
        for (Project proj : projects) {
            if (proj.getStatus() == 6 || proj.getId().equals(project.getId()) || !proj.getCode().equals(project.getCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ReviewCycleEntryTask> getParticipationReviewCycleEntryTodos(Integer projectParticipationId) {
        return this.taskDAO.getAllProjectParticipationReviewCycleEntryTodos(projectParticipationId);
    }

    @Override
    public Collection<ReviewCyclePlottTask> getParticipationReviewCyclePlottTodos(Integer projectParticipationId) {
        return this.taskDAO.getAllProjectParticipationReviewCyclePlottTodos(projectParticipationId);
    }

    @Override
    public List<Project> getProjects(Integer organisationPersonId) {
        ArrayList parts = new ArrayList();
        ArrayList<Project> projects = new ArrayList<Project>();
        OrganisationPerson op = this.organisationPersonDAO.get(organisationPersonId);
        parts.addAll(this.projectParticipantDAO.getAll(op, true));
        for (ProjectParticipant participant : parts) {
            Project project = participant.getParticipation().getProject();
            if (projects.contains(project) || project.getStatus() == 7) continue;
            projects.add(project);
        }
        return projects;
    }

    @Override
    public List<Project> getPersonalProjects() {
        Integer organisationPersonId = ImplContextHelper.getContextOrganisationPersonId();
        if (organisationPersonId != null) {
            return this.getProjects(organisationPersonId);
        }
        return new ArrayList<Project>();
    }

    @Override
    public List<Project> getVisibleProjects(Integer organisationPersonId) {
        ArrayList parts = new ArrayList();
        ArrayList<Project> projects = new ArrayList<Project>();
        OrganisationPerson op = this.organisationPersonDAO.get(organisationPersonId);
        parts.addAll(this.projectParticipantDAO.getAll(op, true));
        for (ProjectParticipant participant : parts) {
            Project project = participant.getParticipation().getProject();
            if (projects.contains(project) || project.getAccess() == 0) continue;
            projects.add(project);
        }
        return projects;
    }

    @Override
    public Collection<Organisation> getOrganisationsOfProject(Integer projectId) {
        if (projectId == null) {
            return null;
        }
        Project project = this.projectDAO.get(projectId);
        if (project.getProjectParticipations() == null) {
            return null;
        }
        Collection participations = project.getProjectParticipations().values();
        ArrayList<Organisation> orgs = new ArrayList<Organisation>();
        for (ProjectParticipation participation : participations) {
            Collection participants = participation.getProjectParticipants().values();
            for (ProjectParticipant participant : participants) {
                Organisation org = participant.getOrganisationPerson().getOrganisation();
                if (orgs.contains(org)) continue;
                orgs.add(org);
            }
        }
        return orgs;
    }

    @Override
    public Collection<OriginalDocumentTask> getParticipationOriginalDocumentTodos(Integer projectParticipationId) {
        return this.taskDAO.getAllProjectParticipationOriginalDocumentTodos(projectParticipationId);
    }

    @Override
    public ProjectExport exportProject(Integer projectId) {
        ProjectExport ret = new ProjectExport();
        Project project = this.projectDAO.get(projectId);
        ret.setProject(project);
        ret.setActions(this.actionDAO.getAll());
        ArrayList<ActionRule> actionRules = new ArrayList<ActionRule>();
        actionRules.addAll(this.actionDAO.getActionRules(null, false));
        actionRules.addAll(this.actionDAO.getActionRules(project.getNetwork(), false));
        ret.setActionRules(actionRules);
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        ArrayList<OriginalDocumentOrder> originalDocOrders = new ArrayList<OriginalDocumentOrder>();
        Collection subProjects = project.getSubProjects().values();
        for (SubProject subProject : subProjects) {
            Collection documents = subProject.getEditDocumentList().getDocuments().values();
            for (Document document : documents) {
                Collection<DocumentVersion> documentVersions = document.getAllDocumentVersions();
                for (DocumentVersion dv : documentVersions) {
                    attachments.addAll(this.attachmentDAO.getAll(dv.getId()));
                }
            }
            Collection<OriginalDocumentOrder> odos = this.orderDAO.getOriginalDocumentOrders(subProject.getId());
            if (odos == null || odos.isEmpty()) continue;
            originalDocOrders.addAll(odos);
        }
        ret.setAttachments(attachments);
        ret.setOriginalDocOrders(originalDocOrders);
        ret.setDigestCalculatorTypes(this.digestCalculatorDAO.getAll());
        List plottOrders = (List)this.orderDAO.getPlottOrders(projectId);
        ret.setPlottOrders(plottOrders);
        List labels = this.labelDAO.getAllLabels(project.getNetwork().getMaintainer().getId());
        ret.setLabels(labels);
        return ret;
    }

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }

    public void setDigestCalculatorDAO(DigestCalculatorDAO digestCalculatorDAO) {
        this.digestCalculatorDAO = digestCalculatorDAO;
    }

    @Override
    public List<SubProject> getAllProjectsSubProjects(Integer projectId) {
        return this.subProjectDAO.getAll(projectId, false);
    }

    @Override
    public ProjectParticipant getParticipantByParticipation(Integer projectParticipationId, Integer organisationPersonId) {
        return this.projectParticipantDAO.get(projectParticipationId, organisationPersonId);
    }

    public void setOrderDAO(OrderDAO orderDAO) {
        this.orderDAO = orderDAO;
    }

    public void setLabelDAO(LabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }

    @Override
    public List<Project> getProjectsByCreationDate(Integer networkId, Date validFrom, Date validTo) {
        List allProjects = this.projectDAO.getAllFromNetwork(networkId);
        ArrayList<Project> validProjects = new ArrayList<Project>();
        for (Project project : allProjects) {
            Date creationDate = project.getCreated();
            if (validFrom != null && creationDate.before(validFrom) || validTo != null && creationDate.after(validTo)) continue;
            validProjects.add(project);
        }
        return validProjects;
    }

    @Override
    public List getSubProjectByType(Integer subProjectTypeId) {
        return this.subProjectDAO.getByType(subProjectTypeId);
    }

    @Override
    public List getAllActiveProjectsByNetwork(Integer networkId) {
        return this.projectDAO.getAllActiveFromNetwork(networkId);
    }

    @Override
    public List getAllParticipationTodos(Integer orgPersonId) {
        ArrayList<TaskBase> allTasks = new ArrayList<TaskBase>();
        List projectParticipations = this.getWriteableProjectParticipations(orgPersonId);
        for (ProjectParticipation pp : projectParticipations) {
            allTasks.addAll(this.getParticipationReviewTodos(pp.getId()));
            allTasks.addAll(this.getParticipationAttachedReviewTodos(pp.getId()));
            allTasks.addAll(this.getParticipationSelectCellConnectionTodos(pp.getId()));
            allTasks.addAll(this.getParticipationReviewCycleEntryTodos(pp.getId()));
            allTasks.addAll(this.getParticipationReviewCyclePlottTodos(pp.getId()));
            allTasks.addAll(this.getParticipationOriginalDocumentTodos(pp.getId()));
            allTasks.addAll(this.getPlotOrderAcceptanceTodos(pp.getId()));
        }
        return allTasks;
    }

    @Override
    public List getPersonsProjectParticipants(Integer personId) {
        return this.projectParticipantDAO.getAllPersons(personId);
    }

    public void setOrderOperations(OrderOperations orderOperations) {
        this.orderOperations = orderOperations;
    }

    public void setRoleOperations(RoleOperations roleOperations) {
        this.roleOperations = roleOperations;
    }

    @Override
    public ProjectParticipation changeProjectParticipationStatus(Integer participationId, int status) {
        ProjectParticipation pp = this.getProjectParticipation(participationId);
        pp.setStatus(status);
        return this.projectParticipationDAO.update(pp);
    }

    @Override
    public ProjectParticipant getSigner(Project project, String actionName) {
        RoleMap roleMap = ImplContextHelper.getRoleMap();
        List roles = roleMap.getProjectRoles(project.getId(), ImplContextHelper.getContextOrganisationPersonId());
        for (int i = 0; i < roles.size(); ++i) {
            RoleMapEntry entry = (RoleMapEntry)roles.get(i);
            Role role = this.roleOperations.get(entry.getId());
            if (!role.hasAction(actionName)) continue;
            return this.getProjectParticipant(entry.getProjectParticipantId());
        }
        return null;
    }

    @Override
    public ProjectParticipation deleteAssignmentsOfParticipationAndInvalidateOrMarkForDeletion(Integer ppId) {
        boolean isBuekProject;
        boolean setMarkedForDeletion = false;
        ProjectParticipation pp = this.projectParticipationDAO.get(ppId);
        Project project = pp.getProject();
        boolean bl = isBuekProject = project.getStatus() == 10;
        if (!isBuekProject) {
            Collection subProjects = project.getSubProjects().values();
            block4: for (Object subProject : subProjects) {
                Iterator nodeInstances;
                Collection cycleInstances = ((SubProject)subProject).getReviewCycleInstances().values();
                block5: for (ReviewCycleInstanceImpl cycleInstance : cycleInstances) {
                    ReviewCycleInstanceRelease rciRel;
                    Collection cellInstances = cycleInstance.getReviewCycleCellInstances().values();
                    Iterator iterator = cellInstances.iterator();
                    while (iterator.hasNext()) {
                        Object position2;
                        ReviewCycleCellInstanceImpl cellInstance = (ReviewCycleCellInstanceImpl)iterator.next();
                        nodeInstances = cellInstance.getReviewCycleNodeInstances().values();
                        Iterator iterator2 = nodeInstances.iterator();
                        while (iterator2.hasNext()) {
                            ReviewCycleNodeInstanceImpl nodeInstance = (ReviewCycleNodeInstanceImpl)iterator2.next();
                            Collection positions = nodeInstance.getReviewCyclePositions().values();
                            ArrayList<ReviewCyclePositionImpl> deletePositions = new ArrayList<ReviewCyclePositionImpl>();
                            for (Object position2 : positions) {
                                if (!((ReviewCyclePositionImpl)position2).getProjectParticipation().getId().equals(ppId)) continue;
                                deletePositions.add((ReviewCyclePositionImpl)position2);
                            }
                            this.reviewCycleOperations.deleteReviewCyclePosition(deletePositions);
                            Collection nodeListeners = nodeInstance.getReviewCycleNode().getListeners().values();
                            position2 = nodeListeners.iterator();
                            while (position2.hasNext()) {
                                PlottOrderTemplate plottOrderTemplate;
                                ReviewCycleNodeListener nodeListener = (ReviewCycleNodeListener)position2.next();
                                ReviewCycleNodeInstanceListener instanceListener = this.reviewCycleOperations.getReviewCycleNodeInstanceListenerByInstance(nodeListener.getId(), nodeInstance.getId());
                                if (instanceListener instanceof ReviewCycleNodeInstanceNotification && ((ReviewCycleNodeInstanceNotification)instanceListener).getReference().containsKey(ppId)) {
                                    ((ReviewCycleNodeInstanceNotification)instanceListener).getReference().remove(ppId);
                                    this.reviewCycleOperations.insertAndUpdateReviewCycleNodeInstanceListener(instanceListener);
                                    continue;
                                }
                                if (!(instanceListener instanceof ReviewCycleNodeInstancePlottOrderListener) || (plottOrderTemplate = ((ReviewCycleNodeInstancePlottOrderListener)instanceListener).getReference()) == null || !plottOrderTemplate.getTemplateResolver().equals("ProjectParticipationPlotTemplate")) continue;
                                Collection itemTempls = plottOrderTemplate.getOrderItems().values();
                                int templsFound = 0;
                                for (PlottOrderItemTemplate itemTempl : itemTempls) {
                                    if (itemTempl.getDeliveryAddressId() == null || !itemTempl.getDeliveryAddressId().equals(ppId) || ++templsFound != itemTempls.size()) continue;
                                    ((ReviewCycleNodeInstancePlottOrderListener)instanceListener).setReference(null);
                                    this.reviewCycleOperations.insertAndUpdateReviewCycleNodeInstanceListener(instanceListener);
                                }
                            }
                        }
                        Collection freenodeInstances = cellInstance.getFreeReviewCycleNodeInstances().values();
                        for (Object nodeInstance : freenodeInstances) {
                            Object position3;
                            Collection positions = ((ReviewCycleNodeInstanceImpl)nodeInstance).getReviewCyclePositions().values();
                            ArrayList<ReviewCyclePositionImpl> deletePositions = new ArrayList<ReviewCyclePositionImpl>();
                            position2 = positions.iterator();
                            while (position2.hasNext()) {
                                position3 = (ReviewCyclePositionImpl)position2.next();
                                if (!((ReviewCyclePositionImpl)position3).getProjectParticipation().getId().equals(ppId)) continue;
                                deletePositions.add((ReviewCyclePositionImpl)position3);
                            }
                            this.reviewCycleOperations.deleteReviewCyclePosition(deletePositions);
                            Collection nodeListeners = ((ReviewCycleNodeInstanceImpl)nodeInstance).getReviewCycleNode().getListeners().values();
                            position3 = nodeListeners.iterator();
                            while (position3.hasNext()) {
                                PlottOrderTemplate plottOrderTemplate;
                                ReviewCycleNodeListener nodeListener = (ReviewCycleNodeListener)position3.next();
                                ReviewCycleNodeInstanceListener instanceListener = this.reviewCycleOperations.getReviewCycleNodeInstanceListenerByInstance(nodeListener.getId(), ((ReviewCycleNodeInstanceImpl)nodeInstance).getId());
                                if (instanceListener instanceof ReviewCycleNodeInstanceNotification && ((ReviewCycleNodeInstanceNotification)instanceListener).getReference().containsKey(ppId)) {
                                    ((ReviewCycleNodeInstanceNotification)instanceListener).getReference().remove(ppId);
                                    this.reviewCycleOperations.insertAndUpdateReviewCycleNodeInstanceListener(instanceListener);
                                    continue;
                                }
                                if (!(instanceListener instanceof ReviewCycleNodeInstancePlottOrderListener) || (plottOrderTemplate = ((ReviewCycleNodeInstancePlottOrderListener)instanceListener).getReference()) == null || !plottOrderTemplate.getTemplateResolver().equals("ProjectParticipationPlotTemplate")) continue;
                                Collection itemTempls = plottOrderTemplate.getOrderItems().values();
                                int templsFound = 0;
                                for (PlottOrderItemTemplate itemTempl : itemTempls) {
                                    if (itemTempl.getDeliveryAddressId() == null || !itemTempl.getDeliveryAddressId().equals(ppId) || ++templsFound != itemTempls.size()) continue;
                                    ((ReviewCycleNodeInstancePlottOrderListener)instanceListener).setReference(null);
                                    this.reviewCycleOperations.insertAndUpdateReviewCycleNodeInstanceListener(instanceListener);
                                }
                            }
                        }
                    }
                    cycleInstance = this.reviewCycleOperations.updateReviewCycleInstance(cycleInstance, ((SubProject)subProject).getId());
                    if (((SubProject)subProject).getActiveObjectList() == null || setMarkedForDeletion || (rciRel = this.reviewCycleOperations.getReleased(((SubProject)subProject).getActiveObjectList().getId(), cycleInstance.getId())) == null) continue;
                    Collection rccisRel = rciRel.getReviewCycleCellInstances().values();
                    for (ReviewCycleCellInstanceRelease rcciRel : rccisRel) {
                        Object rcniRel;
                        Object nodeInstance;
                        Collection rcnisRel = rcciRel.getReviewCycleNodeInstances().values();
                        nodeInstance = rcnisRel.iterator();
                        while (nodeInstance.hasNext()) {
                            rcniRel = (ReviewCycleNodeInstanceRelease)nodeInstance.next();
                            Collection positionsRel = ((ReviewCycleNodeInstanceRelease)rcniRel).getReviewCyclePositions().values();
                            for (ReviewCyclePositionRelease positionRel : positionsRel) {
                                if (!positionRel.getProjectParticipation().getId().equals(ppId)) continue;
                                setMarkedForDeletion = true;
                                break;
                            }
                            if (!setMarkedForDeletion) continue;
                            break;
                        }
                        Collection freeRcnisRel = rcciRel.getFreeReviewCycleNodeInstances().values();
                        rcniRel = freeRcnisRel.iterator();
                        while (rcniRel.hasNext()) {
                            ReviewCycleNodeInstanceRelease rcniRel2 = (ReviewCycleNodeInstanceRelease)rcniRel.next();
                            Collection positionsRel = rcniRel2.getReviewCyclePositions().values();
                            for (ReviewCyclePositionRelease positionRel : positionsRel) {
                                if (!positionRel.getProjectParticipation().getId().equals(ppId)) continue;
                                setMarkedForDeletion = true;
                                break;
                            }
                            if (!setMarkedForDeletion) continue;
                            break;
                        }
                        if (!setMarkedForDeletion) continue;
                        continue block5;
                    }
                }
                ObjectListImpl olist = ((SubProject)subProject).getEditObjectList();
                ArrayList objects = new ArrayList(olist.getObjects().values());
                for (CDESObjectImpl object : objects) {
                    ArrayList objectPlanners = new ArrayList(object.getObjectPlanners().values());
                    nodeInstances = objectPlanners.iterator();
                    while (nodeInstances.hasNext()) {
                        ObjectPlannerImpl objectPlanner = (ObjectPlannerImpl)nodeInstances.next();
                        if (objectPlanner.getPlanner() != null && objectPlanner.getPlanner().getId().equals(ppId)) {
                            objectPlanner.setPlanner(null);
                            if (objectPlanner.getChanged() == 0) {
                                objectPlanner.setChanged(1);
                            }
                            objectPlanner = this.objectOperations.updateObjectPlanner(objectPlanner);
                        }
                        ArrayList positions = new ArrayList(objectPlanner.getPositions().values());
                        for (ObjectPlannerPositionImpl position : positions) {
                            if (!position.getProjectParticipation().getId().equals(ppId)) continue;
                            this.objectOperations.deleteObjectPlannerPosition(position);
                            if (objectPlanner.getChanged() != 0) continue;
                            objectPlanner.setChanged(1);
                            objectPlanner = this.objectOperations.updateObjectPlanner(objectPlanner);
                        }
                    }
                }
                if (((SubProject)subProject).getActiveObjectList() == null || setMarkedForDeletion) continue;
                ReleasedObjectList relObjectList = ((SubProject)subProject).getActiveObjectList();
                Collection relObjects = relObjectList.getObjects().values();
                for (ReleasedCDESObject relObject : relObjects) {
                    if (relObject.getObjectPlanners() == null) continue;
                    Collection relObjectPlanners = relObject.getObjectPlanners().values();
                    for (ReleasedObjectPlanner relObjectPlanner : relObjectPlanners) {
                        Collection relPositions = relObjectPlanner.getPositions().values();
                        for (ReleasedObjectPlannerPosition relPosition : relPositions) {
                            if (relPosition.getProjectParticipation() == null || !relPosition.getProjectParticipation().getId().equals(ppId)) continue;
                            setMarkedForDeletion = true;
                            break;
                        }
                        if (relObjectPlanner.getPlanner() != null && relObjectPlanner.getPlanner().getId().equals(ppId)) {
                            setMarkedForDeletion = true;
                        }
                        if (!setMarkedForDeletion) continue;
                        break;
                    }
                    if (!setMarkedForDeletion) continue;
                    continue block4;
                }
            }
            Collection plottOrderTemplates = this.orderDAO.getTemplatesOfProject(this.getProjectParticipation(ppId).getProject().getId());
            for (Object template : plottOrderTemplates) {
                if (((PlottOrderTemplate)template).getPlotterId() != null && ((PlottOrderTemplate)template).getPlotterId().equals(ppId)) {
                    ((PlottOrderTemplate)template).setPlotterId(null);
                    template = this.orderDAO.updatePlottOrderTemplate((PlottOrderTemplate)template);
                }
                if (!((PlottOrderTemplate)template).getTemplateResolver().equals("ProjectParticipationPlotTemplate")) continue;
                Collection itemTempls = ((PlottOrderTemplate)template).getOrderItems().values();
                for (Object itemTempl : itemTempls) {
                    if (!((PlottOrderItemTemplate)itemTempl).getDeliveryAddressId().equals(ppId)) continue;
                    List items = this.orderDAO.getPlottOrderItemsReferencingTemplateItem(((PlottOrderItemTemplate)itemTempl).getId());
                    if (items.isEmpty()) {
                        this.orderDAO.delete((PlottOrderItemTemplate)itemTempl);
                        continue;
                    }
                    ((PlottOrderItemTemplate)itemTempl).setInvalidated(true);
                    this.orderDAO.updatePlottOrderItemTemplate((PlottOrderItemTemplate)itemTempl);
                }
                itemTempls = ((PlottOrderTemplate)template).getOrderItems().values();
                if (!itemTempls.isEmpty()) {
                    Object itemTempl;
                    boolean hasValidItems = false;
                    itemTempl = itemTempls.iterator();
                    while (itemTempl.hasNext()) {
                        PlottOrderItemTemplate itemTempl2 = (PlottOrderItemTemplate)itemTempl.next();
                        if (itemTempl2.isInvalidated()) continue;
                        hasValidItems = true;
                        break;
                    }
                    if (hasValidItems) continue;
                    ((PlottOrderTemplate)template).setInvalidated(true);
                    this.orderDAO.updatePlottOrderTemplate((PlottOrderTemplate)template);
                    continue;
                }
                this.orderDAO.delete((PlottOrderTemplate)template);
            }
            List<AttachedReviewTask> attachedTasks = this.taskOperations.getAllAttachedReviewTasksByParticipation(ppId);
            for (AttachedReviewTask task : attachedTasks) {
                Collection positions = task.getReviewCyclePositionReleases().values();
                for (AttachedReviewCyclePositionImpl position : positions) {
                    ReviewCycleNodeResult reviewCycleNodeResult = this.reviewOperations.getReviewCycleNodeResult(position.getReviewCycleNodeInstance().getReviewCycleNode(), task.getDocumentVersion());
                    ReviewCyclePositionResult positionResult = this.reviewOperations.getReviewCyclePositionResult2(position, task.getDocumentVersion(), reviewCycleNodeResult.getId());
                    if (positionResult != null && (positionResult == null || positionResult.getSignature() != null)) continue;
                    if (positionResult != null) {
                        this.reviewOperations.deleteReviewCyclePositionResultsWithSubElementsId(positionResult.getId(), false, false);
                    }
                    this.reviewCyclePositionDAO.delete(position);
                }
                this.reviewOperations.deleteAndMove(task.getId());
            }
        } else {
            List<WorkflowNodePosition> workflowNodePositions = this.workflowNodePositionDAO.getPositionsForProject(project.getId());
            boolean noPositions = true;
            for (WorkflowNodePosition workflowNodePosition : workflowNodePositions) {
                boolean isStartNode = workflowNodePosition.getWorkflowNode().getWorkflowNodeTemplate().isStartNode();
                if (!workflowNodePosition.getProjectParticipation().getId().equals(pp.getId())) continue;
                if (!isStartNode) {
                    setMarkedForDeletion = true;
                    break;
                }
                List<WorkflowActivityPositionResult> results = this.workflowActivityDAO.getPositionResultsByInitiator(workflowNodePosition.getId());
                if (!results.isEmpty()) {
                    setMarkedForDeletion = true;
                    break;
                }
                try {
                    noPositions &= this.reviewOperations.deleteWorkflowNodePosition(workflowNodePosition.getId());
                }
                catch (Exception e) {
                    logger.warn((Object)"Exception: ", (Throwable)e);
                    setMarkedForDeletion = true;
                    break;
                }
            }
            if (!setMarkedForDeletion && noPositions) {
                try {
                    this.deleteProjectParticipation(pp);
                    return pp;
                }
                catch (Exception e) {
                    logger.warn((Object)"Exception: ", (Throwable)e);
                    setMarkedForDeletion = false;
                }
            }
            return pp;
        }
        if (!setMarkedForDeletion) {
            return this.changeProjectParticipationStatus(ppId, 2);
        }
        return this.changeProjectParticipationStatus(ppId, 1);
    }

    @Override
    public void invalidateAllMarkedProjectParticipations(Project p) {
        Collection participations = p.getProjectParticipations().values();
        for (ProjectParticipation part : participations) {
            if (part.getStatus() != 1) continue;
            try {
                this.invalidateProjectParticipation(part.getId());
            }
            catch (ActionException actionException) {}
        }
    }

    @Override
    public List getVisibleSubProjectForOrganisationPerson(Integer projectId, Integer orgPersonId) {
        Project project = this.getProject(projectId);
        Map visibleSubProjects = new HashMap();
        if (project == null || project.getSubProjects() == null) {
            return new ArrayList();
        }
        visibleSubProjects = project.getSubProjects();
        List participants = this.projectParticipantDAO.getAll(this.organisationPersonDAO.get(orgPersonId), project, false);
        if (participants.isEmpty()) {
            return new ArrayList();
        }
        for (ProjectParticipant pp : participants) {
            ArrayList excludes = new ArrayList(pp.getParticipation().getExcludedSubProjects().values());
            for (SubProject sp : excludes) {
                if (!visibleSubProjects.containsKey(sp.getId())) continue;
                boolean invalidForAllParticipants = true;
                for (ProjectParticipant otherPP : participants) {
                    if (otherPP.getParticipation().isInvalidated() || otherPP.getParticipation().getExcludedSubProjects().containsKey(sp.getId())) continue;
                    invalidForAllParticipants = false;
                    break;
                }
                if (!invalidForAllParticipants) continue;
                visibleSubProjects.remove(sp.getId());
            }
        }
        ArrayList ret = new ArrayList(visibleSubProjects.values());
        Collections.sort(ret, new SubProjectComparator());
        return ret;
    }

    @Override
    public List getValidParticipationsForSubProject(Integer subProjectId, Integer projectId) {
        Project project = this.getProject(projectId);
        HashMap visibleParticipations = new HashMap(project.getProjectParticipations());
        Collection allParticipations = project.getProjectParticipations().values();
        for (ProjectParticipation pp : allParticipations) {
            if (!pp.getExcludedSubProjects().containsKey(subProjectId) && pp.isActive()) continue;
            visibleParticipations.remove(pp.getId());
        }
        return new ArrayList(visibleParticipations.values());
    }

    @Override
    public List getAllSubProjectsWithAssignmentsOfParticipation(Integer projectParticipationId) {
        ProjectParticipation pp = this.getProjectParticipation(projectParticipationId);
        Project project = pp.getProject();
        List<SubProject> subProjects = project.getSubProjectsSortedByCodeName();
        ArrayList<SubProject> assignedSubProjects = new ArrayList<SubProject>();
        for (SubProject subProject : subProjects) {
            if (!this.objectOperations.isParticipationAssignedInObjectPlanners(subProject.getId(), projectParticipationId) && !this.reviewCycleOperations.isParticipationAssignedInReviewCycleInstance(subProject.getId(), projectParticipationId)) continue;
            assignedSubProjects.add(subProject);
        }
        return assignedSubProjects;
    }

    @Override
    public List<ProjectParticipation> getAllProjectParticipationsForAction(String actionName, Integer organisationpersonId, Integer roleType) {
        return this.projectParticipationDAO.getAllForAction(actionName, organisationpersonId, roleType);
    }

    public void setMailDAO(EMailDAO mailDAO) {
        this.mailDAO = mailDAO;
    }

    public EMailDAO getMailDAO() {
        return this.mailDAO;
    }

    public void setMailOperations(MailOperations mailOperations) {
        this.mailOperations = mailOperations;
    }

    public MailOperations getMailOperations() {
        return this.mailOperations;
    }

    @Override
    public void insertProjectAdministratorConnection(Integer projectId, Integer orgPersonId, boolean isPlanningNotificationProject) {
        Project project = this.getProject(projectId);
        OrganisationPerson orgPerson = this.organisationPersonDAO.get(orgPersonId);
        ProjectParticipation part = new ProjectParticipation();
        part.setProject(project);
        List roles = null;
        roles = !isPlanningNotificationProject ? this.roleDAO.getAll(project.getNetwork().getId(), 3) : this.roleDAO.getAll(project.getNetwork().getId(), 8);
        if (roles == null || roles.size() == 0) {
            throw new ActionException("Die Rolle Projektadministrator konnte nicht gefunden werden.");
        }
        part.setRole((Role)roles.get(0));
        part.setOrganisation(orgPerson.getOrganisation());
        part = this.projectParticipationDAO.save(part);
        ProjectParticipant participant = new ProjectParticipant();
        participant.setCreated(new Date(System.currentTimeMillis()));
        participant.setMainParticipant(true);
        participant.setParticipation(part);
        participant.setOrganisationPerson(orgPerson);
        this.projectParticipantDAO.save(participant);
        part.setProjectParticipants(new HashMap());
        part.getProjectParticipants().put(participant.getId(), participant);
        this.projectParticipationDAO.merge(part);
    }

    @Override
    public Object[] getAllReferencesOfParticipation(Integer participationId) {
        boolean hasAttachedReviewTasks = false;
        boolean hasReleasedObjectListAssignments = false;
        boolean hasUnreleasedObjectListAssignments = false;
        boolean hasNotificationListenerAssignments = false;
        boolean hasPlottOrderListenerAssignments = false;
        ArrayList<String> affectedSubProjects = new ArrayList<String>();
        ArrayList<String> references = new ArrayList<String>();
        ProjectParticipation pp = this.projectParticipationDAO.get(participationId);
        Project p = this.getProject(pp.getProject().getId());
        Collection subProjects = p.getSubProjects().values();
        for (Object subProject : subProjects) {
            boolean isSubProjectAffected = false;
            Collection cycleInstances = ((SubProject)subProject).getReviewCycleInstances().values();
            block1: for (ReviewCycleInstanceImpl cycleInstance : cycleInstances) {
                ReviewCycleInstanceRelease rciRel;
                Collection cellInstances = cycleInstance.getReviewCycleCellInstances().values();
                Iterator iterator = cellInstances.iterator();
                while (iterator.hasNext()) {
                    ReviewCycleCellInstanceImpl cellInstance = (ReviewCycleCellInstanceImpl)iterator.next();
                    Iterator nodeInstances = cellInstance.getReviewCycleNodeInstances().values();
                    Iterator iterator2 = nodeInstances.iterator();
                    while (iterator2.hasNext()) {
                        Object position2;
                        ReviewCycleNodeInstanceImpl nodeInstance = (ReviewCycleNodeInstanceImpl)iterator2.next();
                        Collection positions = nodeInstance.getReviewCyclePositions().values();
                        ArrayList deletePositions = new ArrayList();
                        for (Object position2 : positions) {
                            if (!((ReviewCyclePositionImpl)position2).getProjectParticipation().getId().equals(participationId)) continue;
                            isSubProjectAffected = true;
                            hasUnreleasedObjectListAssignments = true;
                            references.add("Einteilung in einem Pr\u00fcfblatt f\u00fcr den Fachbereich '" + TapestryI18nHelper.getLocalizedString(((ReviewCyclePositionImpl)position2).getRealm().getName()) + "' mit der Rolle '" + ((ReviewCyclePositionImpl)position2).getProjectParticipation().getRole().getName() + "'<br/>Pr\u00fcfblatt: " + TapestryI18nHelper.getLocalizedString(cycleInstance.getName()) + " (" + TapestryI18nHelper.getLocalizedString(cellInstance.getReviewCycleCell().getName()) + " - " + TapestryI18nHelper.getLocalizedString(nodeInstance.getReviewCycleNode().getName()) + ")<br/>Projektstatus: " + ((SubProject)subProject).getCode() + " " + ((SubProject)subProject).getName());
                        }
                        Collection nodeListeners = nodeInstance.getReviewCycleNode().getListeners().values();
                        position2 = nodeListeners.iterator();
                        while (position2.hasNext()) {
                            PlottOrderTemplate plottOrderTemplate;
                            ReviewCycleNodeListener nodeListener = (ReviewCycleNodeListener)position2.next();
                            ReviewCycleNodeInstanceListener instanceListener = this.reviewCycleOperations.getReviewCycleNodeInstanceListenerByInstance(nodeListener.getId(), nodeInstance.getId());
                            if (instanceListener instanceof ReviewCycleNodeInstanceNotification && ((ReviewCycleNodeInstanceNotification)instanceListener).getReference().containsKey(participationId)) {
                                isSubProjectAffected = true;
                                hasNotificationListenerAssignments = true;
                                references.add("Eingeteilt als Empf\u00e4nger f\u00fcr Email-Benachrichtigung<br/>Pr\u00fcfblatt: " + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getName()) + " (" + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleCell().getName()) + " - " + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleNode().getName()) + ")<br/>Projektstatus: " + ((SubProject)subProject).getCode() + " " + ((SubProject)subProject).getName());
                                continue;
                            }
                            if (!(instanceListener instanceof ReviewCycleNodeInstancePlottOrderListener) || (plottOrderTemplate = ((ReviewCycleNodeInstancePlottOrderListener)instanceListener).getReference()) == null || !plottOrderTemplate.getTemplateResolver().equals("ProjectParticipationPlotTemplate")) continue;
                            Collection itemTempls = plottOrderTemplate.getOrderItems().values();
                            boolean templsFound = false;
                            for (PlottOrderItemTemplate itemTempl : itemTempls) {
                                if (itemTempl.isInvalidated() || itemTempl.getDeliveryAddressId() == null || !itemTempl.getDeliveryAddressId().equals(participationId)) continue;
                                isSubProjectAffected = true;
                                hasPlottOrderListenerAssignments = true;
                                references.add("Eingeteilt als Empf\u00e4nger in einer Vorlage f\u00fcr Plotauftr\u00e4ge<br/>Pr\u00fcfblatt: " + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getName()) + " (" + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleCell().getName()) + " - " + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleNode().getName()) + ")<br/>Projektstatus: " + ((SubProject)subProject).getCode() + " " + ((SubProject)subProject).getName());
                            }
                        }
                    }
                    Collection freenodeInstances = cellInstance.getFreeReviewCycleNodeInstances().values();
                    for (Object nodeInstance : freenodeInstances) {
                        Collection nodeListeners = ((ReviewCycleNodeInstanceImpl)nodeInstance).getReviewCycleNode().getListeners().values();
                        for (Object nodeListener : nodeListeners) {
                            PlottOrderTemplate plottOrderTemplate;
                            ReviewCycleNodeInstanceListener instanceListener = this.reviewCycleOperations.getReviewCycleNodeInstanceListenerByInstance(((ReviewCycleNodeListener)nodeListener).getId(), ((ReviewCycleNodeInstanceImpl)nodeInstance).getId());
                            if (instanceListener instanceof ReviewCycleNodeInstanceNotification && ((ReviewCycleNodeInstanceNotification)instanceListener).getReference().containsKey(participationId)) {
                                hasNotificationListenerAssignments = true;
                                isSubProjectAffected = true;
                                references.add("Eingeteilt als Empf\u00e4nger f\u00fcr Email-Benachrichtigung<br/>Pr\u00fcfblatt: " + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getName()) + " (" + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleCell().getName()) + " - " + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleNode().getName()) + ")<br/>Projektstatus: " + ((SubProject)subProject).getCode() + " " + ((SubProject)subProject).getName());
                                continue;
                            }
                            if (!(instanceListener instanceof ReviewCycleNodeInstancePlottOrderListener) || (plottOrderTemplate = ((ReviewCycleNodeInstancePlottOrderListener)instanceListener).getReference()) == null || !plottOrderTemplate.getTemplateResolver().equals("ProjectParticipationPlotTemplate")) continue;
                            Collection itemTempls = plottOrderTemplate.getOrderItems().values();
                            boolean templsFound = false;
                            for (PlottOrderItemTemplate itemTempl : itemTempls) {
                                if (itemTempl.isInvalidated() || itemTempl.getDeliveryAddressId() == null || !itemTempl.getDeliveryAddressId().equals(participationId)) continue;
                                hasPlottOrderListenerAssignments = true;
                                isSubProjectAffected = true;
                                references.add("Eingeteilt als Empf\u00e4nger in einer Vorlage f\u00fcr Plotauftr\u00e4ge<br/>Pr\u00fcfblatt: " + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance().getName()) + " (" + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleCell().getName()) + " - " + TapestryI18nHelper.getLocalizedString(instanceListener.getReviewCycleNodeInstance().getReviewCycleNode().getName()) + ")<br/>Projektstatus: " + ((SubProject)subProject).getCode() + " " + ((SubProject)subProject).getName());
                            }
                        }
                    }
                }
                if (((SubProject)subProject).getActiveObjectList() == null || hasReleasedObjectListAssignments || (rciRel = this.reviewCycleOperations.getReleased(((SubProject)subProject).getActiveObjectList().getId(), cycleInstance.getId())) == null) continue;
                Collection rccisRel = rciRel.getReviewCycleCellInstances().values();
                for (ReviewCycleCellInstanceRelease rcciRel : rccisRel) {
                    Object rcniRel;
                    Object nodeInstance;
                    Collection rcnisRel = rcciRel.getReviewCycleNodeInstances().values();
                    nodeInstance = rcnisRel.iterator();
                    while (nodeInstance.hasNext()) {
                        Object nodeListener;
                        rcniRel = (ReviewCycleNodeInstanceRelease)nodeInstance.next();
                        Collection positionsRel = ((ReviewCycleNodeInstanceRelease)rcniRel).getReviewCyclePositions().values();
                        nodeListener = positionsRel.iterator();
                        while (nodeListener.hasNext()) {
                            ReviewCyclePositionRelease positionRel = (ReviewCyclePositionRelease)nodeListener.next();
                            if (!positionRel.getProjectParticipation().getId().equals(pp.getId())) continue;
                            hasReleasedObjectListAssignments = true;
                            isSubProjectAffected = true;
                            break;
                        }
                        if (!hasReleasedObjectListAssignments) continue;
                        break;
                    }
                    Collection freeRcnisRel = rcciRel.getFreeReviewCycleNodeInstances().values();
                    rcniRel = freeRcnisRel.iterator();
                    while (rcniRel.hasNext()) {
                        ReviewCycleNodeInstanceRelease rcniRel2 = (ReviewCycleNodeInstanceRelease)rcniRel.next();
                        Collection positionsRel = rcniRel2.getReviewCyclePositions().values();
                        for (ReviewCyclePositionRelease positionRel : positionsRel) {
                            if (!positionRel.getProjectParticipation().getId().equals(pp.getId())) continue;
                            hasReleasedObjectListAssignments = true;
                            isSubProjectAffected = true;
                            break;
                        }
                        if (!hasReleasedObjectListAssignments) continue;
                        break;
                    }
                    if (!hasReleasedObjectListAssignments) continue;
                    continue block1;
                }
            }
            ObjectListImpl olist = ((SubProject)subProject).getEditObjectList();
            Collection objects = olist.getObjects().values();
            for (CDESObjectImpl object : objects) {
                if (object.isInactive()) continue;
                Collection objectPlanners = object.getObjectPlanners().values();
                for (ObjectPlannerImpl objectPlanner : objectPlanners) {
                    if (objectPlanner.isInactive()) continue;
                    if (objectPlanner.getPlanner() != null && objectPlanner.getPlanner().getId().equals(participationId)) {
                        isSubProjectAffected = true;
                        hasUnreleasedObjectListAssignments = true;
                        references.add("Eingeteilt mit der Rolle \"" + objectPlanner.getPlanner().getRole().getName() + "\"<br/>Objekt - Objektblatt: " + objectPlanner.getObject().getCode() + " " + objectPlanner.getObject().getName() + " - " + objectPlanner.getCode() + " " + objectPlanner.getArea() + "<br/>Projektstatus: " + ((SubProject)subProject).getCode() + " " + ((SubProject)subProject).getName());
                    }
                    Collection positions = objectPlanner.getPositions().values();
                    for (ObjectPlannerPositionImpl position : positions) {
                        if (!position.getProjectParticipation().getId().equals(participationId)) continue;
                        isSubProjectAffected = true;
                        hasUnreleasedObjectListAssignments = true;
                        references.add("Eingeteilt mit der Rolle \"" + position.getRole().getName() + "\"<br/>Objekt - Objektblatt: " + objectPlanner.getObject().getCode() + " " + objectPlanner.getObject().getName() + " - " + objectPlanner.getCode() + " " + objectPlanner.getArea() + "<br/>Projektstatus: " + ((SubProject)subProject).getCode() + " " + ((SubProject)subProject).getName());
                    }
                }
            }
            if (((SubProject)subProject).getActiveObjectList() != null && !hasReleasedObjectListAssignments) {
                ReleasedObjectList relObjectList = ((SubProject)subProject).getActiveObjectList();
                Collection relObjects = relObjectList.getObjects().values();
                for (ReleasedCDESObject relObject : relObjects) {
                    if (relObject.getObjectPlanners() == null) continue;
                    Collection relObjectPlanners = relObject.getObjectPlanners().values();
                    for (ReleasedObjectPlanner relObjectPlanner : relObjectPlanners) {
                        Collection relPositions = relObjectPlanner.getPositions().values();
                        for (ReleasedObjectPlannerPosition relPosition : relPositions) {
                            if (relPosition.getProjectParticipation() == null || !relPosition.getProjectParticipation().getId().equals(pp.getId())) continue;
                            hasReleasedObjectListAssignments = true;
                            isSubProjectAffected = true;
                            break;
                        }
                        if (relObjectPlanner.getPlanner() != null && relObjectPlanner.getPlanner().getId().equals(pp.getId())) {
                            isSubProjectAffected = true;
                            hasReleasedObjectListAssignments = true;
                        }
                        if (!hasReleasedObjectListAssignments) continue;
                        break;
                    }
                    if (!hasReleasedObjectListAssignments) continue;
                    break;
                }
            }
            if (!isSubProjectAffected) continue;
            affectedSubProjects.add(((SubProject)subProject).getCode() + " " + ((SubProject)subProject).getName());
        }
        Collection templatesOfProject = this.orderDAO.getTemplatesOfProject(pp.getProject().getId());
        for (PlottOrderTemplate template : templatesOfProject) {
            if (template.isInvalidated()) continue;
            if (template.getPlotterId() != null && template.getPlotterId().equals(participationId)) {
                hasPlottOrderListenerAssignments = true;
                references.add("Eingeteilt als Auftragnehmer f\u00fcr Plotauftr\u00e4ge in Plotvorlage<br/>Plotvorlage: " + template.getName());
            }
            Collection items = template.getOrderItems().values();
            for (PlottOrderItemTemplate item : items) {
                if (item.isInvalidated() || item.getDeliveryAddressId() == null || !item.getDeliveryAddressId().equals(participationId)) continue;
                hasPlottOrderListenerAssignments = true;
                references.add("Eingeteilt als Empf\u00e4nger f\u00fcr Plotauftr\u00e4ge in Plotvorlage<br/>Plotvorlage: " + template.getName());
            }
        }
        List attachedtasks = this.reviewOperations.getAttachedReviewTasksByProjectParticipation(participationId);
        for (AttachedReviewTask task : attachedtasks) {
            references.add("Eingeteilt als optionaler Pr\u00fcfer f\u00fcr Plan '" + task.getDocumentVersion().getName() + "' <br/> Fachbereich(e): " + task.getRealmDescription());
            hasAttachedReviewTasks = true;
        }
        String errorCancelOption = "";
        String errorHeadline = "";
        String errorDeleteOptionDescription = "";
        String errorDeleteOptionHeadline = "";
        errorHeadline = "Der Projektteilnehmer konnte nicht gel\u00f6scht werden, da Referenzen gefunden wurden.";
        if (!references.isEmpty() && hasReleasedObjectListAssignments) {
            errorHeadline = errorHeadline + " Erst nachdem diese Referenzen gel\u00f6scht wurden, kann der Projektteilnehmer zum l\u00f6schen markiert werden.";
            if (hasUnreleasedObjectListAssignments) {
                errorHeadline = errorHeadline + " Damit der Projektteilnehmer endg\u00fcltig gel\u00f6scht wird, m\u00fcssen anschlie\u00dfend alle zugeh\u00f6rigen Objektlisten freigegeben werden.";
            }
        } else if (!references.isEmpty() && !hasReleasedObjectListAssignments) {
            errorHeadline = errorHeadline + " Erst nachdem diese Referenzen gel\u00f6scht wurden kann der Projektteilnehmer gel\u00f6scht werden.";
        }
        errorDeleteOptionHeadline = hasUnreleasedObjectListAssignments && hasReleasedObjectListAssignments ? "Automatisch alle Referenzen entfernen und Projektteilnehmer zum L\u00f6schen markieren" : (!hasUnreleasedObjectListAssignments && hasReleasedObjectListAssignments && !hasAttachedReviewTasks && !hasNotificationListenerAssignments && !hasPlottOrderListenerAssignments || references.isEmpty() ? "Projektteilnehmer zum L\u00f6schen markieren" : "Automatisch alle Referenzen entfernen und Projektteilnehmer l\u00f6schen");
        if (hasUnreleasedObjectListAssignments) {
            errorDeleteOptionDescription = "Der Projektteilnehmer wird automatisch aus allen Pr\u00fcf- und Objektbl\u00e4ttern entfernt. ";
        }
        if (hasAttachedReviewTasks) {
            errorDeleteOptionDescription = errorDeleteOptionDescription + "Alle Einteilungen als Optionaler Pr\u00fcfer werden gel\u00f6scht. ";
        }
        if (hasNotificationListenerAssignments && !hasPlottOrderListenerAssignments) {
            errorDeleteOptionDescription = errorDeleteOptionDescription + "Es werden alle Einteilungen als Emf\u00e4nger von Benachrichtigungsemails ausgetragen. ";
        } else if (!hasNotificationListenerAssignments && hasPlottOrderListenerAssignments) {
            errorDeleteOptionDescription = errorDeleteOptionDescription + "Es werden alle Einteilungen als Emf\u00e4nger bzw. Auftraggeber von Plotauftr\u00e4gen ausgetragen. ";
        } else if (hasNotificationListenerAssignments && hasPlottOrderListenerAssignments) {
            errorDeleteOptionDescription = errorDeleteOptionDescription + "Es werden alle Einteilungen als Emf\u00e4nger von Benachrichtigungsemails sowie alle Einteilungen als Emf\u00e4nger bzw. Auftraggeber von Plotauftr\u00e4gen ausgetragen. ";
        }
        errorDeleteOptionDescription = hasReleasedObjectListAssignments && !references.isEmpty() ? errorDeleteOptionDescription + "Anschlie\u00dfend wird dieser Projektteilnehmer zum L\u00f6schen markiert. Nachdem die Objektlisten aller betroffenen Projektstati freigegeben wurden, wird dieser Projektteilnehmer automatisch endg\u00fcltig gel\u00f6scht. ACHTUNG: Das L\u00f6schen dieser Einteilungen kann nicht r\u00fcckg\u00e4ngig gemacht werden!" : (!references.isEmpty() ? errorDeleteOptionDescription + "Anschlie\u00dfend wird dieser Projektteilnehmer gel\u00f6scht. ACHTUNG: Das L\u00f6schen dieses Projektteilnehmers und dessen Einteilungen kann nicht r\u00fcckg\u00e4ngig gemacht werden!" : errorDeleteOptionDescription + "Nachdem die Objektlisten aller betroffenen Projektstati freigegeben wurden, wird dieser Projektteilnehmer automatisch gel\u00f6scht.");
        errorCancelOption = hasReleasedObjectListAssignments ? "Abbrechen und den Projektteilehmer nicht zum L\u00f6schen markieren. " : "Abbrechen und den Projektteilehmer nicht l\u00f6schen. ";
        Object[] ret = new Object[]{references, errorHeadline, errorDeleteOptionHeadline, errorDeleteOptionDescription, errorCancelOption, affectedSubProjects};
        return ret;
    }

    public void setTaskOperations(TaskOperations taskOperations) {
        this.taskOperations = taskOperations;
    }

    public void setReviewCyclePositionDAO(ReviewCyclePositionDAO reviewCyclePositionDAO) {
        this.reviewCyclePositionDAO = reviewCyclePositionDAO;
    }

    @Override
    public boolean invalidateSubProject(Integer subProjectId) {
        SubProject sp = this.getSubProject(subProjectId);
        if (this.orderOperations.deleteInvalidOrdersAndCheckForExistingOpenPlotOrdersForSubProject(sp)) {
            return false;
        }
        ObjectListImpl olist = sp.getEditObjectList();
        Collection objects = olist.getObjects().values();
        for (CDESObjectImpl object : objects) {
            this.objectOperations.inactivateObject(object);
        }
        List<Task> spTasks = this.taskOperations.getAllDeletableTasksOfSubProject(subProjectId);
        for (Task task : spTasks) {
            if (task instanceof PlotOrderAcceptanceTask) {
                OrderStep step = ((PlotOrderAcceptanceTask)task).getOrderStep();
                PlottOrder order = ((PlotOrderAcceptanceTask)task).getOrder();
                Collection items = order.getOrderItems().values();
                boolean allItemsInvalid = true;
                for (PlottOrderItem item : items) {
                    if (item.getDocumentVersion().getDocument().getDocumentList().getSubProject().getId().equals(subProjectId)) continue;
                    allItemsInvalid = false;
                    break;
                }
                if (!allItemsInvalid) continue;
                this.taskOperations.removeTask(task.getId());
                continue;
            }
            this.taskOperations.removeTask(task.getId());
        }
        sp.setInvalidated(true);
        this.subProjectDAO.update(sp);
        return true;
    }

    @Override
    public void updateSubProjectAdditionalRoleTypesEvaluation(boolean readOnly) {
        int releasedPositionCount = 0;
        HashMap<Integer, Project> projects = new HashMap<Integer, Project>();
        HashMap subProjects = new HashMap();
        List releasedPositions = this.reviewCyclePositionDAO.getReleasedPositionsForAdditionalRoleTypeEvaluation();
        List unreleasedPositions = this.reviewCyclePositionDAO.getUnreleasedPositionsForAdditionalRoleTypeEvaluation();
        logger.info((Object)"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        logger.info((Object)("++++++++++++++++++++++++++ START updateSubProjectAdditionalRoleTypesEvaluation() readOnly=[" + readOnly + "]"));
        if (!releasedPositions.isEmpty()) {
            logger.info((Object)"########################################         Aktuell freigegeben:");
            for (ReviewCyclePosition pos : releasedPositions) {
                ReviewCycleInstanceRelease cycleInstRel = (ReviewCycleInstanceRelease)pos.getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance();
                if (!cycleInstRel.getObjectList().getId().equals(cycleInstRel.getSubProject().getActiveObjectList().getId())) continue;
                ++releasedPositionCount;
                logger.info((Object)("ReviewCyclePositionRelease Id=[" + pos.getId() + "] cycleInstanceReleaseId=[" + cycleInstRel.getId() + "] cycleInstanceName=[" + TapestryI18nHelper.getLocalizedString(cycleInstRel.getName()) + "] roleType=[" + pos.getProjectParticipation().getRole().getType().getName() + "] verantwortlich=[" + pos.getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName() + "] fachbereich=[" + TapestryI18nHelper.getLocalizedString(pos.getRealm().getName()) + "] subProject=[" + cycleInstRel.getSubProject().getCode() + " " + cycleInstRel.getSubProject().getName() + "] subProjectId=[" + cycleInstRel.getSubProject().getId() + "] project=[" + cycleInstRel.getSubProject().getProject().getCode() + " " + cycleInstRel.getSubProject().getProject().getName() + "] projectId=[" + cycleInstRel.getSubProject().getProject().getId() + "] network=[" + cycleInstRel.getSubProject().getProject().getNetwork().getName() + "]"));
                projects.put(cycleInstRel.getSubProject().getProject().getId(), cycleInstRel.getSubProject().getProject());
                if (subProjects.get(cycleInstRel.getSubProject().getProject().getId()) == null) {
                    subProjects.put(cycleInstRel.getSubProject().getProject().getId(), new HashMap());
                }
                ((HashMap)subProjects.get(cycleInstRel.getSubProject().getProject().getId())).put(cycleInstRel.getSubProject().getId(), cycleInstRel.getSubProject());
            }
        }
        if (!unreleasedPositions.isEmpty()) {
            logger.info((Object)"########################################         Nicht freigegeben:");
            for (ReviewCyclePosition pos : unreleasedPositions) {
                ReviewCycleInstance cycleInst = ((ReviewCyclePositionImpl)pos).getReviewCycleNodeInstance().getReviewCycleCellInstance().getReviewCycleInstance();
                logger.info((Object)("ReviewCyclePositionImpl Id=[" + ((ReviewCyclePositionImpl)pos).getId() + "] cycleInstanceReleaseId=[" + cycleInst.getId() + "] cycleInstanceName=[" + TapestryI18nHelper.getLocalizedString(cycleInst.getName()) + "] roleType=[" + ((ReviewCyclePositionImpl)pos).getProjectParticipation().getRole().getType().getName() + "] verantwortlich=[" + ((ReviewCyclePositionImpl)pos).getProjectParticipation().getMainParticipant().getOrganisationPerson().getPerson().getInverseCommonName() + "] fachbereich=[" + TapestryI18nHelper.getLocalizedString(((ReviewCyclePositionImpl)pos).getRealm().getName()) + "] subProject=[" + cycleInst.getSubProject().getCode() + " " + cycleInst.getSubProject().getName() + "] subProjectId=[" + cycleInst.getSubProject().getId() + "] project=[" + cycleInst.getSubProject().getProject().getCode() + " " + cycleInst.getSubProject().getProject().getName() + "] projectId=[" + cycleInst.getSubProject().getProject().getId() + "] network=[" + cycleInst.getSubProject().getProject().getNetwork().getName() + "]"));
                projects.put(cycleInst.getSubProject().getProject().getId(), cycleInst.getSubProject().getProject());
                if (subProjects.get(cycleInst.getSubProject().getProject().getId()) == null) {
                    subProjects.put(cycleInst.getSubProject().getProject().getId(), new HashMap());
                }
                ((HashMap)subProjects.get(cycleInst.getSubProject().getProject().getId())).put(cycleInst.getSubProject().getId(), cycleInst.getSubProject());
            }
        }
        logger.info((Object)"++++++++++++++++++++++++++ ENDE updateSubProjectAdditionalRoleTypesEvaluation()");
        logger.info((Object)("Zusammenfassung: freigegebene Positionen=[" + releasedPositionCount + "]; nicht freigegebene Positionen=[" + unreleasedPositions.size() + "]"));
        logger.info((Object)"Betroffene Projekte mit zugeh\u00f6rigen SubProjekten:");
        int subprojectsChanged = 0;
        for (Project project : projects.values()) {
            String ps = "";
            ps = ps + "Projekt Code+Name=[" + project.getCode() + " " + project.getName() + "]; ID=[" + project.getId() + "]; Erstellungsdatum=[" + project.getCreated() + "]; Netzwerk=[" + project.getNetwork().getName() + "]; Anzahl SubProjekte gesamt=[" + project.getSubProjects().size() + "]; Anzahl betroffener SubProjekte=[" + ((HashMap)subProjects.get(project.getId())).size() + "]\n";
            for (SubProject sp : ((HashMap)subProjects.get(project.getId())).values()) {
                ps = ps + "             betroffenes SubProjekt Code+Name=[" + sp.getCode() + " " + sp.getName() + "]; ID=[" + sp.getId() + "]\n";
                if (readOnly) continue;
                sp.setWithAdditionalRoleTypes(true);
                this.subProjectDAO.update(sp);
                ps = ps + "                         -> subProject updated: withAdditionalRoleTypes=true\n";
                ++subprojectsChanged;
            }
            logger.info((Object)ps);
        }
        if (!readOnly) {
            logger.info((Object)("-------> Anzahl der betroffenen SubProjekte=[" + subprojectsChanged + "]\n"));
        }
        logger.info((Object)"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
    }

    @Override
    public boolean isProjectWithDocuments(Integer projectId) {
        Project p = this.projectDAO.get(projectId);
        if (p.getSubProjects() != null) {
            for (SubProject sp : p.getSubProjects().values()) {
                if (sp.getEditDocumentList().getDocuments() == null || sp.getEditDocumentList().getDocuments().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void insertCopyOfSubProjectRestrictionsForParticipations(SubProject sourceSubProject, SubProject destSubProject) {
        List<ProjectParticipation> pps = this.projectParticipationDAO.getAll(sourceSubProject.getProject().getId());
        for (ProjectParticipation pp : pps) {
            if (pp.getExcludedSubProjects() == null || !pp.getExcludedSubProjects().containsKey(sourceSubProject.getId())) continue;
            pp.getExcludedSubProjects().put(destSubProject.getId(), destSubProject);
            this.projectParticipationDAO.update(pp);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void insertCopyOfSubProjectWithSubElements(Integer sourceSubProjectId, String name, String comment, Integer subProjectTypeId, Integer number) {
        SubProjectCopyContainer subProjectCopyContainer = new SubProjectCopyContainer();
        logger.info((Object)("copy subProject with id=[" + sourceSubProjectId + "] "));
        SubProject sourceSubProject = this.subProjectDAO.get(sourceSubProjectId);
        SubProjectType sptype = this.subProjectTypeDAO.get(subProjectTypeId);
        SubProject destSubProject = new SubProject();
        destSubProject.setSubProjectType(sptype);
        destSubProject.setCodeWithoutNumber(sptype.getCode());
        destSubProject.setName(name);
        destSubProject.setComment(comment);
        destSubProject.setNumber(number);
        destSubProject.setProject(sourceSubProject.getProject());
        destSubProject.setWithAdditionalRoleTypes(sourceSubProject.isWithAdditionalRoleTypes());
        destSubProject = this.subProjectDAO.save(destSubProject);
        logger.info((Object)"starting to copy references to excluded projectParticipations");
        this.insertCopyOfSubProjectRestrictionsForParticipations(sourceSubProject, destSubProject);
        logger.info((Object)"starting to copy objectLists");
        subProjectCopyContainer = this.objectOperations.insertCopyOfObjectListWithSubElements(sourceSubProjectId, destSubProject.getId(), subProjectCopyContainer);
        logger.info((Object)"starting to copy documentLists");
        try {
            subProjectCopyContainer = this.planDeliverCatalogueOperations.insertCopyOfDocumentListWithSubElements(sourceSubProjectId, destSubProject.getId(), subProjectCopyContainer);
        }
        catch (NumberCalculatorException e) {
            throw new ActionException("Caught Exception during generation of documentNumber!", e);
        }
        logger.info((Object)"starting to copy attachments");
        for (Integer n : subProjectCopyContainer.getDocumentVersionIds().keySet()) {
            List<Attachment> list = this.attachmentDAO.getAll(n);
            for (Attachment sourceAttachment : list) {
                Attachment destAttachment = new Attachment();
                destAttachment.setComment(sourceAttachment.getComment());
                destAttachment.setCreated(sourceAttachment.getCreated());
                destAttachment.setDigest(sourceAttachment.getDigest());
                destAttachment.setDigestCalculatorType(sourceAttachment.getDigestCalculatorType());
                destAttachment.setDocumentVersionId(subProjectCopyContainer.getDocumentVersionIds().get(n));
                destAttachment.setFileName(sourceAttachment.getFileName());
                destAttachment.setFileType(sourceAttachment.getFileType());
                destAttachment.setKey(sourceAttachment.getKey());
                destAttachment.setOriginalName(sourceAttachment.getOriginalName());
                destAttachment.setProjectParticipantId(sourceAttachment.getProjectParticipantId());
                destAttachment.setRedliningDelta(sourceAttachment.isRedliningDelta());
                destAttachment.setReviewCycleNodeId(sourceAttachment.getReviewCycleNodeId());
                destAttachment = this.attachmentDAO.save(destAttachment);
                subProjectCopyContainer.getAttachmentIds().put(sourceAttachment.getId(), destAttachment.getId());
            }
        }
        logger.info((Object)"starting to copy attachedReviewCyclePositions");
        List<AttachedReviewCyclePositionImpl> sourcePositions = this.reviewCyclePositionDAO.getAllAttachedPositionsOfSubProject(sourceSubProjectId);
        for (AttachedReviewCyclePositionImpl attachedReviewCyclePositionImpl : sourcePositions) {
            AttachedReviewCyclePositionImpl attachedReviewCyclePositionImpl2 = new AttachedReviewCyclePositionImpl();
            attachedReviewCyclePositionImpl2.setDocumentVersion(this.reviewOperations.getDocumentVersion(subProjectCopyContainer.getDocumentVersionIds().get(attachedReviewCyclePositionImpl.getDocumentVersion().getId())));
            attachedReviewCyclePositionImpl2.setProjectParticipation(attachedReviewCyclePositionImpl.getProjectParticipation());
            attachedReviewCyclePositionImpl2.setRealm(attachedReviewCyclePositionImpl.getRealm());
            attachedReviewCyclePositionImpl2.setReviewCycleNodeInstance(this.reviewCycleOperations.getReviewCycleNodeInstance(subProjectCopyContainer.getReviewCycleNodeInstanceImplIds().get(attachedReviewCyclePositionImpl.getReviewCycleNodeInstance().getId())));
            AttachedReviewCyclePositionImpl attachedReviewCyclePositionImpl3 = this.reviewCyclePositionDAO.save(attachedReviewCyclePositionImpl2);
            subProjectCopyContainer.getAttachedReviewCyclePositoinIds().put(attachedReviewCyclePositionImpl.getId(), attachedReviewCyclePositionImpl3.getId());
        }
        logger.info((Object)"starting to copy review stuff");
        subProjectCopyContainer = this.reviewOperations.insertCopyOfDocumentVersionReviewCycleForSubProject(sourceSubProjectId, destSubProject.getId(), subProjectCopyContainer);
        logger.info((Object)"starting to copy plot- and originalDocumentOrders");
        subProjectCopyContainer = this.orderOperations.insertCopiesOfOrdersForSubProject(sourceSubProject, destSubProject, subProjectCopyContainer);
        logger.info((Object)"starting to copy documentVersion related email snippets");
        List<StatusEMailSnippet> list = this.mailDAO.getAllStatusEmailSnippetsForSubProject(sourceSubProjectId);
        for (StatusEMailSnippet statusEMailSnippet : list) {
            StatusEMailSnippet destSnippet = new StatusEMailSnippet();
            destSnippet.setDocumentVersion(this.reviewOperations.getDocumentVersion(subProjectCopyContainer.getDocumentVersionIds().get(statusEMailSnippet.getDocumentVersion().getId())));
            destSnippet.setOrganisationPersonId(statusEMailSnippet.getOrganisationPersonId());
            destSnippet.setSendTime(statusEMailSnippet.getSendTime());
            destSnippet.setType(statusEMailSnippet.getType());
            this.mailDAO.insertSnippet(destSnippet);
        }
        List<NodeListenerEMailSnippet> list2 = this.mailDAO.getAllNodeListenerEmailSnippetsForSubProject(sourceSubProjectId);
        for (NodeListenerEMailSnippet sourceSnippet : list2) {
            NodeListenerEMailSnippet destSnippet = new NodeListenerEMailSnippet();
            destSnippet.setDocumentVersion(this.reviewOperations.getDocumentVersion(subProjectCopyContainer.getDocumentVersionIds().get(sourceSnippet.getDocumentVersion().getId())));
            destSnippet.setNodeListener(sourceSnippet.getNodeListener());
            destSnippet.setOrganisationPersonId(sourceSnippet.getOrganisationPersonId());
            destSnippet.setSendTime(sourceSnippet.getSendTime());
            this.mailDAO.insertSnippet(destSnippet);
        }
        logger.info((Object)"starting to copy tasks with taskEmailSnippets and futureEmails");
        subProjectCopyContainer = this.taskOperations.insertCopiesOfTaskForSubProject(sourceSubProject, destSubProject, subProjectCopyContainer);
        logger.info((Object)("----Finished copying of subProject with id=[" + sourceSubProjectId + "] - new subProject id=[" + destSubProject.getId() + "]"));
        logger.info((Object)"Mappings of some ids of form 'sourceObjectId'='destinationObjectId'");
        logger.info((Object)("Mapping of AttachmentIds copied (" + subProjectCopyContainer.getAttachmentIds().size() + " elements): " + subProjectCopyContainer.getAttachmentIds()));
        logger.info((Object)("Mapping of CellResultIds copied (" + subProjectCopyContainer.getCellResultIds().size() + " elements): " + subProjectCopyContainer.getCellResultIds()));
        logger.info((Object)("Mapping of DocumentImplIds copied (" + subProjectCopyContainer.getDocumentImplIds().size() + " elements): " + subProjectCopyContainer.getDocumentImplIds()));
        logger.info((Object)("Mapping of DocumentListReleaseIds copied (" + subProjectCopyContainer.getDocumentListReleaseIds().size() + " elements): " + subProjectCopyContainer.getDocumentListReleaseIds()));
        logger.info((Object)("Mapping of DocumentVersionIds copied (" + subProjectCopyContainer.getDocumentVersionIds().size() + " elements): " + subProjectCopyContainer.getDocumentVersionIds()));
        logger.info((Object)("Mapping of DocumentVersionsWithRevisionsIds copied (" + subProjectCopyContainer.getDocumentVersionsWithRevisionsIds().size() + " elements): " + subProjectCopyContainer.getDocumentVersionsWithRevisionsIds()));
        logger.info((Object)("Mapping of NodeResultIds copied (" + subProjectCopyContainer.getNodeResultIds().size() + " elements): " + subProjectCopyContainer.getNodeResultIds()));
        logger.info((Object)("Mapping of ObjectImplIds copied (" + subProjectCopyContainer.getObjectImplIds().size() + " elements): " + subProjectCopyContainer.getObjectImplIds()));
        logger.info((Object)("Mapping of ObjectListReleaseIds copied (" + subProjectCopyContainer.getObjectListReleaseIds().size() + " elements): " + subProjectCopyContainer.getObjectListReleaseIds()));
        logger.info((Object)("Mapping of ObjectPlannerImplIds copied (" + subProjectCopyContainer.getObjectPlannerImplIds().size() + " elements): " + subProjectCopyContainer.getObjectPlannerImplIds()));
        logger.info((Object)("Mapping of ObjectPlannerPositionImplIds copied (" + subProjectCopyContainer.getObjectPlannerPositionImplIds().size() + " elements): " + subProjectCopyContainer.getObjectPlannerPositionImplIds()));
        logger.info((Object)("Mapping of ObjectPlannerReleaseIds copied (" + subProjectCopyContainer.getObjectPlannerReleaseIds().size() + " elements): " + subProjectCopyContainer.getObjectPlannerReleaseIds()));
        logger.info((Object)("Mapping of OrderItemIds copied (" + subProjectCopyContainer.getOrderItemIds().size() + " elements): " + subProjectCopyContainer.getOrderItemIds()));
        logger.info((Object)("Mapping of OriginalDocumentOrderIds copied (" + subProjectCopyContainer.getOriginalDocumentOrderIds().size() + " elements): " + subProjectCopyContainer.getOriginalDocumentOrderIds()));
        logger.info((Object)("Mapping of OriginalDocumentOrderOrderStepIds copied (" + subProjectCopyContainer.getOriginalDocumentOrderOrderStepIds().size() + " elements): " + subProjectCopyContainer.getOriginalDocumentOrderOrderStepIds()));
        logger.info((Object)("Mapping of PositionResultIds copied (" + subProjectCopyContainer.getPositionResultIds().size() + " elements): " + subProjectCopyContainer.getPositionResultIds()));
        logger.info((Object)("Mapping of ReviewCycleCellInstanceImplIds copied (" + subProjectCopyContainer.getReviewCycleCellInstanceImplIds().size() + " elements): " + subProjectCopyContainer.getReviewCycleCellInstanceImplIds()));
        logger.info((Object)("Mapping of ReviewCycleEntryResultIds copied (" + subProjectCopyContainer.getReviewCycleEntryResultIds().size() + " elements): " + subProjectCopyContainer.getReviewCycleEntryResultIds()));
        logger.info((Object)("Mapping of ReviewCycleInstanceImplIds copied (" + subProjectCopyContainer.getReviewCycleInstanceImplIds().size() + " elements): " + subProjectCopyContainer.getReviewCycleInstanceImplIds()));
        logger.info((Object)("Mapping of ReviewCycleInstanceReleaseIds copied (" + subProjectCopyContainer.getReviewCycleInstanceReleaseIds().size() + " elements): " + subProjectCopyContainer.getReviewCycleInstanceReleaseIds()));
        logger.info((Object)("Mapping of ReviewCycleNodeInstanceImplIds copied (" + subProjectCopyContainer.getReviewCycleNodeInstanceImplIds().size() + " elements): " + subProjectCopyContainer.getReviewCycleNodeInstanceImplIds()));
        logger.info((Object)("Mapping of ReviewCycleNodePositionImplIds copied (" + subProjectCopyContainer.getReviewCycleNodePositionImplIds().size() + " elements): " + subProjectCopyContainer.getReviewCycleNodePositionImplIds()));
        logger.info((Object)("Mapping of ReviewCycleNodePositionReleaseIds copied (" + subProjectCopyContainer.getReviewCycleNodePositionReleaseIds().size() + " elements): " + subProjectCopyContainer.getReviewCycleNodePositionReleaseIds()));
        logger.info((Object)("Mapping of AttachedReviewCyclePositoinIds copied (" + subProjectCopyContainer.getAttachedReviewCyclePositoinIds().size() + " elements): " + subProjectCopyContainer.getAttachedReviewCyclePositoinIds()));
        if (!subProjectCopyContainer.getInconsistentNotCopiedReviewCyclePositionResults().isEmpty()) {
            void var13_28;
            String string = "Some commented ReviewCyclePositionResults have not been copied due to inconsistencies: \n";
            for (Integer resId : subProjectCopyContainer.getInconsistentNotCopiedReviewCyclePositionResults()) {
                ReviewCyclePositionResult result = this.reviewOperations.getReviewCyclePositionResult(resId);
                String string2 = (String)var13_28 + "resultId=[" + result.getId() + "] documentVersionName=[" + result.getDocumentVersion().getName() + "] projectParticipantId=[" + result.getProjectParticipant().getId() + "] user=[" + result.getProjectParticipant().getOrganisationPerson().getPerson().getInverseCommonName() + "]\n";
            }
            logger.warn((Object)var13_28);
        }
    }

    public void setSubProjectTypeDAO(SubProjectTypeDAO spd) {
        this.subProjectTypeDAO = spd;
    }

    public void setPlanDeliverCatalogueOperations(PlanDeliverCatalogueOperations planDeliverCatalogueOperations) {
        this.planDeliverCatalogueOperations = planDeliverCatalogueOperations;
    }

    @Override
    public List getProjectDTOsWithAsBuiltSubProjects(Integer networkId, Integer organisationPersonId) {
        ArrayList<at.cdes.bo.data.project.ProjectDTO> selectedProjects = new ArrayList<at.cdes.bo.data.project.ProjectDTO>();
        List activeProjects = this.projectDAO.getAllActiveFromNetwork(networkId);
        for (Project project : activeProjects) {
            List projectParticipations = this.getProjectParticipations(organisationPersonId, project.getId(), false);
            boolean hasRight = false;
            for (ProjectParticipation pp : projectParticipations) {
                if (pp.isInvalidated()) continue;
                Collection participants = pp.getProjectParticipants().values();
                boolean hasValidParticipant = false;
                Iterator iterator = participants.iterator();
                while (iterator.hasNext()) {
                    ProjectParticipant participant = (ProjectParticipant)iterator.next();
                    if (participant.isInactive() || !participant.getOrganisationPerson().getId().equals(organisationPersonId)) continue;
                    hasValidParticipant = true;
                    break;
                }
                if (!hasValidParticipant || !pp.getRole().hasAction("administrateAsBuiltDocuments")) continue;
                hasRight = true;
            }
            if (!hasRight) continue;
            List allSubProjects = this.getVisibleSubProjectForOrganisationPerson(project.getId(), organisationPersonId);
            ArrayList<SubProjectDTO> selectedSubProjects = new ArrayList<SubProjectDTO>();
            for (SubProject sp : allSubProjects) {
                if (sp.isInvalidated() || !sp.isAsBuiltStatus()) continue;
                selectedSubProjects.add(new SubProjectDTO(sp));
            }
            if (selectedSubProjects.isEmpty()) continue;
            at.cdes.bo.data.project.ProjectDTO p = new at.cdes.bo.data.project.ProjectDTO(project);
            p.getSubProjects().addAll(selectedSubProjects);
            selectedProjects.add(p);
        }
        return selectedProjects;
    }

    @Override
    public List getAllPersonProjectParticipationAssignmentDTOs(Integer organisationPersonId, Set selectedItems, Locale locale) {
        OrganisationPerson organisationPerson = this.organisationPersonDAO.get(organisationPersonId);
        List allParticipants = this.projectParticipantDAO.getAll(organisationPerson, true);
        ArrayList<PersonProjectParticipationAssignmentDTO> ret = new ArrayList<PersonProjectParticipationAssignmentDTO>();
        for (ProjectParticipant participant : allParticipants) {
            PersonProjectParticipationAssignmentDTO assignment = this.getProjectAssignmentsOfParticipationForPerson(participant.getId(), locale, selectedItems != null && selectedItems.contains(participant.getId()));
            ret.add(assignment);
        }
        return ret;
    }

    @Override
    public PersonProjectParticipationAssignmentDTO getProjectAssignmentsOfParticipationForPerson(Integer projectParticipantId, Locale locale, boolean withDetails) {
        ProjectParticipant participant = this.projectParticipantDAO.get(projectParticipantId);
        ProjectParticipation pp = participant.getParticipation();
        Project project = pp.getProject();
        I18n i18n = I18nFactory.getI18n(locale);
        ProjectParticipant mainParticipant = pp.getMainParticipant();
        PersonProjectParticipationAssignmentDTO assignment = new PersonProjectParticipationAssignmentDTO(projectParticipantId, pp.getId(), project.getId(), participant.getOrganisationPerson().getPerson().getInverseCommonName(), mainParticipant.getOrganisationPerson().getPerson().getInverseCommonName(), pp.getProject().getNetwork().getName(), pp.getProject().getCode(), pp.getProject().getName(), pp.getRole().getName(), pp.getStatus(), participant.isMainParticipant());
        assignment.setCurrentlySelected(withDetails);
        int numberOfNodePositions = 0;
        int numberOfObjectPlannerPositions = 0;
        for (SubProject sp : pp.getProject().getSubProjects().values()) {
            ReleasedObjectList activeObjectList = sp.getActiveObjectList();
            if (activeObjectList == null) continue;
            List reviewCyclePositions = this.reviewCyclePositionDAO.getReleasedByProjectParticipation(pp.getId(), activeObjectList.getId());
            numberOfNodePositions += reviewCyclePositions.size();
            if (withDetails) {
                TreeMap<Integer, PersonReviewCycleInstanceAssignmentContainer> reviewCycleAssignmentContainers = new TreeMap<Integer, PersonReviewCycleInstanceAssignmentContainer>();
                Collections.sort(reviewCyclePositions, ReviewCyclePositionComparator.getInstance());
                for (ReviewCyclePositionRelease position : reviewCyclePositions) {
                    ReviewCycleNodeInstanceRelease rcni = (ReviewCycleNodeInstanceRelease)position.getReviewCycleNodeInstance();
                    ReviewCycleInstanceRelease rci = (ReviewCycleInstanceRelease)rcni.getReviewCycleCellInstance().getReviewCycleInstance();
                    PersonReviewCycleInstanceAssignmentContainer currentRCIAContainer = (PersonReviewCycleInstanceAssignmentContainer)reviewCycleAssignmentContainers.get(rci.getId());
                    if (currentRCIAContainer == null) {
                        currentRCIAContainer = new PersonReviewCycleInstanceAssignmentContainer(rci.getId(), rci.getName(), rci.getReviewCycle().getName(), rci.getSubProject().getCode());
                        List opRels = this.objectOperations.getObjectPlannerReleasesForReviewCycleInstance(rci.getId());
                        for (ReleasedObjectPlanner opRel : opRels) {
                            ReviewCycleObjectPlannerAssignmentDTO rcopa = new ReviewCycleObjectPlannerAssignmentDTO(opRel);
                            currentRCIAContainer.getObjectPlannerAssignments().add(rcopa);
                        }
                    }
                    String realmString = (position.getRealm().getCode() != null && !position.getRealm().getCode().isEmpty() ? position.getRealm().getCode() + " " : "") + TapestryI18nHelper.getLocalizedString(position.getRealm().getName());
                    PersonReviewCycleInstanceAssignmentDTO positionAssignment = new PersonReviewCycleInstanceAssignmentDTO(rci.getName(), TapestryI18nHelper.getLocalizedString(rci.getReviewCycle().getName()), TapestryI18nHelper.getLocalizedString(rcni.getReviewCycleCellInstance().getReviewCycleCell().getName()), TapestryI18nHelper.getLocalizedString(rcni.getReviewCycleNode().getName()), realmString);
                    Collection<ReviewCycleNodeListener> listeners = rcni.getReviewCycleNode().getListenersSortedByPosition();
                    for (ReviewCycleNodeListener listener : listeners) {
                        if ("NotificationListener".equals(listener.getListenerName())) {
                            positionAssignment.getNotificationListeners().add(TapestryI18nHelper.getLocalizedString(listener.getName()));
                            continue;
                        }
                        if (!"PlottOrderListener".equals(listener.getListenerName())) continue;
                        positionAssignment.getPlotOrderListeners().add(TapestryI18nHelper.getLocalizedString(listener.getName()));
                    }
                    currentRCIAContainer.getAssignments().add(positionAssignment);
                    reviewCycleAssignmentContainers.put(rci.getId(), currentRCIAContainer);
                }
                assignment.getReviewCycleInstanceAssignmentContainers().addAll(reviewCycleAssignmentContainers.values());
            }
            List objectPlannerPositions = this.objectOperations.getReleasedObjectPlannerPositionByParticipation(pp.getId(), activeObjectList.getId());
            numberOfObjectPlannerPositions += objectPlannerPositions.size();
            if (!withDetails) continue;
            Iterator oppIt = objectPlannerPositions.iterator();
            ArrayList<PersonObjectPlannerPositionAssignmentDTO> positionAssignments = new ArrayList<PersonObjectPlannerPositionAssignmentDTO>();
            while (oppIt.hasNext()) {
                Object pos = oppIt.next();
                PersonObjectPlannerPositionAssignmentDTO positionAssignment = null;
                positionAssignment = pos instanceof ObjectPlannerPosition ? new PersonObjectPlannerPositionAssignmentDTO((ObjectPlannerPosition)pos) : new PersonObjectPlannerPositionAssignmentDTO((ObjectPlanner)pos, i18n.tr("Planer"));
                positionAssignments.add(positionAssignment);
            }
            Collections.sort(positionAssignments, PersonObjectPlannerPositionAssignmentComparator.getInstance());
            assignment.getObjectPlannerPositionAssignments().addAll(positionAssignments);
        }
        assignment.setNumberOfNodePositions(numberOfNodePositions);
        assignment.setNumberOfObjectPlannerPositions(numberOfObjectPlannerPositions);
        return assignment;
    }

    @Override
    public int getActiveProjectCount(boolean withInvalid) {
        return this.projectDAO.getActiveProjectCount(withInvalid);
    }

    @Override
    public int getActiveSubProjectCount(boolean withInvalid) {
        return this.projectDAO.getActiveSubProjectCount(withInvalid);
    }

    @Override
    public List<ProjectDTO> getPlanningNotificationProjects(Integer networkId) {
        Network network = this.networkDAO.get(networkId);
        NetworkDTO networkDTO = CdesDTOHelper.getNetworkDTO(network);
        ArrayList projects = new ArrayList(this.projectDAO.getAllPlanningNotificationProjectsFromNetwork(networkId));
        ArrayList<ProjectDTO> projectDTOs = new ArrayList<ProjectDTO>();
        if (projects == null || projects.isEmpty()) {
            return projectDTOs;
        }
        for (Project project : projects) {
            projectDTOs.add(CdesDTOHelper.getProjectDTO(project, networkDTO));
        }
        return projectDTOs;
    }

    @Override
    public ProjectDTO insertPlanningNotificationProject(ProjectDTO projectDTO, Integer organisationPersonId) {
        Project project;
        Network network = this.networkDAO.get(projectDTO.getNetwork().getId());
        OrganisationPerson creator = this.organisationPersonDAO.get(organisationPersonId);
        NetworkDTO networkDTO = CdesDTOHelper.getNetworkDTO(network);
        DocumentNumberPartGroup documentNumberPartGroup = (DocumentNumberPartGroup)this.documentNumberPartDAO.getAllGroups(projectDTO.getNetwork().getId()).get(0);
        Localisation localisation = (Localisation)this.locDAO.getAll().get(0);
        Locale loc = new Locale("de");
        Date created = new Date(System.currentTimeMillis());
        if (projectDTO.getId() == null) {
            project = new Project();
            project.setCode(projectDTO.getCode());
            project.setName(projectDTO.getName());
            project.setComment(projectDTO.getComment());
            project.setRouteName("");
            project.setNetwork(network);
            project.setCreated(created);
            project.setCreatedBy(creator);
            project.setModified(created);
            project.setModifiedBy(creator);
            project.setDocumentNumberPartGroup(documentNumberPartGroup);
            project.setLocalisation(localisation);
            project.setStatus(10);
            project.setAccess(2);
            project = this.insertProject(project, creator, null, loc, true, 8, -1);
        } else {
            project = this.getProject(projectDTO.getId());
            project.setCode(projectDTO.getCode());
            project.setName(projectDTO.getName());
            project.setComment(projectDTO.getComment());
            project.setModified(created);
            project.setModifiedBy(creator);
            project = this.updateProject(project);
        }
        return CdesDTOHelper.getProjectDTO(project, networkDTO);
    }

    public void setLocDAO(LocalisationDAO locDAO) {
        this.locDAO = locDAO;
    }

    public void setDocumentNumberPartDAO(DocumentNumberPartDAO documentNumberPartDAO) {
        this.documentNumberPartDAO = documentNumberPartDAO;
    }

    @Override
    public void deletePlanningNotificationProjectById(Integer projectId) {
        Project project = this.getProject(projectId);
        this.deletePlanningNotificationProject(project);
    }

    @Override
    public void deletePlanningNotificationProject(Project project) {
        boolean notDeletable = false;
        if (project.getSubProjects() != null) {
            for (Object sp : project.getSubProjects().values()) {
                if (((SubProject)sp).getActiveObjectList() != null) {
                    notDeletable = true;
                    continue;
                }
                this.deleteSubProjectById(((SubProject)sp).getId());
            }
        }
        if (!notDeletable) {
            List<PlanningNotificationDTO> planningNotifications = this.reviewOperations.getPlanningNotificationsByNetworkAndProject(project.getNetwork().getId(), project.getId());
            for (PlanningNotificationDTO planningNotificationDTO : planningNotifications) {
                this.reviewOperations.deletePlanningNotification(planningNotificationDTO.getId());
            }
            if (project.getProjectParticipations() != null) {
                Iterator it = project.getProjectParticipations().values().iterator();
                while (it.hasNext()) {
                    this.deleteProjectParticipation((ProjectParticipation)it.next());
                }
            }
            this.projectDAO.delete(project);
        } else {
            project.setAccess(0);
            project.setStatus(6);
            this.projectDAO.update(project);
        }
    }

    public void setWorkflowNodePositionDAO(WorkflowNodePositionDAO workflowNodePositionDAO) {
        this.workflowNodePositionDAO = workflowNodePositionDAO;
    }

    public void setWorkflowTokenDAO(WorkflowTokenDAO workflowTokenDAO) {
        this.workflowTokenDAO = workflowTokenDAO;
    }

    public void setWorkflowActivityDAO(WorkflowActivityDAO workflowActivityDAO) {
        this.workflowActivityDAO = workflowActivityDAO;
    }
}

