/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.workflow.WorkflowActivity;
import at.cdes.bo.data.workflow.WorkflowActivityPositionResult;
import at.cdes.bo.file.FileFinder;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.WorkflowActivityDAO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import at.cdes.util.ImplContextHelper;
import java.io.File;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class WorkflowActivityPositionResultAttachmentMimeSource
implements VisitlessMimeSource {
    private WorkflowActivityDAO workflowActivityDAO;
    private FileFinder fileFinder;
    private NetworkDAO networkDAO;

    public String getActionName() {
        return "downloadPlanningNotification";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        return ImplContextHelper.getContextNetworkId() != null ? this.networkDAO.get(ImplContextHelper.getContextNetworkId()) : null;
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        String unique;
        File file;
        String filePath;
        Integer id = (Integer)parameters[0];
        WorkflowActivity activity = this.workflowActivityDAO.get(id);
        if (!(activity instanceof WorkflowActivityPositionResult)) {
            return null;
        }
        try {
            filePath = ((WorkflowActivityPositionResult)activity).getAttachmentFilePath();
            file = this.fileFinder.findFile(filePath, CDESFileRepository.PLANNINGNOTIFICATIONATTACHMENTREPOSITORY);
            unique = this.fileFinder.makeUniqueName(filePath, CDESFileRepository.PLANNINGNOTIFICATIONATTACHMENTREPOSITORY);
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the workflowActivityPositionResultAttachment", (Throwable)e);
        }
        return new FileMimeInputStream(file, unique, "Dateianhang", DefaultHttpContext.getInstance().getMimeType(filePath));
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setWorkflowActivityDAO(WorkflowActivityDAO workflowActivityDAO) {
        this.workflowActivityDAO = workflowActivityDAO;
    }
}

