/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.label;

import at.cdes.bo.data.cycle.ReviewCycleEntryResult;
import at.cdes.bo.data.cycle.ReviewCyclePosition;
import at.cdes.bo.data.cycle.ReviewCyclePositionResult;
import at.cdes.bo.data.cycle.cell.ReviewCycleCellConnectionResult;
import at.cdes.bo.data.cycle.node.ReviewCycleNode;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceImpl;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeInstanceRelease;
import at.cdes.bo.data.cycle.node.ReviewCycleNodeResult;
import at.cdes.bo.data.document.DocumentBase;
import at.cdes.bo.data.document.DocumentImpl;
import at.cdes.bo.data.document.DocumentVersion;
import at.cdes.bo.data.document.ReleasedDocumentList;
import at.cdes.bo.data.label.BoldRichTextItem;
import at.cdes.bo.data.label.CDataRichTextItem;
import at.cdes.bo.data.label.DocumentVersionTextField;
import at.cdes.bo.data.label.FreeTextLabelTextField;
import at.cdes.bo.data.label.ParagraphRichTextItem;
import at.cdes.bo.data.label.RichTextItemContainer;
import at.cdes.bo.data.label.SignatureTextField;
import at.cdes.bo.data.label.TemporaryCustomTextField;
import at.cdes.bo.data.label.TextField;
import at.cdes.bo.data.number.DocumentNumberPart;
import at.cdes.bo.data.object.CDESObjectImpl;
import at.cdes.bo.data.object.ObjectPlannerImpl;
import at.cdes.bo.data.object.ObjectPlannerPosition;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.data.person.OrganisationPerson;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.project.SubProject;
import at.cdes.bo.document.DocumentTranslator;
import at.cdes.bo.document.DocumentVersionHelper;
import at.cdes.bo.label.AbstractTextFieldRenderer;
import at.cdes.db.dao.DocumentDAO;
import at.cdes.db.dao.ObjectPlannerDAO;
import at.cdes.db.dao.ReviewCycleCellConnectionResultDAO;
import at.cdes.db.dao.ReviewCycleEntryResultDAO;
import at.cdes.db.dao.ReviewCycleInstanceDAO;
import at.cdes.db.dao.ReviewCycleNodeInstanceDAO;
import at.cdes.db.dao.ReviewCycleNodeResultDAO;
import at.cdes.db.dao.ReviewCyclePositionResultDAO;
import at.cdes.impl.i18n.I18nFactory;
import at.cdes.util.TapestryI18nHelper;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.clazzes.util.lang.Pair;
import org.xnap.commons.i18n.I18n;

public class DocumentVersionTextFieldRenderer
extends AbstractTextFieldRenderer {
    static Logger logger = Logger.getLogger(DocumentVersionTextFieldRenderer.class);
    private DocumentVersion documentVersion;
    private String appUrl;
    private List<Pair<String, String>> customTextFieldValues;
    private ReviewCyclePositionResultDAO reviewCyclePositionResultDAO;
    private ReviewCycleCellConnectionResultDAO reviewCycleCellConnectionResultDAO;
    private ReviewCycleEntryResultDAO reviewCycleEntryResultDAO;
    private ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO;
    private ReviewCycleNodeResultDAO reviewCycleNodeResultDAO;
    private ReviewCycleInstanceDAO reviewCycleInstanceDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private DocumentDAO documentDAO;

    public DocumentVersionTextFieldRenderer(String appUrl, DocumentVersion documentVersion, double xoff, double yoff, boolean respectUserUnit, ReviewCyclePositionResultDAO reviewCyclePositionResultDAO, ReviewCycleCellConnectionResultDAO reviewCycleCellConnectionResultDAO, ReviewCycleEntryResultDAO reviewCycleEntryResultDAO, ReviewCycleInstanceDAO reviewCycleInstanceDAO, ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO, ReviewCycleNodeResultDAO reviewCycleNodeResultDAO, ObjectPlannerDAO objectPlannerDAO, DocumentDAO documentDAO, List customTextFieldValues) {
        super(documentVersion.getLabelXOffset() == null ? xoff : documentVersion.getLabelXOffset() + xoff, documentVersion.getLabelYOffset() == null ? yoff : documentVersion.getLabelYOffset() + yoff, respectUserUnit ? documentVersion.getUserUnit() : 1.0);
        this.documentVersion = documentVersion;
        this.appUrl = appUrl;
        this.reviewCyclePositionResultDAO = reviewCyclePositionResultDAO;
        this.reviewCycleCellConnectionResultDAO = reviewCycleCellConnectionResultDAO;
        this.reviewCycleEntryResultDAO = reviewCycleEntryResultDAO;
        this.reviewCycleInstanceDAO = reviewCycleInstanceDAO;
        this.reviewCycleNodeInstanceDAO = reviewCycleNodeInstanceDAO;
        this.reviewCycleNodeResultDAO = reviewCycleNodeResultDAO;
        this.objectPlannerDAO = objectPlannerDAO;
        this.documentDAO = documentDAO;
        this.customTextFieldValues = customTextFieldValues;
    }

    @Override
    public void visit(SignatureTextField field) throws IOException {
        boolean isAsBuiltReference = false;
        DocumentVersion fieldsDocumentVersion = this.documentVersion;
        if (field.getReviewCycleNode() == null) {
            return;
        }
        if (!fieldsDocumentVersion.getActualReviewCycleNode().getReviewCycleCell().getId().equals(field.getReviewCycleNode().getReviewCycleCell().getId())) {
            if (fieldsDocumentVersion.getAsBuiltReference() == null || !fieldsDocumentVersion.getAsBuiltReference().getActualReviewCycleNode().getReviewCycleCell().getId().equals(field.getReviewCycleNode().getReviewCycleCell().getId())) {
                return;
            }
            isAsBuiltReference = true;
            fieldsDocumentVersion = fieldsDocumentVersion.getAsBuiltReference();
        }
        ReviewCycleNode fieldsNode = field.getReviewCycleNode();
        ReviewCycleNodeResult nodeResult = this.reviewCycleNodeResultDAO.get(fieldsNode, fieldsDocumentVersion);
        ReleasedObjectList activeObjectList = null;
        if (nodeResult != null) {
            activeObjectList = (ReleasedObjectList)nodeResult.getActiveObjectListOfDocumentDeparture();
        }
        if (activeObjectList == null) {
            activeObjectList = fieldsDocumentVersion.getDocument().getDocumentList().getSubProject().getActiveObjectList();
        }
        ObjectPlannerImpl op = (ObjectPlannerImpl)fieldsDocumentVersion.getDocument().getObjectPlanner();
        ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(activeObjectList.getId(), op.getId());
        if (rop != null) {
            double fieldHeight;
            ReviewCycleNodeInstanceRelease rcniRel = this.reviewCycleNodeInstanceDAO.getReleased(rop.getReviewCycleInstance().getId(), fieldsNode.getId());
            logger.info((Object)("trying to get getRelevantReviewCyclePositions for rcniRel = " + rcniRel + " ReviewCycleInstanceId = " + rop.getReviewCycleInstance().getId() + " fieldsNodeId = " + fieldsNode.getId() + " for fieldsDocumentVersionId = " + fieldsDocumentVersion.getId()));
            ReviewCycleNodeInstanceImpl rcni = null;
            if (rcniRel == null) {
                rcni = this.reviewCycleNodeInstanceDAO.getUnreleased(op.getReviewCycleInstance(), fieldsNode);
                logger.info((Object)("rcniRel is null! trying to get getRelevantReviewCyclePositions for rcni = " + rcni + " ReviewCycleInstanceId = " + op.getReviewCycleInstance().getId() + " fieldsNodeId = " + fieldsNode.getId() + " for fieldsDocumentVersionId = " + fieldsDocumentVersion.getId()));
            }
            if (rcniRel == null && rcni == null) {
                logger.info((Object)("rcniRel and rcni are null! skipping renedering SignatureTextField for fieldsDocumentVersionId = " + fieldsDocumentVersion.getId()));
                return;
            }
            List<ReviewCyclePosition> relevantReviewCyclePositions = this.reviewCycleNodeInstanceDAO.getRelevantReviewCyclePositions(rcniRel != null ? rcniRel : rcni, fieldsDocumentVersion);
            int n = 0;
            int i = 0;
            for (ReviewCyclePosition pos : relevantReviewCyclePositions) {
                if (!pos.getRealm().isSignatureOnLabel() || (!field.isUsedForRealm() || pos.getRealm().getLabelTextFieldSeq() == null || field.getRealmSequence() == null || !pos.getRealm().getLabelTextFieldSeq().equals(field.getRealmSequence())) && (field.isUsedForRealm() || field.getRealmSequence() != null)) continue;
                ++n;
            }
            if (n == 0) {
                return;
            }
            boolean outputReduced = false;
            boolean outputTiny = false;
            boolean horizontalSeparation = false;
            double fieldWidth = field.getUrx() - field.getLlx();
            if (fieldWidth > 1.1 * (fieldHeight = field.getUry() - field.getLly()) || n == 1) {
                horizontalSeparation = true;
            }
            if (n > 1 && (!horizontalSeparation && fieldHeight < 50.0 || horizontalSeparation && fieldWidth < 150.0)) {
                outputReduced = true;
            }
            if (fieldHeight < 20.0) {
                outputTiny = true;
            }
            for (ReviewCyclePosition pos : relevantReviewCyclePositions) {
                if (!pos.getRealm().isSignatureOnLabel() || field.isUsedForRealm() && pos.getRealm().getLabelTextFieldSeq() != null && field.getRealmSequence() != null && !pos.getRealm().getLabelTextFieldSeq().equals(field.getRealmSequence()) || !field.isUsedForRealm() && field.getRealmSequence() == null && !field.isNodeRefUnique()) continue;
                ReviewCyclePositionResult positionResult = this.reviewCyclePositionResultDAO.get(pos.getRealm(), fieldsNode, fieldsDocumentVersion, pos.getProjectParticipation(), null);
                if (positionResult != null && positionResult.getSignature() != null) {
                    OrganisationPerson orgPerson = positionResult.getProjectParticipant().getOrganisationPerson();
                    String reviewer = orgPerson.getPerson().getCommonName() + ", " + orgPerson.getOrganisation().getName();
                    if (orgPerson.getOrganisationalUnitName() != null && orgPerson.getOrganisationalUnitName().length() > 0) {
                        reviewer = reviewer + " (" + orgPerson.getOrganisationalUnitName() + ")";
                    }
                    String restxt = positionResult.getReviewCycleResultOption().getValue() == 1 && positionResult.getRealm().getLabelText() != null && positionResult.getRealm().getLabelText().length() > 0 ? TapestryI18nHelper.getLocalizedString(positionResult.getRealm().getLabelText()) : TapestryI18nHelper.getLocalizedString(positionResult.getReviewCycleResultOption().getName());
                    String fieldsNodeName = TapestryI18nHelper.getLocalizedString(fieldsNode.getName());
                    if (isAsBuiltReference) {
                        fieldsNodeName = fieldsNodeName + " [" + fieldsDocumentVersion.getName() + "]";
                    }
                    this.renderSignatureTextFieldInternal(field, positionResult.getResultDate(), restxt, reviewer, positionResult.getDigest(), fieldsNodeName, null, i, n, outputReduced, outputTiny);
                } else {
                    RichTextItemContainer root = new RichTextItemContainer();
                    String nodeName = TapestryI18nHelper.getLocalizedString(fieldsNode.getName());
                    root.addItem(new ParagraphRichTextItem(new CDataRichTextItem(nodeName + "\r")));
                    super.renderFDFObject(field, nodeName, "c.des", fieldsDocumentVersion.getUploaded(), root, i, n);
                }
                ++i;
            }
        }
    }

    @Override
    public void visit(DocumentVersionTextField field) throws IOException {
        CDESObjectImpl object;
        if (field.getReviewCycle() != null && !this.documentVersion.getActualReviewCycleNode().getReviewCycleCell().getReviewCycle().getId().equals(field.getReviewCycle().getId())) {
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
        Locale locale = DocumentVersionHelper.getProjectLocaleFromDocumentVersion(this.documentVersion);
        I18n i18n = I18nFactory.getI18n(locale);
        Project project = this.documentVersion.getDocument().getDocumentList().getSubProject().getProject();
        SubProject subProject = this.documentVersion.getDocument().getDocumentList().getSubProject();
        String documentName = "";
        DocumentBase relDocument = null;
        ReleasedDocumentList lastRelDocumentList = subProject.getActiveDocumentList();
        if (lastRelDocumentList != null) {
            relDocument = this.documentDAO.getReleased(this.documentVersion.getDocument().getId(), lastRelDocumentList.getId());
        }
        documentName = relDocument != null ? relDocument.getName() : this.documentVersion.getDocument().getName();
        List parts = project.getDocumentNumberPartGroup().getPartsSortedByPosition();
        String seperator = "";
        for (DocumentNumberPart part : parts) {
            if (!part.getRule().contains("document.part")) continue;
            seperator = part.getSeperator();
        }
        boolean hasVersionPartA = false;
        if (this.documentVersion.getVersionPartA() != null && this.documentVersion.getVersionPartA().length() > 0) {
            hasVersionPartA = true;
        }
        String cdata = field.getContent();
        cdata = cdata.replace("${name}", this.documentVersion.getName());
        cdata = cdata.replace("${nameWithoutVersion}", documentName);
        cdata = cdata.replace("${nameWithoutVersionPartB}", documentName + (hasVersionPartA ? seperator + this.documentVersion.getVersionPartA() : ""));
        cdata = cdata.replace("${version_status}", DocumentTranslator.getTextFieldStatusStamp(i18n, this.documentVersion.getStatus()));
        cdata = cdata.replace("${version_parta}", this.documentVersion.getVersionPartA());
        cdata = cdata.replace("${version_partb}", this.documentVersion.getVersionPartB());
        ReleasedObjectPlanner rop = this.objectPlannerDAO.getReleasedObjectPlanner(this.documentVersion.getDocument().getDocumentList().getSubProject().getActiveObjectList().getId(), this.documentVersion.getDocument().getObjectPlanner().getId());
        if (cdata.contains("${object_code}")) {
            cdata = cdata.replace("${object_code}", rop != null ? rop.getObject().getCode() : this.documentVersion.getDocument().getObjectPlanner().getObject().getCode());
        }
        if (cdata.contains("${object_name}")) {
            cdata = cdata.replace("${object_name}", rop != null ? rop.getObject().getName() : this.documentVersion.getDocument().getObjectPlanner().getObject().getName());
        }
        cdata = cdata.replace("${alt_name}", this.documentVersion.getAlternativeName() != null ? this.documentVersion.getAlternativeName() : "");
        cdata = cdata.replace("${comment}", this.documentVersion.getComment() != null ? this.documentVersion.getComment() : "");
        cdata = cdata.replace("${uploaded}", df.format(this.documentVersion.getUploaded()));
        if (this.appUrl != null) {
            cdata = cdata.replace("${tracker_url}", this.appUrl);
        }
        if (cdata.contains("${as_built_name}")) {
            if (this.documentVersion.getAsBuiltReference() != null) {
                cdata = cdata.replace("${as_built_name}", this.documentVersion.getAsBuiltReference().getName());
            } else {
                DocumentImpl asBuiltDoc = ((DocumentImpl)this.documentVersion.getDocument()).getAsBuiltReference();
                DocumentVersion lastVersion = asBuiltDoc != null ? asBuiltDoc.getLastDocumentVersion() : null;
                cdata = cdata.replace("${as_built_name}", lastVersion != null ? lastVersion.getName() : "");
            }
        }
        if (cdata.contains("project") || cdata.contains("subProject")) {
            cdata = cdata.replace("${project_code}", project.getCode());
            cdata = cdata.replace("${project_name}", project.getName());
            cdata = cdata.replace("${principal_project}", project.getPrincipalProject() != null ? project.getPrincipalProject() : "");
            cdata = cdata.replace("${project_stretch}", project.getStretchName() != null ? project.getStretchName() : "");
            cdata = cdata.replace("${project_route}", project.getRouteName() != null ? project.getRouteName() : "");
            cdata = cdata.replace("${project_kms}", project.getKms() != null ? project.getKms() : "");
            cdata = cdata.replace("${subProject_code}", subProject.getCode());
            cdata = cdata.replace("${subProject_name}", subProject.getName());
        }
        cdata = cdata.replace("${object_type}", (object = (CDESObjectImpl)this.documentVersion.getDocument().getObjectPlanner().getObject()).getObjectType() != null ? object.getObjectType().getCode() : "");
        cdata = cdata.replace("${object_kms}", object.getKms() != null ? object.getKms() : "");
        cdata = cdata.replace("${document_title}", TapestryI18nHelper.getLocalizedString(this.documentVersion.getDocument().getContent()));
        cdata = cdata.replace("${scale}", this.documentVersion.getDocument().getScale());
        int idx = cdata.indexOf("${upload_sig}");
        if (cdata.length() <= 0) {
            return;
        }
        if (idx < 0) {
            CDataRichTextItem name_item = new CDataRichTextItem(cdata + "\r");
            super.renderFDFObject(field, this.documentVersion.getName(), "c.des", this.documentVersion.getUploaded(), new ParagraphRichTextItem(name_item), 0, 1);
        } else {
            ReviewCycleEntryResult er;
            String header = null;
            header = idx > 0 ? cdata.substring(0, idx) : TapestryI18nHelper.getI18n("Planung");
            String trailer = null;
            if (idx + 13 < cdata.length()) {
                trailer = cdata.substring(idx + 13, cdata.length());
            }
            OrganisationPerson contractorPlanner = null;
            if (((DocumentImpl)this.documentVersion.getDocument()).getAsBuiltReference() != null) {
                ArrayList positions = new ArrayList(this.documentVersion.getDocument().getObjectPlanner().getPositions().values());
                for (ObjectPlannerPosition position : positions) {
                    if (position.getProjectParticipation().getRole().getProjectFlag() != 4) continue;
                    contractorPlanner = position.getProjectParticipation().getMainParticipant().getOrganisationPerson();
                    break;
                }
            }
            if ((er = this.reviewCycleEntryResultDAO.getByDocumentVersion(this.documentVersion.getId())) != null) {
                OrganisationPerson op = er.getProjectParticipant().getOrganisationPerson();
                String reviewer = op.getPerson().getCommonName() + ", " + op.getOrganisation().getName();
                String contractorPlannerHeader = null;
                String contractorPlannerBody = null;
                ReviewCycleEntryResult ho = er;
                ReviewCycleEntryResult so = er;
                this.renderUploadSignatureTextField(field, so.getSignature().getTime(), "upload", reviewer, ho.getDigest(), header, trailer, contractorPlannerHeader, contractorPlannerBody, 0, 1);
            } else {
                ReviewCycleCellConnectionResult cr = this.reviewCycleCellConnectionResultDAO.getByDestinationDocumentVersion(this.documentVersion.getId());
                if (cr != null) {
                    OrganisationPerson op = cr.getProjectParticipant().getOrganisationPerson();
                    String reviewer = op.getPerson().getCommonName() + ", " + op.getOrganisation().getName();
                    String contractorPlannerHeader = null;
                    String contractorPlannerBody = null;
                    ReviewCycleCellConnectionResult ho = cr;
                    ReviewCycleCellConnectionResult so = cr;
                    this.renderUploadSignatureTextField(field, so.getSignature().getTime(), "upload", reviewer, ho.getDigest(), header, trailer, contractorPlannerHeader, contractorPlannerBody, 0, 1);
                } else {
                    CDataRichTextItem name_item = new CDataRichTextItem(cdata + "\r");
                    super.renderFDFObject(field, this.documentVersion.getName(), "c.des", this.documentVersion.getUploaded(), new ParagraphRichTextItem(name_item), 0, 1);
                }
            }
        }
    }

    @Override
    public void visit(TemporaryCustomTextField textField) throws IOException {
        if (this.customTextFieldValues == null || this.customTextFieldValues.isEmpty()) {
            logger.error((Object)("Tried to render TemporaryCustomTextField with name=[" + textField.getName() + "] but no values were given!"));
            return;
        }
        String cdata = new String();
        for (Pair<String, String> customTextFieldValue : this.customTextFieldValues) {
            if (!((String)customTextFieldValue.getFirst()).equals(textField.getName())) continue;
            cdata = (String)customTextFieldValue.getSecond();
            break;
        }
        if (cdata.length() <= 0) {
            logger.error((Object)("No value was found for TemporaryCustomTextField with name=[" + textField.getName() + "]"));
        }
        CDataRichTextItem name_item = new CDataRichTextItem(cdata + "\r");
        super.renderFDFObject(textField, this.documentVersion.getName(), "c.des", this.documentVersion.getUploaded(), new ParagraphRichTextItem(name_item), 0, 1);
    }

    @Override
    public void visit(FreeTextLabelTextField textField) throws IOException {
        if (textField.getReviewCycle() != null && !this.documentVersion.getActualReviewCycleNode().getReviewCycleCell().getReviewCycle().getId().equals(textField.getReviewCycle().getId())) {
            return;
        }
        String cdata = textField.getContent();
        if (cdata.length() <= 0) {
            logger.error((Object)("No value was found for TemporaryCustomTextField with name=[" + textField.getContent() + "]"));
        }
        CDataRichTextItem name_item = new CDataRichTextItem(cdata + "\r");
        super.renderFDFObject(textField, this.documentVersion.getName(), "c.des", this.documentVersion.getUploaded(), new ParagraphRichTextItem(name_item), 0, 1);
    }

    private void renderUploadSignatureTextField(TextField field, Date date, String subject, String reviewer, String digest, String header, String trailer, String signedByHeader, String signedByBody, int i, int n) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        RichTextItemContainer root = new RichTextItemContainer();
        root.addItem(new ParagraphRichTextItem(new BoldRichTextItem(new CDataRichTextItem(subject + "\r"))));
        root.addItem(new ParagraphRichTextItem(new CDataRichTextItem(reviewer + "\r")));
        root.addItem(new ParagraphRichTextItem(new CDataRichTextItem(df.format(date) + "\r")));
        if (signedByHeader != null) {
            root.addItem(new ParagraphRichTextItem(new BoldRichTextItem(new CDataRichTextItem(signedByHeader + "\r"))));
        }
        if (signedByBody != null) {
            root.addItem(new ParagraphRichTextItem(new CDataRichTextItem(signedByBody + "\r")));
        }
        root.addItem(new ParagraphRichTextItem(new BoldRichTextItem(new CDataRichTextItem("sigId: ")), new CDataRichTextItem(digest + "\r")));
        if (trailer != null) {
            root.addItem(new ParagraphRichTextItem(new CDataRichTextItem(trailer + "\r")));
        }
        this.renderFDFObject(field, subject, reviewer, date, root, i, n);
    }
}

