/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.schema;

import at.cdes.db.SchemaUpdateSnippet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaUpdate_0_246
implements SchemaUpdateSnippet {
    private static final Logger log = LoggerFactory.getLogger(SchemaUpdate_0_246.class);

    @Override
    public String getTargetVersion() {
        return "0.246";
    }

    @Override
    public String getUpdateComment() {
        return "Transform ReviewCycleStatusSearch entries with Search.pageName DocumentList as json, store them in Search.content";
    }

    @Override
    public void performUpdate(ISchemaEngine schemaEngine) throws SQLException {
        String querySQL = "SELECT s.search_id, s.review_cycle_id, s.review_cycle_cell_id, s.review_cycle_node_id, s.days_of_delay, s.document_status, s.document_version_name, s.object_id, s.document_content, s.review_cycle_cell_id2, s.review_cycle_node_id2, s.sizePerPage, s.uploadedFrom, s.uploadedTo, s.documentType, s.projectParticipation, s.with_inactive_objects, p.organisation_person_id FROM ((        review_cycle_status_search s JOIN search base_search           ON     s.search_id = base_search.id) LEFT JOIN project_participant p        ON     p.participation_id = s.projectParticipation AND p.inactive_flag = 0 AND p.main_participant_flag = 1) WHERE base_search.page_name = ? ";
        PreparedStatement queryStatement = schemaEngine.getConnection().prepareStatement(querySQL);
        queryStatement.setString(1, "DocumentList");
        String updateSQL = "UPDATE search set content = ? WHERE id = ?";
        PreparedStatement updateStatement = schemaEngine.getConnection().prepareStatement(updateSQL);
        Gson gson = new GsonBuilder().serializeNulls().create();
        ResultSet resultSet = queryStatement.executeQuery();
        while (resultSet.next()) {
            int currIndex = 1;
            Integer searchId = JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            Integer reviewCycleCellId = JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            Integer reviewCycleNodeId = JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            Integer daysOfDelay = JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            Integer documentStatus = JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            String documentVersionName = resultSet.getString(currIndex++);
            Integer objectId = JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            String documentContent = resultSet.getString(currIndex++);
            JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            Double uploadedFrom = JDBCHelper.getUtcSeconds((ResultSet)resultSet, (int)currIndex++);
            Double uploadedTo = JDBCHelper.getUtcSeconds((ResultSet)resultSet, (int)currIndex++);
            Integer documentType = JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            Boolean withInactiveObjects = JDBCHelper.getBoolean((ResultSet)resultSet, (int)currIndex++);
            Integer organisationPersonId = JDBCHelper.getInt((ResultSet)resultSet, (int)currIndex++);
            log.info("Transforming search with id [" + searchId + "] and objectId [" + objectId + "]");
            JsonObject contentJsonObject = new JsonObject();
            contentJsonObject.addProperty("organisationPersonId", (String)null);
            contentJsonObject.addProperty("subProjectId", (String)null);
            contentJsonObject.addProperty("status", (Number)documentStatus);
            contentJsonObject.addProperty("delayOption", (Number)daysOfDelay);
            contentJsonObject.addProperty("documentTypeId", (Number)documentType);
            contentJsonObject.addProperty("objectId", (Number)objectId);
            contentJsonObject.addProperty("uploadedFrom", (Number)uploadedFrom);
            contentJsonObject.addProperty("uploadedTo", (Number)uploadedTo);
            contentJsonObject.addProperty("releasedFrom", (Number)null);
            contentJsonObject.addProperty("releasedTo", (Number)null);
            contentJsonObject.addProperty("name", documentVersionName);
            contentJsonObject.addProperty("content", documentContent);
            contentJsonObject.addProperty("showDeleted", withInactiveObjects);
            contentJsonObject.addProperty("plannerOrgPersonId", (Number)organisationPersonId);
            contentJsonObject.addProperty("plannerName", (String)null);
            contentJsonObject.add("reviewCycleIds", (JsonElement)new JsonArray());
            JsonArray reviewCycleCellIdArray = new JsonArray();
            if (reviewCycleCellId != null) {
                reviewCycleCellIdArray.add((JsonElement)new JsonPrimitive((Number)reviewCycleCellId));
            }
            contentJsonObject.add("reviewCycleCellIds", (JsonElement)reviewCycleCellIdArray);
            JsonArray reviewCycleNodeIdArray = new JsonArray();
            if (reviewCycleNodeId != null) {
                reviewCycleNodeIdArray.add((JsonElement)new JsonPrimitive((Number)reviewCycleNodeId));
            }
            contentJsonObject.add("reviewCycleNodeIds", (JsonElement)reviewCycleNodeIdArray);
            String content = gson.toJson((JsonElement)contentJsonObject);
            log.info("Registering update for search [" + searchId + "] and content [" + content + "]");
            currIndex = 1;
            updateStatement.setString(currIndex++, content);
            JDBCHelper.setInt((PreparedStatement)updateStatement, (int)currIndex++, (Number)searchId);
            updateStatement.addBatch();
        }
        updateStatement.executeBatch();
    }
}

