/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview.seed.impl;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.mime.MimeSourceFactory;
import at.cdes.ext.preview.seed.SeedItem;
import at.cdes.ext.preview.seed.Seeder;
import at.cdes.preview.api.DRMError;
import at.cdes.preview.api.HPGSError;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.Timeout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class SeederImpl
implements Seeder,
Runnable {
    private static Logger log = Logger.getLogger(SeederImpl.class);
    private MimeSourceFactory mimeSourceFactory;
    private String tempDir;
    private String instanceName;
    private boolean stopping = false;
    private SortedSet<SeedItem> queue;
    private int maxQueueSize = 10000;
    private int nThreads;
    private int maxTries = 5;
    private Thread[] threads;

    private File getSeedCacheFile() {
        if (this.tempDir == null || this.instanceName == null) {
            return null;
        }
        File tempDir_f = new File(this.tempDir);
        return new File(tempDir_f, "SeederImpl_cache_" + this.instanceName + ".bin");
    }

    private SortedSet<SeedItem> readQueue() {
        TreeSet<SeedItem> ret = new TreeSet<SeedItem>();
        File file = this.getSeedCacheFile();
        if (file != null) {
            try {
                if (file.exists()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Reading seed items from cache file [" + file + "]..."));
                    }
                    FileInputStream fis = new FileInputStream(file);
                    ObjectInputStream ois = new ObjectInputStream(fis);
                    Collection items = (Collection)ois.readObject();
                    Iterator item = items.iterator();
                    for (int count = 0; item.hasNext() && count < this.maxQueueSize; ++count) {
                        ret.add((SeedItem)item.next());
                    }
                    log.info((Object)("Successfuly read [" + ret.size() + "] seed items from cache file [" + file + "]."));
                    if (items.size() > ret.size()) {
                        log.warn((Object)("Purged [" + (items.size() - ret.size()) + "] items from cache file."));
                    }
                } else {
                    log.info((Object)("Seed cache file [" + file + "] does not exist, assuming an empty seed cache."));
                }
            }
            catch (Throwable e) {
                log.error((Object)("Error reading seed cache file [" + file + "], starting with an empty seed cache."), e);
            }
        }
        return ret;
    }

    private void writeQueue(SortedSet<SeedItem> sortedSet) {
        File file = this.getSeedCacheFile();
        if (file != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Writing [" + sortedSet.size() + "] seed items to cache file [" + file + "]..."));
                }
                FileOutputStream fos = new FileOutputStream(file);
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(sortedSet);
                oos.close();
                log.info((Object)("Successfully wrote [" + sortedSet.size() + "] seed items to cache file [" + file + "]."));
            }
            catch (Throwable e) {
                log.error((Object)("Error writing seed cache file [" + file + "]."));
            }
        }
    }

    public synchronized void start() {
        if (this.nThreads <= 0) {
            log.info((Object)"Number of seed threads is zero, cache seeding is disabled.");
            return;
        }
        if (this.threads != null) {
            throw new IllegalStateException("worker threasd have already been started.");
        }
        if (this.stopping) {
            throw new IllegalStateException("Service has been stopped.");
        }
        this.queue = this.readQueue();
        this.threads = new Thread[this.nThreads];
        int i = 0;
        try {
            for (i = 0; i < this.nThreads; ++i) {
                String name = "SeederImpl-thread-" + i;
                this.threads[i] = new Thread((Runnable)this, name);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Starting thread [" + name + "]..."));
                }
                this.threads[i].start();
            }
        }
        catch (Throwable e) {
            log.error((Object)("Error starting seed thread [" + i + "]"), e);
            this.stopping = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SeederImpl seederImpl = this;
        synchronized (seederImpl) {
            if (this.nThreads > 0) {
                log.info((Object)("Stopping [" + this.nThreads + "] seeder threads."));
            }
            this.stopping = true;
            this.notifyAll();
        }
        if (this.queue != null) {
            this.writeQueue(this.queue);
        }
    }

    private synchronized SeedItem popNextItem() {
        while (!this.stopping) {
            if (!this.queue.isEmpty()) {
                SeedItem ret = this.queue.first();
                this.queue.remove(ret);
                return ret;
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                log.warn((Object)"wait for next seed item has been interrupted.", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Leaving main loop of thread [" + Thread.currentThread().getName() + "]."));
        }
        return null;
    }

    private synchronized boolean waitForStopping(long timeout) {
        if (this.stopping) {
            return true;
        }
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            log.warn((Object)"wait for stop has been interrupted.", (Throwable)e);
        }
        if (this.stopping && log.isDebugEnabled()) {
            log.debug((Object)("Leaving main loop of thread [" + Thread.currentThread().getName() + "]."));
        }
        return this.stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Starting main loop of thread [" + Thread.currentThread().getName() + "]."));
            }
            while (true) {
                boolean retry;
                SeedItem item;
                if ((item = this.popNextItem()) == null) {
                    return;
                }
                int ntry = 0;
                do {
                    ++ntry;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Start render try [" + ntry + "] for item [" + item + "] in thread  [" + Thread.currentThread().getName() + "]."));
                    }
                    retry = true;
                    IMimeInputStream stream = null;
                    try {
                        VisitlessMimeSource ms = this.mimeSourceFactory.getMimeSource(item.getMimeSource());
                        stream = ms.getMimeStream(item.getParameters());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Seed item [" + item + "] rendered successfully to [" + stream.getUniqueName() + "]"));
                        }
                        retry = false;
                    }
                    catch (Timeout e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Rendering of seed item [" + item + "] timed out, next try in 1 second."));
                        }
                        --ntry;
                        if (!this.waitForStopping(1000L)) continue;
                        return;
                    }
                    catch (HPGSError e) {
                        log.warn((Object)("Rendering of seed item [" + item + "] failed with render error, giving up."));
                        retry = false;
                    }
                    catch (DRMError e) {
                        log.warn((Object)("Rendering of seed item [" + item + "] failed with DRM error, giving up."));
                        retry = false;
                    }
                    catch (Throwable e) {
                        log.warn((Object)("Rendering of seed item [" + item + "] failed, waiting a minute before retrying."), e);
                        if (!this.waitForStopping(60000L)) continue;
                        return;
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable e) {
                                log.warn((Object)("Closing render result seed item [" + item + "] failed"), e);
                            }
                        }
                    }
                } while (retry && ntry < this.maxTries);
                if (!retry) continue;
                log.warn((Object)("Maximum number [" + this.maxTries + "] of reached for seed item [" + item + "]."));
            }
        }
        catch (Throwable e) {
            log.error((Object)("Thread [" + Thread.currentThread().getName() + "] failed unexpectedly."), e);
            return;
        }
    }

    @Override
    public synchronized void queueItem(SeedItem item) {
        if (this.queue == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Queueing item [" + item + "]."));
        }
        if (this.queue.size() >= this.maxQueueSize) {
            item = this.queue.last();
            this.queue.remove(item);
        }
        this.queue.add(item);
        this.notify();
    }

    public void setMimeSourceFactory(MimeSourceFactory mimeSourceFactory) {
        this.mimeSourceFactory = mimeSourceFactory;
    }

    public void setNumberOfThreads(String threadsString) {
        this.nThreads = Integer.parseInt(threadsString);
    }

    public void setMaxTries(String maxTriesString) {
        this.maxTries = Integer.parseInt(maxTriesString);
    }

    @Override
    public boolean isActive() {
        return this.nThreads > 0;
    }

    public void setTempDir(String tempDir) {
        this.tempDir = tempDir;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setMaxQueueSize(String maxQueueSizeString) {
        this.maxQueueSize = Integer.parseInt(maxQueueSizeString);
    }
}

