/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.util;

import at.cdes.util.OperatingSystem;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;

public abstract class ConfigurationHelper {
    public static final String INSTANCE_PROPERTY_NAME = "at.cdes.instance";

    public static OperatingSystem getOperationSystemStatic() {
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().contains("window")) {
            return OperatingSystem.WINDOWS;
        }
        return OperatingSystem.UNIX;
    }

    public static String getInstanceNameStatic() {
        String instanceName = System.getenv("INSTANCE");
        if (!(instanceName != null && instanceName.length() > 0 || (instanceName = System.getProperty(INSTANCE_PROPERTY_NAME)) != null && instanceName.length() > 0)) {
            instanceName = "cdes";
        }
        return instanceName;
    }

    public static void setWinInstDir(String instdir) throws IOException {
        File dir = new File(instdir);
        Preferences prefs = Preferences.systemNodeForPackage(ConfigurationHelper.class);
        prefs.put("instdir", dir.getCanonicalPath());
    }

    public static void clearWinInstDir() {
        try {
            Preferences prefs = Preferences.systemNodeForPackage(ConfigurationHelper.class);
            prefs.remove("instdir");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String getWinInstDir() {
        Preferences prefs = Preferences.systemNodeForPackage(ConfigurationHelper.class);
        String instdir = prefs.get("instdir", null);
        if (instdir == null) {
            instdir = System.getenv("ProgramFiles") + "\\cdes";
        }
        return instdir;
    }

    public static String getGlobalConfigFileName(OperatingSystem os, String basename) {
        if (os == OperatingSystem.WINDOWS) {
            return ConfigurationHelper.getWinInstDir() + "\\etc\\" + basename;
        }
        return "/etc/cdes/" + basename;
    }

    public static String getInstanceConfigFileName(OperatingSystem os, String instance, String basename) {
        if (os == OperatingSystem.WINDOWS) {
            return ConfigurationHelper.getWinInstDir() + "\\etc\\" + instance + "\\" + basename;
        }
        return "/etc/cdes/" + instance + "/" + basename;
    }

    public static boolean isFileTypeSupportedForLabelSeeking(String type) {
        return type != null && (type.equalsIgnoreCase("hpgl") || type.equalsIgnoreCase("hpg") || type.equalsIgnoreCase("plt") || type.equalsIgnoreCase("pdf"));
    }

    public static boolean isFileTypeSupportedForPreview(String type) {
        return type != null && (type.equalsIgnoreCase("hpgl") || type.equalsIgnoreCase("hpg") || type.equalsIgnoreCase("plt") || type.equalsIgnoreCase("pdf"));
    }
}

