/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db.daohibernate;

import at.cdes.bo.data.object.CDESObjectImpl;
import at.cdes.bo.data.object.ObjectList;
import at.cdes.bo.data.object.ObjectType;
import at.cdes.bo.data.object.ReleasedCDESObject;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.db.dao.ObjectDAO;
import at.cdes.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ObjectDAOHibernate
extends HibernateDaoSupport
implements ObjectDAO {
    @Override
    public CDESObjectImpl getCDESObject(Integer id) {
        return (CDESObjectImpl)this.getSession().get(CDESObjectImpl.class, (Serializable)id);
    }

    @Override
    public List getAllCDESObjects() {
        return this.loadAllHibernate(CDESObjectImpl.class);
    }

    @Override
    public CDESObjectImpl save(CDESObjectImpl cons) {
        return this.getCDESObject((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public CDESObjectImpl update(CDESObjectImpl cons) {
        return (CDESObjectImpl)this.getSession().merge((Object)cons);
    }

    @Override
    public void delete(CDESObjectImpl cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public ReleasedCDESObject getReleasedCDESObject(Integer id) {
        return (ReleasedCDESObject)this.getSession().get(ReleasedCDESObject.class, (Serializable)id);
    }

    @Override
    public List getAllReleasedCDESObjects() {
        return this.loadAllHibernate(ReleasedCDESObject.class);
    }

    @Override
    public ReleasedCDESObject save(ReleasedCDESObject cons) {
        return this.getReleasedCDESObject((Integer)this.getSession().save((Object)cons));
    }

    @Override
    public ReleasedCDESObject update(ReleasedCDESObject cons) {
        this.getSession().merge((Object)cons);
        return cons;
    }

    @Override
    public void delete(ReleasedCDESObject cons) {
        this.getSession().delete((Object)cons);
    }

    @Override
    public boolean checkObjectCodeExists(ObjectList list, String code) {
        Object result = this.getSession().createCriteria(CDESObjectImpl.class).add((Criterion)Restrictions.eq((String)"code", (Object)code)).createCriteria("objectList").add(Restrictions.idEq((Object)list.getId())).uniqueResult();
        return result != null;
    }

    @Override
    public List getUnreleasedByObjectType(ObjectType ot) {
        Criteria crit = this.getSession().createCriteria(CDESObjectImpl.class);
        crit.createCriteria("objectType").add(Restrictions.idEq((Object)ot.getId()));
        return crit.list();
    }

    @Override
    public List getReleasedByObjectType(ObjectType ot) {
        Criteria crit = this.getSession().createCriteria(ReleasedCDESObject.class);
        crit.createCriteria("objectType").add(Restrictions.idEq((Object)ot.getId()));
        return crit.list();
    }

    @Override
    public ReleasedCDESObject getLastReleasedObjectFromInvalidatedObject(Integer objectImplId) {
        Criteria crit = this.getSession().createCriteria(ReleasedCDESObject.class);
        crit.createCriteria("object").add(Restrictions.idEq((Object)objectImplId));
        List objects = crit.list();
        ReleasedCDESObject mostRecent = null;
        for (ReleasedCDESObject o : objects) {
            if (mostRecent != null && !((ReleasedObjectList)o.getObjectList()).getSignature().getTime().after(((ReleasedObjectList)mostRecent.getObjectList()).getSignature().getTime())) continue;
            mostRecent = o;
        }
        return mostRecent;
    }

    @Override
    public List getAllAsBuiltReferences(Integer sourceSubProjectId, Integer destinationSubProjectId) {
        Criteria crit = this.getSession().createCriteria(CDESObjectImpl.class);
        crit.add((Criterion)Restrictions.ne((String)"inactive", (Object)Boolean.TRUE));
        crit.createCriteria("asBuiltReference").createCriteria("objectList").createCriteria("subProject").add(Restrictions.idEq((Object)sourceSubProjectId));
        crit.createCriteria("objectList").createCriteria("subProject").add(Restrictions.idEq((Object)destinationSubProjectId));
        return crit.list();
    }

    @Override
    public CDESObjectImpl getForAsBuiltReference(Integer asBuiltReferenceId, Integer destinationSubProjectId) {
        Criteria crit = this.getSession().createCriteria(CDESObjectImpl.class);
        crit.add((Criterion)Restrictions.ne((String)"inactive", (Object)Boolean.TRUE));
        crit.createCriteria("asBuiltReference").add(Restrictions.idEq((Object)asBuiltReferenceId));
        crit.createCriteria("objectList").createCriteria("subProject").add(Restrictions.idEq((Object)destinationSubProjectId));
        return (CDESObjectImpl)crit.uniqueResult();
    }
}

