/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.data.planningNotification.PlanningNotificationAttachment;
import at.cdes.bo.data.planningNotification.PlanningNotificationOrder;
import at.cdes.bo.data.project.Project;
import at.cdes.bo.data.workflow.WorkflowActivityPositionResult;
import at.cdes.bo.data.workflow.WorkflowEntity;
import at.cdes.bo.file.FileFinder;
import at.cdes.db.dao.NetworkDAO;
import at.cdes.db.dao.PlanningNotificationAttachmentDAO;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.db.dao.WorkflowEntityDAO;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.exception.FileHandleException;
import java.io.File;
import java.util.ArrayList;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class PlanningNotificationAttachmentMimeSource
implements VisitlessMimeSource {
    private PlanningNotificationAttachmentDAO planningNotificationAttachmentDAO;
    private FileFinder fileFinder;
    private NetworkDAO networkDAO;
    private ProjectDAO projectDAO;
    private WorkflowEntityDAO workflowEntityDAO;

    public String getActionName() {
        return "downloadPlanningNotification";
    }

    public boolean isEditable() {
        return false;
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        String unique;
        File file;
        Integer id = (Integer)parameters[0];
        PlanningNotificationAttachment pna = this.planningNotificationAttachmentDAO.get(id);
        try {
            file = this.fileFinder.findFile(pna.getFileName(), CDESFileRepository.PLANNINGNOTIFICATIONATTACHMENTREPOSITORY);
            unique = this.fileFinder.makeUniqueName(pna.getFileName(), CDESFileRepository.PLANNINGNOTIFICATIONATTACHMENTREPOSITORY);
        }
        catch (FileHandleException e) {
            throw new IOError("Invalid file handle when fetching the documentversion", (Throwable)e);
        }
        return new FileMimeInputStream(file, unique, pna.getOriginalName(), DefaultHttpContext.getInstance().getMimeType(pna.getFileName()));
    }

    public void setPlanningNotificationAttachmentDAO(PlanningNotificationAttachmentDAO planningNotificationAttachmentDAO) {
        this.planningNotificationAttachmentDAO = planningNotificationAttachmentDAO;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setNetworkDAO(NetworkDAO networkDAO) {
        this.networkDAO = networkDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setWorkflowEntityDAO(WorkflowEntityDAO workflowEntityDAO) {
        this.workflowEntityDAO = workflowEntityDAO;
    }

    public Object getDestinationObject(Object[] parameters) {
        Integer id = (Integer)parameters[0];
        PlanningNotificationAttachment pna = this.planningNotificationAttachmentDAO.get(id);
        ArrayList results = new ArrayList(pna.getResults().values());
        WorkflowActivityPositionResult workflowActivityPositionResult = (WorkflowActivityPositionResult)results.get(0);
        ArrayList<WorkflowEntity> workflowEntity = new ArrayList<WorkflowEntity>(workflowActivityPositionResult.getWorkflow().getWorkflowEntities().values());
        Integer orderId = ((WorkflowEntity)workflowEntity.get(0)).getId();
        PlanningNotificationOrder planningNotificationOrder = this.workflowEntityDAO.getPlanningNotificationOrder(orderId);
        Integer nwId = planningNotificationOrder.getPlanningNotification().getNetwork().getId();
        ArrayList<Project> projects = new ArrayList<Project>(planningNotificationOrder.getPlanningNotification().getAssociatedProjects().values());
        Integer prId = ((Project)projects.get(0)).getId();
        if (prId != null) {
            return this.projectDAO.get(prId);
        }
        return this.networkDAO.get(nwId);
    }
}

