/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.ext.preview;

import at.cdes.api.mime.VisitlessMimeSource;
import at.cdes.api.service.MspService;
import at.cdes.bo.data.file.CDESFileRepository;
import at.cdes.bo.file.FileFinder;
import at.cdes.db.dao.ProjectDAO;
import at.cdes.oldGwtDto.PlanningNotificationDTO;
import at.cdes.oldGwtDto.ProjectDTO;
import at.cdes.preview.api.IHPGLRenderer;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.PreviewException;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.service.NetworkOperations;
import at.cdes.service.ReviewOperations;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.clazzes.util.http.osgi.DefaultHttpContext;

public class PlanningNotificationPngMimeSource
implements VisitlessMimeSource {
    private IHPGLRenderer hpglRenderer;
    private ReviewOperations reviewOperations;
    private NetworkOperations networkOperations;
    private ProjectDAO projectDAO;
    private FileFinder fileFinder;
    private MspService mspService;
    private String tempRepository;

    public void setMspService(MspService mspService) {
        this.mspService = mspService;
    }

    public void setTempRepository(String tempRepository) {
        this.tempRepository = tempRepository;
    }

    public String getActionName() {
        return "downloadPlanningNotification";
    }

    public boolean isEditable() {
        return false;
    }

    public Object getDestinationObject(Object[] parameters) {
        Integer planningNotificationId = (Integer)parameters[0];
        PlanningNotificationDTO planningNotification = this.reviewOperations.getPlanningNotificationDTO(planningNotificationId);
        Integer nwId = planningNotification.getNetwork().getId();
        ArrayList<ProjectDTO> projects = new ArrayList<ProjectDTO>(planningNotification.getProjects().values());
        Integer prId = ((ProjectDTO)projects.get(0)).getId();
        if (prId != null) {
            return this.projectDAO.get(prId);
        }
        return this.networkOperations.getNetwork(nwId);
    }

    public IMimeInputStream getMimeStream(Object[] parameters) throws PreviewException {
        Integer id = (Integer)parameters[0];
        Integer resolution = (Integer)parameters[1];
        Integer ipage = (Integer)parameters[2];
        Integer angle = parameters.length >= 4 && parameters[3] != null ? (Integer)parameters[3] : null;
        PlanningNotificationDTO planningNotification = this.reviewOperations.getPlanningNotificationDTO(id);
        try (FileMimeInputStream stream = null;){
            File file = null;
            String unique = null;
            String sharepointLink = planningNotification.getSharepointLink();
            String path = planningNotification.getPath();
            if (planningNotification.getType() == PlanningNotificationDTO.TYPE_REFERENCED && path == null) {
                try {
                    InputStream inputStream = this.mspService.readDocumentContent(sharepointLink);
                    file = File.createTempFile("tempPngMimeSource", "", new File(this.tempRepository));
                    try (FileOutputStream os = new FileOutputStream(file);){
                        int n;
                        byte[] buf = new byte[4096];
                        while ((n = inputStream.read(buf)) > 0) {
                            ((OutputStream)os).write(buf, 0, n);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                unique = "planningNotification:" + planningNotification.getId().toString();
            } else {
                file = this.getFileFinder().findFile(path, CDESFileRepository.PLANNINGNOTIFICATIONREPOSITORY);
                unique = this.getFileFinder().makeUniqueName(path, CDESFileRepository.PLANNINGNOTIFICATIONREPOSITORY);
            }
            stream = new FileMimeInputStream(file, unique, planningNotification.getFilename(), DefaultHttpContext.getInstance().getMimeType(planningNotification.getPath()));
            IMimeInputStream iMimeInputStream = this.hpglRenderer.renderPngPageByResolution((IMimeInputStream)stream, ipage.intValue(), (double)resolution.intValue(), true, angle != null ? angle : 0, "", null);
            return iMimeInputStream;
        }
    }

    protected FileFinder getFileFinder() {
        return this.fileFinder;
    }

    protected IHPGLRenderer getHpglRenderer() {
        return this.hpglRenderer;
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setHpglRenderer(IHPGLRenderer hpglRenderer) {
        this.hpglRenderer = hpglRenderer;
    }

    public ReviewOperations getReviewOperations() {
        return this.reviewOperations;
    }

    public void setReviewOperations(ReviewOperations reviewOperations) {
        this.reviewOperations = reviewOperations;
    }

    public NetworkOperations getNetworkOperations() {
        return this.networkOperations;
    }

    public void setNetworkOperations(NetworkOperations networkOperations) {
        this.networkOperations = networkOperations;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }
}

