/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.monitoring;

import at.cdes.bo.data.task.Task;
import at.cdes.bo.data.task.TaskMonitoringResult;
import at.cdes.bo.data.task.TaskStateValidator;
import at.cdes.service.TaskOperations;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.clazzes.util.sched.ITimedJob;

public class TaskStateMonitoringThread
implements Callable<Void>,
ITimedJob {
    private TaskStateValidator taskValidator = new TaskStateValidator();
    private TaskOperations _taskOperations;
    static Logger logger = Logger.getLogger(TaskStateMonitoringThread.class);

    public TaskStateMonitoringThread(TaskOperations to) {
        this._taskOperations = to;
    }

    @Override
    public Void call() {
        logger.info((Object)"TaskStateMonitoringThread.run(): Starting.");
        ArrayList<Task> zombieTasks = new ArrayList<Task>();
        this.deleteResults();
        logger.info((Object)"TaskStateMonitoringThread.run(): Check tasks.");
        this.checkTaskList(zombieTasks, this._taskOperations.getAllAttachedReviewTasks());
        this.checkTaskList(zombieTasks, this._taskOperations.getAllReviewTasks());
        this.checkTaskList(zombieTasks, this._taskOperations.getAllSelectCellConnectionTasks());
        this.writeResults(zombieTasks);
        logger.info((Object)"TaskStateMonitoringThread.run(): Exiting.");
        return null;
    }

    protected void checkTaskList(List<Task> zombieTasks, Collection<? extends Task> tasks) {
        for (Task task : tasks) {
            Boolean statusOk = (Boolean)task.accept(this.taskValidator);
            if (statusOk.booleanValue()) continue;
            zombieTasks.add(task);
            logger.error((Object)("task is invalid = " + task.getId()));
        }
    }

    protected void deleteResults() {
        this._taskOperations.deleteAllTaskMonitoringResults();
    }

    protected void writeResults(List<Task> zombieTasks) {
        for (Task task : zombieTasks) {
            TaskMonitoringResult res = new TaskMonitoringResult();
            res.setDate(new Date());
            res.setTask(task);
            this._taskOperations.saveTaskMonitoringResult(res);
        }
    }

    public Long getNextExecutionDelay() {
        return 300000L;
    }
}

