/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.spring;

import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHandshakeCompletedListener
implements HandshakeCompletedListener {
    private static final Logger log = LoggerFactory.getLogger(LogHandshakeCompletedListener.class);

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent event) {
        try {
            String pp = event.getPeerPrincipal().toString();
            log.info("Peer authenticated as [" + pp + "].");
            if (log.isDebugEnabled()) {
                log.debug("Peer presented certificates [\n" + event.getPeerCertificates() + "\n].");
                log.debug("Using cipher [" + event.getCipherSuite() + "].");
            }
        }
        catch (SSLPeerUnverifiedException e) {
            log.error("Peer is unauthenticated.", (Throwable)e);
        }
    }
}

