/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.svg;

import at.cdes.svg.ContentType;
import at.cdes.svg.IMarkupWriter;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Stack;

public abstract class AbstractMarkupWriter
implements IMarkupWriter {
    private static final String DEFAULT_ENCODING = "utf-8";
    private PrintWriter _writer;
    private boolean _openTag = false;
    private boolean _emptyTag = false;
    private Stack _activeElementStack;
    private int _depth = 0;
    private char[] _buffer;
    private String[] _entities;
    private boolean[] _safe;
    private String _contentType;
    private boolean _propagateClose = true;

    @Override
    public String getContentType() {
        return this._contentType;
    }

    @Override
    public abstract IMarkupWriter getNestedWriter();

    protected AbstractMarkupWriter(boolean[] safe, String[] entities, String contentType, String encoding, OutputStream stream) {
        if (entities == null || safe == null || contentType == null || encoding == null) {
            throw new IllegalArgumentException("AbstractMarkupWriter.missing-constructor-parameters");
        }
        this._entities = entities;
        this._safe = safe;
        this._contentType = this.generateFullContentType(contentType, encoding);
        this.setOutputStream(stream, encoding);
    }

    protected AbstractMarkupWriter(boolean[] safe, String[] entities, String contentType, OutputStream stream) {
        this(safe, entities, contentType);
        ContentType contentTypeObject = new ContentType(contentType);
        String encoding = contentTypeObject.getParameter("charset");
        this.setOutputStream(stream, encoding);
    }

    protected AbstractMarkupWriter(boolean[] safe, String[] entities, String contentType, PrintWriter writer) {
        this(safe, entities, contentType);
        this._propagateClose = false;
        this._writer = writer;
    }

    protected AbstractMarkupWriter(boolean[] safe, String[] entities, String contentType) {
        if (entities == null || safe == null || contentType == null) {
            throw new IllegalArgumentException("AbstractMarkupWriter.missing-constructor-parameters");
        }
        this._entities = entities;
        this._safe = safe;
        this._contentType = this.generateFullContentType(contentType, DEFAULT_ENCODING);
    }

    private String generateFullContentType(String contentType, String encoding) {
        ContentType contentTypeObject = new ContentType(contentType);
        if (contentTypeObject.getParameter("charset") == null) {
            contentTypeObject.setParameter("charset", encoding);
        }
        return contentTypeObject.unparse();
    }

    protected void setWriter(PrintWriter writer) {
        this._writer = writer;
    }

    protected void setOutputStream(OutputStream stream, String encoding) {
        try {
            OutputStreamWriter owriter = encoding != null ? new OutputStreamWriter(stream, encoding) : new OutputStreamWriter(stream);
            BufferedWriter bwriter = new BufferedWriter(owriter);
            this._writer = new PrintWriter(bwriter);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("illegal-encoding: " + encoding);
        }
    }

    @Override
    public void attribute(String name, int value) {
        this.checkTagOpen();
        this._writer.print(' ');
        this._writer.print(name);
        this._writer.print("=\"");
        this._writer.print(value);
        this._writer.print('\"');
    }

    @Override
    public void attribute(String name, boolean value) {
        this.checkTagOpen();
        this._writer.print(' ');
        this._writer.print(name);
        this._writer.print("=\"");
        this._writer.print(value);
        this._writer.print('\"');
    }

    @Override
    public void attribute(String name, String value) {
        this.checkTagOpen();
        this._writer.print(' ');
        this._writer.print(name);
        this._writer.print("=\"");
        if (value != null) {
            int length = value.length();
            if (this._buffer == null || this._buffer.length < length) {
                this._buffer = new char[length];
            }
            value.getChars(0, length, this._buffer, 0);
            this.safePrint(this._buffer, 0, length, true);
        }
        this._writer.print('\"');
    }

    @Override
    public void attributeRaw(String name, String value) {
        if (value == null) {
            this.attribute(name, value);
            return;
        }
        this.checkTagOpen();
        this._writer.print(' ');
        this._writer.print(name);
        this._writer.print("=\"");
        this._writer.print(value);
        this._writer.print('\"');
    }

    @Override
    public void begin(String name) {
        if (this._openTag) {
            this.closeTag();
        }
        this.push(name);
        this._writer.print('<');
        this._writer.print(name);
        this._openTag = true;
        this._emptyTag = false;
    }

    @Override
    public void beginEmpty(String name) {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print('<');
        this._writer.print(name);
        this._openTag = true;
        this._emptyTag = true;
    }

    @Override
    public boolean checkError() {
        return this._writer.checkError();
    }

    private void checkTagOpen() {
        if (!this._openTag) {
            throw new IllegalStateException("AbstractMarkupWriter.tag-not-open");
        }
    }

    @Override
    public void close() {
        if (this._openTag) {
            this.closeTag();
        }
        while (this._depth > 0) {
            this._writer.print("</");
            this._writer.print(this.pop());
            this._writer.print('>');
        }
        if (this._propagateClose) {
            this._writer.close();
        }
        this._writer = null;
        this._activeElementStack = null;
        this._buffer = null;
    }

    @Override
    public void closeTag() {
        if (this._emptyTag) {
            this._writer.print('/');
        }
        this._writer.print('>');
        this._openTag = false;
        this._emptyTag = false;
    }

    @Override
    public void comment(String value) {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print("<!-- ");
        this._writer.print(value);
        this._writer.println(" -->");
    }

    @Override
    public void end() {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print("</");
        this._writer.print(this.pop());
        this._writer.print('>');
    }

    @Override
    public void end(String name) {
        String tagName;
        if (this._openTag) {
            this.closeTag();
        }
        do {
            tagName = this.pop();
            this._writer.print("</");
            this._writer.print(tagName);
            this._writer.print('>');
        } while (!tagName.equals(name));
    }

    @Override
    public void flush() {
        this._writer.flush();
    }

    protected final String pop() {
        String result = (String)this._activeElementStack.pop();
        --this._depth;
        return result;
    }

    @Override
    public void print(char[] data, int offset, int length) {
        if (data == null) {
            return;
        }
        if (this._openTag) {
            this.closeTag();
        }
        this.safePrint(data, offset, length, false);
    }

    @Override
    public void print(char value) {
        if (this._openTag) {
            this.closeTag();
        }
        if (value < this._safe.length && this._safe[value]) {
            this._writer.print(value);
            return;
        }
        String entity = null;
        if (value < this._entities.length) {
            entity = this._entities[value];
        }
        if (entity != null) {
            this._writer.print(entity);
            return;
        }
        this._writer.print("&#" + value + ";");
    }

    @Override
    public void print(int value) {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print(value);
    }

    @Override
    public void print(String value) {
        if (value == null) {
            return;
        }
        int length = value.length();
        if (this._buffer == null || this._buffer.length < length) {
            this._buffer = new char[length];
        }
        value.getChars(0, length, this._buffer, 0);
        this.print(this._buffer, 0, length);
    }

    @Override
    public void println() {
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.println();
    }

    @Override
    public void printRaw(char[] buffer, int offset, int length) {
        if (buffer == null) {
            return;
        }
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.write(buffer, offset, length);
    }

    @Override
    public void printRaw(String value) {
        if (value == null) {
            return;
        }
        if (this._openTag) {
            this.closeTag();
        }
        this._writer.print(value);
    }

    protected final void push(String name) {
        if (this._activeElementStack == null) {
            this._activeElementStack = new Stack();
        }
        this._activeElementStack.push(name);
        ++this._depth;
    }

    private void safePrint(char[] data, int offset, int length, boolean isAttribute) {
        int safelength = 0;
        int start = offset;
        for (int i = 0; i < length; ++i) {
            boolean isSafe;
            char ch = data[offset + i];
            boolean bl = isSafe = ch < this._safe.length && this._safe[ch];
            if (isAttribute && ch == '\"') {
                isSafe = false;
            }
            if (isSafe) {
                ++safelength;
                continue;
            }
            if (safelength > 0) {
                this._writer.write(data, start, safelength);
            }
            String entity = null;
            if (ch < this._entities.length) {
                entity = this._entities[ch];
            }
            if (entity == null) {
                entity = "&#" + ch + ";";
            }
            this._writer.print(entity);
            start = offset + i + 1;
            safelength = 0;
        }
        if (safelength > 0) {
            this._writer.write(data, start, safelength);
        }
    }
}

