/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.date;

public enum TimeUnit {
    Year,
    Month,
    Week,
    Day,
    Hour,
    Minute,
    Second;


    public static TimeUnit fromISO8601Duration(char c, boolean timePart) {
        switch (c) {
            case 'Y': {
                return Year;
            }
            case 'M': {
                return timePart ? Minute : Month;
            }
            case 'W': {
                return Week;
            }
            case 'D': {
                return Day;
            }
            case 'H': {
                return Hour;
            }
            case 'S': {
                return Second;
            }
        }
        return null;
    }

    public char toISO8601Duration() {
        switch (this.ordinal()) {
            case 0: {
                return 'Y';
            }
            case 1: {
                return 'M';
            }
            case 3: {
                return 'D';
            }
            case 2: {
                return 'W';
            }
            case 4: {
                return 'H';
            }
            case 5: {
                return 'M';
            }
            case 6: {
                return 'S';
            }
        }
        throw new AssertionError((Object)("Invalid TimeUnit value [" + (Object)((Object)this) + "]"));
    }

    public boolean isTimePart() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        throw new AssertionError((Object)("Invalid TimeUnit value [" + (Object)((Object)this) + "]"));
    }

    public int toCalendarField() {
        switch (this.ordinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 3: {
                return 5;
            }
            case 2: {
                return 3;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 13;
            }
        }
        throw new AssertionError((Object)("Invalid TimeUnit value [" + (Object)((Object)this) + "]"));
    }
}

