/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.db;

import at.cdes.bo.file.FileFinder;
import at.cdes.db.FileFinderAware;
import at.cdes.db.SchemaUpdateSnippet;
import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.streams.FileMimeInputStream;
import at.cdes.preview.streams.MimeInputStreamDataSource;
import at.cdes.service.DatabaseDumpService;
import at.cdes.service.exception.ActionException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.log4j.Logger;
import org.clazzes.jdbc2xml.sax.InsertContentHandler;
import org.clazzes.jdbc2xml.schema.ISchemaEngine;
import org.clazzes.jdbc2xml.schema.SchemaEngine;
import org.clazzes.jdbc2xml.tools.Commands;
import org.clazzes.jdbc2xml.tools.ProcessRestrictionFilter;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SchemaCheckerBean
implements DatabaseDumpService {
    private static final Logger logger = Logger.getLogger(SchemaCheckerBean.class);
    protected ISchemaEngine schemaEngine;
    private FileFinder fileFinder;
    protected boolean disableSchemaCheck;
    private boolean dropTablesOnStartup;
    protected Map<String, Class<? extends SchemaUpdateSnippet>> updateSnippets;
    protected String schemaVersion = null;

    public void setSchemaEngine(ISchemaEngine schemaEngine) {
        this.schemaEngine = schemaEngine;
    }

    public ISchemaEngine getSchemaEngine() {
        return this.schemaEngine;
    }

    public void setUpdateSnippets(Map<String, Class<? extends SchemaUpdateSnippet>> updateSnippets) {
        this.updateSnippets = updateSnippets;
    }

    public void setSchemaVersion(String schemaVersion) {
        this.schemaVersion = schemaVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchSchemaVersion(boolean force) throws SQLException {
        this.schemaVersion = null;
        try (Statement stmt = this.schemaEngine.getConnection().createStatement();){
            ResultSet rs = stmt.executeQuery("SELECT version FROM dbschema_history ORDER BY serialnr DESC");
            if (rs.next()) {
                this.schemaVersion = rs.getString(1);
            } else if (force) {
                throw new SQLException("Table dbschema_history is empty.");
            }
        }
    }

    public synchronized void checkSchema() throws SQLException, CertificateException, InstantiationException, IllegalAccessException, ClassNotFoundException, SAXException, IOException {
        if (this.disableSchemaCheck) {
            logger.info((Object)"Automatic schema check is disabled.");
            return;
        }
        if (logger.isDebugEnabled() && logger != null) {
            logger.debug((Object)"SchemaChecker.checkDBSchema() called");
        }
        if (this.dropTablesOnStartup) {
            this.dropDatabaseTables();
        } else {
            this.fetchSchemaVersion(false);
        }
        if (this.schemaVersion == null) {
            String resourcePath = System.getProperty("at.cdes.schema.resource-path", "at/cdes/db/cdes-schema.xml");
            InputStream is = SchemaCheckerBean.class.getClassLoader().getResourceAsStream(resourcePath);
            this.importInitialSchema(is, resourcePath);
        }
        this.updateDatabaseSchema();
    }

    private void dumpSchemaInner(OutputStream os) throws FileNotFoundException, TransformerConfigurationException, SQLException, SAXException {
        ProcessRestrictionFilter filter = new ProcessRestrictionFilter();
        Commands.jdbc2xml((Connection)this.getDatabaseConnection(), (OutputStream)os, (TimeZone)TimeZone.getDefault(), (ProcessRestrictionFilter)filter);
    }

    public synchronized void dumpSchema() {
        String dumpPath = System.getProperty("at.cdes.schema.dump-path");
        if (dumpPath != null) {
            try {
                new File(dumpPath).createNewFile();
            }
            catch (IOException e1) {
                logger.warn((Object)("Exception caught while creating file [" + dumpPath + "]: " + e1.getMessage()));
            }
            logger.info((Object)("Dumping database to [" + dumpPath + "]..."));
            try {
                this.dumpSchemaInner(new FileOutputStream(dumpPath));
                logger.info((Object)("Successfully dumped database to [" + dumpPath + "]."));
            }
            catch (Throwable e) {
                logger.error((Object)("Exception caught during database export to [" + dumpPath + "]."), e);
            }
        }
    }

    @Override
    public synchronized IMimeInputStream getDatabaseDump() {
        try {
            File f = File.createTempFile("SchemCheckerBean_dump", ".xml");
            f.deleteOnExit();
            logger.info((Object)("Dumping database to [" + f + "]..."));
            this.dumpSchemaInner(new FileOutputStream(f));
            logger.info((Object)("Successfully dumped database to [" + f + "]."));
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss_SSS");
            String fn = "cdes_schema_" + df.format(new Date(System.currentTimeMillis())) + ".xml";
            FileMimeInputStream fi = new FileMimeInputStream(f, fn, fn, "text/xml");
            return fi;
        }
        catch (Throwable e) {
            throw new ActionException("caught exeption during remotely initiated dump", e);
        }
    }

    private void dropDatabaseTables() throws SQLException {
        logger.info((Object)"Dropping all tables in database...");
        List tables = this.schemaEngine.fetchTableInfos(null);
        this.schemaEngine.dropTables(tables, true);
        logger.info((Object)"Sucessfully Dropped all tables in database.");
        this.schemaVersion = null;
    }

    private void importInitialSchema(InputStream is, String resourcePath) throws SQLException, SAXException, IOException {
        logger.info((Object)("Importing initial database from resource [" + resourcePath + "]..."));
        InsertContentHandler handler = new InsertContentHandler(this.schemaEngine);
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler((ContentHandler)handler);
        reader.parse(new InputSource(is));
        this.fetchSchemaVersion(true);
        logger.info((Object)("Successfully imported initial database with version [" + this.schemaVersion + "]."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateDatabaseSchema() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, CertificateException, SAXException, IOException {
        PreparedStatement insertSchemaLog = this.schemaEngine.getConnection().prepareStatement("INSERT INTO dbschema_history (serialnr,version,description,recorddate) VALUES (?,?,?,?)");
        Statement getMaxId = this.schemaEngine.getConnection().createStatement();
        try {
            while (this.updateSnippets.containsKey(this.schemaVersion)) {
                boolean success = false;
                try {
                    SchemaUpdateSnippet snippet = this.updateSnippets.get(this.schemaVersion).newInstance();
                    if (snippet instanceof FileFinderAware) {
                        FileFinderAware ffaw = (FileFinderAware)((Object)snippet);
                        ffaw.setFileFinder(this.fileFinder);
                    }
                    String newVersion = snippet.getTargetVersion();
                    logger.info((Object)("Going to update DB schema from " + this.schemaVersion + " to " + newVersion));
                    snippet.performUpdate(this.schemaEngine);
                    getMaxId.execute("select MAX(serialnr) from dbschema_history");
                    ResultSet rs2 = getMaxId.getResultSet();
                    int id = rs2.next() ? rs2.getInt(1) + 1 : 1;
                    rs2.close();
                    insertSchemaLog.setInt(1, id);
                    insertSchemaLog.setString(2, newVersion);
                    insertSchemaLog.setString(3, snippet.getUpdateComment());
                    insertSchemaLog.setDate(4, new Date(System.currentTimeMillis()));
                    insertSchemaLog.execute();
                    this.schemaEngine.commit();
                    logger.info((Object)("Successfully updated schema from " + this.schemaVersion + " to " + newVersion));
                    this.schemaVersion = newVersion;
                    success = true;
                }
                finally {
                    if (success) continue;
                    this.schemaEngine.rollback();
                }
            }
        }
        finally {
            getMaxId.close();
            insertSchemaLog.close();
        }
        if (logger != null) {
            logger.info((Object)("schema is up to date (Version " + this.schemaVersion + ")"));
        }
    }

    @Override
    public synchronized void loadDatabaseDump(IMimeInputStream dump) {
        try {
            MimeInputStreamDataSource ds = new MimeInputStreamDataSource(dump, 4096);
            this.dropDatabaseTables();
            this.importInitialSchema(ds.getInputStream(), dump.getPrettyName());
        }
        catch (Throwable e) {
            throw new ActionException("caught expeption during remotely initiated database load", e);
        }
    }

    public boolean isDisableSchemaCheck() {
        return this.disableSchemaCheck;
    }

    public void setDisableSchemaCheck(boolean disableSchemaCheck) {
        this.disableSchemaCheck = disableSchemaCheck;
    }

    public Connection getDatabaseConnection() {
        return this.schemaEngine.getConnection();
    }

    public void setDatabaseConnection(Connection dbConn) throws SQLException {
        this.schemaEngine = SchemaEngine.newInstance();
        this.schemaEngine.setConnection(dbConn);
    }

    public void setFileFinder(FileFinder fileFinder) {
        this.fileFinder = fileFinder;
    }

    public void setDropTablesOnStartup(boolean deleteTablesOnStartup) {
        this.dropTablesOnStartup = deleteTablesOnStartup;
    }
}

