/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.bo.sec.digest;

import at.cdes.bo.data.cycle.ReviewCycleInstance;
import at.cdes.bo.data.cycle.ReviewCycleInstanceRelease;
import at.cdes.bo.data.object.ReleasedCDESObject;
import at.cdes.bo.data.object.ReleasedObjectList;
import at.cdes.bo.data.object.ReleasedObjectPlanner;
import at.cdes.bo.sec.digest.DigestCalculator;
import at.cdes.bo.sec.digest.DigestCalculatorException;
import at.cdes.bo.sec.digest.DigestList;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class ObjectDigestCalculator
implements DigestCalculator {
    static Logger logger = Logger.getLogger((String)"object digester");

    public abstract String getCDESObjectHash(ReleasedCDESObject var1) throws DigestCalculatorException;

    public abstract String getObjectListHash(ReleasedObjectList var1) throws DigestCalculatorException;

    public abstract String getObjectPlannerHash(ReleasedObjectPlanner var1) throws DigestCalculatorException;

    public abstract String getReviewCycleInstanceHash(ReviewCycleInstanceRelease var1) throws DigestCalculatorException;

    @Override
    public String getSignableContent(Object o) throws DigestCalculatorException {
        DigestList<String> digests = new DigestList<String>();
        if (o instanceof List) {
            List list = (List)o;
            for (int i = 0; i < list.size(); ++i) {
                this.getSignableContentIteration(list.get(i), digests);
            }
        } else {
            this.getSignableContentIteration(o, digests);
        }
        return digests.toString();
    }

    public void getSignableContentIteration(Object o, DigestList<String> digests) throws DigestCalculatorException {
        if (o instanceof ReleasedObjectList) {
            Iterator it;
            ReleasedObjectList objectList = (ReleasedObjectList)o;
            if (objectList.getDigest() == null) {
                this.getObjectListHash(objectList);
            } else {
                digests.add(objectList.getDigest());
            }
            Iterator iterator = it = objectList.getObjects() != null ? objectList.getObjects().values().iterator() : null;
            while (it.hasNext()) {
                this.getSignableContentIteration(it.next(), digests);
            }
        } else if (o instanceof ReleasedCDESObject) {
            Iterator it;
            ReleasedCDESObject object = (ReleasedCDESObject)o;
            if (object.getDigest() == null) {
                this.getCDESObjectHash(object);
            } else {
                digests.add(object.getDigest());
            }
            Iterator iterator = it = object.getObjectPlanners() != null ? object.getObjectPlanners().values().iterator() : null;
            while (it != null && it.hasNext()) {
                this.getSignableContentIteration(it.next(), digests);
            }
        } else if (o instanceof ReleasedObjectPlanner) {
            ReleasedObjectPlanner objectPlanner = (ReleasedObjectPlanner)o;
            if (objectPlanner.getDigest() == null) {
                this.getObjectPlannerHash(objectPlanner);
            } else {
                digests.add(objectPlanner.getDigest());
            }
        } else if (o instanceof ReviewCycleInstanceRelease) {
            ReviewCycleInstanceRelease instance = (ReviewCycleInstanceRelease)o;
            if (instance.getDigest() == null) {
                this.getReviewCycleInstanceHash(instance);
            } else {
                digests.add(instance.getDigest());
            }
        } else {
            throw new DigestCalculatorException("Class " + o.getClass().getName() + " is not supported in this DigestCalculation");
        }
    }

    protected MessageDigest getMessageDigest() throws DigestCalculatorException {
        try {
            return MessageDigest.getInstance("SHA1", "BC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestCalculatorException("Init Message Digest", e);
        }
        catch (NoSuchProviderException e) {
            throw new DigestCalculatorException("Init Message Digest", e);
        }
    }

    @Override
    public String getDigest(Object o) throws DigestCalculatorException {
        if (o instanceof ReleasedObjectList) {
            return this.getObjectListHash((ReleasedObjectList)o);
        }
        if (o instanceof ReleasedCDESObject) {
            return this.getCDESObjectHash((ReleasedCDESObject)o);
        }
        if (o instanceof ReleasedObjectPlanner) {
            return this.getObjectPlannerHash((ReleasedObjectPlanner)o);
        }
        if (o instanceof ReviewCycleInstance) {
            return this.getReviewCycleInstanceHash((ReviewCycleInstanceRelease)o);
        }
        throw new DigestCalculatorException("Class " + o.getClass().getName() + " is not supported in this DigestCalculation");
    }

    @Override
    public boolean validate(byte[] digest, Object o) throws DigestCalculatorException {
        byte[] newDigest = this.getDigest(o).getBytes();
        return MessageDigest.isEqual(newDigest, digest);
    }
}

